/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.fabric.tasks.ConfigurationException;
import com.sun.portal.fabric.tasks.ValidationException;
import com.sun.portal.fabric.tasks.WebContainer;
import com.sun.portal.fabric.tasks.WebContainerBase;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.fabric.util.os.OSTasks;
import com.sun.portal.fabric.util.os.OSTasksFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class JESWS6Impl
extends WebContainerBase {
    private String wcHomeDir = null;
    private String wcInstance = null;
    private String wcInstanceDir = null;
    private String wcScheme = null;
    private String wcCertDBPassword = null;
    private String wdeploy = null;
    private String amconfigScript = null;
    private final String certDBPasswordFile = "password.conf";
    private boolean isConfiguredforSSL = false;
    private static File wcConfigFile = null;
    private static final String SERVERCLASSPATH = "serverclasspath";
    private static final String LIBPATH = "nativelibrarypathprefix";

    public JESWS6Impl(Map wcAttributes, Logger logger) {
        super(wcAttributes, logger);
        this.wcHomeDir = (String)wcAttributes.get("WebContainerInstallDir");
        this.wcInstance = (String)wcAttributes.get("WebContainerInstanceName");
        this.wcInstanceDir = (String)wcAttributes.get("WebContainerInstanceDir");
        this.wcScheme = (String)wcAttributes.get("Scheme");
        if (this.wcScheme.equalsIgnoreCase("HTTPS")) {
            this.isConfiguredforSSL = true;
            this.wcCertDBPassword = (String)wcAttributes.get("WebContainerCertificateDBPassword");
        }
    }

    public void postValidationInit() throws ConfigurationException {
        this.wdeploy = this.wcHomeDir + WebContainer.fs + "bin" + WebContainer.fs + "https" + WebContainer.fs + "bin" + WebContainer.fs + "wdeploy";
        wcConfigFile = new File(this.wcInstanceDir + WebContainer.fs + "config" + WebContainer.fs + "server.xml");
        this.wcPrintableInstanceName = this.wcInstance;
    }

    public void deploy(String warFile, String uri) throws ConfigurationException {
        String[] args = new String[]{"deploy", "-u", uri, "-i", this.wcInstance, "-v", "https-" + this.wcInstance, warFile};
        this.execUtil.exec(this.wdeploy, args);
    }

    public void undeploy(String uri) throws ConfigurationException {
        String[] args = new String[]{"delete", "-u", uri, "-i", this.wcInstance, "-v", "https-" + this.wcInstance, "hard"};
        this.execUtil.exec(this.wdeploy, args);
    }

    public void doIdentitySDKConfig(PSConfigContext configContext) throws ConfigurationException {
        this.logger.log(Level.INFO, "Starting AM configuration... ");
        if (this.isIdentityServerSDKConfigured()) {
            this.logger.log(Level.INFO, "AM configuration already done... ");
            return;
        }
        String host = (String)this.wcAttributes.get("Host");
        String port = (String)this.wcAttributes.get("Port");
        String amProductLoc = configContext.getISBaseDir();
        String amConfigDir = configContext.getISConfigDir();
        String psDataDir = configContext.getPSDataDir();
        int index = amProductLoc.lastIndexOf(WebContainer.fs);
        String amProductDir = amProductLoc.substring(index + 1);
        String amBaseDir = amProductLoc.substring(0, index);
        this.logger.log(Level.FINEST, "PSFB_CSPFT0015", new String[]{this.wcPrintableInstanceName});
        String amSilentName = psDataDir + WebContainer.fs + "tmp" + WebContainer.fs + "amsilent_ps." + FileUtil.getRandomDirName();
        StringBuffer fileData = new StringBuffer();
        fileData.append("BASEDIR=" + amBaseDir + WebContainer.nl).append("PRODUCT_DIR=" + amProductDir + WebContainer.nl).append("CONFIG_DIR=" + amConfigDir + WebContainer.nl).append("WS61_HOME=" + this.wcHomeDir + WebContainer.nl).append("WS61_INSTANCE=https-" + this.wcInstance + WebContainer.nl).append("WS61_PROTOCOL=" + this.wcScheme + WebContainer.nl).append("WS61_HOST=" + host + WebContainer.nl).append("WS61_PORT=" + port + WebContainer.nl).append("WS61_ADMIN=" + WebContainer.nl).append("WS61_ADMINPASSWD=" + WebContainer.nl).append("WS61_ADMINPORT=" + WebContainer.nl);
        if (configContext.getAMVersion().equals("6")) {
            fileData.append("DEPLOY_LEVEL=4" + WebContainer.nl);
            this.amconfigScript = "amws61config";
        } else {
            fileData.append("DEPLOY_LEVEL=7" + WebContainer.nl).append("JAVA_HOME=" + configContext.getJavaHome() + WebContainer.nl).append("WEB_CONTAINER=WS6" + WebContainer.nl);
            this.amconfigScript = "amconfig";
        }
        File amSilentFile = new File(amSilentName);
        try {
            FileWriter fwriter = new FileWriter(amSilentFile);
            fwriter.write(fileData.toString());
            fwriter.close();
        }
        catch (IOException e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.log(Level.SEVERE, "PSFB_CSPFT0016");
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0017");
                record.setParameters(new String[]{this.wcPrintableInstanceName});
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
            amSilentFile.delete();
            return;
        }
        String amws61config = amProductLoc + WebContainer.fs + "bin" + WebContainer.fs + this.amconfigScript;
        String[] args = new String[]{"-s", amSilentName};
        this.logger.log(Level.FINEST, "PSFB_CSPFT0018", new String[]{amws61config});
        if (this.execUtil.exec(amws61config, args) != 0) {
            this.logger.log(Level.SEVERE, "PSFB_CSPFT0019", new String[]{this.wcType, this.wcPrintableInstanceName});
        } else {
            this.logger.log(Level.INFO, "PSFB_CSPFT0020", new String[]{this.wcType, this.wcPrintableInstanceName});
        }
        amSilentFile.delete();
    }

    public boolean addJVMOption(String option, String value) {
        if (this.doesJVMOptionExist(option)) {
            return false;
        }
        StringBuffer vmoption = new StringBuffer("<JVMOPTIONS>-D");
        vmoption.append(option);
        vmoption.append("=");
        vmoption.append(value);
        vmoption.append("</JVMOPTIONS>");
        return FileUtil.appendLineInFile(wcConfigFile, "java.util.logging.manager", vmoption.toString());
    }

    public boolean doesJVMOptionExist(String option) {
        boolean exists = false;
        String optionLine = FileUtil.findPatternInFile(wcConfigFile, ".*JVMOPTIONS.*" + option + ".*");
        if (optionLine != null) {
            exists = true;
            this.logger.log(Level.INFO, "PSFB_CSPFT0092", new String[]{option, this.wcInstance});
        }
        return exists;
    }

    private final boolean isIdentityServerSDKConfigured() {
        String amSDKJar = null;
        amSDKJar = FileUtil.findTextInFile(wcConfigFile, "am_sdk.jar");
        return amSDKJar != null && amSDKJar.trim().length() > 0;
    }

    public boolean removeJVMOption(String option, String value) {
        return FileUtil.deleteLineInFile(wcConfigFile, option);
    }

    private String getNativeLibraryPath() {
        String text = FileUtil.findTextInFile(wcConfigFile, LIBPATH);
        return FileUtil.getQuotedKeyValueInText(LIBPATH, text);
    }

    public boolean setNativeLibraryPath(String path) {
        String curLibPath = this.getNativeLibraryPath();
        if (curLibPath != null) {
            if (curLibPath.indexOf(path) >= 0) {
                this.logger.log(Level.INFO, "PSFB_CSPFT0043", new String[]{LIBPATH, path});
                return false;
            }
            StringBuffer curLib = new StringBuffer(LIBPATH);
            curLib.append("=\"");
            curLib.append(curLibPath);
            curLib.append("\"");
            StringBuffer newLib = new StringBuffer(LIBPATH);
            newLib.append("=\"");
            if (!"".equals(curLibPath)) {
                newLib.append(curLibPath);
                newLib.append(WebContainer.cps);
            }
            newLib.append(path);
            newLib.append("\"");
            return FileUtil.replaceTokenInFile(wcConfigFile, curLib.toString(), newLib.toString());
        }
        this.logger.log(Level.INFO, "PSFB_CSPFT0042", new String[]{LIBPATH});
        return false;
    }

    public boolean removeNativeLibraryPath(String path) {
        String curLibPath = this.getNativeLibraryPath();
        if (curLibPath != null) {
            if (curLibPath.indexOf(path) < 0) {
                this.logger.log(Level.INFO, "PSFB_CSPFT0045", new String[]{LIBPATH, path});
                return false;
            }
            StringBuffer curLib = new StringBuffer(LIBPATH);
            curLib.append("=\"");
            curLib.append(curLibPath);
            curLib.append("\"");
            StringBuffer newLib = new StringBuffer(LIBPATH);
            newLib.append("=\"");
            if (!"".equals(curLibPath)) {
                String[] remPath = curLibPath.split(path);
                for (int idx = 0; idx < remPath.length; ++idx) {
                    newLib.append(remPath[idx]);
                }
            }
            newLib.append("\"");
            return FileUtil.replaceTokenInFile(wcConfigFile, curLib.toString(), newLib.toString());
        }
        this.logger.log(Level.INFO, "PSFB_CSPFT0044", new String[]{LIBPATH});
        return false;
    }

    public void start() throws ConfigurationException {
        boolean ispasswordFileExists = false;
        FileWriter fwriter = null;
        File passwordFile = null;
        if (this.isConfiguredforSSL) {
            passwordFile = new File(this.wcInstanceDir + "config" + "password.conf");
            if (passwordFile.exists()) {
                ispasswordFileExists = true;
            } else {
                StringBuffer fileData = new StringBuffer();
                fileData.append("internal:" + this.wcCertDBPassword);
                try {
                    fwriter = new FileWriter(passwordFile);
                    fwriter.write(fileData.toString());
                    fwriter.close();
                }
                catch (IOException e) {
                    this.logger.log(Level.INFO, "PSFB_CSPFT0083", e);
                }
            }
        }
        this.logger.log(Level.INFO, "PSFB_CSPFT0103");
        String wsStart = this.wcInstanceDir + WebContainer.fs + "start";
        this.execUtil.exec(wsStart, null);
        if (ispasswordFileExists) {
            passwordFile.deleteOnExit();
        }
    }

    public void stop() throws ConfigurationException {
        this.logger.log(Level.INFO, "PSFB_CSPFT0102");
        String wsStop = this.wcInstanceDir + WebContainer.fs + "stop";
        this.execUtil.exec(wsStop, null);
    }

    public void validate() throws ValidationException {
        String port;
        if (!this.checkNotNullOrEmpty("WebContainerInstanceName", this.wcInstance)) {
            throw new ValidationException("Invalid Instance Name");
        }
        if (!this.checkDirExists("WebContainerInstallDir", this.wcHomeDir)) {
            throw new ValidationException("Invalid Install Directory = " + this.wcHomeDir);
        }
        if (!this.checkDirExists("WebContainerInstanceDir", this.wcInstanceDir)) {
            throw new ValidationException("Invalid Instance Directory = " + this.wcInstanceDir);
        }
        String wcDocRootDir = (String)this.wcAttributes.get("WebContainerDocRoot");
        if (!this.checkDirExists("WebContainerDocRoot", wcDocRootDir)) {
            throw new ValidationException("Invalid Doc Root Directory = " + wcDocRootDir);
        }
        String host = (String)this.wcAttributes.get("Host");
        boolean bIsValidHostNamePort = this.validateInstanceHostNamePort(host, port = (String)this.wcAttributes.get("Port"));
        if (!bIsValidHostNamePort) {
            throw new ValidationException("Invalid Instance Host/Port");
        }
        if (this.isConfiguredforSSL && !this.checkNotNull("WebContainerCertificateDBPassword", this.wcCertDBPassword, true)) {
            throw new ValidationException("Cert DB Password can NOT be NULL.");
        }
    }

    public boolean isPortalConfigured() {
        String str = FileUtil.findTextInFile(wcConfigFile, "serverclasspath=");
        if (str != null && !str.equals("") && str.indexOf("ps_util.jar") >= 0) {
            this.logger.log(Level.INFO, "PSFB_CSPFT0041");
            return true;
        }
        return false;
    }

    private String getServerClassPath() {
        String text = FileUtil.findTextInFile(wcConfigFile, SERVERCLASSPATH);
        return FileUtil.getQuotedKeyValueInText(SERVERCLASSPATH, text);
    }

    public boolean appendClasspath(String classpath) {
        try {
            String serverCP = this.getServerClassPath();
            if (serverCP == null || serverCP.equals("")) {
                return false;
            }
            String filteredClassPath = this.getFilteredClassPath(classpath, serverCP);
            this.logger.log(Level.INFO, "PSFB_CSPFT0046", new String[]{filteredClassPath, wcConfigFile.getAbsolutePath()});
            String cpString = "serverclasspath=\"" + filteredClassPath + ":";
            FileUtil.replaceTokenInFile(wcConfigFile, "serverclasspath=\"", cpString);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0026");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
            return false;
        }
        return true;
    }

    public void createSymbolicLinks(PSConfigContext configContext) {
        block2: {
            try {
                String docsDir = this.wcHomeDir + WebContainer.fs + "docs";
                String helpDir = docsDir + WebContainer.fs + "online_help" + WebContainer.fs + "docs_en_US";
                String psHelpDir = configContext.getPSBaseDir() + WebContainer.fs + "docs" + WebContainer.fs + "public_html" + WebContainer.fs + "online_help" + WebContainer.fs + "docs_en_US";
                String voiceDir = configContext.getPSBaseDir() + WebContainer.fs + "export" + WebContainer.fs + "voice";
                OSTasks osTasks = OSTasksFactory.getOSTasks(configContext, this.logger);
                osTasks.createSymbolicLink(voiceDir, docsDir);
                osTasks.createSymbolicLink(psHelpDir + WebContainer.fs + "ps", helpDir);
                osTasks.createSymbolicLink(psHelpDir + WebContainer.fs + "ma", helpDir);
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block2;
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0040");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
        }
    }

    public boolean doJVMMemorySettings() {
        String defJVMSetting = "<JVMOPTIONS>-Xmx256m</JVMOPTIONS>";
        String reqJVMSetting = "<JVMOPTIONS>-Xmx512M</JVMOPTIONS>\n<JVMOPTIONS>-Xms512M</JVMOPTIONS>\n<JVMOPTIONS>-Xss128k</JVMOPTIONS>\n<JVMOPTIONS>-XX:NewSize=168M</JVMOPTIONS>\n<JVMOPTIONS>-XX:MaxNewSize=168M</JVMOPTIONS>\n<JVMOPTIONS>-XX:PermSize=192M</JVMOPTIONS>\n<JVMOPTIONS>-XX:MaxPermSize=192M</JVMOPTIONS>\n<JVMOPTIONS>-XX:+DisableExplicitGC</JVMOPTIONS>\n<JVMOPTIONS>-XX:SoftRefLRUPolicyMSPerMB=0</JVMOPTIONS>\n<JVMOPTIONS>-XX:+PrintGCTimeStamps</JVMOPTIONS>\n<JVMOPTIONS>-XX:+PrintHeapAtGC</JVMOPTIONS>\n<JVMOPTIONS>-XX:+PrintClassHistogram</JVMOPTIONS>\n<JVMOPTIONS>-Xloggc:" + this.wcInstanceDir + WebContainer.fs + "logs" + WebContainer.fs + "gc.log</JVMOPTIONS>";
        return FileUtil.replaceLineInFile(wcConfigFile, defJVMSetting, reqJVMSetting);
    }

    public void doMiscTasks(PSConfigContext configContext) {
        block6: {
            LogRecord record;
            block5: {
                String wcConfigDir = this.wcInstanceDir + WebContainer.fs + "config";
                String objConf = wcConfigDir + WebContainer.fs + "obj.conf";
                try {
                    File file = new File(objConf);
                    FileUtil.deleteLineInFile(file, "fn=index-common");
                }
                catch (Exception e) {
                    if (!this.logger.isLoggable(Level.SEVERE)) break block5;
                    this.logger.log(Level.SEVERE, "PSFB_CSPFT0039");
                    record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0028");
                    record.setThrown(e);
                    record.setLoggerName(this.logger.getName());
                    this.logger.log(record);
                }
            }
            try {
                if (this.doJVMMemorySettings()) {
                    this.stop();
                    this.start();
                    this.logger.log(Level.INFO, "PSFB_CSPFT0103");
                }
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block6;
                this.logger.log(Level.SEVERE, "PSFB_CSPFT0101");
                record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0101");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
        }
    }

    public void configResource(Element root, String derbyHost, String derbyPort, String databaseName, String poolName, String psLibDir) {
        try {
            Element resource = new Element("RESOURCES");
            Element jdbcConnectionPool = new Element("JDBCCONNECTIONPOOL");
            Element jdbcResource = new Element("JDBCRESOURCE");
            Element property1 = new Element("PROPERTY");
            Element property2 = new Element("PROPERTY");
            Element property3 = new Element("PROPERTY");
            Element property4 = new Element("PROPERTY");
            Element property5 = new Element("PROPERTY");
            jdbcConnectionPool.setAttribute("name", poolName);
            String dataSourceClassName = root.getAttributeValue("dataSourceClassName.SJSWS6");
            if (dataSourceClassName != null && !dataSourceClassName.equals("") && dataSourceClassName.length() > 0) {
                jdbcConnectionPool.setAttribute("datasourceclassname", dataSourceClassName);
            } else {
                jdbcConnectionPool.setAttribute("datasourceclassname", root.getAttributeValue("dataSourceClassName"));
            }
            jdbcConnectionPool.setAttribute("steadypoolsize", "8");
            jdbcConnectionPool.setAttribute("maxpoolsize", root.getAttributeValue("maxActive"));
            jdbcConnectionPool.setAttribute("poolresizequantity", "2");
            jdbcConnectionPool.setAttribute("idletimeout", root.getAttributeValue("maxIdle"));
            jdbcConnectionPool.setAttribute("maxwaittime", root.getAttributeValue("maxWait"));
            jdbcConnectionPool.setAttribute("connectionvalidationrequired", "off");
            jdbcConnectionPool.setAttribute("connectionvalidationmethod", "auto-commit");
            jdbcConnectionPool.setAttribute("validationtablename", "");
            jdbcConnectionPool.setAttribute("failallconnections", "off");
            jdbcConnectionPool.setAttribute("transactionisolationlevel", "read-uncommitted");
            jdbcConnectionPool.setAttribute("isolationlevelguaranteed", "off");
            property1.setAttribute("name", "serverName");
            property1.setAttribute("value", derbyHost);
            property2.setAttribute("name", "portNumber");
            property2.setAttribute("value", derbyPort);
            property3.setAttribute("name", "User");
            property3.setAttribute("value", root.getAttributeValue("username"));
            property4.setAttribute("name", "Password");
            property4.setAttribute("value", root.getAttributeValue("password"));
            property5.setAttribute("name", "databaseName");
            property5.setAttribute("value", databaseName);
            jdbcResource.setAttribute("jndiname", root.getAttributeValue("name"));
            jdbcResource.setAttribute("poolname", poolName);
            jdbcResource.setAttribute("enabled", "on");
            jdbcConnectionPool.addContent((Content)property1);
            jdbcConnectionPool.addContent((Content)property2);
            jdbcConnectionPool.addContent((Content)property3);
            jdbcConnectionPool.addContent((Content)property4);
            jdbcConnectionPool.addContent((Content)property5);
            resource.addContent((Content)jdbcConnectionPool);
            resource.addContent((Content)jdbcResource);
            XMLOutputter output = new XMLOutputter(Format.getPrettyFormat());
            String outputStr = output.outputString(resource);
            String outputStr1 = output.outputString(jdbcConnectionPool);
            String outputStr2 = output.outputString(jdbcResource);
            FileUtil.deleteLineInFile(wcConfigFile, "<RESOURCES/>");
            String resStr = FileUtil.findTextInFile(wcConfigFile, "<RESOURCES>");
            if (resStr.equals("") || resStr == null || resStr.length() == 0) {
                FileUtil.appendLineInFile(wcConfigFile, "</SECURITY>", outputStr, 7);
            } else {
                FileUtil.appendLineInFile(wcConfigFile, "<RESOURCES>", outputStr2, 7);
                FileUtil.appendLineInFile(wcConfigFile, "<RESOURCES>", outputStr1, 7);
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "PSFB_CSPFT0087", e.getMessage());
        }
    }

    public void unConfigResource(String jndiName, String poolName) {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document serverXMLDoc = builder.build(wcConfigFile);
            Element rootElement = serverXMLDoc.getRootElement();
            Element resourcesElement = rootElement.getChild("JAVA").getChild("RESOURCES");
            List resList = null;
            Iterator resIterator = null;
            Element currResource = null;
            resList = resourcesElement.getChildren("JDBCCONNECTIONPOOL");
            resIterator = resList.iterator();
            while (resIterator.hasNext()) {
                currResource = (Element)resIterator.next();
                if (!currResource.getAttributeValue("name").equals(poolName)) continue;
                resourcesElement.removeContent((Content)currResource);
                break;
            }
            resList = resourcesElement.getChildren("JDBCRESOURCE");
            resIterator = resList.iterator();
            while (resIterator.hasNext()) {
                currResource = (Element)resIterator.next();
                if (!currResource.getAttributeValue("jndiname").equals(jndiName)) continue;
                resourcesElement.removeContent((Content)currResource);
                break;
            }
            XMLOutputter serializer = new XMLOutputter();
            serializer.output(serverXMLDoc, (Writer)new FileWriter(wcConfigFile));
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "PSFB_CSPFT0087", e.getMessage());
        }
    }

    public boolean removeClasspath(String classpath) {
        boolean removedCp = false;
        try {
            removedCp = FileUtil.replaceTokenInFile(wcConfigFile, classpath + ":", "");
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0029");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
            return false;
        }
        return removedCp;
    }

    public void deleteSymbolicLinks(PSConfigContext configContext) {
        block2: {
            try {
                String docsDir = this.wcHomeDir + WebContainer.fs + "docs";
                String helpDir = docsDir + WebContainer.fs + "online_help" + WebContainer.fs + "docs_en_US";
                OSTasks osTasks = OSTasksFactory.getOSTasks(configContext, this.logger);
                osTasks.removeSymbolicLink(docsDir + WebContainer.fs + "voice");
                osTasks.removeSymbolicLink(helpDir + WebContainer.fs + "ps");
                osTasks.removeSymbolicLink(helpDir + WebContainer.fs + "ma");
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block2;
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0038");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
        }
    }

    public void undoMiscTasks(PSConfigContext configContext) {
    }
}

