/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.fabric.tasks.ConfigurationException;
import com.sun.portal.fabric.tasks.ValidationException;
import com.sun.portal.fabric.tasks.WebContainer;
import com.sun.portal.fabric.tasks.WebContainerBase;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.fabric.util.os.OSTasks;
import com.sun.portal.fabric.util.os.OSTasksFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jdom.Element;

public class JESAS81Impl
extends WebContainerBase {
    private static final String CLASSPATH_PREFIX = "java-config.classpath-prefix";
    private static final String CLASSPATH_SUFFIX = "java-config.classpath-suffix";
    private static final String NATIVE_LIBRARY_PATH = "java-config.native-library-path-prefix";
    private static final String WEB_CONTAINER_COMMAND = "WebConatinerCommand";
    private static final String POLICY_START_TAG = "// START OF ADDITIONS FOR ";
    private static final String POLICY_END_TAG = "// END OF ADDITIONS FOR ";
    private String wcHomeDir = null;
    private String wcInstanceDir = null;
    private String wcTargetInstance = null;
    private String wcTargetDomain = null;
    private String wcDocRootDir = null;
    private String wcAdminUser = null;
    private String wcAdminPassword = null;
    private String wcMasterPassword = null;
    private String wcAdminPasswordFilePath = null;
    private String wcAdminProtocol = null;
    private String wcAdminHost = null;
    private String wcAdminPort = null;
    private String wcDeployURI = null;
    private String command = null;
    private String amconfigScript = null;
    private boolean bIsDAS = false;

    public JESAS81Impl(Map wcAttributes, Logger logger) {
        super(wcAttributes, logger);
        this.wcHomeDir = (String)wcAttributes.get("WebContainerInstallDir");
        this.wcInstanceDir = (String)wcAttributes.get("WebContainerInstanceDir");
        this.wcTargetInstance = (String)wcAttributes.get("WebContainerInstanceName");
        this.wcTargetDomain = (String)wcAttributes.get("WebContainerDomainName");
        this.wcDocRootDir = (String)wcAttributes.get("WebContainerDocRoot");
        this.wcAdminUser = (String)wcAttributes.get("WebContainerAdminUid");
        this.wcAdminPassword = (String)wcAttributes.get("WebContainerAdminPassword");
        this.wcMasterPassword = (String)wcAttributes.get("WebContainerMasterPassword");
        this.wcAdminProtocol = (String)wcAttributes.get("WebContainerAdminScheme");
        this.wcAdminHost = (String)wcAttributes.get("WebContainerAdminHost");
        this.wcAdminPort = (String)wcAttributes.get("WebContainerAdminPort");
        this.wcDeployURI = "portal";
        this.execUtil.storeOutput(true);
        this.execUtil.storeError(true);
        this.command = this.wcHomeDir + WebContainer.fs + "bin" + WebContainer.fs + "asadmin";
        this.createPasswordFile();
    }

    public void postValidationInit() throws ConfigurationException {
        this.bIsDAS = this.isDAS();
        this.wcPrintableInstanceName = this.wcTargetDomain + "." + this.wcTargetInstance;
    }

    public void start() throws ConfigurationException {
        String[] args;
        String[] stringArray = args = this.bIsDAS ? new String[6] : new String[10];
        if (this.bIsDAS) {
            args[0] = "start-domain";
            args[1] = "--user";
            args[2] = this.wcAdminUser;
            args[3] = "--passwordfile";
            args[4] = this.wcAdminPasswordFilePath;
            args[5] = this.wcTargetDomain;
        } else {
            args[0] = "start-instance";
            args[1] = "--user";
            args[2] = this.wcAdminUser;
            args[3] = "--passwordfile";
            args[4] = this.wcAdminPasswordFilePath;
            args[5] = "--host";
            args[6] = this.wcAdminHost;
            args[7] = "--port";
            args[8] = this.wcAdminPort;
            args[9] = this.wcTargetInstance;
        }
        this.logger.log(Level.INFO, "PSFB_CSPFT0103");
        int iRetCode = this.execUtil.exec(this.command, args);
        if (iRetCode != 0) {
            String sError = this.execUtil.getError();
            this.logger.log(Level.FINEST, "PSFB_CSPFT0012", new String[]{this.getCommand(this.command, args), sError != null ? sError : ""});
        }
    }

    public void stop() throws ConfigurationException {
        String[] args;
        String[] stringArray = args = this.bIsDAS ? new String[2] : new String[10];
        if (this.bIsDAS) {
            args[0] = "stop-domain";
            args[1] = this.wcTargetDomain;
        } else {
            args[0] = "stop-instance";
            args[1] = "--user";
            args[2] = this.wcAdminUser;
            args[3] = "--passwordfile";
            args[4] = this.wcAdminPasswordFilePath;
            args[5] = "--host";
            args[6] = this.wcAdminHost;
            args[7] = "--port";
            args[8] = this.wcAdminPort;
            args[9] = this.wcTargetInstance;
        }
        this.logger.log(Level.INFO, "PSFB_CSPFT0102");
        int iRetCode = this.execUtil.exec(this.command, args);
        if (iRetCode != 0) {
            String sError = this.execUtil.getError();
            this.logger.log(Level.FINEST, "PSFB_CSPFT0012", new String[]{this.getCommand(this.command, args), sError != null ? sError : ""});
        }
    }

    public void deploy(String warFile, String uri) throws ConfigurationException {
        String[] args;
        String name = uri.charAt(0) == '/' ? uri.substring(1) : uri;
        int iRetCode = this.createApplicationReferenceOnTarget(name);
        if (iRetCode != 0 && (iRetCode = this.execUtil.exec(this.command, args = new String[]{"deploy", "--user", this.wcAdminUser, "--passwordfile", this.wcAdminPasswordFilePath, "--host", this.wcAdminHost, "--port", this.wcAdminPort, "--contextroot", uri, "--name", name, "--target", this.wcTargetInstance, warFile})) != 0) {
            String sError = this.execUtil.getError();
            this.logger.log(Level.FINEST, "PSFB_CSPFT0012", new String[]{this.getCommand(this.command, args), sError != null ? sError : ""});
        }
    }

    public void undeploy(String uri) throws ConfigurationException {
        String name = uri.charAt(0) == '/' ? uri.substring(1) : uri;
        String[] args = new String[]{"undeploy", "--user", this.wcAdminUser, "--passwordfile", this.wcAdminPasswordFilePath, "--host", this.wcAdminHost, "--port", this.wcAdminPort, "--target", this.wcTargetInstance, name};
        int iRetCode = this.execUtil.exec(this.command, args);
        if (iRetCode != 0) {
            String sError = this.execUtil.getError();
            if (sError != null && 0 <= sError.indexOf("already deployed")) {
                iRetCode = this.deleteApplicationReferenceFromTarget(name);
            } else if (sError != null && 0 <= sError.indexOf("not registered")) {
                this.logger.log(Level.FINEST, "PSFB_CSPFT0013", new String[]{name, this.wcTargetDomain});
            } else {
                this.logger.log(Level.FINEST, "PSFB_CSPFT0012", new String[]{this.getCommand(this.command, args), sError != null ? sError : ""});
            }
        }
    }

    private void wcSet(String key, String value) throws ConfigurationException {
        String[] args = new String[]{"set", "--user", this.wcAdminUser, "--passwordfile", this.wcAdminPasswordFilePath, "--host", this.wcAdminHost, "--port", this.wcAdminPort, this.wcTargetInstance + "." + key + "=" + value};
        int iRetCode = this.execUtil.exec(this.command, args);
        if (iRetCode != 0) {
            String sError = this.execUtil.getError();
            this.logger.log(Level.FINEST, "PSFB_CSPFT0012", new String[]{this.getCommand(this.command, args), sError != null ? sError : ""});
        }
    }

    private final String wcGet(String key) throws ConfigurationException {
        int iIndex;
        String value;
        String[] args = new String[]{"get", "--user", this.wcAdminUser, "--passwordfile", this.wcAdminPasswordFilePath, "--host", this.wcAdminHost, "--port", this.wcAdminPort, this.wcTargetInstance + "." + key};
        int iRetCode = this.execUtil.exec(this.command, args);
        if (iRetCode != 0) {
            String sError = this.execUtil.getError();
            this.logger.log(Level.FINEST, "PSFB_CSPFT0012", new String[]{this.getCommand(this.command, args), sError != null ? sError : ""});
        }
        String string = value = iRetCode == 0 ? this.execUtil.getOutput() : this.execUtil.getError();
        if (iRetCode == 0 && (iIndex = value.indexOf("=")) >= 0) {
            value = value.substring(iIndex + 1);
            value = value.trim();
        }
        return value;
    }

    public boolean removeJVMOption(String key, String value) {
        String[] args = new String[]{"delete-jvm-options", "--user", this.wcAdminUser, "--passwordfile", this.wcAdminPasswordFilePath, "--host", this.wcAdminHost, "--port", this.wcAdminPort, "--target", this.wcTargetInstance, this.getJVMOptionString(key, value)};
        int iRetCode = this.execUtil.exec(this.command, args);
        if (iRetCode != 0) {
            String sError = this.execUtil.getError();
            this.logger.log(Level.FINEST, "PSFB_CSPFT0012", new String[]{this.getCommand(this.command, args), sError != null ? sError : ""});
        }
        return true;
    }

    public boolean addJVMOption(String key, String value) {
        String[] args = new String[]{"create-jvm-options", "--user", this.wcAdminUser, "--passwordfile", this.wcAdminPasswordFilePath, "--host", this.wcAdminHost, "--port", this.wcAdminPort, "--target", this.wcTargetInstance, this.getJVMOptionString(key, value)};
        int iRetCode = this.execUtil.exec(this.command, args);
        if (iRetCode != 0) {
            String sError = this.execUtil.getError();
            this.logger.log(Level.FINEST, "PSFB_CSPFT0012", new String[]{this.getCommand(this.command, args), sError != null ? sError : ""});
        }
        return true;
    }

    private String getJVMOptionString(String key, String value) {
        StringBuffer option = new StringBuffer();
        if (key.startsWith("-")) {
            if (value == null || value.trim().equals("")) {
                option.append("\"").append(key).append("\"");
            } else {
                option.append("\"").append(key).append("=").append(value).append("\"");
            }
        } else {
            option.append("\"").append("-D").append(key).append("=").append(value).append("\"");
        }
        return option.toString();
    }

    public void doIdentitySDKConfig(PSConfigContext configContext) throws ConfigurationException {
        if (this.isIdentityServerSDKConfigured()) {
            this.logger.log(Level.FINEST, "PSFB_CSPFT0014", new String[]{this.wcPrintableInstanceName});
            return;
        }
        String protocol = (String)this.wcAttributes.get("Scheme");
        String port = (String)this.wcAttributes.get("Port");
        String amProductLoc = configContext.getISBaseDir();
        String amConfigDir = configContext.getISConfigDir();
        String psDataDir = configContext.getPSDataDir();
        int index = amProductLoc.lastIndexOf(WebContainer.fs);
        String amProductDir = amProductLoc.substring(index + 1);
        String amBaseDir = amProductLoc.substring(0, index);
        this.logger.log(Level.FINEST, "PSFB_CSPFT0015", new String[]{this.wcPrintableInstanceName});
        String amSilentName = psDataDir + WebContainer.fs + "tmp" + WebContainer.fs + "amsilent_ps." + FileUtil.getRandomDirName();
        StringBuffer fileData = new StringBuffer();
        fileData.append("BASEDIR=" + amBaseDir + WebContainer.nl).append("PRODUCT_DIR=" + amProductDir + WebContainer.nl).append("CONFIG_DIR=" + amConfigDir + WebContainer.nl + WebContainer.nl).append("AS81_HOME=" + this.wcHomeDir + WebContainer.nl).append("AS81_DOMAIN=" + this.wcTargetDomain + WebContainer.nl).append("AS81_INSTANCE_DIR=" + this.wcInstanceDir + WebContainer.nl).append("AS81_INSTANCE=" + this.wcTargetInstance + WebContainer.nl).append("AS81_DOCS_DIR=" + this.wcDocRootDir + WebContainer.nl).append("AS81_IS_SECURE=false" + WebContainer.nl).append("AS81_ADMIN_IS_SECURE=true" + WebContainer.nl).append("AS81_PROTOCOL=" + protocol + WebContainer.nl).append("AS81_HOST=" + this.wcAdminHost + WebContainer.nl).append("AS81_PORT=" + port + WebContainer.nl).append("AS81_ADMIN=" + this.wcAdminUser + WebContainer.nl).append("AS81_ADMINPASSWD=" + this.wcAdminPassword + WebContainer.nl).append("AS81_ADMINPORT=" + this.wcAdminPort + WebContainer.nl);
        if (configContext.getAMVersion().equals("6")) {
            fileData.append("DEPLOY_LEVEL=4" + WebContainer.nl);
            this.amconfigScript = "amas81config";
        } else {
            fileData.append("DEPLOY_LEVEL=7" + WebContainer.nl).append("JAVA_HOME=" + configContext.getJavaHome() + WebContainer.nl).append("WEB_CONTAINER=AS8" + WebContainer.nl);
            this.amconfigScript = "amconfig";
        }
        File amSilentFile = new File(amSilentName);
        try {
            FileWriter fwriter = new FileWriter(amSilentFile);
            fwriter.write(fileData.toString());
            fwriter.close();
        }
        catch (IOException ioe) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.log(Level.SEVERE, "PSFB_CSPFT0016");
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0017");
                record.setParameters(new String[]{this.wcPrintableInstanceName});
                record.setThrown(ioe);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
            amSilentFile.delete();
            return;
        }
        String amas81config = amProductLoc + WebContainer.fs + "bin" + WebContainer.fs + this.amconfigScript;
        String[] args = new String[]{"-s", amSilentFile.getAbsolutePath()};
        this.logger.log(Level.FINEST, "PSFB_CSPFT0018", new String[]{amas81config});
        if (this.execUtil.exec(amas81config, args) != 0) {
            this.logger.log(Level.SEVERE, "PSFB_CSPFT0019", new String[]{this.wcType, this.wcPrintableInstanceName});
        } else {
            this.logger.log(Level.INFO, "PSFB_CSPFT0020", new String[]{this.wcType, this.wcPrintableInstanceName});
        }
        amSilentFile.delete();
    }

    private final boolean isDAS() {
        return this.wcTargetInstance.equals("server");
    }

    private void wcReconfig() throws ConfigurationException {
        this.stop();
        this.start();
        this.logger.log(Level.INFO, "PSFB_CSPFT0104");
    }

    private final int createApplicationReferenceOnTarget(String sRefName) {
        String[] args = new String[]{"create-application-ref", "--user", this.wcAdminUser, "--passwordfile", this.wcAdminPasswordFilePath, "--host", this.wcAdminHost, "--port", this.wcAdminPort, "--target", this.wcTargetInstance, sRefName};
        int iRetCode = this.execUtil.exec(this.command, args);
        if (iRetCode != 0) {
            String sError = this.execUtil.getError();
            if (sError != null && 0 <= sError.indexOf("already exists")) {
                this.logger.log(Level.FINEST, "PSFB_CSPFT0021", new String[]{sRefName, this.wcPrintableInstanceName});
                iRetCode = 0;
            } else if (sError != null && 0 <= sError.indexOf("not registered")) {
                this.logger.log(Level.FINEST, "PSFB_CSPFT0022", new String[]{sRefName, this.wcTargetDomain});
            } else {
                this.logger.log(Level.FINEST, "PSFB_CSPFT0012", new String[]{this.getCommand(this.command, args), sError != null ? sError : ""});
            }
        }
        return iRetCode;
    }

    private final int deleteApplicationReferenceFromTarget(String sRefName) {
        String[] args = new String[]{"delete-application-ref", "--user", this.wcAdminUser, "--passwordfile", this.wcAdminPasswordFilePath, "--host", this.wcAdminHost, "--port", this.wcAdminPort, "--target", this.wcTargetInstance, sRefName};
        int iRetCode = this.execUtil.exec(this.command, args);
        if (iRetCode != 0) {
            String sError = this.execUtil.getError();
            if (sError != null && 0 <= sError.indexOf("does not have a reference")) {
                this.logger.log(Level.FINEST, "PSFB_CSPFT0023", new String[]{this.wcPrintableInstanceName, sRefName});
                iRetCode = 0;
            } else if (sError != null && 0 <= sError.indexOf("not registered")) {
                this.logger.log(Level.FINEST, "PSFB_CSPFT0024", new String[]{sRefName, this.wcTargetDomain});
                iRetCode = 0;
            } else {
                this.logger.log(Level.FINEST, "PSFB_CSPFT0012", new String[]{this.getCommand(this.command, args), sError != null ? sError : ""});
            }
        }
        return iRetCode;
    }

    private final boolean isIdentityServerSDKConfigured() throws ConfigurationException {
        String sValue = this.wcGet(CLASSPATH_SUFFIX);
        return sValue != null && sValue.indexOf("am_sdk.jar") > 0;
    }

    private void createPasswordFile() {
        block3: {
            StringBuffer fileData = new StringBuffer();
            fileData.append("AS_ADMIN_PASSWORD=" + this.wcAdminPassword + WebContainer.nl);
            if (this.wcMasterPassword != null && this.wcMasterPassword.length() > 0) {
                fileData.append("AS_ADMIN_MASTERPASSWORD=" + this.wcMasterPassword + WebContainer.nl);
            }
            try {
                Date curDate = new Date();
                String sTmpFile = "" + curDate.getTime();
                File appPasswordFile = File.createTempFile(sTmpFile, "");
                appPasswordFile.deleteOnExit();
                this.wcAdminPasswordFilePath = appPasswordFile.getAbsolutePath();
                FileWriter fwriter = new FileWriter(appPasswordFile);
                fwriter.write(fileData.toString());
                fwriter.close();
                this.execUtil.exec("chmod", new String[]{"600", this.wcAdminPasswordFilePath});
            }
            catch (IOException ioe) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block3;
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0025");
                record.setThrown(ioe);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
        }
    }

    protected void finalize() throws Throwable {
        File fAdminPasswordFile;
        super.finalize();
        if (this.wcAdminPasswordFilePath != null && !this.wcAdminPasswordFilePath.trim().equals("") && (fAdminPasswordFile = new File(this.wcAdminPasswordFilePath)).isFile()) {
            fAdminPasswordFile.delete();
        }
    }

    private final String getCommand(String sMainCommand, String[] args) {
        String sCommand = sMainCommand;
        for (int i = 0; i < args.length; ++i) {
            sCommand = sCommand + " " + args[i];
        }
        return sCommand;
    }

    public void validate() throws ValidationException {
        String port;
        if (!this.checkNotNullOrEmpty("WebContainerInstanceName", this.wcTargetInstance)) {
            throw new ValidationException("Invalid Instance Name");
        }
        if (!this.checkNotNullOrEmpty("WebContainerDomainName", this.wcTargetDomain)) {
            throw new ValidationException("Invalid Domain Name");
        }
        if (!this.checkNotNull("WebContainerAdminUid", this.wcAdminUser)) {
            throw new ValidationException("Invalid Admin User");
        }
        if (!this.checkNotNull("WebContainerAdminPassword", this.wcAdminPassword, true)) {
            throw new ValidationException("Invalid Admin Password");
        }
        if (!this.checkNotNullOrEmpty("WebContainerAdminScheme", this.wcAdminProtocol)) {
            throw new ValidationException("Invalid Admin Scheme");
        }
        if (!this.checkNotNullOrEmpty("WebContainerAdminHost", this.wcAdminHost)) {
            throw new ValidationException("Invalid Admin Host");
        }
        if (!this.checkNotNullOrEmpty("WebContainerAdminPort", this.wcAdminPort)) {
            throw new ValidationException("Invalid Admin Port");
        }
        if (!this.checkDirExists("WebContainerInstanceDir", this.wcInstanceDir)) {
            throw new ValidationException("Invalid Instance Directory = " + this.wcInstanceDir);
        }
        if (!this.checkDirExists("WebContainerDocRoot", this.wcDocRootDir)) {
            throw new ValidationException("Invalid Doc Root Directory = " + this.wcDocRootDir);
        }
        if (!this.checkDirExists("WebContainerInstallDir", this.wcHomeDir)) {
            throw new ValidationException("Invalid Install Directory = " + this.wcHomeDir);
        }
        String sPathToASAdminCommand = this.wcHomeDir + WebContainer.fs + "bin" + WebContainer.fs + "asadmin";
        if (!this.checkFileExists(WEB_CONTAINER_COMMAND, sPathToASAdminCommand)) {
            throw new ValidationException("Invalid path to 'asadmin' = " + sPathToASAdminCommand);
        }
        String host = (String)this.wcAttributes.get("Host");
        boolean bIsValidHostNamePort = this.validateInstanceHostNamePort(host, port = (String)this.wcAttributes.get("Port"));
        if (!bIsValidHostNamePort) {
            throw new ValidationException("Invalid Instance Host/Port");
        }
        bIsValidHostNamePort = this.validateAdminHostNamePort(this.wcAdminHost, this.wcAdminPort);
        if (!bIsValidHostNamePort) {
            throw new ValidationException("Invalid Admin Host/Port");
        }
        try {
            String sClassPathSuffix = this.wcGet(CLASSPATH_SUFFIX);
            String sFieldName = this.wcTargetDomain + "." + this.wcTargetInstance + "." + CLASSPATH_SUFFIX;
            if (!this.checkNotNullOrEmpty(sFieldName, sClassPathSuffix)) {
                throw new ValidationException("Could not fetch the value of " + sFieldName);
            }
        }
        catch (ConfigurationException e) {
            throw new ValidationException(e);
        }
    }

    public boolean isPortalConfigured() {
        boolean retValue = false;
        try {
            String sValue = this.wcGet(CLASSPATH_SUFFIX);
            retValue = sValue != null && sValue.indexOf("ps_util.jar") >= 0;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Portal configuration test failed", e);
            return false;
        }
        return retValue;
    }

    public boolean appendClasspath(String classpath) {
        return this.appendClasspath(classpath, CLASSPATH_SUFFIX);
    }

    private boolean appendClasspath(String classpath, String target) {
        block7: {
            try {
                if (classpath == null || classpath.trim().length() <= 0) break block7;
                String sValue = this.wcGet(target);
                if (sValue != null && sValue.length() > 0) {
                    String mergedCP = this.getMergedClassPath(classpath, sValue);
                    if (sValue.equals(mergedCP)) {
                        return true;
                    }
                    sValue = mergedCP;
                } else {
                    sValue = classpath;
                }
                if (sValue != null) {
                    this.wcSet(target, sValue);
                    break block7;
                }
                return false;
            }
            catch (Exception e) {
                if (this.logger.isLoggable(Level.SEVERE)) {
                    LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0026");
                    record.setThrown(e);
                    record.setLoggerName(this.logger.getName());
                    this.logger.log(record);
                }
                return false;
            }
        }
        return true;
    }

    public boolean setNativeLibraryPath(String path) {
        try {
            String sValue = this.wcGet(NATIVE_LIBRARY_PATH);
            String myPath = "." + WebContainer.cps + path;
            int startIndex = sValue.indexOf(myPath);
            if (startIndex >= 0) {
                return false;
            }
            String sValue1 = myPath + (sValue.trim().equals("") ? "" : WebContainer.cps + sValue);
            this.wcSet(NATIVE_LIBRARY_PATH, sValue1);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0027");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
            return false;
        }
        return true;
    }

    public void createSymbolicLinks(PSConfigContext configContext) {
        block2: {
            try {
                String helpDir = this.wcDocRootDir + WebContainer.fs + "online_help" + WebContainer.fs + "docs_en_US";
                String psHelpDir = configContext.getPSBaseDir() + WebContainer.fs + "docs" + WebContainer.fs + "public_html" + WebContainer.fs + "online_help" + WebContainer.fs + "docs_en_US";
                String voiceDir = configContext.getPSBaseDir() + WebContainer.fs + "export" + WebContainer.fs + "voice";
                OSTasks osTasks = OSTasksFactory.getOSTasks(configContext, this.logger);
                osTasks.createSymbolicLink(voiceDir, this.wcDocRootDir);
                osTasks.createSymbolicLink(psHelpDir + WebContainer.fs + "ps", helpDir);
                osTasks.createSymbolicLink(psHelpDir + WebContainer.fs + "ma", helpDir);
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block2;
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0040");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
        }
    }

    public void doMiscTasks(PSConfigContext configContext) {
        block3: {
            try {
                boolean done = this.doJVMMemorySettings();
                this.doPolicyConfig(configContext);
                this.appendClasspath(this.getWsrpJaxRpcClasspath(configContext), CLASSPATH_PREFIX);
                if (done) {
                    this.wcReconfig();
                }
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block3;
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0101");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
        }
    }

    public boolean doJVMMemorySettings() {
        block3: {
            try {
                String vmOptions = this.wcGet("java-config.jvm-options");
                if (vmOptions.indexOf("-Xss") < 0) {
                    this.addJVMOption("-Xms512m", "");
                    this.addJVMOption("-Xss128k", "");
                    this.addJVMOption("-XX:NewSize", "168M");
                    this.addJVMOption("-XX:MaxNewSize", "168M");
                    this.addJVMOption("-XX:PermSize", "192M");
                    this.addJVMOption("-XX:MaxPermSize", "192M");
                    this.addJVMOption("-XX:+DisableExplicitGC", "");
                    this.addJVMOption("-XX:SoftRefLRUPolicyMSPerMB", "0");
                    this.addJVMOption("-XX:+PrintGCTimeStamps", "");
                    this.addJVMOption("-XX:+PrintHeapAtGC", "");
                    this.addJVMOption("-XX:+PrintClassHistogram", "");
                    this.addJVMOption("-Xloggc:" + this.wcInstanceDir + WebContainer.fs + "logs" + WebContainer.fs + "gc.log", "");
                    return true;
                }
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block3;
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0026");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
        }
        return false;
    }

    private String getWsrpJaxRpcClasspath(PSConfigContext configContext) {
        String psLib = configContext.getPSBaseDir() + WebContainer.fs + "lib" + WebContainer.fs;
        String pfxCP = psLib + "soapprocessor.jar" + WebContainer.cps + psLib + "security-plugin.jar" + WebContainer.cps + psLib + "xmlsec.jar" + WebContainer.cps + psLib + "xws-security.jar" + WebContainer.cps + psLib + "xws-security_jaxrpc.jar" + WebContainer.cps;
        return pfxCP;
    }

    private void doPolicyConfig(PSConfigContext configContext) {
        block3: {
            try {
                String policy = this.wcInstanceDir + WebContainer.fs + "config" + WebContainer.fs + "server.policy";
                File file = new File(policy);
                String productMarker = configContext.getPortalProductName() + " " + configContext.getPortalVersion();
                String str = FileUtil.findTextInFile(file, productMarker);
                if (str == null || str.equals("")) {
                    StringBuffer buf = new StringBuffer();
                    buf.append(WebContainer.nl);
                    buf.append(POLICY_START_TAG).append(productMarker).append(WebContainer.nl);
                    buf.append("grant {").append(WebContainer.nl);
                    buf.append("    permission java.util.PropertyPermission \"*\",\"read,write\";").append(WebContainer.nl);
                    buf.append("    permission java.lang.RuntimePermission \"writeFileDescriptor\";").append(WebContainer.nl);
                    buf.append("    permission java.lang.RuntimePermission \"createClassLoader\";").append(WebContainer.nl);
                    buf.append("    permission java.io.FilePermission \"\\${/}-\", \"read,write,execute,delete\";").append(WebContainer.nl);
                    buf.append(WebContainer.nl);
                    buf.append("//  Used by psconsole app").append(WebContainer.nl);
                    buf.append("    permission java.security.SecurityPermission \"insertProvider.SunSASL\";").append(WebContainer.nl);
                    buf.append("    permission java.security.SecurityPermission \"insertProvider.SunJSSE\";").append(WebContainer.nl);
                    buf.append(WebContainer.nl);
                    buf.append("//  Used by wsrp xws identity propagation CR:6355658").append(WebContainer.nl);
                    buf.append("    permission javax.security.auth.AuthPermission \"modifyPrivateCredentials\";").append(WebContainer.nl);
                    buf.append(WebContainer.nl);
                    String sPsMonitoringConfigDir = configContext.getPSConfigDir() + WebContainer.fs + "domains" + WebContainer.fs + this.domainID + WebContainer.fs + "portals" + WebContainer.fs + this.portalID + WebContainer.fs + this.instanceID;
                    String sPsInstanceConfigDir = sPsMonitoringConfigDir + WebContainer.fs + "-";
                    buf.append("//  Used by Monitoring").append(WebContainer.nl);
                    buf.append("    permission java.io.FilePermission \"").append(sPsInstanceConfigDir).append("\", \"read, write, execute, delete\";").append(WebContainer.nl);
                    buf.append("    permission java.lang.RuntimePermission \"accessClassInPackage.*\";").append(WebContainer.nl);
                    buf.append("    permission java.lang.RuntimePermission \"setContextClassLoader\";").append(WebContainer.nl);
                    buf.append("    permission java.net.SocketPermission \"localhost:-\", \"accept, connect, listen\";").append(WebContainer.nl);
                    buf.append("    permission java.security.SecurityPermission \"createAccessControlContext\";").append(WebContainer.nl);
                    buf.append("    permission java.security.SecurityPermission \"insertProvider.PortalServer\";").append(WebContainer.nl);
                    buf.append("    permission java.security.SecurityPermission \"putProviderProperty.PortalServer\";").append(WebContainer.nl);
                    buf.append("    permission java.util.PropertyPermission \"*\", \"read\";").append(WebContainer.nl);
                    buf.append("    permission java.util.PropertyPermission \"com.sun.portal.*\", \"read, write\";").append(WebContainer.nl);
                    buf.append("    permission java.util.logging.LoggingPermission \"control\";").append(WebContainer.nl);
                    buf.append("    permission javax.management.MBeanPermission \"javax.management.*\", \"*\";").append(WebContainer.nl);
                    buf.append("    permission javax.management.MBeanPermission \"com.sun.jdmk.*\", \"*\";").append(WebContainer.nl);
                    buf.append("    permission javax.management.MBeanPermission \"com.sun.portal.*\", \"*\";").append(WebContainer.nl);
                    buf.append("    permission javax.management.MBeanServerPermission \"createMBeanServer\";").append(WebContainer.nl);
                    buf.append("    permission javax.management.MBeanServerPermission \"findMBeanServer\";").append(WebContainer.nl);
                    buf.append("    permission javax.management.MBeanTrustPermission \"register\";").append(WebContainer.nl);
                    buf.append(WebContainer.nl);
                    buf.append("//  Used by Community").append(WebContainer.nl);
                    buf.append("    permission java.lang.RuntimePermission \"getClassLoader\";").append(WebContainer.nl);
                    buf.append("    permission javax.jdo.spi.JDOPermission \"getMetadata\";").append(WebContainer.nl);
                    buf.append("    permission javax.jdo.spi.JDOPermission \"setStateManager\";").append(WebContainer.nl);
                    buf.append("    permission java.lang.reflect.ReflectPermission \"suppressAccessChecks\";").append(WebContainer.nl);
                    buf.append(WebContainer.nl);
                    buf.append("//  Used by SRA NetFile").append(WebContainer.nl);
                    buf.append("    permission java.net.SocketPermission \"*\", \"connect,accept,listen,resolve\";").append(WebContainer.nl);
                    buf.append("    permission java.net.NetPermission \"*\", \"specifyStreamHandler\";").append(WebContainer.nl);
                    buf.append(WebContainer.nl);
                    buf.append("};").append(WebContainer.nl);
                    buf.append(POLICY_END_TAG).append(productMarker).append(WebContainer.nl);
                    buf.append(WebContainer.nl);
                    FileUtil.appendToFile(file, buf.toString(), false);
                }
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block3;
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0028");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
        }
    }

    public void configResource(Element root, String derbyHost, String derbyPort, String databaseName, String poolName, String psLibDir) {
        this.createConnectionPool(root, derbyHost, derbyPort, databaseName, poolName);
        this.createResources(root, poolName);
    }

    public void createConnectionPool(Element root, String derbyHost, String derbyPort, String databaseName, String poolName) {
        String dataSourceClassName = root.getAttributeValue("dataSourceClassName.SJSAS81");
        String[] args = new String[]{"create-jdbc-connection-pool", "--user", this.wcAdminUser, "--passwordfile", this.wcAdminPasswordFilePath, "--host", this.wcAdminHost, "--port", this.wcAdminPort, "--datasourceclassname", dataSourceClassName != null && !dataSourceClassName.equals("") && dataSourceClassName.length() > 0 ? dataSourceClassName : root.getAttributeValue("dataSourceClassName"), "--restype", root.getAttributeValue("type"), "--maxpoolsize", root.getAttributeValue("maxActive"), "--maxwait", root.getAttributeValue("maxWait"), "--idletimeout", root.getAttributeValue("maxIdle"), "--property", "serverName=" + derbyHost + ":portNumber=" + derbyPort + ":User=" + root.getAttributeValue("username") + ":Password=" + root.getAttributeValue("password") + ":databaseName=" + databaseName, poolName};
        int iRetCode = this.execUtil.exec(this.command, args);
        if (iRetCode != 0) {
            String sError = this.execUtil.getError();
            this.logger.log(Level.FINEST, "PSFB_CSPFT0012", new String[]{this.getCommand(this.command, args), sError != null ? sError : ""});
        }
    }

    public void createResources(Element root, String poolName) {
        String[] args = new String[]{"create-jdbc-resource", "--user", this.wcAdminUser, "--passwordfile", this.wcAdminPasswordFilePath, "--host", this.wcAdminHost, "--port", this.wcAdminPort, "--connectionpoolid", poolName, root.getAttributeValue("name")};
        this.execUtil.exec(this.command, args);
        int iRetCode = this.execUtil.exec(this.command, args);
        if (iRetCode != 0) {
            String sError = this.execUtil.getError();
            this.logger.log(Level.FINEST, "PSFB_CSPFT0012", new String[]{this.getCommand(this.command, args), sError != null ? sError : ""});
        }
    }

    public void removeConnectionPool(String poolName) {
        String[] args = new String[]{"delete-jdbc-connection-pool", "--user", this.wcAdminUser, "--passwordfile", this.wcAdminPasswordFilePath, "--host", this.wcAdminHost, "--port", this.wcAdminPort, poolName};
        this.execUtil.exec(this.command, args);
    }

    public void removeResource(String jndiName) {
        String[] args = new String[]{"delete-jdbc-resource", "--user", this.wcAdminUser, "--passwordfile", this.wcAdminPasswordFilePath, "--host", this.wcAdminHost, "--port", this.wcAdminPort, jndiName};
        this.execUtil.exec(this.command, args);
    }

    public void unConfigResource(String jndiName, String poolName) {
        this.removeConnectionPool(poolName);
        this.removeResource(jndiName);
    }

    public boolean removeClasspath(String classpath) {
        return this.removeClasspath(classpath, CLASSPATH_SUFFIX);
    }

    private boolean removeClasspath(String classpath, String target) {
        try {
            String sValue2 = this.wcGet(target);
            int startIndex1 = sValue2.indexOf(classpath);
            if (startIndex1 < 0) {
                return false;
            }
            String sValue3 = sValue2.replaceAll(classpath, "");
            this.wcSet(target, sValue3);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0029");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
            return false;
        }
        return true;
    }

    public boolean removeNativeLibraryPath(String path) {
        try {
            String sValue = this.wcGet(NATIVE_LIBRARY_PATH);
            String myPath = "." + WebContainer.cps + path;
            int startIndex = sValue.indexOf(myPath);
            if (startIndex < 0) {
                return false;
            }
            String sValue1 = sValue.replaceAll(myPath, "");
            this.wcSet(NATIVE_LIBRARY_PATH, sValue1);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0030");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
            return false;
        }
        return true;
    }

    public void deleteSymbolicLinks(PSConfigContext configContext) {
        block2: {
            try {
                String helpDir = this.wcDocRootDir + WebContainer.fs + "online_help" + WebContainer.fs + "docs_en_US";
                OSTasks osTasks = OSTasksFactory.getOSTasks(configContext, this.logger);
                osTasks.removeSymbolicLink(this.wcDocRootDir + WebContainer.fs + "voice");
                osTasks.removeSymbolicLink(helpDir + WebContainer.fs + "ps");
                osTasks.removeSymbolicLink(helpDir + WebContainer.fs + "ma");
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block2;
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0038");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
        }
    }

    public void undoMiscTasks(PSConfigContext configContext) {
        block2: {
            try {
                String policy = this.wcInstanceDir + WebContainer.fs + "config" + WebContainer.fs + "server.policy";
                File file = new File(policy);
                String productMarker = configContext.getPortalProductName() + " " + configContext.getPortalVersion();
                FileUtil.deleteSectionInFile(file, POLICY_START_TAG + productMarker, POLICY_END_TAG + productMarker);
                this.removeClasspath(this.getWsrpJaxRpcClasspath(configContext), CLASSPATH_PREFIX);
                this.wcReconfig();
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block2;
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0031");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
        }
    }
}

