/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.fabric.tasks.ConfigurationException;
import com.sun.portal.fabric.tasks.ValidationException;
import com.sun.portal.fabric.tasks.WebContainer;
import com.sun.portal.fabric.tasks.WebContainerBase;
import com.sun.portal.fabric.util.FileUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;

public class JESAS7Impl
extends WebContainerBase {
    private static final String LIB_PATH_PREFIX = "java-config.libpathprefix";
    private static final String CLASSPATH_SUFFIX = "java-config.classpathsuffix";
    private static final String SERVER_CLASSPATH = "java-config.server-classpath";
    private String wcHomeDir = null;
    private String wcInstanceDir = null;
    private String wcTargetInstance = null;
    private String wcTargetDomain = null;
    private String wcDocRootDir = null;
    private String wcAdminUser = null;
    private String wcAdminPassword = null;
    private String wcAdminPasswordFilePath = null;
    private String wcAdminProtocol = null;
    private String wcAdminHost = null;
    private String wcAdminPort = null;
    private String amconfigScript = null;
    private String command = null;

    public JESAS7Impl(Map wcAttributes, Logger logger) {
        super(wcAttributes, logger);
        this.wcHomeDir = (String)wcAttributes.get("WebContainerInstallDir");
        this.wcInstanceDir = (String)wcAttributes.get("WebContainerInstanceDir");
        this.wcTargetInstance = (String)wcAttributes.get("WebContainerInstanceName");
        this.wcTargetDomain = (String)wcAttributes.get("WebContainerDomainName");
        this.wcDocRootDir = (String)wcAttributes.get("WebContainerDocRoot");
        this.wcAdminUser = (String)wcAttributes.get("WebContainerAdminUid");
        this.wcAdminPassword = (String)wcAttributes.get("WebContainerAdminPassword");
        this.wcAdminProtocol = (String)wcAttributes.get("WebContainerAdminScheme");
        this.wcAdminHost = (String)wcAttributes.get("WebContainerAdminHost");
        this.wcAdminPort = (String)wcAttributes.get("WebContainerAdminPort");
        this.execUtil.storeOutput(true);
        this.execUtil.storeError(true);
        this.command = this.wcHomeDir + WebContainer.fs + "bin" + WebContainer.fs + "asadmin";
        this.createPasswordFile();
    }

    public void start() throws ConfigurationException {
        String[] args = new String[]{"start-instance", "-u", this.wcAdminUser, "--passwordfile", this.wcAdminPasswordFilePath, "-H", this.wcAdminHost, "-p", this.wcAdminPort, this.wcTargetInstance};
        this.execUtil.exec(this.command, args);
    }

    public void stop() throws ConfigurationException {
        String[] args = new String[]{"stop-instance", "-u", this.wcAdminUser, "--passwordfile", this.wcAdminPasswordFilePath, "-H", this.wcAdminHost, "-p", this.wcAdminPort, this.wcTargetInstance};
        this.execUtil.exec(this.command, args);
    }

    public void deploy(String warFile, String uri) throws ConfigurationException {
        String[] args = new String[]{"deploy", "-u", this.wcAdminUser, "--passwordfile", this.wcAdminPasswordFilePath, "-H", this.wcAdminHost, "-p", this.wcAdminPort, "--instance", this.wcTargetInstance, "--name", uri.charAt(0) == '/' ? uri.substring(1) : uri, "--contextroot", uri, "--type", "web", warFile};
        this.execUtil.exec(this.command, args);
    }

    public void undeploy(String uri) throws ConfigurationException {
        String[] args = new String[]{"undeploy", "-u", this.wcAdminUser, "--passwordfile", this.wcAdminPasswordFilePath, "-H", this.wcAdminHost, "-p", this.wcAdminPort, "--instance", this.wcTargetInstance, "--type", "web", uri};
        this.execUtil.exec(this.command, args);
    }

    private void doSRAPolicyConfig() throws ConfigurationException {
        String marker;
        String policy = this.wcInstanceDir + WebContainer.fs + "config" + WebContainer.fs + "server.policy";
        File file = new File(policy);
        String str = FileUtil.findTextInFile(file, marker = "permission java.net.NetPermission \"*\"");
        if (str == null || str.equals("")) {
            StringBuffer buf = new StringBuffer();
            buf.append("// START OF S1AS70 - SRA NetFile" + WebContainer.nl);
            buf.append("grant {" + WebContainer.nl);
            buf.append("    permission java.net.SocketPermission \"*\", \"connect,accept,listen,resolve\";" + WebContainer.nl);
            buf.append("    permission java.net.NetPermission \"*\", \"specifyStreamHandler\";" + WebContainer.nl);
            buf.append("};" + WebContainer.nl);
            buf.append("// END OF S1AS70 - SRA NetFile" + WebContainer.nl);
            buf.append(WebContainer.nl);
            FileUtil.appendToFile(file, buf.toString(), false);
        }
    }

    public void doIdentitySDKConfig(PSConfigContext configContext) throws ConfigurationException {
        if (this.isIdentityServerSDKConfigured()) {
            return;
        }
        String protocol = (String)this.wcAttributes.get("Scheme");
        String port = (String)this.wcAttributes.get("Port");
        String amProductLoc = configContext.getISBaseDir();
        String amConfigDir = configContext.getISConfigDir();
        String psDataDir = configContext.getPSDataDir();
        int index = amProductLoc.lastIndexOf(WebContainer.fs);
        String amProductDir = amProductLoc.substring(index + 1);
        String amBaseDir = amProductLoc.substring(0, index);
        this.logger.log(Level.FINEST, "Configuring webcontainer for AM...");
        String amSilentName = psDataDir + WebContainer.fs + "tmp" + WebContainer.fs + "amsilent_ps." + FileUtil.getRandomDirName();
        StringBuffer fileData = new StringBuffer();
        fileData.append("BASEDIR=" + amBaseDir + WebContainer.nl).append("PRODUCT_DIR=" + amProductDir + WebContainer.nl).append("CONFIG_DIR=" + amConfigDir + WebContainer.nl + WebContainer.nl).append("AS70_HOME=" + this.wcHomeDir + WebContainer.nl).append("AS70_DOMAIN=" + this.wcTargetDomain + WebContainer.nl).append("AS70_INSTANCE_DIR=" + this.wcInstanceDir + WebContainer.nl).append("AS70_INSTANCE=" + this.wcTargetInstance + WebContainer.nl).append("AS70_DOCS_DIR=" + this.wcDocRootDir + WebContainer.nl).append("AS70_IS_SECURE=false" + WebContainer.nl).append("AS70_PROTOCOL=" + protocol + WebContainer.nl).append("AS70_HOST=" + this.wcAdminHost + WebContainer.nl).append("AS70_PORT=" + port + WebContainer.nl).append("AS70_ADMIN=" + this.wcAdminUser + WebContainer.nl).append("AS70_ADMINPASSWD=" + this.wcAdminPassword + WebContainer.nl).append("AS70_ADMINPORT=" + this.wcAdminPort + WebContainer.nl);
        if (configContext.getAMVersion().equals("6")) {
            fileData.append("DEPLOY_LEVEL=4" + WebContainer.nl);
            this.amconfigScript = "amas70config";
        } else {
            fileData.append("DEPLOY_LEVEL=7" + WebContainer.nl).append("JAVA_HOME=" + configContext.getJavaHome() + WebContainer.nl).append("WEB_CONTAINER=AS7" + WebContainer.nl);
            this.amconfigScript = "amconfig";
        }
        File amSilentFile = new File(amSilentName);
        try {
            FileWriter fwriter = new FileWriter(amSilentFile);
            fwriter.write(fileData.toString());
            fwriter.close();
        }
        catch (IOException ioe) {
            this.logger.log(Level.SEVERE, "Error during creation of the silent config file for AM configuration.");
            this.logger.log(Level.SEVERE, "Webcontainer configuration for AM failed." + ioe);
            amSilentFile.delete();
            return;
        }
        String amas70config = amProductLoc + WebContainer.fs + "bin" + WebContainer.fs + this.amconfigScript;
        String[] args = new String[]{"-s", amSilentFile.getAbsolutePath()};
        this.logger.log(Level.FINEST, "Calling " + amas70config + " ...");
        if (this.execUtil.exec(amas70config, args) != 0) {
            this.logger.log(Level.SEVERE, "Webcontainer configuration failed for AM.");
        } else {
            this.logger.log(Level.INFO, "Webcontainer configuration done for AM.");
        }
        amSilentFile.delete();
    }

    private void wcSet(String key, String value) throws ConfigurationException {
        String[] args = new String[]{"set", this.wcTargetInstance + "." + key + "=" + value, "-u", this.wcAdminUser, "--passwordfile", this.wcAdminPasswordFilePath, "-H", this.wcAdminHost, "-p", this.wcAdminPort};
        this.execUtil.exec(this.command, args);
    }

    private final String wcGet(String key) throws ConfigurationException {
        int iIndex;
        String value;
        String[] args = new String[]{"get", "-u", this.wcAdminUser, "--passwordfile", this.wcAdminPasswordFilePath, "-H", this.wcAdminHost, "-p", this.wcAdminPort, this.wcTargetInstance + "." + key};
        int iRetCode = this.execUtil.exec(this.command, args);
        String string = value = iRetCode == 0 ? this.execUtil.getOutput() : this.execUtil.getError();
        if (iRetCode == 0 && (iIndex = value.indexOf("=")) >= 0) {
            value = value.substring(iIndex + 1);
            value = value.trim();
        }
        return value;
    }

    private void wcReconfig() {
        String[] args = new String[]{"reconfig", "-u", this.wcAdminUser, "--passwordfile", this.wcAdminPasswordFilePath, "-H", this.wcAdminHost, "-p", this.wcAdminPort, "--keepmanualchanges=true", this.wcTargetInstance};
        this.execUtil.exec(this.command, args);
    }

    private final boolean isIdentityServerSDKConfigured() throws ConfigurationException {
        String sValue = this.wcGet(CLASSPATH_SUFFIX);
        String sMarker = null;
        if (sValue != null) {
            sValue = WebContainer.cps + sValue + WebContainer.cps;
            sMarker = WebContainer.cps + "am_sdk.jar" + WebContainer.cps;
        }
        return sValue != null && sValue.indexOf(sMarker) >= 0;
    }

    private void createPasswordFile() {
        StringBuffer fileData = new StringBuffer();
        fileData.append("AS_ADMIN_PASSWORD=").append(this.wcAdminPassword);
        try {
            File appPasswordFile = File.createTempFile("appserver", "pass");
            appPasswordFile.deleteOnExit();
            this.wcAdminPasswordFilePath = appPasswordFile.getAbsolutePath();
            FileWriter fwriter = new FileWriter(appPasswordFile);
            fwriter.write(fileData.toString());
            fwriter.close();
        }
        catch (IOException ioe) {
            this.logger.log(Level.SEVERE, "Error during creation of the password_file for Appserver 7.0.");
            return;
        }
    }

    public void postValidationInit() throws ConfigurationException {
        this.wcPrintableInstanceName = this.wcTargetInstance;
    }

    public void validate() throws ValidationException {
        String port;
        if (!this.checkNotNullOrEmpty("WebContainerInstanceName", this.wcTargetInstance)) {
            throw new ValidationException("Invalid Instance Name");
        }
        if (!this.checkNotNullOrEmpty("WebContainerDomainName", this.wcTargetDomain)) {
            throw new ValidationException("Invalid Domain Name");
        }
        if (!this.checkNotNull("WebContainerAdminUid", this.wcAdminUser)) {
            throw new ValidationException("Invalid Admin User");
        }
        if (!this.checkNotNull("WebContainerAdminPassword", this.wcAdminPassword, true)) {
            throw new ValidationException("Invalid Admin Password");
        }
        if (!this.checkNotNullOrEmpty("WebContainerAdminScheme", this.wcAdminProtocol)) {
            throw new ValidationException("Invalid Admin Scheme");
        }
        if (!this.checkNotNullOrEmpty("WebContainerAdminHost", this.wcAdminHost)) {
            throw new ValidationException("Invalid Admin Host");
        }
        if (!this.checkNotNullOrEmpty("WebContainerAdminPort", this.wcAdminPort)) {
            throw new ValidationException("Invalid Admin Port");
        }
        if (!this.checkDirExists("WebContainerInstanceDir", this.wcInstanceDir)) {
            throw new ValidationException("Invalid Instance Directory=" + this.wcInstanceDir);
        }
        if (!this.checkDirExists("WebContainerDocRoot", this.wcDocRootDir)) {
            throw new ValidationException("Invalid Doc RootDirectory" + this.wcDocRootDir);
        }
        if (!this.checkDirExists("WebContainerInstallDir", this.wcHomeDir)) {
            throw new ValidationException("Invalid Install Directory" + this.wcHomeDir);
        }
        String host = (String)this.wcAttributes.get("Host");
        boolean bIsValidHostNamePort = this.validateInstanceHostNamePort(host, port = (String)this.wcAttributes.get("Port"));
        if (!bIsValidHostNamePort) {
            throw new ValidationException("Invalid Instance Host/Port");
        }
        bIsValidHostNamePort = this.validateAdminHostNamePort(this.wcAdminHost, this.wcAdminPort);
        if (!bIsValidHostNamePort) {
            throw new ValidationException("Invalid Admin Host/Port");
        }
        try {
            String sClassPathSuffix = this.wcGet(CLASSPATH_SUFFIX);
            String sFieldName = this.wcPrintableInstanceName + "." + CLASSPATH_SUFFIX;
            if (!this.checkNotNullOrEmpty(sFieldName, sClassPathSuffix)) {
                throw new ValidationException("Could not fetch the value of " + sFieldName);
            }
        }
        catch (ConfigurationException e) {
            throw new ValidationException(e);
        }
    }

    public boolean isPortalConfigured() {
        boolean retValue = false;
        try {
            String sValue = this.wcGet(SERVER_CLASSPATH);
            retValue = sValue != null && sValue.indexOf("ps_util.jar") >= 0;
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Portal configuration test failed", e);
            return false;
        }
        return retValue;
    }

    public boolean appendClasspath(String classpath) {
        block3: {
            try {
                if (classpath == null || classpath.trim().length() <= 0) break block3;
                String sValue = this.wcGet(SERVER_CLASSPATH);
                sValue = sValue != null && sValue.length() > 0 ? this.getMergedClassPath(classpath, sValue) : classpath;
                if (sValue != null) {
                    this.wcSet(SERVER_CLASSPATH, sValue);
                    break block3;
                }
                return false;
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "Classpath configuration failed", e);
                return false;
            }
        }
        return true;
    }

    public boolean setNativeLibraryPath(String path) {
        try {
            String value1 = ".:" + path;
            this.wcSet(LIB_PATH_PREFIX, value1);
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "setNativeLibraryPath failed", e);
            return false;
        }
        return true;
    }

    public boolean addJVMOption(String key, String value) {
        return true;
    }

    public void createSymbolicLinks(PSConfigContext configContext) {
    }

    public void doMiscTasks(PSConfigContext configContext) {
        try {
            String policy = this.wcInstanceDir + WebContainer.fs + "config" + WebContainer.fs + "server.policy";
            File file = new File(policy);
            String marker = "permission java.io.FilePermission \"\\${/}-\"";
            String str = FileUtil.findTextInFile(file, marker);
            if (str == null || str.equals("")) {
                StringBuffer buf = new StringBuffer();
                buf.append("// START OF S1AS70 : added by PS" + WebContainer.nl);
                buf.append("grant {" + WebContainer.nl);
                buf.append("    permission java.util.PropertyPermission \"*\",\"read,write\";" + WebContainer.nl);
                buf.append("    permission java.lang.RuntimePermission \"writeFileDescriptor\";" + WebContainer.nl);
                buf.append("    permission java.lang.RuntimePermission \"createClassLoader\";" + WebContainer.nl);
                buf.append("    permission java.io.FilePermission \"\\${/}-\", \"read,write,execute,delete\";" + WebContainer.nl);
                buf.append("};" + WebContainer.nl);
                buf.append("// END OF S1AS70 : added by PS" + WebContainer.nl);
                FileUtil.appendToFile(file, buf.toString(), false);
            }
            this.doSRAPolicyConfig();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "doMiscTasks failed", e);
        }
    }

    public void configResource(Element root, String derbyHost, String derbyPort, String databaseName, String poolName, String psLibDir) {
    }

    public void unConfigResource(String jndiName, String poolName) {
    }

    public boolean removeClasspath(String classpath) {
        return true;
    }

    public boolean removeJVMOption(String option, String value) {
        return true;
    }

    public boolean removeNativeLibraryPath(String path) {
        return true;
    }

    public void deleteSymbolicLinks(PSConfigContext configContext) {
    }

    public void undoMiscTasks(PSConfigContext configContext) {
    }

    public boolean doJVMMemorySettings() {
        return false;
    }
}

