/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.fabric.tasks.ConfigurationException;
import com.sun.portal.fabric.tasks.ValidationException;
import com.sun.portal.fabric.tasks.WebContainer;
import com.sun.portal.fabric.tasks.WebContainerBase;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.fabric.util.os.OSTasks;
import com.sun.portal.fabric.util.os.OSTasksFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jdom.Element;

public class IBMWAS5Impl
extends WebContainerBase {
    private String wcTargetInstance = null;
    private String wcHomeDir = null;
    private String wcDeployNode = null;
    private String wcDeployCell = null;
    private String wcAdminUser = null;
    private String wcAdminPassword = null;
    private String wcConfigdir = null;
    private String wcJDKDir = null;
    private String wcDocRootDir = null;
    private static File wcConfigfile = null;
    private static File setupFile = null;
    private String amconfigScript = null;
    private String wcDefaultHost;

    public IBMWAS5Impl(Map wcAttributes, Logger logger) {
        super(wcAttributes, logger);
        this.wcHomeDir = (String)wcAttributes.get("WebContainerInstallDir");
        this.wcTargetInstance = (String)wcAttributes.get("WebContainerInstanceName");
        this.wcDocRootDir = (String)wcAttributes.get("WebContainerDocRoot");
        this.wcJDKDir = (String)wcAttributes.get("WebContainerJDKDir");
        this.wcAdminUser = (String)wcAttributes.get("WebContainerAdminUid");
        this.wcAdminPassword = (String)wcAttributes.get("WebContainerAdminPassword");
        this.wcDeployNode = (String)wcAttributes.get("WebContainerDeployNode");
        this.wcDeployCell = (String)wcAttributes.get("WebContainerDeployCell");
    }

    public void postValidationInit() throws ConfigurationException {
        this.wcConfigdir = this.wcHomeDir + WebContainer.fs + "config" + WebContainer.fs + "cells" + WebContainer.fs + this.wcDeployCell + WebContainer.fs + "nodes" + WebContainer.fs + this.wcDeployNode + WebContainer.fs + "servers" + WebContainer.fs + this.wcTargetInstance;
        wcConfigfile = new File(this.wcConfigdir + WebContainer.fs + "server.xml");
        this.logger.log(Level.FINEST, "PSFB_CSPFT0050", new String[]{"Config Dir", this.wcConfigdir});
        setupFile = new File(this.wcHomeDir + WebContainer.fs + "bin" + WebContainer.fs + "setupCmdLine.sh");
        this.wcPrintableInstanceName = this.wcDeployCell + "." + this.wcDeployNode + "." + this.wcTargetInstance;
    }

    public void deploy(String warFile, String uri) throws ConfigurationException {
        CharSequence command;
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("deploy", ".jacl");
            command = new StringBuffer();
            command.append("$AdminApp install ");
            command.append(FileUtil.decoratePath(warFile));
            command.append(" {-contextroot " + uri + "  -usedefaultbindings -nopreCompileJSPs -distributeApp -nouseMetaDataFromBinary ");
            command.append(" -node ");
            command.append(this.wcDeployNode);
            command.append(" -cell ");
            command.append(this.wcDeployCell);
            command.append(" -server ");
            command.append(this.wcTargetInstance);
            command.append(" -appname " + uri.substring(1) + "  -createMBeansForResources -noreloadEnabled -reloadInterval 0 -nodeployws} ");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            this.logger.log(Level.FINEST, "PSFB_CSPFT0050", new String[]{"War deploy command", command.toString()});
            command = new StringBuffer();
            command.append("$AdminConfig save");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex.toString());
        }
        command = this.wcHomeDir + WebContainer.fs + "bin" + WebContainer.fs + "wsadmin.sh";
        String[] serviceArgs = new String[]{"-f", FileUtil.decoratePath(tmpFile.getAbsolutePath())};
        try {
            this.execUtil.exec((String)command, serviceArgs);
            tmpFile.delete();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.toString());
        }
    }

    public void undeploy(String uri) throws ConfigurationException {
        CharSequence command;
        File tmpFile = null;
        try {
            tmpFile = File.createTempFile("undeploy", ".jacl");
            command = new StringBuffer();
            command.append("$AdminApp uninstall ");
            command.append(uri.substring(1));
            command.append(" {-node ");
            command.append(this.wcDeployNode);
            command.append(" -cell ");
            command.append(this.wcDeployCell);
            command.append(" -server ");
            command.append(this.wcTargetInstance);
            command.append("}");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            this.logger.log(Level.FINEST, "PSFB_CSPFT0050", new String[]{"War undeploy command", command.toString()});
            command = new StringBuffer();
            command.append("$AdminConfig save");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex.toString());
        }
        command = this.wcHomeDir + WebContainer.fs + "bin" + WebContainer.fs + "wsadmin.sh";
        String[] serviceArgs = new String[]{"-f", FileUtil.decoratePath(tmpFile.getAbsolutePath())};
        try {
            this.execUtil.exec((String)command, serviceArgs);
            tmpFile.delete();
        }
        catch (Exception e) {
            throw new ConfigurationException(e.toString());
        }
    }

    private final boolean isIdentityServerSDKConfigured(PSConfigContext configContext) throws ConfigurationException {
        boolean amConfigured = false;
        String amSDKJar = FileUtil.findTextInFile(wcConfigfile, "am_sdk.jar");
        if (amSDKJar != null && amSDKJar.trim().length() > 0) {
            amConfigured = true;
        }
        this.logger.log(Level.FINEST, "PSFB_CSPFT0051", new String[]{"am_sdk.jar", wcConfigfile.getAbsolutePath()});
        this.logger.log(Level.FINEST, "PSFB_CSPFT0052", new String[]{amConfigured ? "true" : "false"});
        return amConfigured;
    }

    public void doIdentitySDKConfig(PSConfigContext configContext) throws ConfigurationException {
        if (this.isIdentityServerSDKConfigured(configContext)) {
            this.logger.log(Level.FINEST, "PSFB_CSPFT0014", new String[]{this.wcPrintableInstanceName});
            return;
        }
        this.logger.log(Level.FINEST, "PSFB_CSPFT0053", new String[]{this.wcPrintableInstanceName});
        String protocol = (String)this.wcAttributes.get("Scheme");
        String host = (String)this.wcAttributes.get("Host");
        String port = (String)this.wcAttributes.get("Port");
        String amProductLoc = configContext.getISBaseDir();
        String amConfigDir = configContext.getISConfigDir();
        String psDataDir = configContext.getPSDataDir();
        int index = amProductLoc.lastIndexOf(WebContainer.fs);
        String amProductDir = amProductLoc.substring(index + 1);
        String amBaseDir = amProductLoc.substring(0, index);
        this.logger.log(Level.FINEST, "PSFB_CSPFT0015", new String[]{this.wcPrintableInstanceName});
        String amSilentName = psDataDir + WebContainer.fs + "tmp" + WebContainer.fs + "amsilent_ps." + FileUtil.getRandomDirName();
        StringBuffer fileData = new StringBuffer();
        fileData.append("BASEDIR=" + amBaseDir + WebContainer.nl);
        fileData.append("PRODUCT_DIR=" + amProductDir + WebContainer.nl);
        fileData.append("CONFIG_DIR=" + amConfigDir + WebContainer.nl);
        fileData.append("WAS51_HOME=" + this.wcHomeDir + WebContainer.nl);
        fileData.append("WAS51_JDK_HOME=" + this.wcJDKDir + WebContainer.nl);
        fileData.append("WAS51_NODE=" + this.wcDeployNode + WebContainer.nl);
        fileData.append("WAS51_CELL=" + this.wcDeployCell + WebContainer.nl);
        fileData.append("WAS51_INSTANCE=" + this.wcTargetInstance + WebContainer.nl);
        fileData.append("WAS51_PROTOCOL=" + protocol + WebContainer.nl);
        fileData.append("WAS51_HOST=" + host + WebContainer.nl);
        fileData.append("WAS51_PORT=" + port + WebContainer.nl);
        fileData.append("WAS51_ADMIN=" + this.wcAdminUser + WebContainer.nl);
        fileData.append("WAS51_PASSWORD=" + this.wcAdminPassword + WebContainer.nl);
        if (configContext.getAMVersion().equals("6")) {
            fileData.append("DEPLOY_LEVEL=4" + WebContainer.nl);
            this.amconfigScript = "amwas51config";
        } else {
            fileData.append("DEPLOY_LEVEL=7" + WebContainer.nl).append("JAVA_HOME=" + configContext.getJavaHome() + WebContainer.nl).append("WEB_CONTAINER=WAS5" + WebContainer.nl);
            this.amconfigScript = "amconfig";
        }
        File amSilentFile = new File(amSilentName);
        try {
            FileWriter fwriter = new FileWriter(amSilentFile);
            fwriter.write(fileData.toString());
            fwriter.close();
        }
        catch (IOException ioe) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.log(Level.SEVERE, "PSFB_CSPFT0016");
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0017");
                record.setParameters(new String[]{this.wcPrintableInstanceName});
                record.setThrown(ioe);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
            amSilentFile.delete();
            return;
        }
        String amwas51config = amProductLoc + WebContainer.fs + "bin" + WebContainer.fs + this.amconfigScript;
        String[] args = new String[]{"-s", amSilentName};
        this.logger.log(Level.FINEST, "PSFB_CSPFT0018", new String[]{amwas51config});
        if (this.execUtil.exec(amwas51config, args) != 0) {
            this.logger.log(Level.SEVERE, "PSFB_CSPFT0019", new String[]{this.wcType, this.wcPrintableInstanceName});
        } else {
            this.logger.log(Level.INFO, "PSFB_CSPFT0020", new String[]{this.wcType, this.wcPrintableInstanceName});
        }
        amSilentFile.delete();
    }

    public boolean addJVMOption(String option, String value) {
        File tmpFile = null;
        this.logger.log(Level.FINEST, "PSFB_CSPFT0054", new String[]{"addJVMOption", "Option Value Pair", option + "=" + value});
        try {
            tmpFile = File.createTempFile("setjvmOptions", ".jacl");
            String jvmOptionsAttrXPath = "/Server/processDefinition/jvmEntries";
            String presentAttrValue = FileUtil.getAttributeValue(wcConfigfile, jvmOptionsAttrXPath, "genericJvmArguments");
            String optionValuePair = this.getJVMOptionString(option, value);
            String attrSeparator = " ";
            StringBuffer command = new StringBuffer();
            command.append("set dummyID [$AdminConfig getid /Cell:" + this.wcDeployCell + "/Node:" + this.wcDeployNode + "/Server:" + this.wcTargetInstance + "/] ");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("set jvm [$AdminConfig list JavaVirtualMachine $dummyID]");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("$AdminConfig modify $jvm {{genericJvmArguments \"" + presentAttrValue + " " + optionValuePair + "\"}}");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("$AdminConfig save");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            String execCommand = this.wcHomeDir + WebContainer.fs + "bin" + WebContainer.fs + "wsadmin.sh";
            String[] serviceArgs = new String[]{"-f", FileUtil.decoratePath(tmpFile.getAbsolutePath())};
            this.execUtil.exec(execCommand, serviceArgs);
            tmpFile.delete();
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0069");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
            return false;
        }
        return true;
    }

    private String getJVMOptionString(String key, String value) {
        StringBuffer option = new StringBuffer();
        if (key.startsWith("-")) {
            if (value == null || value.trim().equals("")) {
                return key;
            }
            option.append(key).append("=").append(value);
        } else {
            option.append("-D").append(key).append("=").append(value);
        }
        return option.toString();
    }

    public boolean setNativeLibraryPath(String path) {
        this.logger.log(Level.FINEST, "PSFB_CSPFT0054", new String[]{"setNativeLibraryPath", "path", path});
        try {
            path = path + WebContainer.cps + "/usr/lib/lwp";
            String retStr = FileUtil.findTextInFile(setupFile, path);
            if (retStr == null || !retStr.equals("")) {
                return false;
            }
            FileUtil.appendToFile(setupFile, "LD_LIBRARY_PATH=" + path + ":$LD_LIBRARY_PATH", false);
            FileUtil.appendLineInFile(setupFile, "LD_LIBRARY_PATH=", " export LD_LIBRARY_PATH");
            this.logger.log(Level.FINEST, "PSFB_CSPFT0068", new String[]{path, setupFile.getAbsolutePath()});
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0027");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
            return false;
        }
        return true;
    }

    public boolean isPortalConfigured() {
        String str = FileUtil.findTextInFile(wcConfigfile, "ps_util.jar");
        if (str != null && !str.equals("") && str.indexOf("ps_util.jar") >= 0) {
            this.logger.log(Level.INFO, "PSFB_CSPFT0041");
            return true;
        }
        return false;
    }

    public boolean appendClasspath(String classPath) {
        this.logger.log(Level.FINEST, "PSFB_CSPFT0054", new String[]{"appendClasspath", "jars", classPath});
        String cpTkn = FileUtil.findTextInFile(wcConfigfile, "<classpath>");
        if (cpTkn == null && !cpTkn.equals("")) {
            return false;
        }
        String filteredClassPath = this.getFilteredClassPath(classPath, cpTkn);
        FileUtil.replaceTokenInFile(wcConfigfile, "<classpath>", "<classpath>" + filteredClassPath + File.pathSeparator);
        return true;
    }

    public void createSymbolicLinks(PSConfigContext configContext) {
        String installTimeDeployDocroot = configContext.getPSBaseDir() + WebContainer.fs + "export" + WebContainer.fs + "voice";
        String deployDocroot = this.wcDocRootDir;
        if (installTimeDeployDocroot != null && installTimeDeployDocroot.equals(deployDocroot)) {
            FileUtil.copyFile(installTimeDeployDocroot + WebContainer.fs + "voice", deployDocroot + WebContainer.fs + "voice");
        }
        String appDir = this.wcHomeDir + WebContainer.fs + "installedApps" + WebContainer.fs + this.wcDeployCell + WebContainer.fs + "DefaultApplication.ear";
        String defWebApp = "DefaultWebApplication.war";
        String docsDir = appDir + WebContainer.fs + defWebApp;
        String helpDirStr = docsDir + WebContainer.fs + "online_help" + WebContainer.fs + "docs_en_US";
        File helpDir = new File(helpDirStr);
        if (!helpDir.exists()) {
            helpDir.mkdirs();
        }
        String psHelpDir = configContext.getPSBaseDir() + WebContainer.fs + "docs" + WebContainer.fs + "public_html" + WebContainer.fs + "online_help" + WebContainer.fs + "docs_en_US";
        String voiceDir = configContext.getPSBaseDir() + WebContainer.fs + "export" + WebContainer.fs + "voice";
        OSTasks osTasks = OSTasksFactory.getOSTasks(configContext, this.logger);
        osTasks.createSymbolicLink(voiceDir, docsDir);
        osTasks.createSymbolicLink(psHelpDir + WebContainer.fs + "ps", helpDirStr);
        osTasks.createSymbolicLink(psHelpDir + WebContainer.fs + "ma", helpDirStr);
    }

    public void doMiscTasks(PSConfigContext configContext) {
        block2: {
            try {
                this.doJVMMemorySettings();
                this.tuneMinMaxHeap();
                String jaxpClasspath = configContext.getPSBaseDir() + WebContainer.fs + "lib" + WebContainer.fs + "endorsed" + WebContainer.fs + "jaxp-api.jar" + ":" + configContext.getPSBaseDir() + WebContainer.fs + "lib" + WebContainer.fs + "endorsed" + WebContainer.fs + "sax.jar" + ":" + configContext.getPSBaseDir() + WebContainer.fs + "lib" + WebContainer.fs + "endorsed" + WebContainer.fs + "xalan.jar";
                this.appendClasspath(jaxpClasspath);
                this.wcReconfig();
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block2;
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0028");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
        }
    }

    public void configResource(Element root, String derbyHost, String derbyPort, String databaseName, String poolName, String psLibDir) {
        this.createResource(root, poolName, databaseName, derbyHost, derbyPort);
        this.createConnectionPool(root, poolName);
    }

    public void createConnectionPool(Element root, String poolName) {
        try {
            int endIndx = poolName.indexOf("Pool");
            String resourceName = poolName.substring(0, endIndx);
            String provider = resourceName + "Provider";
            File tmpFile = File.createTempFile("createconnectionpool", ".jacl");
            StringBuffer command = new StringBuffer();
            command.append("set newds [$AdminConfig getid /Cell:" + this.wcDeployCell + "/Node:" + this.wcDeployNode + "/JDBCProvider:" + provider + "/DataSource:" + resourceName + "/] ");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("$AdminConfig create ConnectionPool $newds {{maxConnections " + root.getAttributeValue("maxActive") + "}}");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("$AdminConfig save");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            String execCommand = this.wcHomeDir + WebContainer.fs + "bin" + WebContainer.fs + "wsadmin.sh";
            String[] serviceArgs = new String[]{"-f", FileUtil.decoratePath(tmpFile.getAbsolutePath())};
            this.execUtil.exec(execCommand, serviceArgs);
            tmpFile.delete();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "PSFB_CSPFT0098", poolName);
            this.logger.log(Level.SEVERE, "PSFB_CSPFT0099", e);
        }
    }

    public void createResource(Element root, String poolName, String databaseName, String derbyHost, String derbyPort) {
        int endIndx = poolName.indexOf("Pool");
        String resourceName = poolName.substring(0, endIndx);
        String provider = resourceName + "Provider";
        try {
            File tmpFile = File.createTempFile("createresource", ".jacl");
            StringBuffer command = new StringBuffer();
            command.append("set node [$AdminConfig getid /Cell:" + this.wcDeployCell + "/Node:" + this.wcDeployNode + "/] ");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("$AdminConfig required JDBCProvider");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("set n1 [list name " + provider + "]");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            String dataSourceClassName = root.getAttributeValue("dataSourceClassName.IBMWAS5");
            if (dataSourceClassName != null && !dataSourceClassName.equals("") && dataSourceClassName.length() > 0) {
                command.append("set c1 [list implementationClassName " + dataSourceClassName + "]");
            } else {
                command.append("set c1 [list implementationClassName " + root.getAttributeValue("dataSourceClassName") + "]");
            }
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("set jdbcAttrs [list $n1 $c1]");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("$AdminConfig create JDBCProvider $node $jdbcAttrs");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("set newjdbc [$AdminConfig getid /Cell:" + this.wcDeployCell + "/Node:" + this.wcDeployNode + "/JDBCProvider:" + provider + "/] ");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("$AdminConfig required DataSource");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("set name [list name " + resourceName + "]");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("set dsAttrs [list $name]");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("set newds [$AdminConfig create DataSource $newjdbc $dsAttrs]");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("set propSet [$AdminConfig create J2EEResourcePropertySet $newds {}]");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("set attrs1 [subst {{name databaseName} {type java.lang.String} {value " + databaseName + "}}]");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("set attrs2 [subst {{name user} {type java.lang.String} {value " + root.getAttributeValue("username") + "}}]");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("set attrs3 [subst {{name password} {type java.lang.String} {value " + root.getAttributeValue("password") + "}}]");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("set attrs4 [subst {{name serverName} {type java.lang.String} {value " + derbyHost + "}}]");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("set attrs5 [subst {{name driverType} {type java.lang.String} {value " + root.getAttributeValue("type") + "}}]");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("set attrs6 [subst {{name portNumber} {type java.lang.Integer} {value " + derbyPort + "}}]");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("set attrs7 [subst {{name driverClassName} {type java.lang.String} {value " + root.getAttributeValue("driverClassName") + "}}]");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("$AdminConfig create J2EEResourceProperty $propSet $attrs1");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("$AdminConfig create J2EEResourceProperty $propSet $attrs2");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("$AdminConfig create J2EEResourceProperty $propSet $attrs3");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("$AdminConfig create J2EEResourceProperty $propSet $attrs4");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("$AdminConfig create J2EEResourceProperty $propSet $attrs5");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("$AdminConfig create J2EEResourceProperty $propSet $attrs6");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("$AdminConfig create J2EEResourceProperty $propSet $attrs7");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("set attrs8 [subst {{jndiName " + root.getAttributeValue("name") + "}}]");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("$AdminConfig modify $newds $attrs8");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("$AdminConfig save");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            String execCommand = this.wcHomeDir + WebContainer.fs + "bin" + WebContainer.fs + "wsadmin.sh";
            String[] serviceArgs = new String[]{"-f", FileUtil.decoratePath(tmpFile.getAbsolutePath())};
            this.execUtil.exec(execCommand, serviceArgs);
            tmpFile.delete();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "PSFB_CSPFT0097", resourceName);
            this.logger.log(Level.SEVERE, "PSFB_CSPFT0099", e);
        }
    }

    public void unConfigResource(String jndiName, String poolName) {
    }

    public void start() {
        String[] args = new String[]{" " + this.wcTargetInstance};
        String startWebshphereSh = this.wcHomeDir + WebContainer.fs + "bin" + WebContainer.fs + "startServer.sh";
        this.execUtil.exec(startWebshphereSh, args);
    }

    public void stop() {
        String[] args = new String[]{" " + this.wcTargetInstance};
        String stopWebshphereSh = this.wcHomeDir + WebContainer.fs + "bin" + WebContainer.fs + "stopServer.sh";
        this.execUtil.exec(stopWebshphereSh, args);
    }

    public void validate() throws ValidationException {
        String port;
        if (!this.checkNotNullOrEmpty("WebContainerInstanceName", this.wcTargetInstance)) {
            throw new ValidationException("Invalid Instance Name");
        }
        if (!this.checkNotNull("WebContainerAdminUid", this.wcAdminUser)) {
            throw new ValidationException("Invalid Admin User");
        }
        if (!this.checkNotNull("WebContainerAdminPassword", this.wcAdminPassword, true)) {
            throw new ValidationException("Invalid Admin Password");
        }
        if (!this.checkNotNullOrEmpty("WebContainerDeployNode", this.wcDeployNode)) {
            throw new ValidationException("Invalid Deploy Node");
        }
        if (!this.checkNotNullOrEmpty("WebContainerDeployCell", this.wcDeployCell)) {
            throw new ValidationException("Invalid Deploy Cell");
        }
        if (!this.checkDirExists("WebContainerInstallDir", this.wcHomeDir)) {
            throw new ValidationException("Invalid Install Directory = " + this.wcHomeDir);
        }
        if (!this.checkDirExists("WebContainerJDKDir", this.wcJDKDir)) {
            throw new ValidationException("Invalid JDK Directory = " + this.wcJDKDir);
        }
        String host = (String)this.wcAttributes.get("Host");
        boolean bIsValidHostNamePort = this.validateInstanceHostNamePort(host, port = (String)this.wcAttributes.get("Port"));
        if (!bIsValidHostNamePort) {
            throw new ValidationException("Invalid Instance Host/Port");
        }
    }

    public static void main(String[] s) {
    }

    public boolean removeClasspath(String classpath) {
        this.logger.log(Level.FINEST, "PSFB_CSPFT0082");
        String[] classpathEntries = classpath.split(WebContainer.cps);
        String retStr = null;
        String currClasspathJar = null;
        for (int i = 0; i < classpathEntries.length; ++i) {
            currClasspathJar = classpathEntries[i] + WebContainer.cps;
            this.logger.log(Level.FINEST, "Removing PS jar entry:" + classpathEntries[i]);
            retStr = FileUtil.findTextInFile(wcConfigfile, currClasspathJar);
            if (retStr == null || retStr.equals("") || !retStr.trim().startsWith("<classpath>")) continue;
            FileUtil.replaceTokenInFile(wcConfigfile, currClasspathJar, "");
        }
        return true;
    }

    public boolean removeJVMOption(String option, String value) {
        File tmpFile = null;
        this.logger.log(Level.FINEST, "PSFB_CSPFT0054", new String[]{"removeJVMOption", "Option Value Pair", option + "=" + value});
        try {
            tmpFile = File.createTempFile("removejvmOptions", ".jacl");
            String jvmOptionsAttrXPath = "/Server/processDefinition/jvmEntries";
            String presentAttrValue = FileUtil.getAttributeValue(wcConfigfile, jvmOptionsAttrXPath, "genericJvmArguments");
            String optionValuePair = "-D" + option + "=" + value;
            String modifiedAttrValue = presentAttrValue.replaceAll(optionValuePair, "");
            String attrSeparator = " ";
            StringBuffer command = new StringBuffer();
            command.append("set dummyID [$AdminConfig getid /Cell:" + this.wcDeployCell + "/Node:" + this.wcDeployNode + "/Server:" + this.wcTargetInstance + "/] ");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("set jvm [$AdminConfig list JavaVirtualMachine $dummyID]");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("$AdminConfig modify $jvm {{genericJvmArguments \"" + modifiedAttrValue + "\"}}");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            command = new StringBuffer();
            command.append("$AdminConfig save");
            FileUtil.appendToFile(tmpFile, command.toString(), false);
            String execCommand = this.wcHomeDir + WebContainer.fs + "bin" + WebContainer.fs + "wsadmin.sh";
            String[] serviceArgs = new String[]{"-f", FileUtil.decoratePath(tmpFile.getAbsolutePath())};
            this.execUtil.exec(execCommand, serviceArgs);
            tmpFile.delete();
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0056");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
            return false;
        }
        return true;
    }

    public boolean removeNativeLibraryPath(String path) {
        this.logger.log(Level.FINEST, "PSFB_CSPFT0054", new String[]{"removeNativeLibraryPath", "path", path});
        try {
            String pathToDelete = "/usr/lib/lwp";
            String retStr = FileUtil.findTextInFile(setupFile, "LD_LIBRARY_PATH=");
            if (retStr == null || retStr.equals("") || !retStr.trim().startsWith("LD_LIBRARY_PATH=")) {
                return false;
            }
            FileUtil.replaceTokenInFile(setupFile, pathToDelete, "");
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0030");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
            return false;
        }
        return true;
    }

    public void deleteSymbolicLinks(PSConfigContext configContext) {
        block2: {
            this.logger.log(Level.FINEST, "PSFB_CSPFT0055");
            try {
                String appDir = this.wcHomeDir + WebContainer.fs + "installedApps" + WebContainer.fs + this.wcDeployCell + WebContainer.fs + "DefaultApplication.ear";
                String defWebApp = "DefaultWebApplication.war";
                String docsDir = appDir + WebContainer.fs + defWebApp;
                String helpDir = docsDir + WebContainer.fs + "online_help" + WebContainer.fs + "docs_en_US";
                OSTasks osTasks = OSTasksFactory.getOSTasks(configContext, this.logger);
                osTasks.removeSymbolicLink(docsDir + WebContainer.fs + "voice");
                osTasks.removeSymbolicLink(helpDir + WebContainer.fs + "ps");
                osTasks.removeSymbolicLink(helpDir + WebContainer.fs + "ma");
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block2;
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0038");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
        }
    }

    public void undoMiscTasks(PSConfigContext configContext) {
    }

    public boolean doJVMMemorySettings() {
        block3: {
            try {
                String jvmOptionsAttrXPath = "/Server/processDefinition/jvmEntries";
                String presentAttrValue = FileUtil.getAttributeValue(wcConfigfile, jvmOptionsAttrXPath, "genericJvmArguments");
                if (presentAttrValue.indexOf("-Xss") < 0) {
                    this.addJVMOption("-Xss128k  -XX:NewSize=168M -XX:MaxNewSize=168M -XX:PermSize=192M -XX:MaxPermSize=192M -XX:+DisableExplicitGC -XX:SoftRefLRUPolicyMSPerMB=0 -XX:+PrintHeapAtGC -XX:+PrintClassHistogram", "");
                    return true;
                }
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block3;
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0101");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
        }
        return false;
    }

    private void wcReconfig() {
        this.stop();
        this.start();
        this.logger.log(Level.INFO, "PSFB_CSPFT0104");
    }

    public boolean tuneMinMaxHeap() {
        try {
            File tmpFile = File.createTempFile("setheapsize", ".jacl");
            FileUtil.appendToFile(tmpFile, "set dummyID [$AdminConfig getid /Cell:" + this.wcDeployCell + "/Node:" + this.wcDeployNode + "/Server:" + this.wcTargetInstance + "/] ", false);
            FileUtil.appendToFile(tmpFile, "set jvm [$AdminConfig list JavaVirtualMachine $dummyID]", false);
            FileUtil.appendToFile(tmpFile, "$AdminConfig modify $jvm {{initialHeapSize \"512\"}}", false);
            FileUtil.appendToFile(tmpFile, "$AdminConfig modify $jvm {{maximumHeapSize \"1024\"}}", false);
            FileUtil.appendToFile(tmpFile, "$AdminConfig save", false);
            String execCommand = this.wcHomeDir + WebContainer.fs + "bin" + WebContainer.fs + "wsadmin.sh";
            String[] serviceArgs = new String[]{"-f", FileUtil.decoratePath(tmpFile.getAbsolutePath())};
            this.execUtil.exec(execCommand, serviceArgs);
            tmpFile.delete();
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0101");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
            return false;
        }
        return true;
    }
}

