/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.sun.portal.fabric.util.AMTaskUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnableServices {
    private String psRequestLoc;
    private String psTmpDir;
    private String amAdminDN;
    private Logger logger;
    private Properties requestConfig;
    private AMTaskUtil atu;
    private String isBaseDir;
    private String fcURL;
    private String nonAuthURL;
    public static final String fs = File.separator;

    public EnableServices(String psBaseDir, String psDataDir, String isBaseDir, String amAdminDN, String amAdminPassword, Logger logger) {
        this.logger = logger;
        this.amAdminDN = amAdminDN;
        this.isBaseDir = isBaseDir;
        this.psRequestLoc = psBaseDir + fs + "export" + fs + "request";
        this.psTmpDir = psDataDir + fs + "tmp";
        logger.log(Level.FINEST, "Fetching Set of Access Manager Requests");
        String reqConfigPath = psBaseDir + fs + "lib" + fs + "PSAMConfigRequests.properties";
        this.requestConfig = new Properties();
        try {
            this.requestConfig.load(new FileInputStream(reqConfigPath));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to load request config file", e);
        }
        this.atu = new AMTaskUtil(isBaseDir, amAdminDN, amAdminPassword, logger);
    }

    private List getRequestFileList(String type) {
        String requestString = this.requestConfig.getProperty(type, "");
        requestString.trim();
        String[] reqTokenzr = null;
        if (requestString.length() > 0) {
            reqTokenzr = requestString.split("[\\s]+");
        }
        int iSize0 = reqTokenzr != null ? reqTokenzr.length : 0;
        ArrayList<String> requestPaths = new ArrayList<String>();
        for (int i = 0; i < iSize0; ++i) {
            String requestFilePath = this.psRequestLoc + fs + reqTokenzr[i];
            requestPaths.add(requestFilePath);
        }
        return requestPaths;
    }

    public void domainServices(String orgDN) {
        String[] tokens = new String[]{"%ORG_DN%"};
        String[] values = new String[]{orgDN};
        List requestPaths = this.getRequestFileList("DomainSvcConfigRequests");
        this.logger.log(Level.FINEST, "Enabling Domain Servics for: " + orgDN);
        this.atu.processRequestXML(tokens, values, requestPaths, this.psTmpDir);
    }

    public void unConfigdomainServices(String orgDN, String UserNamingAttr) {
        String[] tokens = new String[]{"%ORG_DN%", "%IDSAME_USER_NAMING%"};
        String[] values = new String[]{orgDN, UserNamingAttr};
        List requestPaths = this.getRequestFileList("DomainSvcUnconfigRequests");
        this.logger.log(Level.FINEST, "Removing Domain Servics for: " + orgDN);
        this.atu.processRequestXML(tokens, values, requestPaths, this.psTmpDir);
    }

    public void unConfigSRAServices(String orgDN, String UserNamingAttr) {
        String[] tokens = new String[]{"%ORG_DN%", "%IDSAME_USER_NAMING%"};
        String[] values = new String[]{orgDN, UserNamingAttr};
        List requestPaths = this.getRequestFileList("DomainSRASvcUnconfigRequests");
        this.logger.log(Level.FINEST, "Removing Domain Servics for: " + orgDN);
        this.atu.processRequestXML(tokens, values, requestPaths, this.psTmpDir);
    }

    public void portalServices(String portalID, String orgDN, String UserNamingAttr) {
        String[] tokens = new String[]{"%PORTAL_ID%", "%ORG_DN%", "%IDSAME_USER_NAMING%", "%ADMIN_DN%"};
        String[] values = new String[]{portalID, orgDN, UserNamingAttr, this.amAdminDN};
        List requestPaths = this.getRequestFileList("PortalSvcConfigRequests");
        this.logger.log(Level.FINEST, "Enabling Portal Services for: " + orgDN);
        this.atu.processRequestXML(tokens, values, requestPaths, this.psTmpDir);
    }

    public void unconfigPortalRequests(String portalID, String orgDN, String UserNamingAttr) {
        String[] tokens = new String[]{"%PORTAL_ID%", "%ORG_DN%", "%IDSAME_USER_NAMING%", "%ADMIN_DN%"};
        String[] values = new String[]{portalID, orgDN, UserNamingAttr, this.amAdminDN};
        List requestPaths = this.getRequestFileList("PortalSvcUnconfigRequests");
        this.logger.log(Level.FINEST, "Removing Portal Services for: " + orgDN);
        this.atu.processRequestXML(tokens, values, requestPaths, this.psTmpDir);
    }

    public void sraServices(String orgDN, String sraServerDomain, String gwProtocol, String gwPort, String sraGWProfile, String sraLogUserPassword, String isConsoleURI, String isServerURI, String peopleDN, String portalAccessURI) {
        String rproxyPort;
        String enableRproxy;
        String eproxyPort;
        String enableEproxy;
        if ("https".equalsIgnoreCase(gwProtocol)) {
            enableEproxy = "true";
            eproxyPort = gwPort;
            enableRproxy = "false";
            rproxyPort = "80";
        } else {
            enableEproxy = "false";
            eproxyPort = "443";
            enableRproxy = "true";
            rproxyPort = gwPort;
        }
        this.replaceFCNonAuth();
        String[] tokens = new String[]{"INST_FCURLS", "INST_IS_NONAUTH_URLS", "%ORG_DN%", "%IDSAME_AMCONSOLE%", "%GW_DOMAIN%", "%IDSAME_AMSERVER%", "INST_ENABLE_EPROXY", "INST_ENABLE_RPROXY", "INST_EPROXY_PORT", "INST_GWNAME", "INST_RPROXY_PORT", "INST_SERVER_DOMAIN", "INST_USE_PROXY", "INST_WEB_PROXY_DOMAIN|INST_SUBDOMAIN", "%ADMIN_DN%", "%PEOPLE_DN%", "%SRA_LOG_USER_PASSWORD%", "%PRODUCT_NAME%", "%PRODUCT_VERSION%", "INST_PS_SERVER_LIST"};
        String[] values = new String[]{this.fcURL, this.nonAuthURL, orgDN, isConsoleURI, sraServerDomain, isServerURI, enableEproxy, enableRproxy, eproxyPort, sraGWProfile, rproxyPort, sraServerDomain, "n", sraServerDomain, this.amAdminDN, peopleDN, sraLogUserPassword, "", "", portalAccessURI};
        List requestPaths = this.getRequestFileList("DomainSRASvcConfigRequests");
        this.logger.log(Level.FINEST, "Enabling SRA Services for: " + orgDN);
        this.atu.processRequestXML(tokens, values, requestPaths, this.psTmpDir);
    }

    public void postInstallRequests(String orgDN, String successLoginURL) {
        String[] tokens = new String[]{"%LOGIN_URL%", "%ORG_DN%"};
        String[] values = new String[]{successLoginURL, orgDN};
        List requestPaths = this.getRequestFileList("PostInstallRequests");
        this.logger.log(Level.FINEST, "Setting the SuccessLoginURL to: " + successLoginURL);
        this.atu.processRequestXML(tokens, values, requestPaths, this.psTmpDir);
    }

    private void replaceFCNonAuth() {
        String requestFileName = "srapGatewayConfig.request";
        File origRequestFile = new File(this.psRequestLoc + fs + requestFileName);
        if (origRequestFile.exists()) {
            int i;
            String serverList = this.getServerList();
            String[] amServerURLs = new String[]{"%IDSAME_AMSERVER%/images", "%IDSAME_AMSERVER%/login_images", "%IDSAME_AMSERVER%/js", "%IDSAME_AMSERVER%/css"};
            String[] amConsoleURLs = new String[]{"%IDSAME_AMCONSOLE%/console/images", "%IDSAME_AMCONSOLE%/console/css", "%IDSAME_AMCONSOLE%/console/js"};
            StringBuffer nonAuthURLs = new StringBuffer();
            for (i = 0; i < amServerURLs.length; ++i) {
                nonAuthURLs.append(" <Value>" + serverList + amServerURLs[i] + "</Value>");
            }
            for (i = 0; i < amConsoleURLs.length; ++i) {
                nonAuthURLs.append(" <Value>" + serverList + amConsoleURLs[i] + "</Value>");
            }
            StringBuffer fcURLList = new StringBuffer();
            fcURLList.append(" <Value>" + serverList + "</Value>");
            int endIndx = serverList.indexOf("://");
            String protocol = serverList.substring(0, endIndx);
            int beginIndx = serverList.indexOf("://");
            int endIndx1 = serverList.substring(beginIndx + 3).indexOf(":");
            if (endIndx1 == -1) {
                endIndx1 = serverList.substring(beginIndx + 3).indexOf("/");
            }
            String host = serverList.substring(beginIndx + 3, beginIndx + endIndx1 + 3);
            String port = null;
            int beginIndx1 = serverList.substring(beginIndx + 3).indexOf(":");
            port = beginIndx1 == -1 ? "80" : serverList.substring(beginIndx + beginIndx1 + 4);
            if (port.equals("80") || port.equals("443")) {
                fcURLList.append("<Value>" + protocol + "://" + host + "</Value>");
            }
            this.fcURL = fcURLList.toString();
            this.nonAuthURL = nonAuthURLs.toString();
        }
    }

    private String getServerList() {
        String isServerList = null;
        try {
            File file = File.createTempFile("platformList", ".xml");
            FileWriter fw = new FileWriter(file);
            fw.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n");
            fw.write("<!DOCTYPE Requests SYSTEM \"jar://com/iplanet/am/admin/cli/amAdmin.dtd\">\n");
            fw.write("<Requests>\n");
            fw.write("  <SchemaRequests serviceName=\"iPlanetAMPlatformService\" SchemaType=\"global\">\n");
            fw.write("      <GetServiceDefaultValues>\n");
            fw.write("          <Attribute name=\"iplanet-am-platform-server-list\" />\n");
            fw.write("      </GetServiceDefaultValues>\n");
            fw.write("  </SchemaRequests>\n");
            fw.write("</Requests>\n");
            fw.close();
            ArrayList<String> paths = new ArrayList<String>();
            paths.add(file.getAbsolutePath());
            String out = this.atu.execAMRequest(paths);
            out.trim();
            String[] tokens = null;
            if (out.length() > 0) {
                tokens = out.split("\n");
            }
            int iSize0 = tokens != null ? tokens.length : 0;
            String answer = null;
            for (int i = 0; i < iSize0; ++i) {
                String token = tokens[i];
                if (token.indexOf("iplanet-am-platform-server-list") < 0) continue;
                answer = token.substring(token.indexOf("=") + 1);
                answer = answer.trim();
                break;
            }
            if (answer != null && answer.trim().length() != 0) {
                isServerList = answer.substring(answer.indexOf("[") + 1, answer.indexOf("|"));
            }
            file.delete();
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "Error in getting the server list " + e);
        }
        return isServerList;
    }
}

