/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.iplanet.sso.SSOToken;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.fabric.util.AMUtil;
import com.sun.portal.fabric.util.ExecuteUtil;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.util.LDAPUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import netscape.ldap.LDAPConnection;

public class Domain {
    private static final String fs = File.separator;
    private static final Properties svcConf = new Properties();
    private static final String DOMAIN_RB_NAME = "psDomainServices";
    private PSConfigContext pcc;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$tasks$Domain == null ? (class$com$sun$portal$fabric$tasks$Domain = Domain.class$("com.sun.portal.fabric.tasks.Domain")) : class$com$sun$portal$fabric$tasks$Domain));
    private ExecuteUtil execUtil;
    private String psBaseDir;
    private String exportLocation;
    private String psLibDir;
    static /* synthetic */ Class class$com$sun$portal$fabric$tasks$Domain;

    public Domain(PSConfigContext pcc) {
        this.pcc = pcc;
        this.execUtil = new ExecuteUtil(logger);
        this.psBaseDir = pcc.getPSBaseDir();
        this.exportLocation = this.psBaseDir + fs + "export";
        this.psLibDir = this.psBaseDir + fs + "lib";
        String svcConfLocation = this.psLibDir + fs + "PSServiceConfig.properties";
        try {
            svcConf.load(new FileInputStream(svcConfLocation));
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Unable to fetch config file", ioe);
        }
    }

    private void processDomainServices(Set domainSvcs, SSOToken ssoToken) {
        LDAPConnection conn = LDAPUtil.getLDAPConnection((String)this.pcc.getDirectoryServerHost(), (String)this.pcc.getDirectoryServerPort(), (String)this.pcc.getUserDataStoreManager(), (String)this.pcc.getUserDataStoreManagerCredentials(), (boolean)this.pcc.isDomainDataSecure());
        try {
            String psTmpDir = this.pcc.getPSDataDir() + fs + "tmp";
            String svcTmpDirLoc = psTmpDir + fs + FileUtil.getRandomDirName();
            File svcTmpDirDir = new File(svcTmpDirLoc);
            logger.log(Level.FINEST, "Creating tmp directory: " + svcTmpDirLoc);
            if (!svcTmpDirDir.mkdirs()) {
                logger.log(Level.SEVERE, "Failed creating tmp directory while processingdomain services.");
            }
            Iterator domainSvcsItr = domainSvcs.iterator();
            this.info("Parsing the file that associates Services to LDIFs");
            String svcLDIFMapperLocation = this.psLibDir + fs + "ServiceLDIFMap.properties";
            Properties svcToLDIFFileMap = new Properties();
            svcToLDIFFileMap.load(new FileInputStream(svcLDIFMapperLocation));
            this.info("Parsing the file that associate Services to SchemaXMLs");
            String svcXMLMapperLocation = this.psLibDir + fs + "ServiceXMLMap.properties";
            Properties svcToXmlFileMap = new Properties();
            svcToXmlFileMap.load(new FileInputStream(svcXMLMapperLocation));
            HashSet<String> svcXmlFilePaths = new HashSet<String>();
            while (domainSvcsItr.hasNext()) {
                String svcSchemaXMLFile;
                String svcName = (String)domainSvcsItr.next();
                String svcLDIFFiles = svcToLDIFFileMap.getProperty(svcName, "");
                svcLDIFFiles.trim();
                String[] ldifFileNames = null;
                if (svcLDIFFiles.length() > 0) {
                    ldifFileNames = svcLDIFFiles.split("[\\s]+");
                }
                int iSize0 = ldifFileNames != null ? ldifFileNames.length : 0;
                for (int i = 0; i < iSize0; ++i) {
                    String svcLDIFPath = this.exportLocation + fs + "ldif" + fs + ldifFileNames[i];
                    File svcLDIF = new File(svcLDIFPath);
                    if (!svcLDIF.exists()) {
                        this.info("LDIF FileNotFound for Service: " + svcName);
                        continue;
                    }
                    this.info("Loading Objectclasses defined in:" + svcLDIFPath);
                    LDAPUtil.loadLDIF((String)svcLDIFPath, (LDAPConnection)conn);
                }
                Properties sraConf = new Properties();
                String sraConfLocation = this.pcc.getPSConfigDir() + fs + "SRAConfig.properties";
                File sraConfig = new File(sraConfLocation);
                String sraServerDomain = null;
                if (sraConfig.exists()) {
                    try {
                        sraConf.load(new FileInputStream(sraConfLocation));
                        sraServerDomain = sraConf.getProperty("portal.server.domain");
                    }
                    catch (IOException ioe) {
                        logger.log(Level.SEVERE, "Error loading sra config file", ioe);
                    }
                }
                if (!(svcSchemaXMLFile = svcToXmlFileMap.getProperty(svcName, "")).equals("")) {
                    String svcXMLFilePath = this.exportLocation + fs + "service" + fs + svcSchemaXMLFile;
                    File svcXML = new File(svcXMLFilePath);
                    if (svcXML.exists()) {
                        if (sraServerDomain != null && svcSchemaXMLFile.indexOf("srap") != -1 && svcTmpDirDir.exists()) {
                            String destSvcTmpFilePath = svcTmpDirLoc + fs + svcSchemaXMLFile;
                            File destSvcTmpFile = new File(destSvcTmpFilePath);
                            logger.log(Level.FINEST, "Copying file:" + svcXMLFilePath + " To:" + destSvcTmpFilePath);
                            FileUtil.copyFile(svcXML, destSvcTmpFile);
                            logger.log(Level.FINEST, "Tag Swapping the SRA service file:" + destSvcTmpFilePath);
                            FileUtil.replaceTokenInFile(destSvcTmpFile, "INST_SERVER_DOMAIN", sraServerDomain);
                            svcXmlFilePaths.add(destSvcTmpFilePath);
                            continue;
                        }
                        svcXmlFilePaths.add(svcXMLFilePath);
                        continue;
                    }
                    logger.log(Level.INFO, "Schema XML file associated with Service:" + svcName + " is not installed");
                    continue;
                }
                logger.log(Level.SEVERE, "No Schema XML file associated with Service:" + svcName);
            }
            this.info("Loading Portal Services into Access Manager...");
            AMUtil.loadServiceSchema(svcXmlFilePaths, ssoToken);
            FileUtil.deleteDir(svcTmpDirDir);
            this.info("Loading I18N for Domain Services");
            File rbLoc = new File(this.exportLocation + fs + "locale");
            File[] localeFileList = rbLoc.listFiles();
            for (int i = 0; i < localeFileList.length; ++i) {
                try {
                    String fname = localeFileList[i].getName();
                    String fPath = localeFileList[i].getAbsolutePath();
                    String fileLocale = null;
                    if (!fname.startsWith(DOMAIN_RB_NAME) || !fname.endsWith(".properties")) continue;
                    Properties props = new Properties();
                    FileInputStream fis = new FileInputStream(fPath);
                    props.load(fis);
                    int beginFileLocale = fname.indexOf(95) + 1;
                    int endFileLocale = fname.indexOf(".properties");
                    if (beginFileLocale > 0) {
                        fileLocale = fname.substring(beginFileLocale, endFileLocale);
                    }
                    AMUtil.addResourceBundle(DOMAIN_RB_NAME, fileLocale, props, ssoToken);
                    continue;
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Loading Locale Failed", e);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to Configure AM for Portal", e);
        }
    }

    public void configureMandatoryServices(SSOToken ssoToken) {
        Set domainSvcs = this.getMandatoryDomainServices();
        this.processDomainServices(domainSvcs, ssoToken);
    }

    public void configureSRAServices(SSOToken ssoToken) {
        Set sraDomainSvcs = this.getSRADomainServices();
        this.processDomainServices(sraDomainSvcs, ssoToken);
    }

    public void removeDomainServices(SSOToken ssoToken) {
        Set domainSvcs = this.getMandatoryDomainServices();
        AMUtil.deleteServiceSchema(domainSvcs, ssoToken);
        AMUtil.removeResourceBundle(DOMAIN_RB_NAME, null, ssoToken);
    }

    public void removeSRAServices(SSOToken ssoToken) {
        Set domainSvcs = this.getSRADomainServices();
        AMUtil.deleteServiceSchema(domainSvcs, ssoToken);
    }

    private Set getMandatoryDomainServices() {
        this.info("Fetching the list of Portal Domain Services");
        String domainSvcsStr = svcConf.getProperty("DomainServices", "");
        domainSvcsStr.trim();
        String[] domainSvc = null;
        if (domainSvcsStr.length() > 0) {
            domainSvc = domainSvcsStr.split("[\\s]+");
        }
        int iSize0 = domainSvc != null ? domainSvc.length : 0;
        HashSet<String> domainSvcs = new HashSet<String>();
        for (int i = 0; i < iSize0; ++i) {
            domainSvcs.add(domainSvc[i]);
        }
        return domainSvcs;
    }

    private Set getSRADomainServices() {
        this.info("Fetching the list of SRA Domain Services");
        String sraSvcsStr = svcConf.getProperty("SRADomainServices", "");
        sraSvcsStr.trim();
        String[] sraSvc = null;
        if (sraSvcsStr.length() > 0) {
            sraSvc = sraSvcsStr.split("[\\s]+");
        }
        int iSize0 = sraSvc != null ? sraSvc.length : 0;
        HashSet<String> sraDomainSvcs = new HashSet<String>();
        for (int i = 0; i < iSize0; ++i) {
            sraDomainSvcs.add(sraSvc[i]);
        }
        return sraDomainSvcs;
    }

    private final void info(String message) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

