/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.fabric.util.AntUtil;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.fabric.util.NetworkUtil;
import com.sun.portal.log.common.PortalLogger;
import java.io.File;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Derby {
    private static String fs = File.separator;
    private AntUtil antUtil;
    private static Logger logger;
    private static String derbyPropFileLoc;
    private static String derbyHostName;
    private static String derbyAntFile;
    private static String derbyLibDir;
    private static String buildFileLoc;
    private static String propFileLoc;
    private static final String PS_CONFIG_PROPERTIES = "PS_CONFIG";
    static /* synthetic */ Class class$com$sun$portal$fabric$tasks$Derby;

    public Derby(PSConfigContext pcc, String host) {
        logger = PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$tasks$Derby == null ? (class$com$sun$portal$fabric$tasks$Derby = Derby.class$("com.sun.portal.fabric.tasks.Derby")) : class$com$sun$portal$fabric$tasks$Derby));
        this.antUtil = new AntUtil(pcc.getPSDataDir());
        buildFileLoc = pcc.getPSBaseDir() + fs + "lib" + fs + derbyAntFile;
        propFileLoc = pcc.getPSConfigDir() + fs + "PSConfig.properties";
        derbyPropFileLoc = pcc.getPSDataDir() + fs + "derby" + fs + "derby.properties";
        derbyHostName = host;
        derbyLibDir = pcc.getDerbyLibDir();
    }

    public void configureDerby() {
        this.createDerbyInstance();
        if (this.replaceTokensInDerbyPropFile()) {
            this.startDerbyInstance();
        }
    }

    public void unconfigureDerby() {
        this.stopDerbyInstance();
    }

    public void createDerbyInstance() {
        Vector<String> targets = new Vector<String>();
        targets.add("create-instance");
        this.antUtil.runant(buildFileLoc, targets, "derby", PS_CONFIG_PROPERTIES, propFileLoc);
    }

    public void startDerbyInstance() {
        logger.log(Level.INFO, "Starting Derby Server instance");
        Vector<String> targets = new Vector<String>();
        targets.add("start-instance");
        this.antUtil.runant(buildFileLoc, targets, "derby", PS_CONFIG_PROPERTIES, propFileLoc);
    }

    public void stopDerbyInstance() {
        Vector<String> targets = new Vector<String>();
        targets.add("stop-instance");
        this.antUtil.runant(buildFileLoc, targets, "derby", PS_CONFIG_PROPERTIES, propFileLoc);
    }

    private boolean replaceTokensInDerbyPropFile() {
        File propertiesFile = new File(derbyPropFileLoc);
        if (!propertiesFile.exists()) {
            logger.log(Level.INFO, "Derby properties file not found: ", derbyPropFileLoc);
            return false;
        }
        String availablePort = NetworkUtil.getNextAvailablePort(derbyHostName, "1527");
        FileUtil.replaceTokenInFile(propertiesFile, "%PS_HOST%", derbyHostName);
        FileUtil.replaceTokenInFile(propertiesFile, "%DERBY_PORT%", availablePort);
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        derbyAntFile = "derby.xml";
    }
}

