/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.sun.portal.fabric.tasks.ConfigDataConstants;
import com.sun.portal.fabric.tasks.ConfigDataRecorderPlaybackException;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.fabric.util.XMLJdomFileCreationException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class ConfigDataRecorder
extends ConfigDataConstants {
    private static final String PASCONFIG_NAMESPACE_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String PASCONFIG_NAMESPACE_XSI = "xsi";
    private static final String PASCONFIG_NO_NAMESPACE_SCHEMA_LOCATION = "noNamespaceSchemaLocation";

    public ConfigDataRecorder(String sPSLibDir, String sPortalConfigDataDir, Logger logger) throws ConfigDataRecorderPlaybackException {
        super(sPSLibDir, sPortalConfigDataDir, logger);
        try {
            if (!this.m_bRecordingFound) {
                HashMap dummyMap = new HashMap();
                this.m_xmlJdomUtil.addChild(null, "WebContainerConfigData", dummyMap);
            }
        }
        catch (XMLJdomFileCreationException e) {
            throw new ConfigDataRecorderPlaybackException(e);
        }
    }

    public void doRecordPath(String sPathType, String sConfigPath) throws ConfigDataRecorderPlaybackException {
        if (sPathType == null || sPathType.trim().length() == 0) {
            String msg = "sPathType = Null/Empty";
            throw new ConfigDataRecorderPlaybackException(msg);
        }
        if (sConfigPath == null || sConfigPath.trim().length() == 0) {
            String msg = "sConfigPath = Null/Empty";
            throw new ConfigDataRecorderPlaybackException(msg);
        }
        try {
            String psConfigPath = sConfigPath.trim();
            String sPathPath = "WebContainerConfigData@Paths";
            Properties props = this.m_xmlJdomUtil.getChildAsProperties(sPathPath);
            if (props == null) {
                HashMap<String, String> pathMap = new HashMap<String, String>();
                pathMap.put(sPathType, psConfigPath);
                this.m_xmlJdomUtil.addChild("WebContainerConfigData", "Paths", pathMap);
            } else {
                String sOldPath = props.getProperty(sPathType);
                sOldPath = sOldPath != null ? sOldPath.trim() : "";
                String sNewPath = sOldPath.equals("") ? psConfigPath : sOldPath + cps + psConfigPath;
                this.m_xmlJdomUtil.setAttribute(sPathPath, sPathType, sNewPath);
            }
            this.m_logger.log(Level.FINEST, "PSFB_CSPFT0115", new String[]{"Record", sPathType, psConfigPath});
        }
        catch (XMLJdomFileCreationException e) {
            throw new ConfigDataRecorderPlaybackException(e);
        }
    }

    public void doRecordJVMOption(String sJvmOption, String sValue) throws ConfigDataRecorderPlaybackException {
        if (sJvmOption == null || sJvmOption.trim().length() == 0) {
            String msg = "sJvmOption = Null/Empty";
            throw new ConfigDataRecorderPlaybackException(msg);
        }
        if (sValue == null || sValue.trim().length() == 0) {
            String msg = "sJvmOptionValue = Null/Empty";
            throw new ConfigDataRecorderPlaybackException(msg);
        }
        try {
            String sJvmOptionsPath = "WebContainerConfigData@Jvm_options";
            Properties props = this.m_xmlJdomUtil.getChildAsProperties(sJvmOptionsPath);
            if (props == null) {
                HashMap<String, String> jvmOptionsMap = new HashMap<String, String>();
                jvmOptionsMap.put(sJvmOption, sValue);
                this.m_xmlJdomUtil.addChild("WebContainerConfigData", "Jvm_options", jvmOptionsMap);
            } else {
                String sOptionValue = props.getProperty(sJvmOption);
                if (sOptionValue != null) {
                    this.m_logger.log(Level.FINEST, "PSFB_CSPFT0111", new String[]{sJvmOption, sOptionValue});
                    return;
                }
                this.m_xmlJdomUtil.setAttribute(sJvmOptionsPath, sJvmOption, sValue);
            }
            this.m_logger.log(Level.FINEST, "PSFB_CSPFT0116", new String[]{"Record", sJvmOption, sValue});
        }
        catch (XMLJdomFileCreationException e) {
            throw new ConfigDataRecorderPlaybackException(e);
        }
    }

    public void doRecordResources(String sConfigDir) throws ConfigDataRecorderPlaybackException {
        try {
            int iDataSourceFiles;
            if (sConfigDir == null || sConfigDir.trim().length() == 0) {
                String msg = "sConfigDir = Null/Empty";
                throw new ConfigDataRecorderPlaybackException(msg);
            }
            File confDir = new File(sConfigDir);
            if (!confDir.isDirectory()) {
                String msg = "Directory '" + confDir.getAbsolutePath() + "' does not exist.";
                throw new ConfigDataRecorderPlaybackException(msg);
            }
            ArrayList datasourceFiles = new ArrayList();
            FileUtil.getFiles(confDir, datasourceFiles, "datasource");
            int n = iDataSourceFiles = datasourceFiles != null ? datasourceFiles.size() : 0;
            if (iDataSourceFiles > 0) {
                String sResourcesPath = "WebContainerConfigData@Resources";
                Element resources = this.m_xmlJdomUtil.getChildAsElement(sResourcesPath);
                String sResourcesList = null;
                if (resources != null) {
                    sResourcesList = this.m_xmlJdomUtil.getAttribute(sResourcesPath, "resources_list");
                }
                for (int i = 0; i < iDataSourceFiles; ++i) {
                    File datasource = (File)datasourceFiles.get(i);
                    SAXBuilder builder = new SAXBuilder();
                    Document doc = builder.build(datasource.getAbsolutePath());
                    this.m_logger.log(Level.INFO, "PSFB_CSPFT0085", datasource.getAbsolutePath());
                    Element elm = doc.getRootElement();
                    if (elm == null) continue;
                    doc.detachRootElement();
                    String sResourceName = elm.getAttributeValue("name");
                    boolean bAddResource = true;
                    if (resources == null) {
                        HashMap<String, String> propList = new HashMap<String, String>();
                        sResourcesList = cps + sResourceName + cps;
                        propList.put("resources_list", sResourcesList);
                        this.m_xmlJdomUtil.addChild("WebContainerConfigData", "Resources", propList);
                        resources = this.m_xmlJdomUtil.getChildAsElement(sResourcesPath);
                    } else {
                        boolean bl = bAddResource = sResourcesList.indexOf(cps + sResourceName + cps) < 0;
                        if (bAddResource) {
                            sResourcesList = sResourcesList + sResourceName + cps;
                            this.m_xmlJdomUtil.setAttribute(sResourcesPath, "resources_list", sResourcesList);
                        } else {
                            this.m_logger.log(Level.FINEST, "PSFB_CSPFT0112", new String[]{sResourceName});
                        }
                    }
                    if (!bAddResource) continue;
                    this.m_xmlJdomUtil.addChild(sResourcesPath, null, elm);
                    this.m_logger.log(Level.FINEST, "PSFB_CSPFT0117", new String[]{"Record", sResourceName, elm.toString()});
                }
            }
        }
        catch (JDOMException e0) {
            throw new ConfigDataRecorderPlaybackException(e0);
        }
        catch (XMLJdomFileCreationException e1) {
            throw new ConfigDataRecorderPlaybackException(e1);
        }
        catch (IOException e2) {
            throw new ConfigDataRecorderPlaybackException(e2);
        }
    }

    public final boolean saveRecording() throws ConfigDataRecorderPlaybackException {
        boolean bWritten = true;
        if (this.m_xmlJdomUtil.getXMLJdomDocument() != null) {
            try {
                if (!this.m_bRecordingFound) {
                    this.m_xmlJdomUtil.setNamespace("WebContainerConfigData", PASCONFIG_NAMESPACE_XSI, PASCONFIG_NAMESPACE_URI, PASCONFIG_NO_NAMESPACE_SCHEMA_LOCATION, this.m_sPASXSDFileLocation);
                    this.m_bRecordingFound = true;
                }
                this.removeDuplicateFilesFromPath("classpath");
                this.removeDuplicateFilesFromPath("native_lib_path");
                this.m_xmlJdomUtil.writeXMLFile(this.m_sPASFileLocation);
            }
            catch (XMLJdomFileCreationException e) {
                bWritten = false;
                throw new ConfigDataRecorderPlaybackException(e);
            }
        } else {
            this.m_logger.log(Level.FINEST, "PSFB_CSPFT0113");
            bWritten = false;
        }
        return bWritten;
    }

    private void removeDuplicateFilesFromPath(String sPathType) throws XMLJdomFileCreationException {
        if (sPathType == null || sPathType.length() == 0) {
            String msg = "sPathtype = Null/Empty";
            throw new XMLJdomFileCreationException(msg);
        }
        String sPathPath = "WebContainerConfigData@Paths";
        String sOldPathValue = this.m_xmlJdomUtil.getAttribute(sPathPath, sPathType);
        System.out.println(sPathPath + "@" + sPathType + "(Old)=" + sOldPathValue);
        if (sOldPathValue != null && !sOldPathValue.trim().equals("")) {
            String sNewPathValue = null;
            String[] pathList = sOldPathValue.split(cps);
            HashMap<String, String> pathMap = new HashMap<String, String>();
            for (int i = 0; i < pathList.length; ++i) {
                String sPath;
                String string = sPath = pathList[i] != null ? pathList[i].trim() : null;
                if (sPath == null || pathMap.put(sPath, sPath) != null) continue;
                sNewPathValue = sNewPathValue != null ? sNewPathValue + cps + sPath : sPath;
            }
            System.out.println(sPathPath + "@" + sPathType + "(New)=" + sNewPathValue);
            this.m_xmlJdomUtil.setAttribute(sPathPath, sPathType, sNewPathValue);
        }
    }
}

