/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.sun.portal.fabric.tasks.ConfigDataConstants;
import com.sun.portal.fabric.tasks.ConfigDataRecorderPlaybackException;
import com.sun.portal.fabric.tasks.WebContainerTasks;
import com.sun.portal.fabric.util.XMLJdomFileCreationException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jdom.Element;

public class ConfigDataPlayback
extends ConfigDataConstants {
    private static final String[] s_classPathTypes = new String[]{"classpath", "native_lib_path"};
    private static final String[] s_classPathPlayerMethods = new String[]{"appendClasspath", "setNativeLibraryPath"};
    private Map m_valueMap = null;
    private WebContainerTasks m_wc = null;
    private String psLibDir = null;

    public ConfigDataPlayback(String sPSLibDir, String sPortalConfigDataDir, Logger logger, WebContainerTasks wc, Map valueMap) throws ConfigDataRecorderPlaybackException {
        super(sPSLibDir, sPortalConfigDataDir, logger);
        this.m_valueMap = valueMap;
        this.m_wc = wc;
        if (this.m_wc == null) {
            throw new ConfigDataRecorderPlaybackException("Web Container instance is Null.");
        }
        if (!this.m_bRecordingFound) {
            this.m_logger.log(Level.FINEST, "PSFB_CSPFT0114", new String[]{sPortalConfigDataDir});
        }
        this.psLibDir = sPSLibDir;
    }

    private final String unTokenize(String sTokenizedStr) {
        String sUnTokenizedStr = sTokenizedStr;
        if (sTokenizedStr != null && sTokenizedStr.length() > 0 && this.m_valueMap != null) {
            Iterator itr = this.m_valueMap.keySet().iterator();
            while (itr.hasNext()) {
                String sToken = (String)itr.next();
                String sValue = (String)this.m_valueMap.get(sToken);
                sUnTokenizedStr = sUnTokenizedStr.replaceAll(sToken, sValue);
            }
        }
        return sUnTokenizedStr;
    }

    private void doPlaybackPath() throws ConfigDataRecorderPlaybackException {
        try {
            String sClasspathPath = "WebContainerConfigData@Paths";
            Properties props = this.m_xmlJdomUtil.getChildAsProperties(sClasspathPath);
            if (props != null) {
                for (int i = 0; i < s_classPathTypes.length; ++i) {
                    String sClassPath = this.m_xmlJdomUtil.getAttribute(sClasspathPath, s_classPathTypes[i]);
                    String sUnTokenizedClassPath = this.unTokenize(sClassPath);
                    String sMethodName = s_classPathPlayerMethods[i];
                    Class<?> cls = Class.forName("com.sun.portal.fabric.tasks.WebContainerTasks");
                    Class[] params = new Class[]{Class.forName("java.lang.String")};
                    Method method2 = cls.getMethod(sMethodName, params);
                    Object[] values = new Object[]{sUnTokenizedClassPath};
                    method2.invoke((Object)this.m_wc, values);
                    this.m_logger.log(Level.FINEST, "PSFB_CSPFT0115", new String[]{"Playback", s_classPathTypes[i], sUnTokenizedClassPath});
                }
            }
        }
        catch (ClassNotFoundException e0) {
            throw new ConfigDataRecorderPlaybackException(e0);
        }
        catch (XMLJdomFileCreationException e1) {
            throw new ConfigDataRecorderPlaybackException(e1);
        }
        catch (NoSuchMethodException e2) {
            throw new ConfigDataRecorderPlaybackException(e2);
        }
        catch (InvocationTargetException e3) {
            throw new ConfigDataRecorderPlaybackException(e3);
        }
        catch (IllegalAccessException e4) {
            throw new ConfigDataRecorderPlaybackException(e4);
        }
    }

    private void doPlaybackJvmOptions() throws ConfigDataRecorderPlaybackException {
        try {
            String sJvmOptionsPath = "WebContainerConfigData@Jvm_options";
            Properties props = this.m_xmlJdomUtil.getChildAsProperties(sJvmOptionsPath);
            if (props != null) {
                Enumeration<?> e = props.propertyNames();
                while (e.hasMoreElements()) {
                    String sJVMOptionValue;
                    String sJVMOptionName = (String)e.nextElement();
                    if (sJVMOptionName == null || sJVMOptionName.trim().length() <= 0 || (sJVMOptionValue = props.getProperty(sJVMOptionName = sJVMOptionName.trim())) == null) continue;
                    String sUnTokenizedJVMOptionValue = this.unTokenize(sJVMOptionValue);
                    this.m_wc.addJVMOption(sJVMOptionName, sUnTokenizedJVMOptionValue);
                    this.m_logger.log(Level.FINEST, "PSFB_CSPFT0116", new String[]{"Playback", sJVMOptionName, sUnTokenizedJVMOptionValue});
                }
            }
        }
        catch (XMLJdomFileCreationException e) {
            throw new ConfigDataRecorderPlaybackException(e);
        }
    }

    private void doPlaybackResources() throws ConfigDataRecorderPlaybackException {
        try {
            String sResourcesPath = "WebContainerConfigData@Resources";
            List resources = this.m_xmlJdomUtil.getChildrenAsElementsList(sResourcesPath, null);
            if (resources != null) {
                Iterator e = resources.iterator();
                while (e.hasNext()) {
                    Element resource = (Element)e.next();
                    if (resource == null) continue;
                    this.m_wc.createResource(resource, this.psLibDir);
                    String sResourceName = resource.getAttributeValue("name");
                    this.m_logger.log(Level.FINEST, "PSFB_CSPFT0117", new String[]{"Playback", sResourceName, resource.toString()});
                }
            }
        }
        catch (XMLJdomFileCreationException e) {
            throw new ConfigDataRecorderPlaybackException(e);
        }
    }

    public final boolean doPlayback() throws ConfigDataRecorderPlaybackException {
        if (this.m_bRecordingFound) {
            this.doPlaybackPath();
            this.doPlaybackJvmOptions();
            this.doPlaybackResources();
        }
        return this.m_bRecordingFound;
    }
}

