/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.sun.portal.fabric.tasks.ConfigDataRecorderPlaybackException;
import com.sun.portal.fabric.util.XMLJdomFileCreationException;
import com.sun.portal.fabric.util.XMLJdomUtil;
import java.io.File;
import java.util.logging.Logger;

public class ConfigDataConstants {
    protected static final String cps = File.pathSeparator;
    protected static final String fs = File.separator;
    protected static final String nl = System.getProperty("line.separator");
    protected static final String ts = "@";
    public static final String PASCONFIG_PORTAL_SERVER_CONFIGURATION = "WebContainerConfigData";
    public static final String PASCONFIG_PATHS = "Paths";
    public static final String PASCONFIG_JVM_OPTIONS = "Jvm_options";
    public static final String PASCONFIG_RESOURCES = "Resources";
    public static final String PASCONFIG_ATTR_CLASSPATH = "classpath";
    public static final String PASCONFIG_ATTR_NATIVE_LIB_PATH = "native_lib_path";
    public static final String PASCONFIG_ATTR_RESOURCES_LIST = "resources_list";
    public static final String PASCONFIG_INSTANCE_ID = "@INSTANCE_ID@";
    protected XMLJdomUtil m_xmlJdomUtil = null;
    protected String m_sPASFileLocation = null;
    protected String m_sPASXSDFileLocation = null;
    protected Logger m_logger = null;
    protected boolean m_bRecordingFound = false;

    protected ConfigDataConstants(String sPSLibDir, String sPortalConfigDataDir, Logger logger) throws ConfigDataRecorderPlaybackException {
        this.m_logger = logger;
        if (this.m_logger == null) {
            throw new ConfigDataRecorderPlaybackException("Logger is NULL");
        }
        if (sPSLibDir == null || sPSLibDir.trim().length() == 0) {
            throw new ConfigDataRecorderPlaybackException("PS Lib Directory = Null/Empty");
        }
        File fPSLibDir = new File(sPSLibDir);
        if (!fPSLibDir.isDirectory()) {
            throw new ConfigDataRecorderPlaybackException("Directory '" + sPSLibDir + "' can not be found!!!");
        }
        this.m_sPASXSDFileLocation = sPSLibDir + fs + "PASconfig.xsd";
        try {
            boolean bCreatePortalConfigDir;
            this.m_xmlJdomUtil = new XMLJdomUtil();
            if (sPortalConfigDataDir == null || sPortalConfigDataDir.trim().length() == 0) {
                throw new ConfigDataRecorderPlaybackException("Portal Config Dir = Null/Empty");
            }
            File fDir = new File(sPortalConfigDataDir);
            boolean bl = bCreatePortalConfigDir = fDir.isDirectory() ? true : fDir.mkdirs();
            if (!bCreatePortalConfigDir) {
                throw new ConfigDataRecorderPlaybackException("Failed to create Portal Config Dir '" + sPortalConfigDataDir + "'");
            }
            this.m_sPASFileLocation = sPortalConfigDataDir + fs + "WebContainerConfigData.xml";
            File fTmpFile = new File(this.m_sPASFileLocation);
            if (fTmpFile.isFile()) {
                System.out.println("File '" + fTmpFile.getAbsolutePath() + "' found.");
                this.m_xmlJdomUtil.readXMLFileLessSchemaValidation(fTmpFile.getAbsolutePath());
                this.m_bRecordingFound = true;
            }
        }
        catch (XMLJdomFileCreationException e) {
            throw new ConfigDataRecorderPlaybackException(e);
        }
    }

    public final boolean isRecordingFound() {
        return this.m_bRecordingFound;
    }
}

