/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.fabric.util.ExecuteUtil;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.log.common.PortalLogger;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cacao {
    static final String fs = File.separator;
    static final String fps = File.pathSeparator;
    static final String CACAO_CONFIG_FILE = fs + "cacao.properties";
    static final String CACAO_ADMIN = fs + "bin" + fs + "cacaoadm";
    static final String STATUS = "status";
    static final String ENABLED = "ENABLED";
    static final String ENABLE = "enable";
    static final String START = "start";
    static final String UNLOCK = "unlock";
    static final String LOCK = "lock";
    static final String LIST_MODULES = "list-modules";
    static final String UNDEPLOY = "undeploy";
    static final String DEPLOY = "deploy";
    static final String RESTART = "restart";
    public static final String MODULE = "com.sun.portal.admin.server.module";
    public static final String CACAO_UPTIME = "Cacao uptime";
    public static final String XML = "com.sun.portal.admin.server.module.xml";
    public static final String DEPLOYMENT_DESCRIPTOR = fs + "modules" + fs + "com.sun.portal.admin.server.module.xml";
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$tasks$Cacao == null ? (class$com$sun$portal$fabric$tasks$Cacao = Cacao.class$("com.sun.portal.fabric.tasks.Cacao")) : class$com$sun$portal$fabric$tasks$Cacao));
    private PSConfigContext pcc;
    private ExecuteUtil execUtil;
    private String psLibDir;
    private String cacaoadm;
    static /* synthetic */ Class class$com$sun$portal$fabric$tasks$Cacao;

    public Cacao(PSConfigContext pcc) {
        this.pcc = pcc;
        this.execUtil = new ExecuteUtil(logger);
        this.execUtil.storeOutput(true);
        this.psLibDir = pcc.getPSBaseDir() + fs + "lib";
        this.cacaoadm = pcc.getCacaoBaseDir() + CACAO_ADMIN;
    }

    public String getCacaoStatus() {
        String[] args = new String[]{STATUS};
        this.execUtil.storeOutput(true);
        this.execUtil.exec(this.cacaoadm, args);
        String result = this.execUtil.getOutput();
        return result;
    }

    public void configureDomain() {
        String[] TOKENS = new String[]{"%shared.lib.location%", "%cacao.config.location%", "%am.product.location%", "%am.config.location%", "%ps.product.location%", "%ps.jars%", "%ps.config.location%", "%private.lib.location%", "%jss.jar.location%", "%jdk.lib.location%", "%registry.lib.location%", "%ant.lib.location%"};
        String psLibDirName = this.pcc.getPSBaseDir() + fs + "lib";
        File psLibDir = new File(psLibDirName);
        String ls = System.getProperty("line.separator", "\n");
        StringBuffer psJars = new StringBuffer();
        try {
            String[] args;
            File[] files = psLibDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String fileName = files[i].getName();
                if (!fileName.endsWith(".jar")) continue;
                psJars.append("    <path-element>" + ls);
                psJars.append("      file:");
                psJars.append(psLibDirName + fs + fileName);
                psJars.append(ls);
                psJars.append("    </path-element>" + ls + ls);
            }
            String[] values = new String[]{this.pcc.getSharedLibsDir(), this.pcc.getCacaoConfigDir(), this.pcc.getISBaseDir(), this.pcc.getISConfigDir(), this.pcc.getPSBaseDir(), psJars.toString(), this.pcc.getPSConfigDir(), this.pcc.getPrivateSharedLibsDir(), this.pcc.getJSSJARDir(), this.pcc.getJavaHome() + fs + "lib", this.pcc.getRegistryLibDir(), this.pcc.getAntLibDir()};
            String template = this.pcc.getPSBaseDir() + fs + "admin" + fs + XML;
            String dd = this.pcc.getCacaoConfigDir() + DEPLOYMENT_DESCRIPTOR;
            File templateFile = new File(template);
            File ddFile = new File(dd);
            FileUtil.copyFile(templateFile, ddFile);
            FileUtil.replaceTokensInFile(ddFile, TOKENS, values);
            String ccConfig = this.pcc.getCacaoConfigDir() + CACAO_CONFIG_FILE;
            File ccConfigFile = new File(ccConfig);
            boolean requiresRestart = false;
            String pattern = "process.username=";
            String text = "process.username=root";
            String line = FileUtil.findTextInFile(ccConfigFile, pattern);
            int index = line.indexOf(pattern);
            if (index < 0) {
                FileUtil.appendToFile(ccConfigFile, text, false);
                requiresRestart = true;
            } else {
                String user = line.substring(index + pattern.length()).trim();
                if (!"root".equals(user)) {
                    FileUtil.replaceLineInFile(ccConfigFile, pattern, text);
                    requiresRestart = true;
                }
            }
            pattern = "java.flags=";
            String ubtVMOption = " -Djava.awt.headless=true ";
            String xwsVMOption = " -Domar.common.security.soapSecurityProviderClass=org.freebxml.omar.common.security.xwssec20FCS.XWSSec20SoapSecurityUtil ";
            text = pattern + "-Xms128M -Xmx256M" + ubtVMOption + xwsVMOption;
            line = FileUtil.findTextInFile(ccConfigFile, pattern);
            index = line.indexOf(pattern);
            String logConfigFileOption = "com.sun.portal.log.config.file";
            String logFileStr = " -D" + logConfigFileOption + "=" + this.pcc.getPSConfigDir() + fs + "PSAdminLogConfig.properties";
            if (index < 0) {
                FileUtil.appendToFile(ccConfigFile, text + logFileStr, false);
                requiresRestart = true;
            } else {
                String newLine = this.modifyHeapSize(line, "-Xms", 128, "-Xms128M");
                newLine = this.modifyHeapSize(newLine, "-Xmx", 256, "-Xmx256M");
                if ((newLine = this.modifyLibraryPath(newLine)).indexOf(logConfigFileOption) < 0) {
                    newLine = newLine + logFileStr;
                }
                if (newLine.indexOf(ubtVMOption) < 0) {
                    newLine = newLine + ubtVMOption;
                }
                if (newLine.indexOf(xwsVMOption) < 0) {
                    newLine = newLine + xwsVMOption;
                }
                if (!newLine.equals(line)) {
                    FileUtil.replaceLineInFile(ccConfigFile, pattern, newLine);
                    requiresRestart = true;
                }
            }
            String result = this.getCacaoStatus();
            if (result.indexOf(ENABLED) == -1) {
                this.info("Enable Cacao ...");
                args = new String[]{ENABLE};
                this.execUtil.storeOutput(false);
                this.execUtil.exec(this.cacaoadm, args);
            }
            if (result.indexOf(CACAO_UPTIME) == -1) {
                this.info("Start Cacao ...");
                args = new String[]{START};
            } else if (requiresRestart) {
                this.info("Restart Cacao ...");
                args = new String[]{RESTART};
            } else {
                args = new String[]{LIST_MODULES};
                this.execUtil.storeOutput(true);
                this.execUtil.exec(this.cacaoadm, args);
                result = this.execUtil.getOutput();
                if (result.indexOf(MODULE) >= 0) {
                    this.info("Undeploy com.sun.portal.admin.server.module ...");
                    args = new String[]{UNDEPLOY, MODULE};
                    this.execUtil.storeOutput(false);
                    this.execUtil.exec(this.cacaoadm, args);
                }
                this.info("Deploy com.sun.portal.admin.server.module ...");
                args = new String[]{DEPLOY, dd};
            }
            this.execUtil.storeOutput(false);
            this.execUtil.exec(this.cacaoadm, args);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    public void unconfigureDomain() {
        try {
            String ddPath = this.pcc.getCacaoConfigDir() + DEPLOYMENT_DESCRIPTOR;
            File dd = new File(ddPath);
            if (dd.exists()) {
                dd.delete();
            }
            this.cacaoadm = this.pcc.getCacaoBaseDir() + CACAO_ADMIN;
            String[] args = new String[]{STATUS};
            this.execUtil.storeOutput(true);
            this.execUtil.exec(this.cacaoadm, args);
            String result = this.execUtil.getOutput();
            if (result.indexOf(CACAO_UPTIME) >= 0) {
                args = new String[]{LIST_MODULES};
                this.execUtil.storeOutput(true);
                this.execUtil.exec(this.cacaoadm, args);
                result = this.execUtil.getOutput();
                if (result.indexOf(MODULE) >= 0) {
                    this.info("Undeploy com.sun.portal.admin.server.module ...");
                    args = new String[]{UNDEPLOY, MODULE};
                    this.execUtil.storeOutput(false);
                    this.execUtil.exec(this.cacaoadm, args);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "", e);
        }
    }

    private final void info(String message) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info(message);
        }
    }

    private String modifyHeapSize(String line, String option, int preferredSize, String preferredSetting) {
        int index = line.indexOf(option);
        if (index < 0) {
            line = line + " " + preferredSetting;
        } else {
            String sizeSetting = line.substring(index);
            if ((index = sizeSetting.indexOf(" ", option.length())) >= option.length()) {
                sizeSetting = sizeSetting.substring(0, index);
            }
            String sizeString = sizeSetting.substring(option.length());
            int multiplier = 1;
            if (sizeString.endsWith("k") || sizeString.endsWith("K")) {
                multiplier = 1024;
                sizeString = sizeString.substring(0, sizeString.length() - 1);
            } else if (sizeString.endsWith("m") || sizeString.endsWith("M")) {
                multiplier = 0x100000;
                sizeString = sizeString.substring(0, sizeString.length() - 1);
            }
            long size = 0L;
            try {
                size = Long.parseLong(sizeString);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            size = size * (long)multiplier / 0x100000L;
            if (size < (long)preferredSize) {
                line = line.replaceFirst(sizeSetting, preferredSetting);
            }
        }
        return line;
    }

    public void restartCacao() {
        this.info("Restart Cacao ...");
        String[] args = new String[]{RESTART, MODULE};
        this.execUtil.storeOutput(false);
        this.execUtil.exec(this.cacaoadm, args);
    }

    public void reloadCacao() {
        this.info("LOCK Cacao Module...");
        String[] args = new String[]{LOCK, MODULE};
        this.execUtil.storeOutput(false);
        this.execUtil.exec(this.cacaoadm, args);
        this.info("UNLOCK Cacao Module...");
        args = new String[]{UNLOCK, MODULE};
        this.execUtil.storeOutput(false);
        this.execUtil.exec(this.cacaoadm, args);
        this.info("COMPLETED UNLOCKING Cacao Module...");
    }

    private String modifyLibraryPath(String line) {
        String psBaseDir = this.pcc.getPSBaseDir();
        String newPath = psBaseDir + fs + "lib" + fps + psBaseDir + fs + "lib" + fs + "filter";
        String option = " -Djava.library.path=";
        int index = line.indexOf(option);
        if (index < 0) {
            line = line + option + newPath;
        } else {
            String before = line.substring(0, index + option.length());
            String oldPath = line.substring(index + option.length());
            String after = "";
            index = oldPath.indexOf(" ");
            if (index >= 0) {
                after = oldPath.substring(index);
                oldPath = oldPath.substring(0, index);
            }
            if (oldPath.length() == 0) {
                line = before + newPath + after;
            } else if (oldPath.indexOf(newPath) < 0) {
                line = before + oldPath + fps + newPath + after;
            }
        }
        return line;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

