/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.tasks;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.fabric.tasks.ConfigurationException;
import com.sun.portal.fabric.tasks.ValidationException;
import com.sun.portal.fabric.tasks.WebContainer;
import com.sun.portal.fabric.tasks.WebContainerBase;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.fabric.util.os.OSTasks;
import com.sun.portal.fabric.util.os.OSTasksFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.jdom.Element;

public class BEAWL8Impl
extends WebContainerBase {
    private String wcHomeDir = null;
    private String wcTargetInstance = null;
    private String wcInstanceDir = null;
    private String wcAdminUser = null;
    private String wcAdminPassword = null;
    private String wcAdminProtocol = null;
    private String wcAdminHost = null;
    private String wcAdminPort = null;
    private String wcTargetConfigdir = null;
    private String wcDomain = null;
    private String wcJDKDir = null;
    private String wcManagedServerStr = null;
    private String amconfigScript = null;
    private boolean wcManagedServer;
    private File wcConfigfile;
    private String psBaseDir;
    private static String AM_CLASSPATH = "";
    private String amConfigDir = "";
    private String psClassPath;

    public BEAWL8Impl(Map wcAttributes, Logger logger) {
        super(wcAttributes, logger);
        logger.log(Level.FINEST, wcAttributes.toString());
        this.wcHomeDir = (String)wcAttributes.get("WebContainerInstallDir");
        this.wcInstanceDir = (String)wcAttributes.get("WebContainerInstanceDir");
        this.wcTargetInstance = (String)wcAttributes.get("WebContainerInstanceName");
        this.wcJDKDir = (String)wcAttributes.get("WebContainerJDKDir");
        this.wcAdminUser = (String)wcAttributes.get("WebContainerAdminUid");
        this.wcAdminPassword = (String)wcAttributes.get("WebContainerAdminPassword");
        this.wcAdminProtocol = (String)wcAttributes.get("WebContainerAdminScheme");
        this.wcAdminHost = (String)wcAttributes.get("WebContainerAdminHost");
        this.wcAdminPort = (String)wcAttributes.get("WebContainerAdminPort");
        this.wcManagedServerStr = (String)wcAttributes.get("WebContainerManagedServer");
    }

    public void postValidationInit() throws ConfigurationException {
        this.wcTargetConfigdir = this.wcInstanceDir.substring(0, this.wcInstanceDir.lastIndexOf(WebContainer.fs));
        this.wcDomain = this.wcInstanceDir.substring(this.wcInstanceDir.lastIndexOf(WebContainer.fs) + 1);
        this.wcManagedServer = new Boolean(this.wcManagedServerStr);
        this.wcPrintableInstanceName = this.wcDomain + "." + this.wcTargetInstance;
        this.setConfigFile();
    }

    private void setConfigFile() {
        String wcConfigfileName = "startWebLogic.sh";
        String wcManagedConfigfileName = "startManagedWebLogic.sh";
        String wcConfigfileNameToUse = !this.wcManagedServer ? wcConfigfileName : wcManagedConfigfileName;
        this.wcConfigfile = new File(this.wcInstanceDir + WebContainer.fs + wcConfigfileNameToUse);
    }

    public void deploy(String warFile, String uri) throws ConfigurationException {
        this.logger.log(Level.FINEST, "PSFB_CSPFT0049", new String[]{warFile, uri, this.wcPrintableInstanceName});
        if (!this.wcManagedServer) {
            return;
        }
        String command = this.wcJDKDir + WebContainer.fs + "bin" + WebContainer.fs + "java";
        String[] args = new String[]{"-cp", this.wcHomeDir + WebContainer.fs + "server" + WebContainer.fs + "lib" + WebContainer.fs + "weblogic.jar", "weblogic.Deployer", "-adminurl", "t3://" + this.wcAdminHost + ":" + this.wcAdminPort, "-name", uri, "-username", this.wcAdminUser, "-password", this.wcAdminPassword, "-targets", this.wcTargetInstance, "-deploy", warFile};
        this.execUtil.storeOutput(true);
        try {
            this.execUtil.exec(command, args);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0059");
                record.setParameters(new String[]{warFile, uri, this.wcPrintableInstanceName});
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
            throw new ConfigurationException(e);
        }
        this.logger.log(Level.FINEST, "PSFB_CSPFT0050", new String[]{"War file deployment output", this.execUtil.getOutput()});
    }

    public void redeploy(String instance, String uri, String deployDir) throws ConfigurationException {
        this.logger.log(Level.FINEST, "PSFB_CSPFT0060", new String[]{instance, uri, deployDir});
        if (!this.wcManagedServer) {
            return;
        }
        String command = this.wcJDKDir + WebContainer.fs + "bin" + WebContainer.fs + "java";
        String[] args = new String[]{"-cp", this.wcHomeDir + WebContainer.fs + "server" + WebContainer.fs + "lib" + WebContainer.fs + "weblogic.jar", "weblogic.Deployer", "-adminurl", "t3://" + this.wcAdminHost + ":" + this.wcAdminPort, "-name", uri, "-username", this.wcAdminUser, "-password", this.wcAdminPassword, "-targets", this.wcTargetInstance, "-redeploy"};
        this.execUtil.storeOutput(true);
        try {
            this.execUtil.exec(command, args);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0061");
                record.setParameters(new String[]{instance, uri, deployDir});
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
            throw new ConfigurationException(e);
        }
        this.logger.log(Level.FINEST, "PSFB_CSPFT0050", new String[]{"War file redeployment output", this.execUtil.getOutput()});
    }

    public void undeploy(String uri) throws ConfigurationException {
        this.logger.log(Level.FINEST, "PSFB_CSPFT0073", new String[]{uri});
        if (!this.wcManagedServer) {
            return;
        }
        String command = this.wcJDKDir + WebContainer.fs + "bin" + WebContainer.fs + "java";
        String[] args = new String[]{"-cp", this.wcHomeDir + WebContainer.fs + "server" + WebContainer.fs + "lib" + WebContainer.fs + "weblogic.jar", "weblogic.Deployer", "-adminurl", "t3://" + this.wcAdminHost + ":" + this.wcAdminPort, "-name", uri, "-username", this.wcAdminUser, "-password", this.wcAdminPassword, "-targets", this.wcTargetInstance, "-undeploy"};
        this.execUtil.storeOutput(true);
        try {
            this.execUtil.exec(command, args);
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0062");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
            throw new ConfigurationException(e);
        }
        this.logger.log(Level.FINEST, "PSFB_CSPFT0050", new String[]{"War file undeployment output", this.execUtil.getOutput()});
    }

    public void doIdentitySDKConfig(PSConfigContext configContext) throws ConfigurationException {
        if (this.isIdentityServerSDKConfigured()) {
            this.logger.log(Level.INFO, "PSFB_CSPFT0014", new String[]{this.wcPrintableInstanceName});
            return;
        }
        String FS = File.separator;
        String protocol = (String)this.wcAttributes.get("Scheme");
        String host = (String)this.wcAttributes.get("Host");
        String port = (String)this.wcAttributes.get("Port");
        String amProductLoc = configContext.getISBaseDir();
        this.amConfigDir = configContext.getISConfigDir();
        String psDataDir = configContext.getPSDataDir();
        int index = amProductLoc.lastIndexOf(FS);
        String amProductDir = amProductLoc.substring(index + 1);
        String amBaseDir = amProductLoc.substring(0, index);
        this.logger.log(Level.FINEST, "PSFB_CSPFT0015", new String[]{this.wcPrintableInstanceName});
        String amSilentName = psDataDir + FS + "tmp" + FS + "amsilent_ps." + FileUtil.getRandomDirName();
        StringBuffer fileData = new StringBuffer();
        fileData.append("BASEDIR=" + amBaseDir + WebContainer.nl).append("PRODUCT_DIR=" + amProductDir + WebContainer.nl).append("CONFIG_DIR=" + this.amConfigDir + WebContainer.nl + WebContainer.nl).append("WL8_HOME=" + this.wcHomeDir + WebContainer.nl).append("WL8_PROJECT_DIR=user_projects" + WebContainer.nl).append("WL8_CONFIG_LOCATION=" + this.wcTargetConfigdir + WebContainer.nl).append("WL8_DOMAIN=" + this.wcDomain + WebContainer.nl).append("WL8_INSTANCE=" + this.wcHomeDir + WebContainer.nl).append("WL8_SERVER=" + this.wcTargetInstance + WebContainer.nl).append("WL8_PROTOCOL=" + protocol + WebContainer.nl).append("WL8_HOST=" + host + WebContainer.nl).append("WL8_PORT=" + port + WebContainer.nl).append("WL8_ADMIN=" + this.wcAdminUser + WebContainer.nl).append("WL8_ADMINPASSWD=" + this.wcAdminPassword + WebContainer.nl).append("WL8_ADMINPORT=" + this.wcAdminPort + WebContainer.nl).append("WL8_JDK_HOME=" + this.wcJDKDir + WebContainer.nl);
        if (configContext.getAMVersion().equals("6")) {
            fileData.append("DEPLOY_LEVEL=4" + WebContainer.nl);
            this.amconfigScript = "amwl81config";
        } else {
            fileData.append("DEPLOY_LEVEL=7" + WebContainer.nl).append("JAVA_HOME=" + configContext.getJavaHome() + WebContainer.nl).append("WEB_CONTAINER=WL8" + WebContainer.nl);
            this.amconfigScript = "amconfig";
        }
        File amSilentFile = new File(amSilentName);
        try {
            FileWriter fwriter = new FileWriter(amSilentFile);
            fwriter.write(fileData.toString());
            fwriter.close();
        }
        catch (IOException ioe) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                this.logger.log(Level.SEVERE, "PSFB_CSPFT0016");
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0017");
                record.setParameters(new String[]{this.wcPrintableInstanceName});
                record.setThrown(ioe);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
            amSilentFile.delete();
            return;
        }
        String amwl81config = amProductLoc + WebContainer.fs + "bin" + WebContainer.fs + this.amconfigScript;
        String[] args = new String[]{"-s", amSilentName};
        this.logger.log(Level.FINEST, "PSFB_CSPFT0018", new String[]{amwl81config});
        if (this.execUtil.exec(amwl81config, args) != 0) {
            this.logger.log(Level.SEVERE, "PSFB_CSPFT0019", new String[]{this.wcType, this.wcPrintableInstanceName});
        } else {
            this.logger.log(Level.INFO, "PSFB_CSPFT0020", new String[]{this.wcType, this.wcPrintableInstanceName});
        }
        amSilentFile.delete();
    }

    private void computeAMClassPath(String amConfigDir) {
        boolean sunOS;
        String AMClasspathKeyStr = "";
        String OSStr = System.getProperty("os.name");
        boolean linuxOS = OSStr.indexOf("Linux") != -1;
        boolean bl = sunOS = OSStr.indexOf("SunOS") != -1;
        if (sunOS) {
            AMClasspathKeyStr = "CLASSPATH=/etc/opt/SUNWam/config";
        } else if (linuxOS) {
            AMClasspathKeyStr = "CLASSPATH=/etc/opt/sun/identity/config";
        }
        String str = FileUtil.findTextInFile(this.wcConfigfile, AMClasspathKeyStr);
        AM_CLASSPATH = str != null ? str.substring(10) : "";
    }

    private final boolean isIdentityServerSDKConfigured() throws ConfigurationException {
        String amSDKJar = null;
        amSDKJar = FileUtil.findTextInFile(this.wcConfigfile, "am_sdk.jar");
        return amSDKJar != null && amSDKJar.trim().length() > 0;
    }

    public void createSymbolicLinks(PSConfigContext configContext) {
        String docsDir;
        String helpDirStr;
        File helpDir;
        String appDir = this.wcInstanceDir + WebContainer.fs + "applications";
        String defWebApp = "DefaultWebApp";
        File defWebAppDir = new File(appDir + WebContainer.fs + defWebApp);
        if (!defWebAppDir.exists()) {
            String tmpDefWebAppPath;
            block8: {
                String defWebAppJar = this.wcHomeDir + WebContainer.fs + "common" + WebContainer.fs + "templates" + WebContainer.fs + "applications" + WebContainer.fs + defWebApp + ".jar";
                tmpDefWebAppPath = configContext.getPSDataDir() + WebContainer.fs + "WL81" + defWebApp;
                File tmpDefWebAppDir = new File(tmpDefWebAppPath);
                if (tmpDefWebAppDir.exists()) {
                    if (tmpDefWebAppDir.isDirectory()) {
                        FileUtil.deleteDir(tmpDefWebAppDir);
                    } else {
                        tmpDefWebAppDir.delete();
                    }
                } else {
                    FileUtil.makeDir(tmpDefWebAppPath);
                }
                try {
                    FileUtil.extractJar(defWebAppJar, tmpDefWebAppPath);
                }
                catch (IOException ex) {
                    if (!this.logger.isLoggable(Level.SEVERE)) break block8;
                    LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0063");
                    record.setParameters(new String[]{defWebAppJar});
                    record.setThrown(ex);
                    record.setLoggerName(this.logger.getName());
                    this.logger.log(record);
                }
            }
            FileUtil.copyDir(tmpDefWebAppPath + WebContainer.fs + "_apps_" + WebContainer.fs + defWebApp, appDir + WebContainer.fs + defWebApp);
            FileUtil.deleteDir(tmpDefWebAppPath);
        }
        if (!(helpDir = new File(helpDirStr = (docsDir = appDir + WebContainer.fs + defWebApp) + WebContainer.fs + "online_help" + WebContainer.fs + "docs_en_US")).exists()) {
            helpDir.mkdirs();
        }
        String psHelpDir = configContext.getPSBaseDir() + WebContainer.fs + "docs" + WebContainer.fs + "public_html" + WebContainer.fs + "online_help" + WebContainer.fs + "docs_en_US";
        String voiceDir = configContext.getPSBaseDir() + WebContainer.fs + "export" + WebContainer.fs + "voice";
        OSTasks osTasks = OSTasksFactory.getOSTasks(configContext, this.logger);
        osTasks.createSymbolicLink(voiceDir, docsDir);
        osTasks.createSymbolicLink(psHelpDir + WebContainer.fs + "ps", helpDirStr);
        osTasks.createSymbolicLink(psHelpDir + WebContainer.fs + "ma", helpDirStr);
        this.psBaseDir = configContext.getPSBaseDir();
    }

    public boolean setNativeLibraryPath(String path) {
        try {
            String retStr = FileUtil.findTextInFile(this.wcConfigfile, "LD_LIBRARY_PATH=");
            if (retStr != null && retStr.equals("")) {
                FileUtil.appendLineInFile(this.wcConfigfile, "SERVER_NAME=", "LD_LIBRARY_PATH=" + path);
                FileUtil.appendLineInFile(this.wcConfigfile, "LD_LIBRARY_PATH=", "export LD_LIBRARY_PATH");
            } else {
                FileUtil.replaceTokenInFile(this.wcConfigfile, "LD_LIBRARY_PATH=", "LD_LIBRARY_PATH=" + path + WebContainer.cps);
            }
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0027");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
            return false;
        }
        return true;
    }

    public boolean isPortalConfigured() {
        String str = FileUtil.findTextInFile(this.wcConfigfile, "$PS_CLASS_PATH=");
        if (str != null && !str.equals("") && str.indexOf("ps_util.jar") >= 0) {
            this.logger.log(Level.INFO, "PSFB_CSPFT0041");
            return true;
        }
        return false;
    }

    public boolean appendClasspath(String classPath) {
        this.logger.log(Level.FINEST, "PSFB_CSPFT0072");
        String str = FileUtil.findTextInFile(this.wcConfigfile, "PS_CLASS_PATH=");
        if (str != null && !str.equals("")) {
            String serverCP = FileUtil.getQuotedKeyValueInText("PS_CLASS_PATH", str);
            String filteredClassPath = this.getFilteredClassPath(classPath, serverCP);
            FileUtil.replaceTokenInFile(this.wcConfigfile, "PS_CLASS_PATH=\"", "PS_CLASS_PATH=\"" + filteredClassPath + ":");
        } else {
            FileUtil.appendLineInFile(this.wcConfigfile, "SERVER_NAME=", "PS_CLASS_PATH=\"" + classPath + "\"", 7);
        }
        str = FileUtil.findTextInFile(this.wcConfigfile, "CLASSPATH=");
        if (str != null && !str.equals("")) {
            if (str.indexOf("$PS_CLASS_PATH") == -1) {
                str = str.endsWith("\"") ? str.substring(0, str.length() - 1) + WebContainer.cps + "$PS_CLASS_PATH" + "\"" : str + WebContainer.cps + "$PS_CLASS_PATH";
                FileUtil.deleteLineInFile(this.wcConfigfile, "CLASSPATH=", 3);
                FileUtil.appendLineInFile(this.wcConfigfile, "PS_CLASS_PATH=", "\n" + str, 7);
            }
        } else {
            FileUtil.appendLineInFile(this.wcConfigfile, "PS_CLASS_PATH=", "CLASSPATH=\"$PS_CLASS_PATH\"", 7);
        }
        this.psClassPath = classPath;
        return true;
    }

    private void prepareWebLogicServerStartClasspath(String psClassPath) {
        this.logger.log(Level.FINEST, "PSFB_CSPFT0071");
        if (!this.wcManagedServer) {
            return;
        }
        this.computeAMClassPath(this.psBaseDir);
        String command = this.wcJDKDir + WebContainer.fs + "bin" + WebContainer.fs + "java";
        String[] args = new String[]{"-cp", "." + WebContainer.cps + this.wcHomeDir + WebContainer.fs + "server" + WebContainer.fs + "lib" + WebContainer.fs + "weblogic.jar" + WebContainer.cps + this.psBaseDir + WebContainer.fs + "lib" + WebContainer.fs + "fabric.jar" + WebContainer.cps + this.psBaseDir + WebContainer.fs + "lib" + WebContainer.fs + "config.jar" + WebContainer.cps + this.psBaseDir + WebContainer.fs + "lib" + WebContainer.fs + "pslogcommon.jar", "com.sun.portal.fabric.tasks.WeblogicServerHelper", "-method", "setManagedServerClasspath", "-params", "t3://" + this.wcAdminHost + ":" + this.wcAdminPort, this.wcAdminUser, this.wcAdminPassword, this.wcTargetInstance, this.wcHomeDir + WebContainer.fs + "server" + WebContainer.fs + "lib" + WebContainer.fs + "weblogic.jar" + WebContainer.cps + psClassPath + WebContainer.cps + this.psBaseDir + WebContainer.fs + "web-src" + WebContainer.fs + "WEB-INF" + WebContainer.fs + "lib" + WebContainer.fs + "log4j-1.2.8.jar" + WebContainer.cps + AM_CLASSPATH};
        this.execUtil.storeOutput(true);
        this.execUtil.exec(command, args);
        this.logger.log(Level.FINEST, "PSFB_CSPFT0050", new String[]{"Classpath for Weblogic Server Helper", args[1]});
        this.logger.log(Level.FINEST, "PSFB_CSPFT0050", new String[]{"Prepare start-stop output", this.execUtil.getOutput()});
    }

    private boolean createJVMOptionVariables(String option, String value) {
        boolean success = false;
        String strID = "";
        if (option.equals("com.sun.portal.portal.id")) {
            strID = "PS_PORTAL_ID_";
        } else if (option.equals("com.sun.portal.instance.id")) {
            strID = "PS_INSTANCE_ID_";
        }
        String str = FileUtil.findTextInFile(this.wcConfigfile, strID + this.wcTargetInstance + "=" + value);
        if (str != null && !str.equals("")) {
            return success;
        }
        str = FileUtil.findTextInFile(this.wcConfigfile, strID + this.wcTargetInstance + "=");
        if (str != null && !str.equals("")) {
            if (str.indexOf(value) == -1) {
                FileUtil.deleteLineInFile(this.wcConfigfile, strID + this.wcTargetInstance + "=");
                success = FileUtil.appendLineInFile(this.wcConfigfile, "ADMIN_URL=", strID + this.wcTargetInstance + "=" + value, 7);
            }
        } else {
            success = FileUtil.appendLineInFile(this.wcConfigfile, "ADMIN_URL=", strID + this.wcTargetInstance + "=" + value, 7);
        }
        return success;
    }

    public boolean addJVMOption(String option, String value) {
        boolean success = false;
        String modifiedValue = value;
        if (this.wcManagedServer && (option.equals("com.sun.portal.portal.id") || option.equals("com.sun.portal.instance.id"))) {
            int idx = value.indexOf(this.portalID);
            if (idx != -1) {
                modifiedValue = value.substring(0, idx) + "`eval echo \\\\$PS_PORTAL_ID_${1}`";
            }
            if ((idx = modifiedValue.indexOf(this.instanceID)) != -1) {
                modifiedValue = modifiedValue.substring(0, idx) + "`eval echo \\\\$PS_INSTANCE_ID_${1}`";
            }
            if (option.equals("com.sun.portal.portal.id")) {
                this.createJVMOptionVariables("com.sun.portal.portal.id", this.portalID);
            }
            if (option.equals("com.sun.portal.instance.id")) {
                this.createJVMOptionVariables("com.sun.portal.instance.id", this.instanceID);
            }
        }
        String optionValuePair = "-D" + option + "=" + modifiedValue;
        String str = FileUtil.findTextInFile(this.wcConfigfile, "JAVA_OPTIONS=");
        if (str != null && !str.equals("")) {
            if (str.indexOf(optionValuePair) == -1) {
                optionValuePair = str.substring(str.indexOf("\"") + 1, str.length() - 1) + " " + optionValuePair;
                FileUtil.deleteLineInFile(this.wcConfigfile, "JAVA_OPTIONS=");
                success = FileUtil.appendLineInFile(this.wcConfigfile, "SERVER_NAME=", "JAVA_OPTIONS=\"" + optionValuePair + "\"", 7);
            }
        } else {
            success = FileUtil.appendLineInFile(this.wcConfigfile, "SERVER_NAME=", "JAVA_OPTIONS=\"" + optionValuePair + "\"", 7);
        }
        return success;
    }

    public void removeJarFromClassPath(String jarToRemove) throws ConfigurationException {
        File wlFile = new File(this.wcInstanceDir + WebContainer.fs + "startWebLogic.sh");
        File wlFileManaged = new File(this.wcInstanceDir + WebContainer.fs + "startManagedWebLogic.sh");
        boolean wlFileExists = wlFile.exists();
        boolean wlFileManagedExists = wlFileManaged.exists();
        StringTokenizer st = new StringTokenizer(jarToRemove, WebContainer.cps);
        while (st.hasMoreTokens()) {
            if (wlFileExists) {
                this.removeJarFromClassPath(wlFile, st.nextToken());
            }
            if (!wlFileManagedExists) continue;
            this.removeJarFromClassPath(wlFileManaged, st.nextToken());
        }
    }

    private void removeJarFromClassPath(File wlFile, String jarPath) throws ConfigurationException {
        try {
            String retStr = FileUtil.findTextInFile(wlFile, jarPath);
            if (retStr != null && !retStr.equals("")) {
                FileUtil.replaceTokenInFile(wlFile, jarPath + WebContainer.cps, "");
            }
        }
        catch (Exception ioe) {
            throw new ConfigurationException(ioe.toString());
        }
    }

    public void doMiscTasks(PSConfigContext configContext) {
        this.logger.log(Level.FINEST, "PSFB_CSPFT0065");
        File bsOrigFile = new File(configContext.getPSConfigDir() + WebContainer.fs + "bootstrapSystem.properties-orig");
        if (!bsOrigFile.exists()) {
            try {
                FileUtil.copyFile(new File(configContext.getPSConfigDir() + WebContainer.fs + "bootstrapSystem.properties"), bsOrigFile, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            FileUtil.copyFile(new File(configContext.getPSConfigDir() + WebContainer.fs + "WEBLOGIC.bootstrapSystem.properties"), new File(configContext.getPSConfigDir() + WebContainer.fs + "bootstrapSystem.properties"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.prepareWebLogicServerStartClasspath(this.psClassPath);
        String jaxpClasspath = configContext.getPSBaseDir() + WebContainer.fs + "lib" + WebContainer.fs + "endorsed" + WebContainer.fs + "jaxp-api.jar" + ":" + configContext.getPSBaseDir() + WebContainer.fs + "lib" + WebContainer.fs + "endorsed" + WebContainer.fs + "sax.jar" + ":" + configContext.getPSBaseDir() + WebContainer.fs + "lib" + WebContainer.fs + "endorsed" + WebContainer.fs + "xalan.jar";
        this.appendClasspath(jaxpClasspath);
    }

    public void configResource(Element root, String derbyHost, String derbyPort, String databaseName, String poolName, String psLibDir) {
        this.createConnectionPool(root, poolName, psLibDir);
        this.createResource(root, poolName, psLibDir);
    }

    private void createConnectionPool(Element root, String poolName, String psLibDir) {
        String[] args = new String[12];
        String command = this.wcJDKDir + WebContainer.fs + "bin" + WebContainer.fs + "java";
        args[0] = "-cp";
        args[1] = this.wcHomeDir + WebContainer.fs + "server" + WebContainer.fs + "lib" + WebContainer.fs + "weblogic.jar";
        args[2] = "weblogic.Admin";
        args[3] = "-adminurl";
        args[4] = "t3://" + this.wcAdminHost + ":" + this.wcAdminPort;
        args[5] = "-username";
        args[6] = this.wcAdminUser;
        args[7] = "-password";
        args[8] = this.wcAdminPassword;
        args[9] = "CREATE_POOL";
        args[10] = poolName;
        args[11] = "url=" + root.getAttributeValue("url") + "," + "driver=" + root.getAttributeValue("driverClassName") + "," + "maxCapacity=" + root.getAttributeValue("maxActive") + "," + "props=user=" + root.getAttributeValue("username") + ";" + "password=" + root.getAttributeValue("password");
        this.execUtil.storeOutput(true);
        this.execUtil.exec(command, args);
        this.logger.log(Level.FINEST, "PSFB_CSPFT0088", this.execUtil.getOutput());
        this.setTargetsToConnectionPool(psLibDir);
    }

    private void createResource(Element root, String poolName, String psLibDir) {
        String[] args = new String[12];
        String command = this.wcJDKDir + WebContainer.fs + "bin" + WebContainer.fs + "java";
        int endIndx = poolName.indexOf("Pool");
        String resourceName = poolName.substring(0, endIndx);
        args[0] = "-cp";
        args[1] = this.wcHomeDir + WebContainer.fs + "server" + WebContainer.fs + "lib" + WebContainer.fs + "weblogic.jar";
        args[2] = "weblogic.Admin";
        args[3] = "-adminurl";
        args[4] = "t3://" + this.wcAdminHost + ":" + this.wcAdminPort;
        args[5] = "-username";
        args[6] = this.wcAdminUser;
        args[7] = "-password";
        args[8] = this.wcAdminPassword;
        args[9] = "CREATE";
        args[10] = "-mbean";
        args[11] = this.wcDomain + ":Name=" + resourceName + ",Type=JDBCTxDataSource";
        this.execUtil.storeOutput(true);
        this.execUtil.exec(command, args);
        this.logger.log(Level.FINEST, "PSFB_CSPFT0090", this.execUtil.getOutput());
        String[] args1 = new String[]{"-cp", this.wcHomeDir + WebContainer.fs + "server" + WebContainer.fs + "lib" + WebContainer.fs + "weblogic.jar", "weblogic.Admin", "-adminurl", "t3://" + this.wcAdminHost + ":" + this.wcAdminPort, "-username", this.wcAdminUser, "-password", this.wcAdminPassword, "SET", "-mbean", this.wcDomain + ":Name=" + resourceName + ",Type=JDBCTxDataSource", "-property", "PoolName", "\"" + poolName + "\"", "-property", "JNDIName", "\"" + root.getAttributeValue("name") + "\""};
        this.execUtil.storeOutput(true);
        this.execUtil.exec(command, args1);
        this.logger.log(Level.FINEST, "PSFB_CSPFT0091", this.execUtil.getOutput());
        this.setTargetsToDatasource(root.getAttributeValue("name"), psLibDir);
    }

    private void setTargetsToConnectionPool(String psLibDir) {
        String command = this.wcJDKDir + WebContainer.fs + "bin" + WebContainer.fs + "java";
        String[] args = new String[]{"-cp", "." + WebContainer.cps + this.wcHomeDir + WebContainer.fs + "server" + WebContainer.fs + "lib" + WebContainer.fs + "weblogic.jar" + WebContainer.cps + psLibDir + WebContainer.fs + "fabric.jar" + WebContainer.cps + psLibDir + WebContainer.fs + "config.jar" + WebContainer.cps + psLibDir + WebContainer.fs + "pslogcommon.jar", "com.sun.portal.fabric.tasks.WeblogicServerHelper", "-method", "setTargetsToConnectionPools", "-params", "t3://" + this.wcAdminHost + ":" + this.wcAdminPort, this.wcAdminUser, this.wcAdminPassword, this.wcTargetInstance};
        this.execUtil.storeOutput(true);
        this.execUtil.exec(command, args);
        this.logger.log(Level.FINEST, "PSFB_CSPFT0100", this.execUtil.getOutput());
        this.logger.log(Level.FINEST, "PSFB_CSPFT0050", new String[]{"Classpath for Weblogic Server Helper", args[1]});
    }

    private void setTargetsToDatasource(String jndiName, String psLibDir) {
        String command = this.wcJDKDir + WebContainer.fs + "bin" + WebContainer.fs + "java";
        String[] args = new String[]{"-cp", "." + WebContainer.cps + this.wcHomeDir + WebContainer.fs + "server" + WebContainer.fs + "lib" + WebContainer.fs + "weblogic.jar" + WebContainer.cps + psLibDir + WebContainer.fs + "fabric.jar" + WebContainer.cps + psLibDir + WebContainer.fs + "config.jar" + WebContainer.cps + psLibDir + WebContainer.fs + "pslogcommon.jar", "com.sun.portal.fabric.tasks.WeblogicServerHelper", "-method", "setTargetsToDatasources", "-params", "t3://" + this.wcAdminHost + ":" + this.wcAdminPort, this.wcAdminUser, this.wcAdminPassword, this.wcTargetInstance, jndiName};
        this.execUtil.storeOutput(true);
        this.execUtil.exec(command, args);
        this.logger.log(Level.FINEST, "PSFB_CSPFT0100", this.execUtil.getOutput());
        this.logger.log(Level.FINEST, "PSFB_CSPFT0050", new String[]{"Classpath for Weblogic Server Helper", args[1]});
    }

    public void unConfigResource(String jndiName, String poolName) {
    }

    public void start() {
        this.logger.log(Level.FINEST, "PSFB_CSPFT0074");
        if (!this.wcManagedServer) {
            return;
        }
        String[] args = new String[11];
        String command = this.wcJDKDir + WebContainer.fs + "bin" + WebContainer.fs + "java";
        args[0] = "-cp";
        args[1] = this.wcHomeDir + WebContainer.fs + "server" + WebContainer.fs + "lib" + WebContainer.fs + "weblogic.jar";
        args[2] = "weblogic.Admin";
        args[3] = "-adminurl";
        args[4] = "t3://" + this.wcAdminHost + ":" + this.wcAdminPort;
        args[5] = "-username";
        args[6] = this.wcAdminUser;
        args[7] = "-password";
        args[8] = this.wcAdminPassword;
        args[9] = "START";
        args[10] = this.wcTargetInstance;
        this.execUtil.storeOutput(true);
        this.execUtil.exec(command, args);
        this.logger.log(Level.FINEST, "PSFB_CSPFT0050", new String[]{"Weblogic Server Start output", this.execUtil.getOutput()});
    }

    public void stop() {
        this.logger.log(Level.FINEST, "PSFB_CSPFT0075");
        if (!this.wcManagedServer) {
            return;
        }
        String[] args = new String[11];
        String command = this.wcJDKDir + WebContainer.fs + "bin" + WebContainer.fs + "java";
        args[0] = "-cp";
        args[1] = this.wcHomeDir + WebContainer.fs + "server" + WebContainer.fs + "lib" + WebContainer.fs + "weblogic.jar";
        args[2] = "weblogic.Admin";
        args[3] = "-adminurl";
        args[4] = "t3://" + this.wcAdminHost + ":" + this.wcAdminPort;
        args[5] = "-username";
        args[6] = this.wcAdminUser;
        args[7] = "-password";
        args[8] = this.wcAdminPassword;
        args[9] = "FORCESHUTDOWN";
        args[10] = this.wcTargetInstance;
        this.execUtil.storeOutput(true);
        this.execUtil.exec(command, args);
        this.logger.log(Level.FINEST, "PSFB_CSPFT0050", new String[]{"Weblogic Server Stop output", this.execUtil.getOutput()});
    }

    public void validate() throws ValidationException {
        String port;
        if (!this.checkNotNullOrEmpty("WebContainerInstanceName", this.wcTargetInstance)) {
            throw new ValidationException("Invalid Instance Name");
        }
        if (!this.checkNotNull("WebContainerAdminUid", this.wcAdminUser)) {
            throw new ValidationException("Invalid Admin User");
        }
        if (!this.checkNotNull("WebContainerAdminPassword", this.wcAdminPassword, true)) {
            throw new ValidationException("Invalid Admin Password");
        }
        if (!this.checkNotNullOrEmpty("WebContainerAdminScheme", this.wcAdminProtocol)) {
            throw new ValidationException("Invalid Admin Scheme");
        }
        if (!this.checkNotNullOrEmpty("WebContainerAdminHost", this.wcAdminHost)) {
            throw new ValidationException("Invalid Admin Host");
        }
        if (!this.checkNotNullOrEmpty("WebContainerAdminPort", this.wcAdminPort)) {
            throw new ValidationException("Invalid Admin Port");
        }
        if (!this.checkNotNullOrEmpty("WebContainerManagedServer", this.wcManagedServerStr)) {
            throw new ValidationException("Invalid Managed Server Status");
        }
        if (!this.checkDirExists("WebContainerInstanceDir", this.wcInstanceDir)) {
            throw new ValidationException("Invalid Instance Directory = " + this.wcInstanceDir);
        }
        if (!this.checkDirExists("WebContainerInstallDir", this.wcHomeDir)) {
            throw new ValidationException("Invalid Install Directory = " + this.wcHomeDir);
        }
        if (!this.checkDirExists("WebContainerJDKDir", this.wcJDKDir)) {
            throw new ValidationException("Invalid JDK Directory = " + this.wcJDKDir);
        }
        String host = (String)this.wcAttributes.get("Host");
        boolean bIsValidHostNamePort = this.validateInstanceHostNamePort(host, port = (String)this.wcAttributes.get("Port"));
        if (!bIsValidHostNamePort) {
            throw new ValidationException("Invalid Instance Host/Port");
        }
        if (this.wcAdminPort == null || this.wcAdminPort.length() <= 0) {
            throw new ValidationException("Invalid Admin Port");
        }
        bIsValidHostNamePort = this.validateAdminHostNamePort(this.wcAdminHost, this.wcAdminPort);
        if (!bIsValidHostNamePort) {
            throw new ValidationException("Invalid Admin Host/Port");
        }
    }

    public boolean removeClasspath(String classpath) {
        this.logger.log(Level.FINEST, "PSFB_CSPFT0050", new String[]{"Removing classpath", classpath});
        String str = FileUtil.findTextInFile(this.wcConfigfile, "PS_CLASS_PATH=");
        if (str != null && !str.equals("")) {
            FileUtil.deleteLineInFile(this.wcConfigfile, "PS_CLASS_PATH=", 3);
        }
        if ((str = FileUtil.findTextInFile(this.wcConfigfile, "$PS_CLASS_PATH")) != null && !str.equals("")) {
            int idx = str.indexOf("$PS_CLASS_PATH");
            str = str.substring(0, idx - 1) + str.substring(idx + 14);
            FileUtil.deleteLineInFile(this.wcConfigfile, "$PS_CLASS_PATH", 1);
            FileUtil.appendLineInFile(this.wcConfigfile, "resetFd", "\n" + str, 7);
        }
        return true;
    }

    public boolean removeJVMOption(String option, String value) {
        String str;
        boolean someInstanceExist;
        boolean success = false;
        String optionValuePair = "-D" + option + "=" + value;
        this.logger.log(Level.FINEST, "PSFB_CSPFT0058", new String[]{optionValuePair});
        success = FileUtil.replaceLineInFile(this.wcConfigfile, "PS_PORTAL_ID_" + this.wcTargetInstance, "");
        success = FileUtil.replaceLineInFile(this.wcConfigfile, "PS_INSTANCE_ID_" + this.wcTargetInstance, "");
        String strSomeInstancePortalID = FileUtil.findTextInFile(this.wcConfigfile, "PS_PORTAL_ID_=");
        boolean bl = someInstanceExist = strSomeInstancePortalID != null && !strSomeInstancePortalID.equals("");
        if (!someInstanceExist && (str = FileUtil.findTextInFile(this.wcConfigfile, "JAVA_OPTIONS=")) != null && !str.equals("")) {
            int idx = str.indexOf("-D" + option);
            int idx2 = 0;
            if (idx != -1) {
                idx2 = str.indexOf(" -D", idx);
                str = idx2 != -1 ? str.substring(0, idx) + str.substring(str.indexOf(" -D", idx)) : str.substring(0, idx) + (str.startsWith("JAVA_OPTIONS=\"") ? "\"" : "");
                FileUtil.deleteLineInFile(this.wcConfigfile, "JAVA_OPTIONS=");
                success = FileUtil.appendLineInFile(this.wcConfigfile, "SERVER_NAME=", str, 7);
            }
        }
        return success;
    }

    public boolean removeNativeLibraryPath(String path) {
        this.logger.log(Level.FINEST, "PSFB_CSPFT0066");
        try {
            String pathToDelete = "/usr/lib/lwp";
            String retStr = FileUtil.findTextInFile(this.wcConfigfile, "LD_LIBRARY_PATH=");
            if (retStr == null || retStr.equals("") || !retStr.trim().startsWith("LD_LIBRARY_PATH=")) {
                this.logger.log(Level.FINEST, "PSFB_CSPFT0079");
                return false;
            }
            FileUtil.replaceTokenInFile(this.wcConfigfile, pathToDelete, "");
            this.logger.log(Level.FINEST, "PSFB_CSPFT0078", new String[]{"/usr/lib/lwp", retStr, this.wcConfigfile.getAbsolutePath()});
        }
        catch (Exception e) {
            if (this.logger.isLoggable(Level.SEVERE)) {
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0030");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
            return false;
        }
        return true;
    }

    public void deleteSymbolicLinks(PSConfigContext configContext) {
        block2: {
            this.logger.log(Level.FINEST, "PSFB_CSPFT0070");
            try {
                String appDir = this.wcInstanceDir + WebContainer.fs + "applications";
                String defWebApp = "DefaultWebApp";
                String docsDir = appDir + WebContainer.fs + defWebApp;
                String helpDir = docsDir + WebContainer.fs + "online_help" + WebContainer.fs + "docs_en_US";
                OSTasks osTasks = OSTasksFactory.getOSTasks(configContext, this.logger);
                osTasks.removeSymbolicLink(docsDir + WebContainer.fs + "voice");
                osTasks.removeSymbolicLink(helpDir + WebContainer.fs + "ps");
                osTasks.removeSymbolicLink(helpDir + WebContainer.fs + "ma");
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.SEVERE)) break block2;
                LogRecord record = new LogRecord(Level.SEVERE, "PSFB_CSPFT0038");
                record.setThrown(e);
                record.setLoggerName(this.logger.getName());
                this.logger.log(record);
            }
        }
    }

    public void undoMiscTasks(PSConfigContext configContext) {
        String jaxpClasspath = configContext.getPSBaseDir() + WebContainer.fs + "lib" + WebContainer.fs + "endorsed" + WebContainer.fs + "jaxp-api.jar" + ":" + configContext.getPSBaseDir() + WebContainer.fs + "lib" + WebContainer.fs + "endorsed" + WebContainer.fs + "sax.jar" + ":" + configContext.getPSBaseDir() + WebContainer.fs + "lib" + WebContainer.fs + "endorsed" + WebContainer.fs + "xalan.jar";
        this.removeClasspath(jaxpClasspath);
    }

    public boolean doJVMMemorySettings() {
        return false;
    }
}

