/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.mbeans;

import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.server.mbeans.PSResource;
import com.sun.portal.fabric.mbeans.UploadDownloadFileManagerMBean;
import com.sun.portal.fabric.tasks.DownloadInfo;
import com.sun.portal.fabric.tasks.UploadInfo;
import com.sun.portal.log.common.PortalLogger;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UploadDownloadFileManager
extends PSResource
implements UploadDownloadFileManagerMBean {
    private static final String STRING_UPLOAD = "upload";
    private static final String STRING_DOWNLOAD = "download";
    private static final String STRING_HYPHEN = "-";
    private static final String MSG_PREFIX = "fileUploadDownload";
    private String psPortalID;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$mbeans$UploadDownloadFileManager == null ? (class$com$sun$portal$fabric$mbeans$UploadDownloadFileManager = UploadDownloadFileManager.class$("com.sun.portal.fabric.mbeans.UploadDownloadFileManager")) : class$com$sun$portal$fabric$mbeans$UploadDownloadFileManager));
    private PSConfigContext cc = null;
    private Hashtable mInfo = new Hashtable();
    private int fileCounter = 0;
    static /* synthetic */ Class class$com$sun$portal$fabric$mbeans$UploadDownloadFileManager;

    public void init(PSConfigContext cc, PortalDomainContext pdc, List path) {
        super.init(cc, pdc, path);
        this.cc = cc;
        this.psPortalID = (String)path.get(1);
    }

    public String[] initiateFileUpload(String fileName, Long fileSize) throws PSMBeanException {
        String mObjectId = "upload-" + this.getCounter();
        UploadInfo uploadInfo = null;
        try {
            uploadInfo = new UploadInfo(fileName, fileSize, this.cc.getPSDataDir());
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "PSFB_CSPFM0003", ioe);
            Object[] tokens = new Object[]{uploadInfo.getName()};
            throw new PSMBeanException("fileUploadDownloaderrorInUpload", ioe.getMessage(), tokens);
        }
        this.mInfo.put(mObjectId, uploadInfo);
        String[] nameIdArray = new String[]{mObjectId, uploadInfo.getName()};
        return nameIdArray;
    }

    private synchronized int getCounter() {
        ++this.fileCounter;
        return this.fileCounter;
    }

    public void uploadBytes(String uploadId, byte[] bytesToUpload) throws PSMBeanException {
        UploadInfo uploadInfo = (UploadInfo)this.mInfo.get(uploadId);
        try {
            uploadInfo.writeBytes(bytesToUpload);
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{uploadInfo.getName()};
            logger.log(Level.SEVERE, "PSFB_CSPFM0004", tokens);
            logger.log(Level.SEVERE, "PSFB_CSPFM0003", ioe);
            throw new PSMBeanException("fileUploadDownloaderrorInUpload", ioe.getMessage(), tokens);
        }
    }

    public Object[] initiateFileDownload(String fileName) throws PSMBeanException {
        String mObjectId = "download-" + this.getCounter();
        DownloadInfo downloadInfo = null;
        try {
            downloadInfo = new DownloadInfo(fileName);
        }
        catch (FileNotFoundException fne) {
            logger.log(Level.SEVERE, "PSFB_CSPFM0003", fne);
            Object[] tokens = new Object[]{fileName};
            throw new PSMBeanException("fileUploadDownloaderrorInDownloadFileNotFound", fne.getMessage(), tokens);
        }
        this.mInfo.put(mObjectId, downloadInfo);
        Object[] idSizeArray = new Object[]{mObjectId, new Long(downloadInfo.getSize())};
        return idSizeArray;
    }

    public byte[] downloadBytes(String downloadId, Integer downloadSize) throws PSMBeanException {
        byte[] readBytes = null;
        DownloadInfo downloadInfo = (DownloadInfo)this.mInfo.get(downloadId);
        try {
            readBytes = downloadInfo.readBytes(downloadSize);
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "PSFB_CSPFM0003", ioe);
            Object[] tokens = new Object[]{downloadInfo.getName()};
            logger.log(Level.SEVERE, "PSFB_CSPFM0004", tokens);
            throw new PSMBeanException("fileUploadDownloaderrorInDownload", ioe.getMessage(), tokens);
        }
        return readBytes;
    }

    public void cleanUp(String Id) {
        Object info = this.mInfo.get(Id);
        if (info instanceof UploadInfo) {
            UploadInfo uploadInfo = (UploadInfo)info;
            boolean ret = false;
            ret = uploadInfo.deleteFile();
            if (!ret) {
                logger.log(Level.SEVERE, "PSFB_CSPFM0005", uploadInfo.getName());
            }
        } else if (info instanceof DownloadInfo) {
            DownloadInfo downloadInfo = (DownloadInfo)info;
            downloadInfo.cleanUp();
        }
        this.mInfo.remove(Id);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

