/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.mbeans;

import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.common.util.AdminUtil;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.admin.server.mbeans.PSResource;
import com.sun.portal.fabric.mbeans.SchedulerMBean;
import com.sun.portal.fabric.tasks.scheduler.SchedulerTask;
import com.sun.portal.log.common.PortalLogger;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;

public class Scheduler
extends PSResource
implements SchedulerMBean {
    private ObjectName objectName = null;
    private String host = null;
    private String psDir = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$mbeans$Scheduler == null ? (class$com$sun$portal$fabric$mbeans$Scheduler = Scheduler.class$("com.sun.portal.fabric.mbeans.Scheduler")) : class$com$sun$portal$fabric$mbeans$Scheduler));
    static /* synthetic */ Class class$com$sun$portal$fabric$mbeans$Scheduler;

    public void init(PSConfigContext cc, PortalDomainContext pdc, List path) {
        super.init(cc, pdc, path);
        try {
            this.objectName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.Scheduler", (List)path);
            this.host = pdc.getAttributeValue("PortalDomain.Scheduler", path, "Host");
        }
        catch (Exception e) {
            // empty catch block
        }
        this.psDir = cc.getPSBaseDir();
    }

    public Boolean schedule(List actions) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{actions};
                String[] signature = new String[]{"java.util.List"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "schedule", params, signature);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                throw new PSMBeanException("Scheduler:schedule", e.toString(), (Throwable)e);
            }
        }
        SchedulerTask schedulerTask = new SchedulerTask(this.cc, logger);
        schedulerTask.schedule((ArrayList)actions);
        return Boolean.TRUE;
    }

    public Boolean unschedule(List actions) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{actions};
                String[] signature = new String[]{"java.util.List"};
                Boolean result = (Boolean)msc.invoke(this.objectName, "unschedule", params, signature);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                throw new PSMBeanException("Scheduler:unschedule", e.toString(), (Throwable)e);
            }
        }
        SchedulerTask schedulerTask = new SchedulerTask(this.cc, logger);
        schedulerTask.unschedule((ArrayList)actions);
        return Boolean.TRUE;
    }

    public ArrayList getSchedules(String command) throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                Object[] params = new Object[]{command};
                String[] signature = new String[]{"java.lang.String"};
                ArrayList result = (ArrayList)msc.invoke(this.objectName, "getSchedules", params, signature);
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                throw new PSMBeanException("Scheduler:getSchedules", e.toString(), (Throwable)e);
            }
        }
        SchedulerTask schedulerTask = new SchedulerTask(this.cc, logger);
        return schedulerTask.getSchedules(command);
    }

    public String getPSDir() throws PSMBeanException, UnknownHostException {
        if (!AdminUtil.isLocal((String)this.host)) {
            try {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)this.host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                String result = (String)msc.getAttribute(this.objectName, "PSDir");
                jmxc.close();
                return result;
            }
            catch (Exception e) {
                throw new PSMBeanException("Scheduler:getPSDir", e.toString(), (Throwable)e);
            }
        }
        return this.psDir;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

