/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.mbeans;

import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.common.context.PortalDomainContextException;
import com.sun.portal.admin.common.util.AdminUtil;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.admin.server.mbeans.PSResource;
import com.sun.portal.fabric.mbeans.PortalServerInstanceMBean;
import com.sun.portal.fabric.tasks.ConfigurationException;
import com.sun.portal.fabric.tasks.WebContainer;
import com.sun.portal.fabric.tasks.WebContainerFactory;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.fabric.util.XMLJdomFileCreationException;
import com.sun.portal.fabric.util.XMLJdomUtil;
import com.sun.portal.log.common.PortalLogger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ObjectName;

public class PortalServerInstance
extends PSResource
implements PortalServerInstanceMBean {
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$mbeans$PortalServerInstance == null ? (class$com$sun$portal$fabric$mbeans$PortalServerInstance = PortalServerInstance.class$("com.sun.portal.fabric.mbeans.PortalServerInstance")) : class$com$sun$portal$fabric$mbeans$PortalServerInstance));
    private ObjectName iObjName;
    private String host;
    private String port;
    private String warDirLocation;
    private Boolean isLocal = Boolean.FALSE;
    private WebContainer wcInstance;
    static /* synthetic */ Class class$com$sun$portal$fabric$mbeans$PortalServerInstance;

    public void init(PSConfigContext cc, PortalDomainContext pdc, List path) {
        super.init(cc, pdc, path);
        try {
            this.iObjName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal.ServerInstance", (List)path);
            this.host = pdc.getAttributeValue("PortalDomain.Portal.ServerInstance", path, "Host");
            this.port = pdc.getAttributeValue("PortalDomain.Portal.ServerInstance", path, "Port");
            this.isLocal = AdminUtil.isLocal((String)this.host) ? Boolean.TRUE : Boolean.FALSE;
            this.warDirLocation = cc.getPSDataDir() + fs + "portals" + fs + this.getPortal() + fs + "war";
            this.setWCInstance();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "MBean initialization failed", e);
            throw new RuntimeException(e);
        }
    }

    public String getPortal() {
        return (String)this.path.get(1);
    }

    public void redeploy(String uri) throws PSMBeanException {
    }

    public void deployAll() throws PSMBeanException {
        String message;
        if (!this.isLocal.booleanValue()) {
            this.invokeRemoteOperation(this.host, this.iObjName, "deployAll", null, null);
            return;
        }
        File warDir = new File(this.warDirLocation);
        Vector warFiles = new Vector();
        FileUtil.getFiles(warDir, warFiles, "war");
        Set<String> uriSet = new HashSet();
        try {
            uriSet = this.pdc.getAttributeValues("PortalDomain.Portal.ServerInstance", this.path, "DeployedWebApplications");
            if (uriSet.isEmpty()) {
                uriSet = new HashSet();
            }
        }
        catch (Exception e) {
            message = "Error reading resources in fetching deployed URI";
            logger.log(Level.SEVERE, message, e);
        }
        if (warFiles != null) {
            for (int i = 0; i < warFiles.size(); ++i) {
                File war = (File)warFiles.get(i);
                String fileName = war.getName();
                int idx = fileName.indexOf(".war");
                String uri = "/" + fileName.substring(0, idx);
                try {
                    this.wcInstance.deploy(war.getAbsolutePath(), uri);
                    uriSet.add(uri);
                    continue;
                }
                catch (ConfigurationException ce) {
                    logger.log(Level.SEVERE, "Deploy Failed", ce);
                }
            }
        }
        try {
            this.pdc.setAttributeValues("PortalDomain.Portal.ServerInstance", this.path, "DeployedWebApplications", uriSet);
        }
        catch (Exception e) {
            message = "Error setting deployed URIs";
            logger.log(Level.SEVERE, message, e);
            throw new PSMBeanException("admin.error.set.resources", e.getMessage(), (Throwable)e, null);
        }
    }

    public void deploy(String uri) throws PSMBeanException {
        if (!this.isLocal.booleanValue()) {
            Object[] params = new Object[]{uri};
            String[] signature = new String[]{"java.lang.String"};
            this.invokeRemoteOperation(this.host, this.iObjName, "deploy", params, signature);
            return;
        }
        File war = new File(this.warDirLocation + fs + uri + ".war");
        if (war.exists()) {
            try {
                HashSet<String> uriSet = this.pdc.getAttributeValues("PortalDomain.Portal.ServerInstance", this.path, "DeployedWebApplications");
                this.wcInstance.deploy(war.getAbsolutePath(), uri);
                if (uriSet.isEmpty()) {
                    uriSet = new HashSet<String>();
                }
                uriSet.add(uri);
                this.pdc.setAttributeValues("PortalDomain.Portal.ServerInstance", this.path, "DeployedWebApplications", uriSet);
            }
            catch (ConfigurationException ce) {
                logger.log(Level.SEVERE, "Deploy Failed", ce);
                throw new PSMBeanException("admin.error.deploy.failed", ce.getMessage(), (Throwable)ce, null);
            }
            catch (Exception e) {
                String message = "Error setting instance data";
                logger.log(Level.SEVERE, message, e);
                throw new PSMBeanException("admin.error.set.resources", e.getMessage(), (Throwable)e, null);
            }
        } else {
            throw new PSMBeanException("admin.error.deploy.failed", "WAR File Not Found :" + war);
        }
    }

    public void undeploy(String uri) throws PSMBeanException {
        if (!this.isLocal.booleanValue()) {
            Object[] params = new Object[]{uri};
            String[] signature = new String[]{"java.lang.String"};
            this.invokeRemoteOperation(this.host, this.iObjName, "undeploy", params, signature);
            return;
        }
        try {
            HashSet uriSet = this.pdc.getAttributeValues("PortalDomain.Portal.ServerInstance", this.path, "DeployedWebApplications");
            this.wcInstance.undeploy(uri);
            if (uriSet.isEmpty()) {
                uriSet = new HashSet();
            }
            uriSet.remove(uri);
            this.pdc.setAttributeValues("PortalDomain.Portal.ServerInstance", this.path, "DeployedWebApplications", uriSet);
        }
        catch (ConfigurationException ce) {
            logger.log(Level.SEVERE, "Undeploy Failed", ce);
            throw new PSMBeanException("admin.error.undeploy.failed", ce.getMessage(), (Throwable)ce, null);
        }
        catch (Exception e) {
            String message = "Error setting instance data";
            logger.log(Level.SEVERE, message, e);
            throw new PSMBeanException("admin.error.set.resources", e.getMessage(), (Throwable)e, null);
        }
    }

    public void undeployAll() throws PSMBeanException {
        if (!this.isLocal.booleanValue()) {
            this.invokeRemoteOperation(this.host, this.iObjName, "undeployAll", null, null);
            return;
        }
        try {
            Iterator uriValues = this.pdc.getAttributeValues("PortalDomain.Portal.ServerInstance", this.path, "DeployedWebApplications").iterator();
            while (uriValues.hasNext()) {
                this.undeploy((String)uriValues.next());
            }
        }
        catch (PSMBeanException ce) {
            logger.log(Level.SEVERE, "Undeploy Failed", ce);
            throw new PSMBeanException("admin.error.undeploy.failed", ce.getMessage(), (Throwable)ce, null);
        }
        catch (Exception e) {
            String message = "Error setting instance data";
            logger.log(Level.SEVERE, message, e);
            throw new PSMBeanException("admin.error.set.resources", e.getMessage(), (Throwable)e, null);
        }
    }

    public Boolean configureContainer(String confDir, String instanceID) throws PSMBeanException {
        boolean ret = true;
        try {
            ArrayList portalPath = new ArrayList();
            int iSize = this.path != null ? this.path.size() : 0;
            for (int i = iSize - 2; i < iSize; ++i) {
                portalPath.add(this.path.get(i));
            }
            String swcConfigDataR = null;
            try {
                logger.log(Level.INFO, "Type=PortalDomain.Portal");
                logger.log(Level.INFO, "List=" + portalPath);
                swcConfigDataR = this.pdc.getAttributeValue("PortalDomain.Portal", portalPath, "WebContainerConfigData");
            }
            catch (PortalDomainContextException pde) {
                swcConfigDataR = null;
            }
            String swcConfigDataFile = this.cc.getPSDataDir() + fs + "portals" + fs + this.getPortal() + fs + "config" + fs + "WebContainerConfigData.xml";
            File fwcConfigData = new File(swcConfigDataFile);
            if (fwcConfigData.exists()) {
                fwcConfigData.delete();
            }
            logger.log(Level.INFO, "PSFB_CSPFM1020", new String[]{"Configure Portal Apps", swcConfigDataR == null ? "" : swcConfigDataR});
            if (swcConfigDataR != null && swcConfigDataR.trim().length() > 0) {
                FileWriter fw = new FileWriter(fwcConfigData);
                fw.write(swcConfigDataR);
                fw.close();
            }
            ret = this.wcInstance.configureApp(confDir, this.cc, this.getPortal());
            String swcConfigDataW = null;
            try {
                XMLJdomUtil xmlJdomUtil = new XMLJdomUtil();
                xmlJdomUtil.readXMLFileLessSchemaValidation(swcConfigDataFile);
                swcConfigDataW = xmlJdomUtil.getXMLJdomDocumentAsString();
            }
            catch (XMLJdomFileCreationException e0) {
                logger.log(Level.SEVERE, e0.getMessage());
                swcConfigDataW = null;
            }
            if (swcConfigDataW == null || swcConfigDataW.trim().length() <= 0) {
                String msg = "Internal Error:Configuration data to be stored in PAS is missing. Please report the problem to your system administrator.";
                XMLJdomFileCreationException e1 = new XMLJdomFileCreationException(msg);
                logger.log(Level.SEVERE, msg, e1);
                throw new PSMBeanException("admin.error.configure.instance", msg, (Throwable)e1, new Object[]{instanceID});
            }
            logger.log(Level.INFO, "PSFB_CSPFM1021", new String[]{"Configure Portal Apps", swcConfigDataW == null ? "" : swcConfigDataW});
            this.pdc.setAttributeValue("PortalDomain.Portal", portalPath, "WebContainerConfigData", swcConfigDataW);
        }
        catch (PortalDomainContextException pde0) {
            logger.log(Level.SEVERE, "Failed to store/retrieve Web Container Config data to PAS", pde0);
            throw new PSMBeanException("admin.error.configure.instance", pde0.getMessage(), (Throwable)pde0, new Object[]{instanceID});
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Configure Failed", ioe);
            throw new PSMBeanException("admin.error.configure.instance", ioe.getMessage(), (Throwable)ioe, new Object[]{instanceID});
        }
        catch (ConfigurationException ex) {
            ret = false;
            String message = "Error configuring instance container with:" + confDir;
            logger.log(Level.SEVERE, message, ex);
        }
        return new Boolean(ret);
    }

    public String getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public Boolean isLocal() {
        return this.isLocal;
    }

    public void restart() throws PSMBeanException {
        try {
            logger.log(Level.SEVERE, "Invoking Stop Operation");
            this.stop();
            logger.log(Level.SEVERE, "Completed Stop Operation Successfully");
        }
        catch (Exception ce) {
            logger.log(Level.SEVERE, "Stop Operation Failed", ce);
            throw new PSMBeanException("admin.error.stop.instance", ce.getMessage(), (Throwable)ce, new Object[]{this.getID()});
        }
        try {
            logger.log(Level.SEVERE, "Invoking Start Operation");
            this.start();
            logger.log(Level.SEVERE, "Completed Start Operation Successfully");
        }
        catch (Exception ce) {
            logger.log(Level.SEVERE, "Start Operation Failed", ce);
            throw new PSMBeanException("admin.error.start.instance", ce.getMessage(), (Throwable)ce, new Object[]{this.getID()});
        }
    }

    public void start() throws PSMBeanException {
        if (!this.isLocal.booleanValue()) {
            this.invokeRemoteOperation(this.host, this.iObjName, "start", null, null);
            return;
        }
        try {
            this.wcInstance.start();
        }
        catch (ConfigurationException ce) {
            logger.log(Level.SEVERE, "Start Operation Failed", ce);
            throw new PSMBeanException("admin.error.start.instance", ce.getMessage(), (Throwable)ce, new Object[]{this.getID()});
        }
    }

    public void stop() throws PSMBeanException {
        if (!this.isLocal.booleanValue()) {
            this.invokeRemoteOperation(this.host, this.iObjName, "stop", null, null);
            return;
        }
        try {
            this.wcInstance.stop();
        }
        catch (ConfigurationException ce) {
            logger.log(Level.SEVERE, "Stop Operation Failed", ce);
            throw new PSMBeanException("admin.error.stop.instance", ce.getMessage(), (Throwable)ce, new Object[]{this.getID()});
        }
    }

    public String getMBeanServerConnectionInfo() throws PSMBeanException {
        try {
            String encrypted = this.pdc.getAttributeValue("PortalDomain.Portal.ServerInstance", this.path, "MBeanServerConnectionInfo");
            return AdminServerUtil.decrypt((String)encrypted);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Can't read connection info: ", e);
            throw new PSMBeanException("admin.error.get.connection.info", e.getMessage(), (Throwable)e, new Object[]{this.getID()});
        }
    }

    public void setMBeanServerConnectionInfo(String connectionInfo) throws PSMBeanException {
        try {
            String encrypted = AdminServerUtil.encrypt((String)connectionInfo);
            this.pdc.setAttributeValue("PortalDomain.Portal.ServerInstance", this.path, "MBeanServerConnectionInfo", encrypted);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Can't write connection info: ", e);
            throw new PSMBeanException("admin.error.set.connection.info", e.getMessage(), (Throwable)e, new Object[]{this.getID()});
        }
    }

    private void setWCInstance() throws PSMBeanException {
        HashMap<String, String> wcInfoMap = new HashMap<String, String>(6);
        for (int i = 0; i < WebContainer.wcAttrKeys.length; ++i) {
            String attrVal = "";
            String attrKey = WebContainer.wcAttrKeys[i];
            try {
                attrVal = this.pdc.getAttributeValue("PortalDomain.Portal.ServerInstance", this.path, attrKey);
            }
            catch (PortalDomainContextException pde) {
                // empty catch block
            }
            if (attrVal == null || attrVal.length() <= 0) continue;
            wcInfoMap.put(attrKey, attrVal);
        }
        try {
            this.wcInstance = WebContainerFactory.getWebContainer(wcInfoMap, logger, false);
        }
        catch (ConfigurationException ce) {
            this.wcInstance = null;
            throw new PSMBeanException("admin.error.create.wcinstance", ce.getMessage(), (Throwable)ce);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

