/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.mbeans;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.server.mbeans.PSResource;
import com.sun.portal.fabric.mbeans.DateExceededException;
import com.sun.portal.fabric.mbeans.LoggerComparator;
import com.sun.portal.fabric.mbeans.PortalFilenameFilter;
import com.sun.portal.fabric.mbeans.PortalLogConfiguratorMBean;
import com.sun.portal.fabric.mbeans.PortalLoggerFilenameFilter;
import com.sun.portal.fabric.mbeans.SearchLoggerFilenameFilter;
import com.sun.portal.log.common.EnhancedProperties;
import com.sun.portal.log.common.LoggerDetails;
import com.sun.portal.log.common.LoggersList;
import com.sun.portal.log.common.PortalLogFormatter;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.log.monitor.FileMonitor;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;

public class PortalLogConfigurator
extends PSResource
implements PortalLogConfiguratorMBean {
    private Properties defaultProperties = new Properties();
    public static final String PORTALS_DIR = "portals";
    public static final String CONFIG_DIR = "config";
    public static final String SEARCHSERVERS_DIR = "searchservers";
    public static final String DEFAULT_HANDLER = "java.util.logging.FileHandler";
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$mbeans$PortalLogConfigurator == null ? (class$com$sun$portal$fabric$mbeans$PortalLogConfigurator = PortalLogConfigurator.class$("com.sun.portal.fabric.mbeans.PortalLogConfigurator")) : class$com$sun$portal$fabric$mbeans$PortalLogConfigurator));
    private static String LEVEL_UI = "level";
    private static String HANDLER_UI = "handler";
    private static String PATTERN_UI = "pattern";
    private static String LIMIT_UI = "limit";
    private static String COUNT_UI = "count";
    private static String APPEND_UI = "append";
    private static String FILTER_UI = "filter";
    private static String FORMATTER_UI = "formatter";
    private static String USE_SERVER_LOG_UI = "useServerLog";
    private static String PARENT_LEVEL = "ParentLevel";
    private static final String LOGGER_NAME_UI = "logger";
    private static final String SEPARATE_FILE_UI = "separateFile";
    private static final String USE_PARENT_UI = "useParent";
    private static final String STACKTRACE_UI = "stacktrace";
    private static final String LOGFILES_UI = "logfiles";
    public static final String LOGFILES_DIR_UI = "logfilesDir";
    public static final String LOGRECORDS_UI = "logrecords";
    private static final String INCLUDE_MORE_SEVERE_UI = "includeMoreSevere";
    private static final String SELECTED_MOST_RECENT_UI = "selectedMostRecent";
    private static final String SELECTED_SPECIFIC_RANGE_FROM_DATE_UI = "specificRangeFromDate";
    private static final String SELECTED_SPECIFIC_RANGE_TO_DATE_UI = "specificRangeToDate";
    private static final String SELECTED_SPECIFIC_RANGE_FROM_TIME_UI = "specificRangeFromTime";
    private static final String SELECTED_SPECIFIC_RANGE_TO_TIME_UI = "specificRangeToTime";
    private static final String SELECTED_LOG_FILE_NAME = "logFileName";
    private static final String TOTAL_LOG_RECORDS_FOR_MOST_RECENT = "totalLogRecords";
    private static final String INPUT_DATE_FORMAT = "MM/dd/yyyy";
    private static final String INPUT_TIME_FORMAT = "HH:mm:ss.SSS";
    private static final SimpleDateFormat logDateFormatter = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat logDateTimeFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final SimpleDateFormat inputDateFormatter = new SimpleDateFormat("MM/dd/yyyy");
    public static final String INPUT_DATE_TIME_FORMAT = "MM/dd/yyyy'T'HH:mm:ss.SSS";
    private static final SimpleDateFormat inputDateTimeFormatter = new SimpleDateFormat("MM/dd/yyyy'T'HH:mm:ss.SSS");
    static /* synthetic */ Class class$com$sun$portal$fabric$mbeans$PortalLogConfigurator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(PSConfigContext cc, PortalDomainContext pdc, List path) {
        super.init(cc, pdc, path);
        InputStream defaultConfigBundle = null;
        defaultConfigBundle = this.getClass().getClassLoader().getResourceAsStream("PSLogConfigDefault.properties");
        this.defaultProperties.load(defaultConfigBundle);
        Object var7_5 = null;
        if (defaultConfigBundle == null) return;
        try {
            defaultConfigBundle.close();
            return;
        }
        catch (IOException e2) {}
        return;
        {
            catch (Exception e) {
                Object var7_6 = null;
                if (defaultConfigBundle == null) return;
                try {
                    defaultConfigBundle.close();
                    return;
                }
                catch (IOException e2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (defaultConfigBundle == null) throw throwable;
            try {
                defaultConfigBundle.close();
                throw throwable;
            }
            catch (IOException e2) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public Vector listPSLoggers(String componentName, String componentID, String instance, Boolean detail) throws Exception {
        logger.log(Level.FINEST, "PSFB_CSPFM1009", new Object[]{componentName, componentID, instance});
        PortalLogConfigurator.validateComponent(componentName);
        String logConfigFileName = this.getLogConfigFileName(componentName, componentID, instance);
        String loggerListFileName = this.getLoggerListFileName(componentName, logConfigFileName, instance);
        Vector loggerDetails = this.getLoggersDetails(componentName, logConfigFileName, loggerListFileName, detail);
        return loggerDetails;
    }

    private String getLoggerListFileName(String componentName, String logConfigFileName, String instance) {
        String loggerListFileName = LoggersList.getListLoggerFile((String)componentName, (String)logConfigFileName, (String)instance);
        logger.log(Level.FINE, "PSFB_CSPFM1006", loggerListFileName);
        return loggerListFileName;
    }

    private Vector getLoggersDetails(String componentName, String logConfigFileName, String loggerListFileName, Boolean detail) throws Exception {
        Vector loggerDetails = new Vector();
        if (detail.booleanValue()) {
            Vector loggerList = this.getLoggerList(loggerListFileName);
            Map loggerDetailsMap = this.getLoggerDetails(componentName, logConfigFileName, loggerList);
            loggerDetails = this.getFormattedLoggerDetails(loggerList, loggerDetailsMap);
        } else {
            Vector loggerList = this.getLoggerList(loggerListFileName);
            Set sortedLoggerList = Collections.synchronizedSet(new TreeSet());
            sortedLoggerList.addAll(loggerList);
            loggerDetails.addAll(sortedLoggerList);
        }
        return loggerDetails;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Vector getLoggerList(String loggersListFileName) throws Exception {
        Vector<Object> vector2;
        Vector vector = new Vector();
        InputStream is = null;
        try {
            try {
                Properties props = new Properties();
                is = new FileInputStream(new File(loggersListFileName));
                props.load(is);
                props.keys();
                vector2 = new Vector<Object>(props.keySet());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "PSFB_CSPFM1008", e);
                throw new Exception("Invalid componentId or instance");
            }
            Object var6_7 = null;
            if (is == null) return vector2;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        is.close();
        return vector2;
    }

    private LoggerDetails getLoggerDetails(String componentName, String loggerName, EnhancedProperties props) {
        LoggerDetails details = new LoggerDetails();
        details.setLoggerName(loggerName);
        details.setLevel(this.getLevel(loggerName, props));
        details.setLogToParent(this.getLogToParent(loggerName, props));
        details.setStackTraceValue(this.getStackTraceValue(loggerName, props));
        details.setHandlers(this.getHandlers(componentName, loggerName, props));
        details.setPattern(this.getPattern(componentName, loggerName, props));
        return details;
    }

    private Vector getChildLoggers(String loggerName, Vector loggerNames) {
        String loggerNamespace = loggerName + ".";
        int numberOfLoggers = loggerNames.size();
        Vector<String> childLoggers = new Vector<String>();
        for (int i = 0; i < numberOfLoggers; ++i) {
            String childLoggerName = (String)loggerNames.get(i);
            if (!childLoggerName.equals(loggerName) && !childLoggerName.startsWith(loggerNamespace)) continue;
            childLoggers.add(childLoggerName);
        }
        return childLoggers;
    }

    private Set getSortedChildLoggers(Vector childLoggers) {
        Set sortedChildLoggers = Collections.synchronizedSet(new TreeSet());
        sortedChildLoggers.addAll(childLoggers);
        return sortedChildLoggers;
    }

    private String format(LoggerDetails loggerDetails, boolean fileInfo) {
        return loggerDetails.format(fileInfo, false);
    }

    private Vector getFormattedLoggerDetails(Vector loggerNames, Map loggerDetailsMap) {
        String loggerName;
        Vector<String> loggerDetails = new Vector<String>();
        TreeSet<String> loggersWithSeparateFile = new TreeSet<String>(new LoggerComparator());
        int numberOfLoggers = loggerNames.size();
        for (int i = 0; i < numberOfLoggers; ++i) {
            loggerName = (String)loggerNames.get(i);
            if (loggerName.equals("debug.com.sun.portal") || ((LoggerDetails)loggerDetailsMap.get(loggerName)).getPattern() == null) continue;
            loggersWithSeparateFile.add(loggerName);
        }
        Map<String, Set> childLoggersMap = Collections.synchronizedMap(new TreeMap());
        Iterator<Object> itr = loggersWithSeparateFile.iterator();
        while (itr.hasNext()) {
            loggerName = (String)itr.next();
            Vector childLoggers = this.getChildLoggers(loggerName, loggerNames);
            childLoggersMap.put(loggerName, this.getSortedChildLoggers(childLoggers));
            loggerNames.removeAll(childLoggers);
        }
        Vector childLoggers = this.getChildLoggers("debug.com.sun.portal", loggerNames);
        childLoggersMap.put("debug.com.sun.portal", this.getSortedChildLoggers(childLoggers));
        Set mappings = childLoggersMap.entrySet();
        itr = mappings.iterator();
        while (itr.hasNext()) {
            Map.Entry mapEntry = (Map.Entry)itr.next();
            Set sortedChildLoggers = (Set)mapEntry.getValue();
            Iterator childItr = sortedChildLoggers.iterator();
            while (childItr.hasNext()) {
                String childLoggerName = (String)childItr.next();
                loggerDetails.add(this.format((LoggerDetails)loggerDetailsMap.get(childLoggerName), true));
            }
        }
        return loggerDetails;
    }

    private String getPattern(String componentName, String loggerName, EnhancedProperties props) {
        StringBuffer loggerPatternBuff = new StringBuffer();
        loggerPatternBuff.append(loggerName).append(".handler").append(".");
        String handlerName = "search".equals(componentName) ? (String)props.get((Object)"debug.com.sun.portal.search.handler") : (String)props.get((Object)"debug.com.sun.portal.handler");
        loggerPatternBuff.append(handlerName).append(".pattern");
        if (props.containsKey((Object)loggerPatternBuff.toString())) {
            return (String)props.get((Object)loggerPatternBuff.toString());
        }
        if (props.containsKey((Object)(loggerName + ".separatefile"))) {
            return this.getLoggerProperty((Properties)props, loggerName, ".handler.java.util.logging.FileHandler.pattern");
        }
        return null;
    }

    private String[] getHandlers(String componentName, String loggerName, EnhancedProperties props) {
        Vector<String> handlers = new Vector<String>();
        handlers.add(this.getLoggerProperty((Properties)props, loggerName, ".handler"));
        if (props.containsKey((Object)(loggerName + ".separatefile")) && handlers.size() == 0) {
            handlers.add(this.getLoggerProperty((Properties)props, loggerName, ".handler"));
        }
        String[] handlersA = new String[handlers.size()];
        this.convert(handlers, handlersA);
        return handlersA;
    }

    private void convert(Vector v, String[] sa) {
        for (int i = 0; i < v.size(); ++i) {
            sa[i] = (String)v.get(i);
        }
    }

    private String getStackTraceValue(String loggerName, EnhancedProperties props) {
        if (props.containsKey((Object)(loggerName + ".stacktrace"))) {
            return (String)props.get((Object)(loggerName + ".stacktrace"));
        }
        return "false";
    }

    private String getLogToParent(String loggerName, EnhancedProperties props) {
        if (props.containsKey((Object)(loggerName + ".useparenthandler"))) {
            return (String)props.get((Object)(loggerName + ".useparenthandler"));
        }
        if ("debug.com.sun.portal".equals(loggerName)) {
            return "false";
        }
        return "true";
    }

    private String getLevel(String loggerName, EnhancedProperties props) {
        return this.getLoggerProperty((Properties)props, loggerName, ".level");
    }

    private Map getLoggerDetails(String componentName, String logConfigFileName, Vector loggerList) throws IOException {
        Map<String, LoggerDetails> loggerDetailsMap = Collections.synchronizedMap(new HashMap());
        int numberOfLoggers = loggerList.size();
        EnhancedProperties props = this.getProps(logConfigFileName);
        for (int i = 0; i < numberOfLoggers; ++i) {
            String loggerName = (String)loggerList.get(i);
            loggerDetailsMap.put(loggerName, this.getLoggerDetails(componentName, loggerName, props));
        }
        return loggerDetailsMap;
    }

    private String getLogConfigFileName(String componentName, String componentID, String instance) {
        StringBuffer logConfigFileName = new StringBuffer();
        if ("portal".equals(componentName)) {
            logConfigFileName.append(this.cc.getPSDataDir());
            logConfigFileName.append(fs);
            logConfigFileName.append(PORTALS_DIR);
            logConfigFileName.append(fs);
            logConfigFileName.append(componentID);
            logConfigFileName.append(fs);
            logConfigFileName.append(CONFIG_DIR);
            logConfigFileName.append(fs);
            logConfigFileName.append("PSLogConfig.properties");
        } else if ("gateway".equals(componentName) || "nlproxy".equals(componentName) || "rwproxy".equals(componentName)) {
            logConfigFileName.append(this.cc.getPSConfigDir());
            logConfigFileName.append(fs);
            logConfigFileName.append("platform.conf.");
            logConfigFileName.append(instance);
        } else if ("search".equals(componentName)) {
            logConfigFileName.append(this.cc.getPSDataDir());
            logConfigFileName.append(fs);
            logConfigFileName.append(SEARCHSERVERS_DIR);
            logConfigFileName.append(fs);
            logConfigFileName.append(componentID);
            logConfigFileName.append(fs);
            logConfigFileName.append(CONFIG_DIR);
            logConfigFileName.append(fs);
            logConfigFileName.append("SearchLogConfig.properties");
        } else if ("pas".equals(componentName) || "psconsole".equals(componentName)) {
            logConfigFileName.append(this.cc.getPSConfigDir());
            logConfigFileName.append(fs);
            logConfigFileName.append("PSAdminLogConfig.properties");
        } else {
            logConfigFileName.append(this.cc.getPSConfigDir());
            logConfigFileName.append(fs);
            logConfigFileName.append("PSLogConfig.properties");
        }
        logger.log(Level.FINE, "PSFB_CSPFM1007", logConfigFileName);
        return logConfigFileName.toString();
    }

    public void setLevel(String componentName, String componentID, String instance, String loggerName, String level) throws Exception {
        logger.log(Level.INFO, "PSFB_CSPFM1010", new Object[]{componentName, componentID, instance, loggerName, level});
        this.validateInput(componentName, componentID, instance, loggerName, level);
        EnhancedProperties props = this.getProps(componentName, componentID, instance);
        this.checkConfigurationAllowed(props);
        props.put((Object)(loggerName + ".level"), (Object)level);
        String logConfigFileName = this.getLogConfigFileName(componentName, componentID, instance);
        this.store(props, logConfigFileName);
    }

    private void validateLoggerName(String loggerListFilename, String loggerName) throws Exception {
        if (!loggerName.startsWith("debug.com.sun.portal")) {
            throw new Exception("invalid logger");
        }
        Vector loggerList = this.getLoggerList(loggerListFilename);
        if (!loggerList.contains(loggerName)) {
            throw new Exception("Invalid logger specified: " + loggerName);
        }
    }

    private void validateLevel(String level) throws Exception {
        try {
            Level.parse(level);
        }
        catch (Exception e) {
            throw new Exception("Invalid level specified: " + level);
        }
    }

    public static void validateComponent(String componentName) throws Exception {
        if (!("portal".equals(componentName) || "gateway".equals(componentName) || "nlproxy".equals(componentName) || "rwproxy".equals(componentName) || "search".equals(componentName) || "pas".equals(componentName) || "psconsole".equals(componentName))) {
            StringBuffer validComponentList = new StringBuffer(" Valid component names are ");
            validComponentList.append("portal");
            validComponentList.append(" ");
            validComponentList.append("search");
            validComponentList.append(" ");
            validComponentList.append("pas");
            validComponentList.append(" ");
            validComponentList.append("psconsole");
            validComponentList.append(" ");
            validComponentList.append("gateway");
            validComponentList.append(" ");
            validComponentList.append("nlproxy");
            validComponentList.append(" ");
            validComponentList.append("rwproxy");
            throw new Exception("Invalid component specified: " + componentName + validComponentList);
        }
    }

    private void validateInput(String componentName, String componentID, String instance, String loggerName, String level) throws Exception {
        this.validateInput(componentName, componentID, instance, loggerName);
        this.validateLevel(level);
    }

    private void validateInput(String componentName, String componentID, String instance, String loggerName) throws Exception {
        String logConfigFileName = this.getLogConfigFileName(componentName, componentID, instance);
        String loggerListFilename = this.getLoggerListFileName(componentName, logConfigFileName, instance);
        PortalLogConfigurator.validateComponent(componentName);
        this.validateLoggerName(loggerListFilename, loggerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(EnhancedProperties props, String logConfigFileName) throws IOException {
        FileOutputStream oStream = null;
        FileOutputStream monitoredFileStream = null;
        try {
            oStream = new FileOutputStream(new File(logConfigFileName));
            props.store((OutputStream)oStream, null);
            monitoredFileStream = new FileOutputStream(FileMonitor.getMonitoredConfigFile((String)logConfigFileName));
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                if (oStream != null) {
                    oStream.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (monitoredFileStream != null) {
                    monitoredFileStream.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (oStream != null) {
                oStream.close();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (monitoredFileStream != null) {
                monitoredFileStream.close();
            }
        }
        catch (Exception e) {}
    }

    private boolean userServerLogs(EnhancedProperties props) {
        return props.containsKey((Object)"debug.com.sun.portal.setserverlogs") && "true".equals(props.get((Object)"debug.com.sun.portal.setserverlogs"));
    }

    private String getParent(String loggerName) {
        int lastIndex = loggerName.lastIndexOf(".");
        if (lastIndex == -1) {
            return "debug.com.sun.portal";
        }
        return loggerName.substring(0, lastIndex);
    }

    private String getLoggerProperty(Properties props, String loggerName, String attribute) {
        String value = props.getProperty(loggerName + attribute);
        while (value == null && !loggerName.equals("debug.com.sun.portal")) {
            loggerName = this.getParent(loggerName);
            value = props.getProperty(loggerName + attribute);
        }
        return value;
    }

    public String getLevel(String loggerName, String componentName, String componentID, String instance) throws Exception {
        this.validateInput(componentName, componentID, instance, loggerName);
        return this.getLoggerProperty((Properties)this.getProps(componentName, componentID, instance), loggerName, ".level");
    }

    public void setSeparateLogFile(String componentName, String componentID, String instance, String loggerName, String level, Boolean printStackTrace, Boolean logInParent) throws Exception {
        logger.log(Level.INFO, "PSFB_CSPFM1011", new Object[]{componentName, componentID, instance, loggerName, level, printStackTrace, logInParent});
        if ("debug.com.sun.portal".equals(loggerName)) {
            return;
        }
        this.validateInput(componentName, componentID, instance, loggerName, level);
        if (printStackTrace.booleanValue() && logInParent.booleanValue()) {
            logger.severe("PSALI_CSPACCL0002");
            throw new Exception("Both printStackTrace and logInParent cannot be true");
        }
        EnhancedProperties props = this.getProps(componentName, componentID, instance);
        this.checkConfigurationAllowed(props);
        props.put((Object)(loggerName + ".level"), (Object)level);
        props.put((Object)(loggerName + ".separatefile"), (Object)"true");
        props.put((Object)(loggerName + ".useparenthandler"), (Object)logInParent.toString());
        props.put((Object)(loggerName + ".stacktrace"), (Object)printStackTrace.toString());
        String logConfigFileName = this.getLogConfigFileName(componentName, componentID, instance);
        this.store(props, logConfigFileName);
    }

    public void reset(String componentName, String componentID, String instance, String loggerName) throws Exception {
        logger.log(Level.INFO, "PSFB_CSPFM1012", new Object[]{componentName, componentID, instance, loggerName});
        if ("debug.com.sun.portal".equals(loggerName)) {
            return;
        }
        this.validateInput(componentName, componentID, instance, loggerName);
        EnhancedProperties props = this.getProps(componentName, componentID, instance);
        this.checkConfigurationAllowed(props);
        if (!props.containsKey((Object)(loggerName + ".separatefile"))) {
            throw new Exception("The specified logger " + loggerName + " does not have a Handler attached to it.");
        }
        props.remove((Object)(loggerName + ".level"));
        props.remove((Object)(loggerName + ".separatefile"));
        props.remove((Object)(loggerName + ".useparenthandler"));
        props.remove((Object)(loggerName + ".stacktrace"));
        String logConfigFileName = this.getLogConfigFileName(componentName, componentID, instance);
        this.store(props, logConfigFileName);
    }

    private EnhancedProperties getProps(String componentName, String componentID, String instance) throws IOException {
        String logConfigFileName = this.getLogConfigFileName(componentName, componentID, instance);
        return this.getProps(logConfigFileName);
    }

    private EnhancedProperties getProps(String logConfigFileName) throws IOException {
        EnhancedProperties props = new EnhancedProperties(this.defaultProperties);
        this.load(props, logConfigFileName);
        return props;
    }

    private void load(EnhancedProperties props, String logConfigFileName) throws IOException {
        BufferedInputStream iStream = new BufferedInputStream(new FileInputStream(new File(logConfigFileName)));
        props.load((InputStream)iStream);
        iStream.close();
    }

    private void checkConfigurationAllowed(EnhancedProperties props) throws Exception {
        if (this.userServerLogs(props)) {
            throw new Exception("Portal logs are routed to server log file. So no log configuration is applied.");
        }
    }

    public Hashtable getCommonLogDetails(String componentName, String componentID, String instance) throws Exception {
        logger.log(Level.INFO, "PSFB_CSPFM1013", new Object[]{componentName, componentID, instance});
        String loggerName = this.getLoggerName(componentName);
        this.validateInput(componentName, componentID, instance, loggerName);
        Hashtable<String, String> values = new Hashtable<String, String>();
        EnhancedProperties props = this.getProps(componentName, componentID, instance);
        values.put(LEVEL_UI, this.getLoggerProperty((Properties)props, loggerName, ".level"));
        values.put(HANDLER_UI, this.getLoggerProperty((Properties)props, loggerName, ".handler"));
        values.put(PATTERN_UI, this.getLoggerProperty((Properties)props, loggerName, ".handler.java.util.logging.FileHandler.pattern"));
        values.put(LIMIT_UI, this.getLoggerProperty((Properties)props, loggerName, ".handler.java.util.logging.FileHandler.limit"));
        values.put(COUNT_UI, this.getLoggerProperty((Properties)props, loggerName, ".handler.java.util.logging.FileHandler.count"));
        values.put(APPEND_UI, this.getLoggerProperty((Properties)props, loggerName, ".handler.java.util.logging.FileHandler.append"));
        values.put(FILTER_UI, this.getLoggerProperty((Properties)props, loggerName, ".handler.java.util.logging.FileHandler.filter"));
        values.put(FORMATTER_UI, this.getLoggerProperty((Properties)props, loggerName, ".handler.java.util.logging.FileHandler.formatter"));
        values.put(USE_SERVER_LOG_UI, "" + (props.containsKey((Object)"debug.com.sun.portal.setserverlogs") && "true".equals(props.get((Object)"debug.com.sun.portal.setserverlogs"))));
        return values;
    }

    private String getLoggerName(String componentName) {
        if ("search".equals(componentName)) {
            return "debug.com.sun.portal.search";
        }
        return "debug.com.sun.portal";
    }

    public void setCommonLogDetails(String componentName, String componentID, String instance, Hashtable values) throws Exception {
        logger.log(Level.INFO, "PSFB_CSPFM1001", new Object[]{componentName, componentID, instance, values});
        String loggerName = this.getLoggerName(componentName);
        this.validateInput(componentName, componentID, instance, loggerName);
        EnhancedProperties props = this.getProps(componentName, componentID, instance);
        Object val = values.get(LEVEL_UI);
        if (val != null) {
            props.setProperty(loggerName + ".level", (String)val);
        }
        if ((val = values.get(HANDLER_UI)) != null) {
            props.setProperty(loggerName + ".handler", (String)val);
        }
        if ((val = values.get(LIMIT_UI)) != null) {
            props.setProperty(loggerName + ".handler" + "." + DEFAULT_HANDLER + ".limit", (String)val);
        }
        if ((val = values.get(COUNT_UI)) != null) {
            props.setProperty(loggerName + ".handler" + "." + DEFAULT_HANDLER + ".count", (String)val);
        }
        if ((val = values.get(APPEND_UI)) != null) {
            props.setProperty(loggerName + ".handler" + "." + DEFAULT_HANDLER + ".append", (String)val);
        }
        if ((val = values.get(FILTER_UI)) != null) {
            props.setProperty(loggerName + ".handler" + "." + DEFAULT_HANDLER + ".filter", (String)val);
        }
        if ((val = values.get(USE_SERVER_LOG_UI)) != null) {
            props.setProperty(loggerName + ".setserverlogs", (String)val);
        }
        this.store(props, this.getLogConfigFileName(componentName, componentID, instance));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getLoggersListProps(String componentName, String componentID, String instance) throws IOException {
        Properties loggersListProps = new Properties();
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.getLoggerListFileName(componentName, this.getLogConfigFileName(componentName, componentID, instance), instance));
            loggersListProps.load(is);
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return loggersListProps;
    }

    public List getSpecificLogDetails(String componentName, String componentID, String instance) throws Exception {
        logger.log(Level.INFO, "PSFB_CSPFM1014", new Object[]{componentName, componentID, instance});
        PortalLogConfigurator.validateComponent(componentName);
        Properties loggersListProps = this.getLoggersListProps(componentName, componentID, instance);
        Iterator<Object> loggersSetIt = new TreeSet<Object>(loggersListProps.keySet()).iterator();
        EnhancedProperties props = this.getProps(componentName, componentID, instance);
        LinkedList loggersDetails = new LinkedList();
        while (loggersSetIt.hasNext()) {
            String logger = (String)loggersSetIt.next();
            Hashtable<String, Object> specificLoggerDetails = new Hashtable<String, Object>();
            specificLoggerDetails.put(LOGGER_NAME_UI, logger);
            if (props.containsKey((Object)(logger + ".level"))) {
                specificLoggerDetails.put(LEVEL_UI, props.get((Object)(logger + ".level")));
            }
            if (props.containsKey((Object)(logger + ".separatefile"))) {
                specificLoggerDetails.put(SEPARATE_FILE_UI, props.get((Object)(logger + ".separatefile")));
            }
            if (props.containsKey((Object)(logger + ".useparenthandler"))) {
                specificLoggerDetails.put(USE_PARENT_UI, props.get((Object)(logger + ".useparenthandler")));
            }
            if (props.containsKey((Object)(logger + ".stacktrace"))) {
                specificLoggerDetails.put(STACKTRACE_UI, props.get((Object)(logger + ".stacktrace")));
            }
            if (logger.equals("debug.com.sun.portal")) {
                if (props.containsKey((Object)"debug.com.sun.portal.setserverlogs") && props.get((Object)"debug.com.sun.portal.setserverlogs").equals("true")) {
                    specificLoggerDetails.put(SEPARATE_FILE_UI, "false");
                    specificLoggerDetails.put(USE_PARENT_UI, "true");
                } else {
                    specificLoggerDetails.put(SEPARATE_FILE_UI, "true");
                    specificLoggerDetails.put(USE_PARENT_UI, "false");
                }
            }
            if (specificLoggerDetails.containsKey(SEPARATE_FILE_UI) && !specificLoggerDetails.containsKey(USE_PARENT_UI)) {
                specificLoggerDetails.put(USE_PARENT_UI, "false");
            }
            loggersDetails.add(specificLoggerDetails);
        }
        return loggersDetails;
    }

    public void setSpecificLogDetails(String componentName, String componentID, String instance, List loggersDetails) throws Exception {
        logger.log(Level.INFO, "PSFB_CSPFM1002", new Object[]{componentName, componentID, instance, loggersDetails});
        PortalLogConfigurator.validateComponent(componentName);
        EnhancedProperties props = this.getProps(componentName, componentID, instance);
        Object[] loggersDetailsArray = loggersDetails.toArray();
        for (int i = 0; i < loggersDetailsArray.length; ++i) {
            Hashtable loggerDetails = (Hashtable)loggersDetailsArray[i];
            String logger = (String)loggerDetails.get(LOGGER_NAME_UI);
            if (loggerDetails.containsKey(LEVEL_UI)) {
                String levelValue = (String)loggerDetails.get(LEVEL_UI);
                if (PARENT_LEVEL.equals(levelValue) && !"debug.com.sun.portal".equals(logger) && !"debug.com.sun.portal.search".equals(logger)) {
                    props.remove((Object)(logger + ".level"));
                } else {
                    props.put((Object)(logger + ".level"), (Object)levelValue);
                }
            }
            if (!"debug.com.sun.portal".equals(logger)) {
                if (loggerDetails.containsKey(SEPARATE_FILE_UI)) {
                    props.put((Object)(logger + ".separatefile"), (Object)((String)loggerDetails.get(SEPARATE_FILE_UI)));
                }
                if (loggerDetails.containsKey(USE_PARENT_UI)) {
                    props.put((Object)(logger + ".useparenthandler"), (Object)((String)loggerDetails.get(USE_PARENT_UI)));
                }
            }
            if (loggerDetails.containsKey(STACKTRACE_UI)) {
                props.put((Object)(logger + ".stacktrace"), (Object)((String)loggerDetails.get(STACKTRACE_UI)));
            }
            if ("true".equals(props.get((Object)(logger + ".separatefile")))) {
                if (!"true".equals(props.get((Object)(logger + ".useparenthandler"))) || "false".equals(props.get((Object)(logger + ".stacktrace")))) continue;
                props.put((Object)(logger + ".useparenthandler"), (Object)"false");
                continue;
            }
            if (logger.startsWith("debug.com.sun.portal.search") || "debug.com.sun.portal".equals(logger)) continue;
            props.remove((Object)(logger + ".separatefile"));
            props.remove((Object)(logger + ".useparenthandler"));
            props.remove((Object)(logger + ".stacktrace"));
        }
        this.store(props, this.getLogConfigFileName(componentName, componentID, instance));
    }

    public Hashtable getLogFileNames(String componentName, String componentID, String instance) throws Exception {
        logger.log(Level.INFO, "PSFB_CSPFM1015", new Object[]{componentName, componentID, instance});
        String loggerName = this.getLoggerName(componentName);
        this.validateInput(componentName, componentID, instance, loggerName);
        EnhancedProperties props = this.getProps(componentName, componentID, instance);
        Hashtable<String, Object> values = new Hashtable<String, Object>();
        String pattern = this.getLoggerProperty((Properties)props, loggerName, ".handler.java.util.logging.FileHandler.pattern");
        logger.log(Level.FINEST, "PSFB_CSPFM1004", pattern);
        StringBuffer buff = new StringBuffer(pattern);
        int index = buff.indexOf("%instanceID");
        if (index != -1) {
            buff.replace(index, index + "%instanceID".length(), instance);
        }
        index = buff.lastIndexOf(File.separator);
        String logDirValue = buff.substring(0, index);
        File logDir = new File(logDirValue);
        String[] logFileNames = logDir.list(new PortalFilenameFilter());
        if (logger.isLoggable(Level.FINEST)) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < logFileNames.length; ++i) {
                sb.append(logFileNames[i] + ",");
            }
            logger.log(Level.FINEST, "PSFB_CSPFM1016", sb);
        }
        List loggerNamesWithSeparateFileAttribute = this.getLoggerNamesWithSeparateFileAttribute(componentName, props, loggerName);
        List loggerNamesWithSeparateFile = this.getLoggerNamesWithSeparateFile(componentName, loggerNamesWithSeparateFileAttribute, logFileNames);
        values.put(LEVEL_UI, this.getLoggerProperty((Properties)props, loggerName, ".level"));
        values.put(LOGFILES_UI, loggerNamesWithSeparateFile);
        return values;
    }

    private List getLoggerNamesWithSeparateFileAttribute(String componentName, EnhancedProperties props, String rootLoggerName) {
        LinkedList<String> separateFiles = new LinkedList<String>();
        if (!"portal".equals(componentName)) {
            return separateFiles;
        }
        Enumeration e = props.propertyNames();
        while (e.hasMoreElements()) {
            int prefixIndex;
            int index;
            String loggerName;
            String propertyName = (String)e.nextElement();
            if (!propertyName.endsWith(".separatefile") || !props.getProperty(propertyName).equals("true") || !(loggerName = propertyName.substring(0, index = propertyName.indexOf(".separatefile"))).startsWith("debug.com.sun.portal") || loggerName.equals(rootLoggerName) || (prefixIndex = loggerName.indexOf("debug.com.sun.")) == -1) continue;
            separateFiles.add(loggerName.substring(prefixIndex + "debug.com.sun.".length()));
        }
        return separateFiles;
    }

    private List getLoggerNamesWithSeparateFile(String componentName, List loggerNamesWithSeparateFileAttribute, String[] logFileNames) {
        LinkedList<String> loggerNamesWithSeparateFile = new LinkedList<String>(loggerNamesWithSeparateFileAttribute);
        for (int i = 0; i < logFileNames.length; ++i) {
            int index;
            String loggerName;
            if (logFileNames[i].indexOf(componentName) == -1) continue;
            String[] nameValues = logFileNames[i].split("\\.", -1);
            StringBuffer loggerNameBuffer = new StringBuffer();
            for (int j = 0; j < nameValues.length; ++j) {
                try {
                    Integer.parseInt(nameValues[j]);
                    break;
                }
                catch (Exception e) {
                    loggerNameBuffer.append(nameValues[j]);
                    loggerNameBuffer.append(".");
                    continue;
                }
            }
            if (loggerNamesWithSeparateFile.contains(loggerName = loggerNameBuffer.substring(0, index = loggerNameBuffer.lastIndexOf(".")))) continue;
            loggerNamesWithSeparateFile.add(loggerName);
        }
        return loggerNamesWithSeparateFile;
    }

    public Hashtable getLogRecords(String componentName, String componentID, String instance, Hashtable logViewerInputs) throws Exception {
        logger.log(Level.INFO, "PSFB_CSPFM1003", new Object[]{componentName, componentID, instance, logViewerInputs});
        String loggerName = this.getLoggerName(componentName);
        this.validateInput(componentName, componentID, instance, loggerName);
        EnhancedProperties props = this.getProps(componentName, componentID, instance);
        Hashtable<String, Object> values = new Hashtable<String, Object>();
        String selectedLogFileName = (String)logViewerInputs.get(SELECTED_LOG_FILE_NAME);
        logger.log(Level.FINEST, "PSFB_CSPFM1005", selectedLogFileName);
        String selectedLoggerName = "debug.com.sun." + selectedLogFileName;
        String pattern = this.getLoggerProperty((Properties)props, selectedLoggerName, ".handler.java.util.logging.FileHandler.pattern");
        logger.log(Level.FINEST, "PSFB_CSPFM1004", pattern);
        StringBuffer buff = new StringBuffer(pattern);
        int index = buff.indexOf("%instanceID");
        if (index != -1) {
            buff.replace(index, index + "%instanceID".length(), instance);
        }
        index = buff.lastIndexOf(File.separator);
        String logDirValue = buff.substring(0, index);
        File logDir = new File(logDirValue);
        File[] logFiles = logDir.listFiles("search".equals(componentName) ? new SearchLoggerFilenameFilter(selectedLogFileName) : new PortalLoggerFilenameFilter(selectedLogFileName));
        Date fromDateTime = null;
        Date toDateTime = null;
        boolean onlyDate = true;
        Boolean mostRecent = (Boolean)logViewerInputs.get(SELECTED_MOST_RECENT_UI);
        if (!mostRecent.booleanValue()) {
            String fromDateValue = (String)logViewerInputs.get(SELECTED_SPECIFIC_RANGE_FROM_DATE_UI);
            String toDateValue = (String)logViewerInputs.get(SELECTED_SPECIFIC_RANGE_TO_DATE_UI);
            String fromTimeValue = (String)logViewerInputs.get(SELECTED_SPECIFIC_RANGE_FROM_TIME_UI);
            String toTimeValue = (String)logViewerInputs.get(SELECTED_SPECIFIC_RANGE_TO_TIME_UI);
            if (fromTimeValue == null && toTimeValue == null) {
                fromDateTime = inputDateFormatter.parse(fromDateValue);
                toDateTime = inputDateFormatter.parse(toDateValue);
                onlyDate = true;
            } else {
                if (fromTimeValue == null) {
                    fromTimeValue = "00:00:00.000";
                }
                String fromDateTimeValue = fromDateValue + "T" + fromTimeValue;
                String toDateTimeValue = toDateValue + "T" + toTimeValue;
                fromDateTime = inputDateTimeFormatter.parse(fromDateTimeValue);
                toDateTime = inputDateTimeFormatter.parse(toDateTimeValue);
                onlyDate = false;
            }
        }
        String levelValue = (String)logViewerInputs.get(LEVEL_UI);
        Boolean includeMoreSevere = (Boolean)logViewerInputs.get(INCLUDE_MORE_SEVERE_UI);
        Vector relevantFiles = this.getRelevantFiles(selectedLogFileName, logFiles, mostRecent);
        LinkedList<Vector> logRecords = new LinkedList<Vector>();
        logger.log(Level.FINER, "PSFB_CSPFM1017", relevantFiles);
        block2: for (int i = relevantFiles.size() - 1; i >= 0; --i) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream((File)relevantFiles.get(i))));
            boolean recordStart = false;
            boolean recordEnd = false;
            StringBuffer lineBuffer = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                Vector logRecordFields;
                if (line.trim().equals("")) continue;
                if (recordStart && !recordEnd) {
                    lineBuffer.append(PortalLogFormatter.LINE_SEPARATOR);
                }
                lineBuffer.append(line);
                if (line.startsWith("[#|")) {
                    recordStart = true;
                }
                if (recordStart && line.endsWith("|#]")) {
                    recordEnd = true;
                }
                if (!recordEnd) continue;
                try {
                    logRecordFields = PortalLogConfigurator.getLogRecord(lineBuffer.toString(), mostRecent, fromDateTime, toDateTime, onlyDate, levelValue, includeMoreSevere);
                }
                catch (DateExceededException e) {
                    continue block2;
                }
                if (!logRecordFields.isEmpty()) {
                    logRecords.add(logRecordFields);
                }
                recordStart = false;
                recordEnd = false;
                lineBuffer = new StringBuffer();
            }
        }
        values.put(LOGFILES_DIR_UI, logDirValue);
        if (mostRecent.booleanValue()) {
            Integer rowCount = (Integer)logViewerInputs.get(TOTAL_LOG_RECORDS_FOR_MOST_RECENT);
            values.put(LOGRECORDS_UI, this.getLogRecordsForMostRecent(logRecords, rowCount));
        } else {
            values.put(LOGRECORDS_UI, logRecords);
        }
        return values;
    }

    public Hashtable getLoggerDetails(String componentType, String componentID, String instance, String loggerName) throws Exception {
        Hashtable<String, Object> detailsTable = new Hashtable<String, Object>();
        PortalLogConfigurator.validateComponent(componentType);
        EnhancedProperties props = this.getProps(this.getLogConfigFileName(componentType, componentID, instance));
        LoggerDetails details = this.getLoggerDetails(componentType, loggerName, props);
        detailsTable.put(LOGGER_NAME_UI, loggerName);
        detailsTable.put(LEVEL_UI, details.getLevel());
        detailsTable.put(STACKTRACE_UI, details.getStackTraceValue());
        detailsTable.put(USE_PARENT_UI, details.isLogToParent());
        detailsTable.put(SEPARATE_FILE_UI, props.containsKey((Object)(loggerName + ".separatefile")) ? props.get((Object)(loggerName + ".separatefile")) : "false");
        detailsTable.put(PATTERN_UI, this.getLoggerProperty((Properties)props, loggerName, ".handler.java.util.logging.FileHandler.pattern"));
        detailsTable.put(HANDLER_UI, this.getLoggerProperty((Properties)props, loggerName, ".handler"));
        detailsTable.put(LIMIT_UI, this.getLoggerProperty((Properties)props, loggerName, ".handler.java.util.logging.FileHandler.limit"));
        detailsTable.put(COUNT_UI, this.getLoggerProperty((Properties)props, loggerName, ".handler.java.util.logging.FileHandler.count"));
        detailsTable.put(APPEND_UI, this.getLoggerProperty((Properties)props, loggerName, ".handler.java.util.logging.FileHandler.append"));
        detailsTable.put(FILTER_UI, this.getLoggerProperty((Properties)props, loggerName, ".handler.java.util.logging.FileHandler.filter"));
        detailsTable.put(FORMATTER_UI, this.getLoggerProperty((Properties)props, loggerName, ".handler.java.util.logging.FileHandler.formatter"));
        if (props.containsKey((Object)(loggerName + ".handler" + "." + DEFAULT_HANDLER + ".formatter")) || props.containsKey((Object)(loggerName + ".handler" + "." + DEFAULT_HANDLER + ".pattern")) || props.containsKey((Object)(loggerName + ".handler"))) {
            detailsTable.put(SEPARATE_FILE_UI, "true");
        }
        if ((props.containsKey((Object)(loggerName + ".separatefile")) || detailsTable.containsKey(SEPARATE_FILE_UI) && "true".equals((String)detailsTable.get(SEPARATE_FILE_UI))) && !props.containsKey((Object)(loggerName + ".useparenthandler"))) {
            detailsTable.put(USE_PARENT_UI, "false");
        }
        if ("debug.com.sun.portal".equals(loggerName) || "debug.com.sun.portal.search".equals(loggerName)) {
            if (props.containsKey((Object)(loggerName + ".setserverlogs")) && props.get((Object)(loggerName + ".setserverlogs")).equals("true")) {
                detailsTable.put(SEPARATE_FILE_UI, "false");
                detailsTable.put(USE_PARENT_UI, "true");
            } else {
                detailsTable.put(SEPARATE_FILE_UI, "true");
                detailsTable.put(USE_PARENT_UI, "false");
            }
        }
        return detailsTable;
    }

    private List getLogRecordsForMostRecent(List logRecords, int totalLogRecords) {
        LinkedList tempLogRecords = new LinkedList();
        int size = logRecords.size();
        int start = size - totalLogRecords;
        if (start < 0) {
            start = 0;
        }
        for (int i = start; i < size; ++i) {
            tempLogRecords.add(logRecords.get(i));
        }
        return tempLogRecords;
    }

    private Vector getRelevantFiles(String rootLogger, File[] logFiles, boolean mostRecent) {
        Vector<File> relevantFiles = new Vector<File>();
        for (int i = 0; i < logFiles.length; ++i) {
            String logFileName = logFiles[i].getName();
            if (!logFileName.startsWith(rootLogger)) continue;
            if (mostRecent) {
                int gIndex;
                String[] values = logFileName.split("\\.", 0);
                int gValue = Integer.parseInt(values[gIndex = values.length - 2]);
                if (gValue == 0) {
                    relevantFiles.add(logFiles[i]);
                    break;
                }
                logger.log(Level.INFO, "PSFB_CSPFM1018", String.valueOf(gValue));
                continue;
            }
            relevantFiles.add(logFiles[i]);
        }
        return relevantFiles;
    }

    private static Vector getLogRecord(String line, boolean mostRecent, Date fromDateTime, Date toDateTime, boolean onlyDate, String levelValue, boolean includeMoreSevere) throws Exception {
        Vector<Object> logRecordFields = new Vector<Object>();
        int startRecordIndex = line.indexOf("[#|");
        int endRecordIndex = line.indexOf("|#]");
        String logRecordLine = line.substring(startRecordIndex + "[#|".length(), endRecordIndex);
        StringTokenizer tokens = new StringTokenizer(logRecordLine, "|");
        String datetime = tokens.nextToken();
        String logLevel = tokens.nextToken();
        String productId = tokens.nextToken();
        String loggerName = tokens.nextToken();
        String nameValuePairs = tokens.nextToken();
        StringBuffer messageBuffer = new StringBuffer();
        while (tokens.hasMoreTokens()) {
            messageBuffer.append(tokens.nextToken());
        }
        Date logDateTime = logDateTimeFormatter.parse(datetime);
        if (!mostRecent) {
            if (onlyDate) {
                int index = datetime.indexOf(84);
                String dateValue = datetime.substring(0, index);
                Date logDate = logDateFormatter.parse(dateValue);
                if (logDate.compareTo(fromDateTime) < 0) {
                    return logRecordFields;
                }
                if (logDate.compareTo(toDateTime) > 0) {
                    throw new DateExceededException();
                }
            } else {
                if (logDateTime.compareTo(fromDateTime) < 0) {
                    return logRecordFields;
                }
                if (logDateTime.compareTo(toDateTime) > 0) {
                    throw new DateExceededException();
                }
            }
        }
        int inputLevel = Level.parse(levelValue).intValue();
        int currentLevel = Level.parse(logLevel).intValue();
        if (currentLevel >= inputLevel) {
            if (!includeMoreSevere && currentLevel != inputLevel) {
                return logRecordFields;
            }
            logRecordFields.add(logDateTime);
            logRecordFields.add(logLevel);
            logRecordFields.add(loggerName);
            logRecordFields.add(nameValuePairs);
            logRecordFields.add(messageBuffer.toString());
        }
        return logRecordFields;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

