/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.mbeans;

import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.common.util.AdminClientUtil;
import com.sun.portal.admin.common.util.AdminUtil;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.admin.server.PASModule;
import com.sun.portal.admin.server.mbeans.PSResource;
import com.sun.portal.fabric.mbeans.PortalLogConfigHostBridgeMBean;
import com.sun.portal.fabric.mbeans.PortalLogConfigurator;
import com.sun.portal.log.common.PortalLogger;
import java.net.URL;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;

public class PortalLogConfigHostBridge
extends PSResource
implements PortalLogConfigHostBridgeMBean {
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$mbeans$PortalLogConfigHostBridge == null ? (class$com$sun$portal$fabric$mbeans$PortalLogConfigHostBridge = PortalLogConfigHostBridge.class$("com.sun.portal.fabric.mbeans.PortalLogConfigHostBridge")) : class$com$sun$portal$fabric$mbeans$PortalLogConfigHostBridge));
    protected static final String PORTAL_LOG_OBJECT_NAME = "PortalDomain.PortalLogConfigurator";
    static /* synthetic */ Class class$com$sun$portal$fabric$mbeans$PortalLogConfigHostBridge;

    public void init(PSConfigContext cc, PortalDomainContext pdc, List path) {
        super.init(cc, pdc, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getCommonLogDetails(String component, String componentID, String instance) throws Exception {
        Object obj = null;
        MBeanServerConnection serverConnection = null;
        try {
            PortalLogConfigurator.validateComponent(component);
            serverConnection = this.getConnection(component, componentID, instance);
            ObjectName logConfigObjName = this.getLogConfigObjName();
            Object[] params = new Object[]{component, componentID, instance};
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
            obj = serverConnection.invoke(logConfigObjName, "getCommonLogDetails", params, signature);
            this.closeRemoteConnection(serverConnection);
        }
        catch (Throwable throwable) {
            this.closeRemoteConnection(serverConnection);
            throw throwable;
        }
        if (obj == null) {
            return null;
        }
        return (Hashtable)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getSpecificLogDetails(String component, String componentID, String instance) throws Exception {
        Object obj = null;
        MBeanServerConnection serverConnection = null;
        try {
            PortalLogConfigurator.validateComponent(component);
            serverConnection = this.getConnection(component, componentID, instance);
            ObjectName logConfigObjName = this.getLogConfigObjName();
            Object[] params = new Object[]{component, componentID, instance};
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
            obj = serverConnection.invoke(logConfigObjName, "getSpecificLogDetails", params, signature);
            this.closeRemoteConnection(serverConnection);
        }
        catch (Throwable throwable) {
            this.closeRemoteConnection(serverConnection);
            throw throwable;
        }
        if (obj == null) {
            return null;
        }
        return (List)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSpecificLogDetails(String component, String componentID, String instance, List loggersDetails) throws Exception {
        MBeanServerConnection serverConnection = null;
        try {
            PortalLogConfigurator.validateComponent(component);
            serverConnection = this.getConnection(component, componentID, instance);
            ObjectName logConfigObjName = this.getLogConfigObjName();
            Object[] params = new Object[]{component, componentID, instance, loggersDetails};
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.util.List"};
            serverConnection.invoke(logConfigObjName, "setSpecificLogDetails", params, signature);
            this.closeRemoteConnection(serverConnection);
        }
        catch (Throwable throwable) {
            this.closeRemoteConnection(serverConnection);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCommonLogDetails(String component, String componentID, String instance, Hashtable values) throws Exception {
        MBeanServerConnection serverConnection = null;
        try {
            PortalLogConfigurator.validateComponent(component);
            serverConnection = this.getConnection(component, componentID, instance);
            ObjectName logConfigObjName = this.getLogConfigObjName();
            Object[] params = new Object[]{component, componentID, instance, values};
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.util.Hashtable"};
            serverConnection.invoke(logConfigObjName, "setCommonLogDetails", params, signature);
            this.closeRemoteConnection(serverConnection);
        }
        catch (Throwable throwable) {
            this.closeRemoteConnection(serverConnection);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getLogFileNames(String component, String componentID, String instance) throws Exception {
        Object obj = null;
        MBeanServerConnection serverConnection = null;
        try {
            PortalLogConfigurator.validateComponent(component);
            serverConnection = this.getConnection(component, componentID, instance);
            ObjectName logConfigObjName = this.getLogConfigObjName();
            Object[] params = new Object[]{component, componentID, instance};
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
            obj = serverConnection.invoke(logConfigObjName, "getLogFileNames", params, signature);
            this.closeRemoteConnection(serverConnection);
        }
        catch (Throwable throwable) {
            this.closeRemoteConnection(serverConnection);
            throw throwable;
        }
        if (obj == null) {
            return null;
        }
        return (Hashtable)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getLogRecords(String component, String componentID, String instance, Hashtable logViewerInputs) throws Exception {
        Object obj = null;
        MBeanServerConnection serverConnection = null;
        try {
            PortalLogConfigurator.validateComponent(component);
            serverConnection = this.getConnection(component, componentID, instance);
            ObjectName logConfigObjName = this.getLogConfigObjName();
            Object[] params = new Object[]{component, componentID, instance, logViewerInputs};
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.util.Hashtable"};
            obj = serverConnection.invoke(logConfigObjName, "getLogRecords", params, signature);
            this.closeRemoteConnection(serverConnection);
        }
        catch (Throwable throwable) {
            this.closeRemoteConnection(serverConnection);
            throw throwable;
        }
        if (obj == null) {
            return null;
        }
        return (Hashtable)obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable getLoggerDetails(String component, String componentID, String instance, String loggerName) throws Exception {
        Object obj = null;
        MBeanServerConnection serverConnection = null;
        try {
            PortalLogConfigurator.validateComponent(component);
            serverConnection = this.getConnection(component, componentID, instance);
            ObjectName logConfigObjName = this.getLogConfigObjName();
            Object[] params = new Object[]{component, componentID, instance, loggerName};
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.lang.String"};
            obj = serverConnection.invoke(logConfigObjName, "getLoggerDetails", params, signature);
            this.closeRemoteConnection(serverConnection);
        }
        catch (Throwable throwable) {
            this.closeRemoteConnection(serverConnection);
            throw throwable;
        }
        if (obj == null) {
            return null;
        }
        return (Hashtable)obj;
    }

    private ObjectName getLogConfigObjName() throws MalformedObjectNameException {
        LinkedList<String> path = new LinkedList<String>();
        path.addFirst("defaultDomain");
        path.addFirst("portalLogConfigurator");
        return AdminUtil.getResourceMBeanObjectName((String)PORTAL_LOG_OBJECT_NAME, path);
    }

    private void closeRemoteConnection(MBeanServerConnection serverConnection) {
        try {
            if (!serverConnection.equals(PASModule.getMBeanServer())) {
                ((JMXConnector)((Object)serverConnection)).close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private MBeanServerConnection getConnection(String component, String componentID, String instance) throws Exception {
        MBeanServerConnection serverConnection;
        if (this.isRemote(component, componentID, instance)) {
            try {
                JMXConnector connector = AdminServerUtil.getJMXConnector((String)this.getHost(component, componentID, instance));
                serverConnection = connector.getMBeanServerConnection();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "PSFB_CSPFM0006", e);
                throw e;
            }
        } else {
            serverConnection = PASModule.getMBeanServer();
        }
        return serverConnection;
    }

    private String getHost(String component, String componentID, String instance) throws Exception {
        String host = null;
        if ("portal".equals(component)) {
            ObjectName objName = this.getPortalInstanceObjectName(componentID, instance);
            host = (String)PASModule.getMBeanServer().getAttribute(objName, "Host");
        } else if ("gateway".equals(component) || "nlproxy".equals(component) || "rwproxy".equals(component)) {
            host = componentID;
        } else if ("search".equals(component)) {
            ObjectName objName = this.getSearchServerObjectName(componentID);
            Properties p = (Properties)PASModule.getMBeanServer().getAttribute(objName, "Vitals");
            URL searchURL = new URL(p.getProperty("url"));
            host = searchURL.getHost();
        }
        return host;
    }

    private boolean isRemote(String component, String componentID, String instance) throws Exception {
        boolean isRemote = false;
        if ("portal".equals(component)) {
            MBeanServer server = PASModule.getMBeanServer();
            Boolean isLocal = (Boolean)server.invoke(this.getPortalInstanceObjectName(componentID, instance), "isLocal", null, null);
            isRemote = isLocal == false;
        } else if ("gateway".equals(component) || "nlproxy".equals(component) || "rwproxy".equals(component)) {
            isRemote = !AdminUtil.isLocal((String)componentID);
        } else if ("search".equals(component)) {
            isRemote = !AdminUtil.isLocal((String)this.getHost(component, componentID, instance));
        }
        logger.log(Level.FINEST, "PSFB_CSPFM1019", new Object[]{component, componentID, instance, isRemote});
        return isRemote;
    }

    private ObjectName getPortalInstanceObjectName(String componentID, String instance) throws Exception {
        return AdminUtil.getInstanceMBeanObjectName((String)this.m_sPsDomainID, (String)componentID, (String)instance);
    }

    private ObjectName getSearchServerObjectName(String componentID) throws Exception {
        LinkedList<String> path = new LinkedList<String>();
        path.addFirst("defaultDomain");
        path.addFirst(componentID);
        return AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain.SearchServer", path);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

