/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.mbeans;

import com.iplanet.sso.SSOToken;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.common.util.AdminClientUtil;
import com.sun.portal.admin.common.util.AdminUtil;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.admin.server.PASModule;
import com.sun.portal.admin.server.mbeans.PSResource;
import com.sun.portal.fabric.common.AttributeHandler;
import com.sun.portal.fabric.common.AttributeHandlerFactory;
import com.sun.portal.fabric.mbeans.PortalDomainMBean;
import com.sun.portal.fabric.tasks.ConfigurationException;
import com.sun.portal.fabric.tasks.CreateSearchServerThread;
import com.sun.portal.fabric.tasks.Domain;
import com.sun.portal.fabric.tasks.EnableServices;
import com.sun.portal.fabric.tasks.Portal;
import com.sun.portal.fabric.tasks.PortalVersion;
import com.sun.portal.fabric.tasks.SearchSetup;
import com.sun.portal.fabric.tasks.WebContainer;
import com.sun.portal.fabric.tasks.WebContainerFactory;
import com.sun.portal.fabric.util.FileUtil;
import com.sun.portal.log.common.PortalLogger;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;
import sun.misc.BASE64Encoder;

public class PortalDomain
extends PSResource
implements PortalDomainMBean {
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$mbeans$PortalDomain == null ? (class$com$sun$portal$fabric$mbeans$PortalDomain = PortalDomain.class$("com.sun.portal.fabric.mbeans.PortalDomain")) : class$com$sun$portal$fabric$mbeans$PortalDomain));
    private CreateSearchServerThread csst = null;
    static /* synthetic */ Class class$com$sun$portal$fabric$mbeans$PortalDomain;

    public void init(PSConfigContext cc, PortalDomainContext pdc, List path) {
        super.init(cc, pdc, path);
        try {
            if (!this.isResourceAvailable("PortalDomain.AMObjectSearch", "amobjsearch")) {
                pdc.createResource("PortalDomain.AMObjectSearch", path, "amobjsearch", Collections.EMPTY_MAP);
                PASModule.reloadMBeans((PortalDomainContext)pdc, (String)"PortalDomain.AMObjectSearch", (List)path);
            }
        }
        catch (Exception pme) {
            logger.log(Level.SEVERE, "Error creating am object search", pme);
        }
        try {
            if (!this.isResourceAvailable("PortalDomain.Scheduler", "scheduler")) {
                pdc.createResource("PortalDomain.Scheduler", path, "scheduler", Collections.EMPTY_MAP);
                PASModule.reloadMBeans((PortalDomainContext)pdc, (String)"PortalDomain.Scheduler", (List)path);
            }
        }
        catch (Exception pme) {
            logger.log(Level.SEVERE, "Error creating scheduler", pme);
        }
        try {
            if (!this.isResourceAvailable("PortalDomain.PortalLogConfigHostBridge", "portalLogConfigHostBridge")) {
                pdc.createResource("PortalDomain.PortalLogConfigHostBridge", path, "portalLogConfigHostBridge", Collections.EMPTY_MAP);
                PASModule.reloadMBeans((PortalDomainContext)pdc, (String)"PortalDomain.PortalLogConfigHostBridge", (List)path);
            }
        }
        catch (Exception pme) {
            logger.log(Level.SEVERE, "Error creating portalLogConfigHostBridge", pme);
        }
        try {
            if (!this.isResourceAvailable("PortalDomain.PortalLogConfigurator", "portalLogConfigurator")) {
                pdc.createResource("PortalDomain.PortalLogConfigurator", path, "portalLogConfigurator", Collections.EMPTY_MAP);
                PASModule.reloadMBeans((PortalDomainContext)pdc, (String)"PortalDomain.PortalLogConfigurator", (List)path);
            }
        }
        catch (Exception pme) {
            logger.log(Level.SEVERE, "Error creating portalLogConfigurator", pme);
        }
        try {
            if (!this.isResourceAvailable("PortalDomain.Rewriter", "rewriter")) {
                pdc.createResource("PortalDomain.Rewriter", path, "rewriter", Collections.EMPTY_MAP);
                PASModule.reloadMBeans((PortalDomainContext)pdc, (String)"PortalDomain.Rewriter", (List)path);
            }
        }
        catch (Exception pme) {
            logger.log(Level.SEVERE, "Error creating rewriter", pme);
        }
        if (this.isSRAInstalled(cc)) {
            try {
                if (!this.isResourceAvailable("PortalDomain.SRA", "sra")) {
                    pdc.createResource("PortalDomain.SRA", path, "sra", Collections.EMPTY_MAP);
                    PASModule.reloadMBeans((PortalDomainContext)pdc, (String)"PortalDomain.SRA", (List)path);
                }
            }
            catch (Exception pme) {
                logger.log(Level.SEVERE, "Error creating sra", pme);
            }
            try {
                if (!this.isResourceAvailable("PortalDomain.SRAMonitoring", "sramonitoring")) {
                    pdc.createResource("PortalDomain.SRAMonitoring", path, "sramonitoring", Collections.EMPTY_MAP);
                    PASModule.reloadMBeans((PortalDomainContext)pdc, (String)"PortalDomain.SRAMonitoring", (List)path);
                }
            }
            catch (Exception pme) {
                logger.log(Level.SEVERE, "Error creating sramonitoring", pme);
            }
        }
        try {
            if (!this.isResourceAvailable("PortalDomain.UploadDownloadFileManager", "UploadDownloadFileManager")) {
                pdc.createResource("PortalDomain.UploadDownloadFileManager", path, "UploadDownloadFileManager", Collections.EMPTY_MAP);
                PASModule.reloadMBeans((PortalDomainContext)pdc, (String)"PortalDomain.UploadDownloadFileManager", (List)path);
            }
        }
        catch (Exception pme) {
            logger.log(Level.SEVERE, "Error creating UploadDownloadFileManager", pme);
        }
        try {
            if (!this.isResourceAvailable("PortalDomain.SSOAdapter", "ssoadapter")) {
                pdc.createResource("PortalDomain.SSOAdapter", path, "ssoadapter", Collections.EMPTY_MAP);
                PASModule.reloadMBeans((PortalDomainContext)pdc, (String)"PortalDomain.SSOAdapter", (List)path);
            }
        }
        catch (Exception pme) {
            logger.log(Level.SEVERE, "Error creating ssoadapter", pme);
        }
    }

    public void setDomainRepositoryPassword(String password) throws PSMBeanException {
        File domainConfigFile = new File(this.cc.getPSConfigDir() + fs + "domains" + fs + this.getID() + fs + "PortalDomainConfig.properties");
        String pattern = "domain.data.credentials=";
        if (password == null) {
            password = "";
        } else {
            try {
                byte[] passwordBytes = password.getBytes("8859_1");
                password = new BASE64Encoder().encodeBuffer(passwordBytes);
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
        }
        String text = pattern + password;
        if (!FileUtil.replaceLineInFile(domainConfigFile, pattern, text)) {
            String message = "Can't set domain repository password.";
            logger.log(Level.SEVERE, message);
            throw new PSMBeanException("admin.error.setPassword", message);
        }
        logger.log(Level.INFO, "Domain repository password changed to " + password);
    }

    public List getPortals() throws PSMBeanException {
        try {
            return new ArrayList(this.pdc.getResourceIDs("PortalDomain.Portal", this.path));
        }
        catch (Exception e) {
            String message = "Error reading portals in domain " + this.m_sPsID;
            logger.log(Level.SEVERE, message, e);
            throw new PSMBeanException("admin.error.getPortals", e.getMessage(), (Throwable)e, new Object[]{this.m_sPsID});
        }
    }

    public void createPortal(String portalID, String host, String uri) throws PSMBeanException {
        try {
            if (host != null && !AdminUtil.isLocal((String)host)) {
                ObjectName domainObj = AdminUtil.getPortalDomainMBeanObjectName((String)this.getDomainID());
                Object[] params = new Object[]{portalID, host, uri};
                String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String"};
                this.invokeRemoteOperation(host, domainObj, "createPortal", params, signature);
                return;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error creating portal " + portalID, e);
            throw new PSMBeanException("admin.error.create.portal", this.getStackTrace(e), new Object[]{portalID});
        }
        String amAdminPassword = AdminServerUtil.getPassword();
        SSOToken ssoToken = AdminServerUtil.getSSOToken();
        EnableServices es = new EnableServices(this.cc.getPSBaseDir(), this.cc.getPSDataDir(), this.cc.getISBaseDir(), this.cc.getAdminUserDN(), amAdminPassword, logger);
        Portal newPortal = new Portal(this.cc.getPSBaseDir(), this.cc.getPSDataDir(), this.cc.getPSConfigDir(), this.cc.getISBaseDir(), logger);
        List allPortals = this.getPortals();
        try {
            if (allPortals.size() > 0) {
                Iterator iter = allPortals.iterator();
                while (iter.hasNext()) {
                    String id = (String)iter.next();
                    if (!id.equalsIgnoreCase(portalID)) continue;
                    logger.log(Level.SEVERE, "Error creating portal . Portal already exists.");
                    throw new PSMBeanException("admin.error.duplicate.portal", "Portal " + portalID + " already exists", new Object[]{portalID});
                }
            } else {
                Domain pDomain = new Domain(this.cc);
                pDomain.configureMandatoryServices(ssoToken);
                es.domainServices(this.cc.getDefaultOrganization());
            }
            logger.log(Level.INFO, "Configuring portal " + portalID + " ...");
            newPortal.configurePortal(portalID, ssoToken, this.cc.getDirectoryServerHost(), this.cc.getDirectoryServerPort(), this.cc.getUserDataStoreManager(), this.cc.getUserDataStoreManagerCredentials(), this.cc.isDomainDataSecure());
            logger.log(Level.INFO, "Enable Portal Svcs: " + portalID + " ...");
            es.portalServices(portalID, this.cc.getDefaultOrganization(), this.cc.getUserNamingAttribute());
        }
        catch (ConfigurationException ce) {
            logger.log(Level.SEVERE, "Error configuring portal " + portalID, ce);
            throw new PSMBeanException("admin.error.configure.portal", this.getStackTrace(ce), new Object[]{portalID});
        }
        logger.log(Level.INFO, "Registering Portal : " + portalID);
        List portalPath = AdminUtil.getChildPath((List)this.path, (String)portalID);
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("Name", portalID);
        attributes.put("Description", portalID);
        attributes.put("PortalWebAppUri", uri);
        try {
            ObjectName pattern;
            Set<ObjectName> objects;
            Iterator<ObjectName> i;
            logger.log(Level.INFO, "Registering Portal Mbean");
            this.pdc.createResource("PortalDomain.Portal", this.path, portalID, attributes);
            logger.log(Level.INFO, "Registering DesktopDynamicMbean");
            this.pdc.createResource("PortalDomain.Portal.DesktopDynamic", portalPath, "DesktopDynamic", Collections.EMPTY_MAP);
            logger.log(Level.INFO, "Registering DPAdminWrapperMbean");
            this.pdc.createResource("PortalDomain.Portal.DPAdminWrapper", portalPath, "DPAdminWrapper", Collections.EMPTY_MAP);
            logger.log(Level.INFO, "Registering DisplayProfileMbean");
            this.pdc.createResource("PortalDomain.Portal.DisplayProfile", portalPath, "DisplayProfile", Collections.EMPTY_MAP);
            logger.log(Level.INFO, "Registering PortletAdminMbean");
            this.pdc.createResource("PortalDomain.Portal.PortletAdmin", portalPath, "PortletAdmin", Collections.EMPTY_MAP);
            this.pdc.createResource("PortalDomain.Portal.ProducerManager", portalPath, "ProducerManager", Collections.EMPTY_MAP);
            this.pdc.createResource("PortalDomain.Portal.ProducerManager.Producer", AdminUtil.getChildPath((List)portalPath, (String)"ProducerManager"), "default", Collections.EMPTY_MAP);
            this.pdc.createResource("PortalDomain.Portal.Consumer", portalPath, "Consumer", Collections.EMPTY_MAP);
            this.pdc.createResource("PortalDomain.Portal.RegistrySearch", portalPath, "RegistrySearch", Collections.EMPTY_MAP);
            this.pdc.createResource("PortalDomain.Portal.RegistryPublish", portalPath, "RegistryPublish", Collections.EMPTY_MAP);
            this.pdc.createResource("PortalDomain.Portal.Profiler", portalPath, "Profiler", Collections.EMPTY_MAP);
            logger.log(Level.INFO, "Registering UBTReportAggregatorMbean");
            this.pdc.createResource("PortalDomain.Portal.UBTReportAggregator", portalPath, "UBTReportAggregator", Collections.EMPTY_MAP);
            logger.log(Level.INFO, "Registering UBTReportMbean");
            this.pdc.createResource("PortalDomain.Portal.UBTReport", portalPath, "UBTReport", Collections.EMPTY_MAP);
            logger.log(Level.INFO, "Registering UBTSettingsHostBridgeMbean");
            this.pdc.createResource("PortalDomain.Portal.UBTSettingsHostBridge", portalPath, "UBTSettingsHostBridge", Collections.EMPTY_MAP);
            logger.log(Level.INFO, "Registering UBTSettingsMbean");
            this.pdc.createResource("PortalDomain.Portal.UBTSettings", portalPath, "UBTSettings", Collections.EMPTY_MAP);
            logger.log(Level.INFO, "Reloading the MBeans...");
            PASModule.reloadMBeans((PortalDomainContext)this.pdc, (String)"PortalDomain.Portal", (List)this.path);
            MBeanServer mbs = PASModule.getMBeanServer();
            ObjectName mBeanName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal.DesktopDynamic", (List)AdminUtil.getChildPath((List)portalPath, (String)"DesktopDynamic"));
            String parLoc = newPortal.createDesktopPar();
            String[] signature = new String[]{"java.lang.Boolean", "java.lang.Boolean", "java.lang.Boolean", "java.lang.Boolean", "java.lang.Boolean", "java.lang.String", "java.lang.String", "java.lang.Boolean", "java.lang.String", "java.lang.String"};
            Object[] params = new Object[]{new Boolean(false), new Boolean(false), new Boolean(false), new Boolean(true), new Boolean(false), parLoc, portalID, new Boolean(true), "2", ""};
            logger.log(Level.INFO, "Invoking ImportDesktop on the MBean...");
            mbs.invoke(mBeanName, "lImportDesktop", params, signature);
            File parFile = new File(parLoc);
            if (parFile.exists()) {
                parFile.delete();
            }
            ObjectName portalMBeanName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal", (List)portalPath);
            String[] signtrarr = new String[]{};
            Object[] paramarr = new String[]{};
            logger.log(Level.INFO, "Invoking createPortalWebApp on Portal MBean...");
            mbs.invoke(portalMBeanName, "createPortalWebApp", paramarr, signtrarr);
            String warfile = this.cc.getPSBaseDir() + fs + "portlet" + fs + "communityportlets.war";
            if (new File(warfile).exists()) {
                LinkedList<String> path = new LinkedList<String>();
                path.addFirst(this.getID());
                path.addFirst(portalID);
                path.addFirst("PortletAdmin");
                ObjectName objName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal.PortletAdmin", path);
                Object dn = null;
                boolean global = true;
                Properties rolesProperties = new Properties();
                Properties userinfoProperties = new Properties();
                boolean verbose = true;
                ArrayList<String> instanceList = new ArrayList<String>();
                instanceList.add("DummyInstance");
                boolean nodeploy = true;
                Object[] parm = new Object[]{dn, new Boolean(global), warfile, rolesProperties, userinfoProperties, new Boolean(verbose), instanceList, new Boolean(false), new Boolean(nodeploy)};
                String[] sign = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.String", "java.util.Properties", "java.util.Properties", "java.lang.Boolean", "java.util.List", "java.lang.Boolean", "java.lang.Boolean"};
                mbs.invoke(objName, "deployAll", parm, sign);
            }
            if ((i = (objects = mbs.queryNames(pattern = AdminClientUtil.getSearchServerPattern((String)"defaultDomain"), new ObjectName(""))).iterator()).hasNext()) {
                ObjectName on = i.next();
                Properties p = (Properties)mbs.getAttribute(on, "Vitals");
                URL searchURL = new URL(p.getProperty("url"));
                String surl = searchURL.toString();
                String propFileLoc = this.cc.getPSDataDir() + fs + "portals" + fs + portalID + fs + "config" + fs + "communityportlets.properties";
                File propFile = new File(propFileLoc);
                if (propFile.exists()) {
                    if (FileUtil.replaceTokenInFile(propFile, "%SEARCH_SERVER_URL%", surl)) {
                        logger.log(Level.INFO, "Replacing search server url for community  portlet.");
                    } else {
                        logger.log(Level.INFO, "No token replacement of search server url for community portlet.");
                    }
                } else {
                    logger.log(Level.INFO, "communityportlets.properties does not exist.");
                }
            } else {
                logger.log(Level.INFO, "No search server is assosciated with the default domain.");
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error creating portal " + portalID, e);
            throw new PSMBeanException("admin.error.create.portal", this.getStackTrace(e), new Object[]{portalID});
        }
    }

    public void deletePortal(String portalID) throws PSMBeanException {
        List allPortals = this.getPortals();
        if (!allPortals.contains(portalID)) {
            logger.log(Level.SEVERE, "Error deleting portal " + portalID + ". Portal does not exists.");
            throw new PSMBeanException("admin.error.delete.portal", "Portal " + portalID + " does not exists", new Object[]{portalID});
        }
        try {
            ObjectName pObjName = AdminClientUtil.getPortalMBeanObjectName((String)"defaultDomain", (String)portalID);
            ObjectName instancePat = AdminClientUtil.getPortalServerInstancesPattern((String)"defaultDomain", (String)portalID);
            MBeanServer mbs = PASModule.getMBeanServer();
            Set<ObjectName> instanceObjs = mbs.queryNames(instancePat, new ObjectName(""));
            Iterator<ObjectName> j = instanceObjs.iterator();
            while (j.hasNext()) {
                ObjectName iObj = j.next();
                String instanceId = null;
                try {
                    instanceId = (String)mbs.getAttribute(iObj, "ID");
                    Object[] params = new Object[]{instanceId};
                    String[] signatures = new String[]{"java.lang.String"};
                    mbs.invoke(pObjName, "deleteInstance", params, signatures);
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "Error deleting instance: " + instanceId, e);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error Fetching Instances for Portal: " + portalID, e);
        }
        String amAdminPassword = AdminServerUtil.getPassword();
        Portal newPortal = new Portal(this.cc.getPSBaseDir(), this.cc.getPSDataDir(), this.cc.getPSConfigDir(), this.cc.getISBaseDir(), logger);
        EnableServices es = new EnableServices(this.cc.getPSBaseDir(), this.cc.getPSDataDir(), this.cc.getISBaseDir(), this.cc.getAdminUserDN(), amAdminPassword, logger);
        try {
            SSOToken ssoToken = AdminServerUtil.getSSOToken();
            logger.log(Level.INFO, "Remove Portal Svcs: " + portalID + " ...");
            es.unconfigPortalRequests(portalID, this.cc.getDefaultOrganization(), this.cc.getUserNamingAttribute());
            newPortal.unconfigurePortal(portalID, ssoToken);
            this.pdc.removeResource("PortalDomain.Portal", AdminUtil.getChildPath((List)this.path, (String)portalID));
            this.pdc.removeResource("PortalDomain.Portal.Profiler", AdminUtil.getChildPath((List)this.path, (String)portalID));
            PASModule.reloadMBeans((PortalDomainContext)this.pdc, (String)"PortalDomain.Portal", (List)this.path);
        }
        catch (ConfigurationException ce) {
            logger.log(Level.SEVERE, "Error unconfiguring Portal Services ", ce);
            throw new PSMBeanException("admin.error.unconfigure.portal", this.getStackTrace(ce), new Object[]{ce.getMessage()});
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error deleting portal " + portalID, e);
            throw new PSMBeanException("admin.error.delete.portal", this.getStackTrace(e), new Object[]{portalID});
        }
    }

    public void createSearchServer(String searchServerID, Properties webContainerProperties) throws PSMBeanException {
        try {
            String host = (String)webContainerProperties.get("Host");
            if (!AdminUtil.isLocal((String)host)) {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                LinkedList<String> path = new LinkedList<String>();
                path.addFirst("defaultDomain");
                ObjectName on = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain", path);
                Object[] params = new Object[]{searchServerID, webContainerProperties};
                String[] signatures = new String[]{"java.lang.String", "java.util.Properties"};
                msc.invoke(on, "createSearchServer", params, signatures);
            } else {
                SearchSetup ss = new SearchSetup(logger);
                ss.configuration(this.cc, searchServerID);
                ss.deployment(this.cc, searchServerID, searchServerID, webContainerProperties);
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("Type", this.getProperty(webContainerProperties, "WebContainerType"));
                m.put("Protocol", this.getProperty(webContainerProperties, "Scheme"));
                m.put("Host", this.getProperty(webContainerProperties, "Host"));
                m.put("Port", this.getProperty(webContainerProperties, "Port"));
                m.put("Domain", this.getProperty(webContainerProperties, "WebContainerDomainName"));
                m.put("Instance", this.getProperty(webContainerProperties, "WebContainerInstanceName"));
                m.put("Cell", this.getProperty(webContainerProperties, "WebContainerDeployCell"));
                m.put("Node", this.getProperty(webContainerProperties, "WebContainerDeployNode"));
                m.put("ManagedServer", this.getProperty(webContainerProperties, "WebContainerManagedServer"));
                m.put("AdministrationProtocol", this.getProperty(webContainerProperties, "WebContainerAdminScheme"));
                m.put("AdministrationHost", this.getProperty(webContainerProperties, "WebContainerAdminHost"));
                m.put("AdministrationPort", this.getProperty(webContainerProperties, "WebContainerAdminPort"));
                m.put("Administrator", this.getProperty(webContainerProperties, "WebContainerAdminUid"));
                m.put("AdministrationPassword", this.getProperty(webContainerProperties, "WebContainerAdminPassword"));
                m.put("MasterPassword", this.getProperty(webContainerProperties, "WebContainerMasterPassword"));
                m.put("JDKDirectory", this.getProperty(webContainerProperties, "WebContainerJDKDir"));
                m.put("InstallDirectory", this.getProperty(webContainerProperties, "WebContainerInstallDir"));
                m.put("InstanceDirectory", this.getProperty(webContainerProperties, "WebContainerInstanceDir"));
                m.put("DocumentRootDirectory", this.getProperty(webContainerProperties, "WebContainerDocRoot"));
                this.pdc.createResource("PortalDomain.SearchServer", this.path, searchServerID, m);
                List childPath = AdminUtil.getChildPath((List)this.path, (String)searchServerID);
                this.pdc.createResource("PortalDomain.SearchServer.Database", childPath, "database", m);
                this.pdc.createResource("PortalDomain.SearchServer.Robot", childPath, "robot", m);
                this.pdc.createResource("PortalDomain.SearchServer.SiteProbe", childPath, "siteprobe", m);
                this.pdc.createResource("PortalDomain.SearchServer.Autoclassify", childPath, "autoclassify", m);
                this.pdc.createResource("PortalDomain.SearchServer.Category", childPath, "category", m);
                PASModule.reloadMBeans((PortalDomainContext)this.pdc, (String)"PortalDomain.SearchServer", (List)this.path);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error creating " + searchServerID, e);
            throw new PSMBeanException("admin.error.create.search", e.getMessage(), (Throwable)e, new Object[]{searchServerID});
        }
    }

    public void createSearchServerBackground(String searchServerID, Properties webContainerProperties) throws PSMBeanException {
        try {
            String host = (String)webContainerProperties.get("Host");
            if (!AdminUtil.isLocal((String)host)) {
                JMXConnector jmxc = AdminServerUtil.getJMXConnector((String)host);
                MBeanServerConnection msc = jmxc.getMBeanServerConnection();
                LinkedList<String> path = new LinkedList<String>();
                path.addFirst("defaultDomain");
                ObjectName on = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain", path);
                Object[] params = new Object[]{searchServerID, webContainerProperties};
                String[] signatures = new String[]{"java.lang.String", "java.util.Properties"};
                msc.invoke(on, "createSearchServerBackground", params, signatures);
            } else {
                this.csst = new CreateSearchServerThread(this.cc, this.pdc, this.path, logger, searchServerID, webContainerProperties);
                this.csst.start();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error creating " + searchServerID, e);
            throw new PSMBeanException("admin.error.create.search", e.getMessage(), (Throwable)e, new Object[]{searchServerID});
        }
    }

    public Integer getCreateSearchServerStatus() throws PSMBeanException {
        if (this.csst == null) {
            return new Integer(0);
        }
        if (!this.csst.isAlive()) {
            this.csst = null;
            return new Integer(0);
        }
        if (this.csst.status == 0) {
            this.csst = null;
            return new Integer(0);
        }
        return new Integer(this.csst.status);
    }

    public void deleteSearchServer(String searchServerID) throws PSMBeanException {
        List childPath;
        Properties p = new Properties();
        try {
            childPath = AdminUtil.getChildPath((List)this.path, (String)searchServerID);
            p.setProperty("WebContainerType", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "Type"));
            p.setProperty("Scheme", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "Protocol"));
            p.setProperty("Host", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "Host"));
            p.setProperty("Port", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "Port"));
            p.setProperty("WebContainerDomainName", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "Domain"));
            p.setProperty("WebContainerInstanceName", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "Instance"));
            p.setProperty("WebContainerDeployCell", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "Cell"));
            p.setProperty("WebContainerDeployNode", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "Node"));
            p.setProperty("WebContainerManagedServer", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "ManagedServer"));
            p.setProperty("WebContainerAdminScheme", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "AdministrationProtocol"));
            p.setProperty("WebContainerAdminHost", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "AdministrationHost"));
            p.setProperty("WebContainerAdminPort", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "AdministrationPort"));
            p.setProperty("WebContainerAdminUid", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "Administrator"));
            p.setProperty("WebContainerAdminPassword", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "AdministrationPassword"));
            p.setProperty("WebContainerMasterPassword", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "MasterPassword"));
            p.setProperty("WebContainerJDKDir", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "JDKDirectory"));
            p.setProperty("WebContainerInstallDir", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "InstallDirectory"));
            p.setProperty("WebContainerInstanceDir", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "InstanceDirectory"));
            p.setProperty("WebContainerDocRoot", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "DocumentRootDirectory"));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error deleting " + searchServerID, e);
            throw new PSMBeanException("admin.error.delete.search", e.getMessage(), (Throwable)e, new Object[]{searchServerID});
        }
        try {
            SearchSetup ss = new SearchSetup(logger);
            ss.delete(this.cc, searchServerID, searchServerID, p);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error deleting " + searchServerID, e);
            throw new PSMBeanException("admin.error.delete.search", e.getMessage(), (Throwable)e, new Object[]{searchServerID});
        }
        try {
            childPath = AdminUtil.getChildPath((List)this.path, (String)searchServerID);
            List databasePath = AdminUtil.getChildPath((List)childPath, (String)"database");
            this.pdc.removeResource("PortalDomain.SearchServer.Database", databasePath);
            List categoryPath = AdminUtil.getChildPath((List)childPath, (String)"category");
            this.pdc.removeResource("PortalDomain.SearchServer.Category", categoryPath);
            List autoclassPath = AdminUtil.getChildPath((List)childPath, (String)"autoclassify");
            this.pdc.removeResource("PortalDomain.SearchServer.Autoclassify", autoclassPath);
            List siteProbePath = AdminUtil.getChildPath((List)childPath, (String)"siteprobe");
            this.pdc.removeResource("PortalDomain.SearchServer.SiteProbe", siteProbePath);
            List robotPath = AdminUtil.getChildPath((List)childPath, (String)"robot");
            this.pdc.removeResource("PortalDomain.SearchServer.Robot", robotPath);
            this.pdc.removeResource("PortalDomain.SearchServer", childPath);
            PASModule.reloadMBeans((PortalDomainContext)this.pdc, (String)"PortalDomain.SearchServer", (List)this.path);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error deleting " + searchServerID, e);
            throw new PSMBeanException("admin.error.delete.search", e.getMessage(), (Throwable)e, new Object[]{searchServerID});
        }
    }

    public void redeploySearchServerWarfile(String searchServerID) throws PSMBeanException {
        Properties p = new Properties();
        try {
            List childPath = AdminUtil.getChildPath((List)this.path, (String)searchServerID);
            p.setProperty("WebContainerType", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "Type"));
            p.setProperty("Scheme", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "Protocol"));
            p.setProperty("Host", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "Host"));
            p.setProperty("Port", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "Port"));
            p.setProperty("WebContainerDomainName", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "Domain"));
            p.setProperty("WebContainerInstanceName", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "Instance"));
            p.setProperty("WebContainerDeployCell", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "Cell"));
            p.setProperty("WebContainerDeployNode", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "Node"));
            p.setProperty("WebContainerManagedServer", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "ManagedServer"));
            p.setProperty("WebContainerAdminScheme", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "AdministrationProtocol"));
            p.setProperty("WebContainerAdminHost", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "AdministrationHost"));
            p.setProperty("WebContainerAdminPort", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "AdministrationPort"));
            p.setProperty("WebContainerAdminUid", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "Administrator"));
            p.setProperty("WebContainerAdminPassword", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "AdministrationPassword"));
            p.setProperty("WebContainerMasterPassword", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "MasterPassword"));
            p.setProperty("WebContainerJDKDir", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "JDKDirectory"));
            p.setProperty("WebContainerInstallDir", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "InstallDirectory"));
            p.setProperty("WebContainerInstanceDir", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "InstanceDirectory"));
            p.setProperty("WebContainerDocRoot", this.pdc.getAttributeValue("PortalDomain.SearchServer", childPath, "DocumentRootDirectory"));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error deleting " + searchServerID, e);
            throw new PSMBeanException("admin.error.delete.search", e.getMessage(), (Throwable)e, new Object[]{searchServerID});
        }
        try {
            SearchSetup ss = new SearchSetup(logger);
            ss.redeployment(this.cc, searchServerID, searchServerID, p);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error redeploying " + searchServerID, e);
            throw new PSMBeanException("admin.error.redeploy.search", e.getMessage(), (Throwable)e, new Object[]{searchServerID});
        }
    }

    public String getPortalVersion(Boolean display, String jarpath, Boolean patch, Boolean patchVerbose) throws PSMBeanException {
        PortalVersion pv = new PortalVersion(this.getPSConfigContext(), logger);
        StringBuffer sb = new StringBuffer(256);
        if (display.booleanValue()) {
            sb.append(pv.getVersion());
            sb.append("\n");
        }
        if (jarpath != null) {
            sb.append(pv.getVersionFromJar(jarpath));
            sb.append("\n");
        }
        if (patch.booleanValue()) {
            sb.append(pv.getPatchInfo());
            sb.append("\n");
        }
        if (patchVerbose.booleanValue()) {
            sb.append(pv.getPatchVerbose());
            sb.append("\n");
        }
        return sb.toString();
    }

    public List getAttribute(Map optionsMap) throws PSMBeanException {
        List values = null;
        String compName = (String)optionsMap.get("component");
        logger.log(Level.FINEST, "Getting attr for " + compName);
        AttributeHandler handler = AttributeHandlerFactory.getComponentAttrHandler(compName, this.getPSConfigContext(), this.getDomainID(), null);
        handler.validate(null, optionsMap);
        values = handler.getAttribute(optionsMap);
        return values;
    }

    public Map getAttributes(Map optionsMap) throws PSMBeanException {
        Map nameValues = null;
        String compName = (String)optionsMap.get("component");
        logger.log(Level.FINEST, "Getting multiple attrs for " + compName);
        AttributeHandler handler = AttributeHandlerFactory.getComponentAttrHandler(compName, this.getPSConfigContext(), this.getDomainID(), null);
        handler.validate(null, optionsMap);
        nameValues = handler.getAttributes(optionsMap);
        return nameValues;
    }

    public void setAttribute(List values, Map optionsMap) throws PSMBeanException {
        String compName = (String)optionsMap.get("component");
        logger.log(Level.FINEST, "Setting attr for " + compName);
        AttributeHandler handler = AttributeHandlerFactory.getComponentAttrHandler(compName, this.getPSConfigContext(), this.getDomainID(), null);
        handler.validate(values, optionsMap);
        handler.setAttribute(values, optionsMap);
    }

    public void setAttributes(Map nameValues, Map optionsMap) throws PSMBeanException {
        String compName = (String)optionsMap.get("component");
        logger.log(Level.FINEST, "Setting multiple attrs for " + compName);
        AttributeHandler handler = AttributeHandlerFactory.getComponentAttrHandler(compName, this.getPSConfigContext(), this.getDomainID(), null);
        handler.validate(null, optionsMap);
        handler.setAttributes(nameValues, optionsMap);
    }

    public Map listAttributes(Map optionsMap) throws PSMBeanException {
        Map values = null;
        String compName = (String)optionsMap.get("component");
        logger.log(Level.FINEST, "Getting attr list for " + compName);
        AttributeHandler handler = AttributeHandlerFactory.getComponentAttrHandler(compName, this.getPSConfigContext(), this.getDomainID(), null);
        handler.validate(null, optionsMap);
        values = handler.listAttributes(optionsMap);
        return values;
    }

    public void validateWebContainer(Map attributes) throws PSMBeanException {
        String iHost = (String)attributes.get("Host");
        String iPort = (String)attributes.get("Port");
        logger.log(Level.FINEST, "Target host :" + iHost);
        try {
            if (iHost != null && !AdminUtil.isLocal((String)iHost)) {
                ObjectName domainObj = AdminUtil.getPortalDomainMBeanObjectName((String)this.getDomainID());
                Object[] params = new Object[]{attributes};
                String[] signature = new String[]{"java.util.Map"};
                this.invokeRemoteOperation(iHost, domainObj, "validateWebContainer", params, signature);
                return;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to invoke remote method", e);
            throw new PSMBeanException("admin.error.validate.instance", this.getStackTrace(e), new Object[]{e.getCause().getMessage()});
        }
        try {
            MBeanServer mbs = PASModule.getMBeanServer();
            ObjectName portalPat = AdminUtil.getPortalsPattern((String)"defaultDomain");
            Set<ObjectName> portalObjs = mbs.queryNames(portalPat, new ObjectName(""));
            Iterator<ObjectName> i = portalObjs.iterator();
            while (i.hasNext()) {
                ObjectName o = i.next();
                String pId = (String)mbs.getAttribute(o, "ID");
                ObjectName instancePat = AdminClientUtil.getPortalServerInstancesPattern((String)"defaultDomain", (String)pId);
                Set<ObjectName> instanceObjs = mbs.queryNames(instancePat, new ObjectName(""));
                Iterator<ObjectName> j = instanceObjs.iterator();
                while (j.hasNext()) {
                    ObjectName iObj = j.next();
                    String host = (String)mbs.getAttribute(iObj, "Host");
                    String port = (String)mbs.getAttribute(iObj, "Port");
                    if (!host.equalsIgnoreCase(iHost) || !port.equals(iPort)) continue;
                    String msg = "Another Portal Instance Configured on:" + host + ":" + port;
                    throw new IllegalArgumentException(msg);
                }
            }
            WebContainer wc = WebContainerFactory.getWebContainer(attributes, logger, true);
            wc.validate();
        }
        catch (IllegalArgumentException iae) {
            logger.log(Level.SEVERE, "Illegal Arguments", iae);
            Throwable tr = iae.getCause();
            if (tr != null) {
                throw new PSMBeanException("admin.error.validate.instance", this.getStackTrace(iae), new Object[]{tr.getMessage()});
            }
            throw new PSMBeanException("admin.error.validate.instance", iae.getMessage(), new Object[]{iae.getMessage()});
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Incorrect webcontainer data", e);
            throw new PSMBeanException("admin.error.validate.instance", this.getStackTrace(e), new Object[]{e.getCause().getMessage()});
        }
    }

    private String getProperty(Properties p, String key) {
        if (p.containsKey(key)) {
            return p.getProperty(key);
        }
        return "";
    }

    private boolean isSRAInstalled(PSConfigContext cc) {
        String libDir = cc.getPSBaseDir() + fs + "lib";
        String webInfLibDir = cc.getPSBaseDir() + fs + "web-src" + fs + "WEB-INF" + fs + "lib";
        boolean installed = false;
        if (FileUtil.fileExists(webInfLibDir + fs + "netletprovider.jar")) {
            installed = true;
        }
        if (!installed && FileUtil.fileExists(libDir + fs + "gateway.jar")) {
            installed = true;
        }
        return installed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

