/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.mbeans;

import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PortalDomainContext;
import com.sun.portal.admin.common.context.PortalDomainContextException;
import com.sun.portal.admin.common.util.AdminClientUtil;
import com.sun.portal.admin.common.util.AdminUtil;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.admin.server.PASModule;
import com.sun.portal.admin.server.mbeans.PSResource;
import com.sun.portal.fabric.common.AttributeHandler;
import com.sun.portal.fabric.common.AttributeHandlerFactory;
import com.sun.portal.fabric.mbeans.PortalMBean;
import com.sun.portal.fabric.tasks.ConfigurationException;
import com.sun.portal.fabric.tasks.PortalFileHandler;
import com.sun.portal.fabric.tasks.PortalInstance;
import com.sun.portal.fabric.tasks.PortalWar;
import com.sun.portal.fabric.tasks.WebContainer;
import com.sun.portal.fabric.tasks.WebContainerFactory;
import com.sun.portal.fabric.util.XMLJdomFileCreationException;
import com.sun.portal.fabric.util.XMLJdomUtil;
import com.sun.portal.log.common.PortalLogger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;

public class Portal
extends PSResource
implements PortalMBean {
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$mbeans$Portal == null ? (class$com$sun$portal$fabric$mbeans$Portal = Portal.class$("com.sun.portal.fabric.mbeans.Portal")) : class$com$sun$portal$fabric$mbeans$Portal));
    private String portalDir;
    private String portalConfigDir;
    static /* synthetic */ Class class$com$sun$portal$fabric$mbeans$Portal;

    public void init(PSConfigContext cc, PortalDomainContext pdc, List path) {
        super.init(cc, pdc, path);
        this.portalDir = cc.getPSDataDir() + fs + "portals" + fs + this.getID();
        this.portalConfigDir = this.portalDir + fs + "config";
    }

    public List getInstances() throws PSMBeanException {
        try {
            Set instances = this.pdc.getResourceIDs("PortalDomain.Portal.ServerInstance", this.path);
            return new ArrayList(instances);
        }
        catch (Exception e) {
            String message = "Error reading instances in portal " + this.getID();
            logger.log(Level.SEVERE, message, e);
            throw new PSMBeanException("admin.error.getInstances", e.getMessage(), (Throwable)e, new Object[]{this.getID()});
        }
    }

    public Boolean hasLocalInstance() {
        return new Boolean(false);
    }

    public Set getHosts() throws PSMBeanException {
        TreeSet<String> hosts = new TreeSet<String>();
        try {
            Iterator it = this.getInstances().iterator();
            MBeanServer mbs = PASModule.getMBeanServer();
            while (it.hasNext()) {
                String instanceID = (String)it.next();
                ObjectName iObjectName = AdminUtil.getInstanceMBeanObjectName((String)this.getDomainID(), (String)this.getID(), (String)instanceID);
                String host = (String)mbs.getAttribute(iObjectName, "Host");
                if (hosts.contains(host)) continue;
                hosts.add(host);
            }
        }
        catch (Exception e) {
            throw new PSMBeanException("error.get.instances", e.getMessage(), (Throwable)e);
        }
        return hosts;
    }

    public synchronized String createPortalWebApp() throws PSMBeanException {
        String portalUri = "/portal";
        String warFileName = "portal.war";
        try {
            portalUri = this.pdc.getAttributeValue("PortalDomain.Portal", this.path, "PortalWebAppUri");
            if (portalUri != null && portalUri.startsWith("/")) {
                warFileName = portalUri.substring(1) + ".war";
            }
            String psConfig = this.cc.getPSConfigDir() + fs + "PSConfig.properties";
            PortalWar pwar = new PortalWar(this.getID(), psConfig, logger);
            pwar.create(warFileName);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error creating portal " + this.getID(), e);
            throw new PSMBeanException("admin.error.create.portal.war", e.getMessage(), (Throwable)e, new Object[]{this.getID()});
        }
        return portalUri;
    }

    public synchronized String zipFilesystem() throws PSMBeanException {
        String zipPath = this.cc.getPSDataDir() + fs + "tmp" + fs + this.getID() + ".zip";
        PortalFileHandler.zipFilesystem(this.portalDir, zipPath, logger);
        File output = new File(zipPath);
        if (!output.exists()) {
            throw new PSMBeanException("Failed creating zip file");
        }
        return zipPath;
    }

    public synchronized void createInstance(String instanceID, Properties wcProp) throws PSMBeanException {
        HashMap<Object, Object> attributes = new HashMap<Object, Object>(wcProp);
        String host = (String)attributes.get("Host");
        if (instanceID == null || instanceID.trim().equals("")) {
            String port = wcProp.getProperty("Port");
            instanceID = this.generateID(host, port);
        }
        List instances = new ArrayList();
        instances = this.getInstances();
        if (instances.contains(instanceID)) {
            logger.log(Level.SEVERE, "Error creating Portal Instance " + instanceID);
            throw new PSMBeanException("admin.error.create.instance", "Portal Instance already exists", new Object[]{instanceID});
        }
        logger.log(Level.INFO, "Portal Instance ID :" + instanceID);
        String containerType = (String)attributes.get("WebContainerType");
        PortalInstance pInstance = new PortalInstance(this.getID(), instanceID, host, containerType, this.cc, logger);
        try {
            pInstance.setupInstanceConfigFiles();
        }
        catch (ConfigurationException ce) {
            logger.log(Level.SEVERE, "Setup of Instance Configation Files failed", ce);
            throw new PSMBeanException("admin.error.configure.instance", this.getStackTrace(ce), (Throwable)ce, new Object[]{instanceID});
        }
        attributes.put("Name", instanceID);
        attributes.put("Description", instanceID);
        String sPortalID = this.getID();
        attributes.put("com.sun.portal.domain.id", this.getDomainID());
        attributes.put("com.sun.portal.portal.id", sPortalID);
        try {
            String swcConfigDataR = null;
            try {
                swcConfigDataR = this.pdc.getAttributeValue("PortalDomain.Portal", this.path, "WebContainerConfigData");
            }
            catch (PortalDomainContextException pde) {
                swcConfigDataR = null;
            }
            String swcConfigDataFile = this.cc.getPSDataDir() + fs + "portals" + fs + sPortalID + fs + "config" + fs + "WebContainerConfigData.xml";
            File fwcConfigData = new File(swcConfigDataFile);
            if (fwcConfigData.exists()) {
                fwcConfigData.delete();
            }
            logger.log(Level.INFO, "PSFB_CSPFM1020", new String[]{"Configure Portal", swcConfigDataR == null ? "" : swcConfigDataR});
            if (swcConfigDataR != null && swcConfigDataR.trim().length() > 0) {
                FileWriter fw = new FileWriter(fwcConfigData);
                fw.write(swcConfigDataR);
                fw.close();
            }
            WebContainer wc = WebContainerFactory.getWebContainer(attributes, logger, true);
            wc.configure(this.cc);
            String swcConfigDataW = null;
            try {
                XMLJdomUtil xmlJdomUtil = new XMLJdomUtil();
                xmlJdomUtil.readXMLFileLessSchemaValidation(swcConfigDataFile);
                swcConfigDataW = xmlJdomUtil.getXMLJdomDocumentAsString();
            }
            catch (XMLJdomFileCreationException e0) {
                logger.log(Level.SEVERE, e0.getMessage());
                swcConfigDataW = null;
            }
            if (swcConfigDataW == null || swcConfigDataW.trim().length() <= 0) {
                String msg = "Internal Error:Configuration data to be stored in PAS is missing. Please report the problem to your system administrator.";
                XMLJdomFileCreationException e1 = new XMLJdomFileCreationException(msg);
                logger.log(Level.SEVERE, msg, e1);
                throw new PSMBeanException("admin.error.configure.instance", msg, (Throwable)e1, new Object[]{instanceID});
            }
            logger.log(Level.INFO, "PSFB_CSPFM1021", new String[]{"Configure Portal", swcConfigDataW == null ? "" : swcConfigDataW});
            logger.log(Level.INFO, "Type=PortalDomain.Portal");
            logger.log(Level.INFO, "List=" + this.path);
            this.pdc.setAttributeValue("PortalDomain.Portal", this.path, "WebContainerConfigData", swcConfigDataW);
            attributes.remove("com.sun.portal.domain.id");
            attributes.remove("com.sun.portal.portal.id");
        }
        catch (PortalDomainContextException pde0) {
            logger.log(Level.SEVERE, "Failed to store/retrieve Web Container Config data to PAS", pde0);
            throw new PSMBeanException("admin.error.configure.instance", this.getStackTrace(pde0), (Throwable)pde0, new Object[]{instanceID});
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Configure Failed", ioe);
            throw new PSMBeanException("admin.error.configure.instance", this.getStackTrace(ioe), (Throwable)ioe, new Object[]{instanceID});
        }
        catch (ConfigurationException ce) {
            logger.log(Level.SEVERE, "Configure Failed", ce);
            throw new PSMBeanException("admin.error.configure.instance", this.getStackTrace(ce), (Throwable)ce, new Object[]{instanceID});
        }
        try {
            logger.log(Level.INFO, "Registering Portal Server Instance");
            this.pdc.createResource("PortalDomain.Portal.ServerInstance", this.path, instanceID, attributes);
            List instancePath = AdminUtil.getChildPath((List)this.path, (String)instanceID);
            this.pdc.createResource("PortalDomain.Portal.ServerInstance.Monitoring", instancePath, "Monitoring", Collections.EMPTY_MAP);
            logger.log(Level.INFO, "Forcing a reload of MBeans");
            PASModule.reloadMBeans((PortalDomainContext)this.pdc, (String)"PortalDomain.Portal.ServerInstance", (List)this.path);
        }
        catch (Exception e) {
            String message = "Error creating instance " + instanceID;
            logger.log(Level.SEVERE, message, e);
            throw new PSMBeanException("admin.error.create.instance", this.getStackTrace(e), (Throwable)e, new Object[]{instanceID});
        }
    }

    private String generateID(String host, String port) {
        String instanceID = "psInstance";
        if (host != null && host.trim().length() > 0) {
            int idx = host.indexOf(46);
            instanceID = idx > 0 ? host.substring(0, idx) + "-" + port : host + "-" + port;
            instanceID = instanceID.replace('_', '-');
        }
        return instanceID;
    }

    /*
     * Loose catch block
     */
    public synchronized void createAndFinalizeInstance(String instanceID, Properties wcProp) throws PSMBeanException {
        block18: {
            block16: {
                String failMsg;
                block17: {
                    String iHost = (String)wcProp.get("Host");
                    logger.log(Level.FINEST, "Target host :" + iHost);
                    try {
                        if (iHost != null && !AdminUtil.isLocal((String)iHost)) {
                            logger.log(Level.FINEST, "Target host is not local. Invoking remote opertaion");
                            ObjectName pObjectName = AdminUtil.getPortalMBeanObjectName((String)this.getDomainID(), (String)this.getID());
                            Object[] params = new Object[]{instanceID, wcProp};
                            String[] signature = new String[]{"java.lang.String", "java.util.Properties"};
                            this.invokeRemoteOperation(iHost, pObjectName, "createAndFinalizeInstance", params, signature);
                            return;
                        }
                    }
                    catch (Exception e) {
                        throw new PSMBeanException("admin.error.create.instance", this.getStackTrace(e), new Object[]{instanceID});
                    }
                    File portalConfig = new File(this.portalConfigDir);
                    if (portalConfig.exists()) break block16;
                    logger.log(Level.FINEST, "Portal filesystem doesn not exist");
                    Set portalHosts = this.getHosts();
                    Iterator itr = portalHosts.iterator();
                    JMXConnector connector = null;
                    MBeanServerConnection mbsc = null;
                    while (itr.hasNext()) {
                        String host = (String)itr.next();
                        try {
                            logger.log(Level.FINEST, "Connecting to MBean Server On Host:" + host);
                            connector = AdminServerUtil.getJMXConnector((String)host);
                            mbsc = connector.getMBeanServerConnection();
                            break;
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Failed to Connect to Instance", e);
                        }
                    }
                    failMsg = "Unable to create data directory from remote host";
                    if (mbsc == null) break block17;
                    ObjectName pObjectName = AdminUtil.getPortalMBeanObjectName((String)this.getDomainID(), (String)this.getID());
                    String[] signature = new String[]{};
                    Object[] params = new Object[]{};
                    logger.log(Level.FINEST, "Creating Portal file data zip on remote host");
                    String zipPath = (String)mbsc.invoke(pObjectName, "zipFilesystem", params, signature);
                    String localPath = this.cc.getPSDataDir() + fs + "tmp" + fs + this.getID() + ".zip";
                    logger.log(Level.FINEST, "Downloading Portal Zip");
                    AdminClientUtil.downloadFile((MBeanServerConnection)mbsc, (String)this.getDomainID(), (String)zipPath, (int)0, (String)localPath);
                    logger.log(Level.FINEST, "Unzipping the portal filesystem");
                    PortalFileHandler.unzipFilesystem(this.portalDir, localPath, logger);
                    Object var16_22 = null;
                    try {
                        connector.close();
                    }
                    catch (Exception e) {
                        logger.log(Level.SEVERE, "Failed to close connection", e);
                    }
                    break block18;
                    {
                        catch (Exception e) {
                            throw new PSMBeanException("admin.error.create.instance", failMsg, new Object[]{instanceID});
                        }
                    }
                    catch (Throwable throwable) {
                        Object var16_23 = null;
                        try {
                            connector.close();
                        }
                        catch (Exception e) {
                            logger.log(Level.SEVERE, "Failed to close connection", e);
                        }
                        throw throwable;
                    }
                }
                throw new PSMBeanException("admin.error.create.instance", failMsg, new Object[]{instanceID});
            }
            logger.log(Level.FINEST, "Portal filesystem data exists");
            logger.log(Level.FINEST, "Proceeding with instance configuation");
        }
        try {
            if (instanceID == null || instanceID.trim().equals("")) {
                String host = wcProp.getProperty("Host");
                String port = wcProp.getProperty("Port");
                instanceID = this.generateID(host, port);
            }
            this.createInstance(instanceID, wcProp);
            ObjectName mBeanName = AdminUtil.getInstanceMBeanObjectName((String)this.getDomainID(), (String)this.getID(), (String)instanceID);
            String[] signature = new String[]{};
            Object[] params = new Object[]{};
            MBeanServer mbs = PASModule.getMBeanServer();
            logger.log(Level.INFO, "Invoking restart method on: " + mBeanName);
            mbs.invoke(mBeanName, "restart", params, signature);
            logger.log(Level.INFO, "Invoking deployAll method on: " + mBeanName);
            mbs.invoke(mBeanName, "deployAll", params, signature);
        }
        catch (Exception e) {
            String message = "Error creating instance " + instanceID;
            logger.log(Level.SEVERE, message, e);
            throw new PSMBeanException("admin.error.create.instance", this.getStackTrace(e), new Object[]{instanceID});
        }
    }

    public synchronized void deleteInstance(String instanceID) throws PSMBeanException {
        try {
            logger.log(Level.INFO, "Forcing a reload of MBeans");
            PASModule.reloadMBeans((PortalDomainContext)this.pdc, (String)"PortalDomain.Portal.ServerInstance", (List)this.path);
            MBeanServer mbs = PASModule.getMBeanServer();
            ObjectName iObjectName = AdminUtil.getInstanceMBeanObjectName((String)this.getDomainID(), (String)this.getID(), (String)instanceID);
            String host = (String)mbs.getAttribute(iObjectName, "Host");
            if (host != null && !AdminUtil.isLocal((String)host)) {
                ObjectName pObjectName = AdminUtil.getPortalMBeanObjectName((String)this.getDomainID(), (String)this.getID());
                Object[] params = new Object[]{instanceID};
                String[] signature = new String[]{"java.lang.String"};
                this.invokeRemoteOperation(host, pObjectName, "deleteInstance", params, signature);
                return;
            }
            logger.log(Level.INFO, "Invoking undeploy method on: " + iObjectName);
            String[] signature = new String[]{};
            Object[] params = new Object[]{};
            mbs.invoke(iObjectName, "undeployAll", params, signature);
        }
        catch (MBeanException me) {
            logger.log(Level.SEVERE, "Delete Instance Failed", me);
            throw (PSMBeanException)me.getTargetException();
        }
        catch (Exception e) {
            String message = "Error deleting instance " + instanceID;
            logger.log(Level.SEVERE, message, e);
        }
        HashMap<String, String> wcInfoMap = new HashMap<String, String>(WebContainer.wcAttrKeys.length);
        try {
            for (int i = 0; i < WebContainer.wcAttrKeys.length; ++i) {
                String attrVal = "";
                String attrKey = WebContainer.wcAttrKeys[i];
                try {
                    attrVal = this.pdc.getAttributeValue("PortalDomain.Portal.ServerInstance", AdminUtil.getChildPath((List)this.path, (String)instanceID), attrKey);
                }
                catch (PortalDomainContextException pde) {
                    // empty catch block
                }
                if (attrVal == null || attrVal.length() <= 0) continue;
                wcInfoMap.put(attrKey, attrVal);
            }
            try {
                wcInfoMap.put("Name", instanceID);
                wcInfoMap.put("com.sun.portal.domain.id", this.getDomainID());
                wcInfoMap.put("com.sun.portal.portal.id", this.getID());
                WebContainer wc = WebContainerFactory.getWebContainer(wcInfoMap, logger, false);
                wc.unconfigure(this.cc);
            }
            catch (ConfigurationException ce) {
                throw new PSMBeanException("admin.error.delete.instance", this.getStackTrace(ce), (Throwable)ce);
            }
            this.pdc.removeResource("PortalDomain.Portal.ServerInstance", AdminUtil.getChildPath((List)this.path, (String)instanceID));
            PASModule.reloadMBeans((PortalDomainContext)this.pdc, (String)"PortalDomain.Portal.ServerInstance", (List)this.path);
        }
        catch (Exception e) {
            String message = "Error deleting instance " + instanceID;
            logger.log(Level.SEVERE, message, e);
            throw new PSMBeanException("admin.error.delete.instance", this.getStackTrace(e), new Object[]{instanceID});
        }
    }

    public Boolean configureInstances(String confDir) throws PSMBeanException {
        Boolean retVal = new Boolean(true);
        Iterator instances = this.getInstances().iterator();
        while (instances.hasNext()) {
            String instanceID = (String)instances.next();
            try {
                String[] signature;
                Object[] params;
                ObjectName mBeanName;
                MBeanServer mbs = PASModule.getMBeanServer();
                Boolean instRetVal = (Boolean)mbs.invoke(mBeanName = AdminUtil.getInstanceMBeanObjectName((String)this.getDomainID(), (String)this.getID(), (String)instanceID), "configureContainer", params = new Object[]{confDir, instanceID}, signature = new String[]{"java.lang.String", "java.lang.String"});
                if (instRetVal != null && instRetVal.booleanValue()) continue;
                logger.log(Level.SEVERE, "Failed during to configure webcontainer: " + mBeanName);
                retVal = new Boolean(false);
            }
            catch (Exception e) {
                String message = "Error deleting instance " + instanceID;
                logger.log(Level.SEVERE, message, e);
            }
        }
        return retVal;
    }

    public void deployAllWebApps() throws PSMBeanException {
        Iterator instances = this.getInstances().iterator();
        while (instances.hasNext()) {
            String instanceID = (String)instances.next();
            try {
                MBeanServer mbs = PASModule.getMBeanServer();
                ObjectName mBeanName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal.ServerInstance", (List)AdminUtil.getChildPath((List)this.path, (String)instanceID));
                Object[] params = new Object[]{};
                String[] signature = new String[]{};
                mbs.invoke(mBeanName, "deployAll", params, signature);
            }
            catch (Exception e) {
                String message = "Error deploying on instance: " + instanceID;
                logger.log(Level.SEVERE, message, e);
            }
        }
    }

    public void undeployAllWebApps() throws PSMBeanException {
        Iterator instances = this.getInstances().iterator();
        while (instances.hasNext()) {
            String instanceID = (String)instances.next();
            try {
                MBeanServer mbs = PASModule.getMBeanServer();
                ObjectName mBeanName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal.ServerInstance", (List)AdminUtil.getChildPath((List)this.path, (String)instanceID));
                Object[] params = new Object[]{};
                String[] signature = new String[]{};
                mbs.invoke(mBeanName, "undeployAll", params, signature);
            }
            catch (Exception e) {
                String message = "Error undeploying on instance: " + instanceID;
                logger.log(Level.SEVERE, message, e);
            }
        }
    }

    public void deployPortalWebApp() throws PSMBeanException {
        Iterator instances = this.getInstances().iterator();
        String instanceID = null;
        while (instances.hasNext()) {
            try {
                instanceID = (String)instances.next();
                List instancePath = AdminUtil.getChildPath((List)this.path, (String)instanceID);
                String host = this.pdc.getAttributeValue("PortalDomain.Portal.ServerInstance", instancePath, "Host");
                if (AdminUtil.isLocal((String)host)) {
                    this.createPortalWebApp();
                } else {
                    ObjectName iObjName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal", (List)this.path);
                    this.invokeRemoteOperation(host, iObjName, "createPortalWebApp", new Object[0], new String[0]);
                }
                MBeanServer mbs = PASModule.getMBeanServer();
                ObjectName mBeanName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal.ServerInstance", (List)AdminUtil.getChildPath((List)this.path, (String)instanceID));
                String portalUri = this.pdc.getAttributeValue("PortalDomain.Portal", this.path, "PortalWebAppUri");
                Object[] params = new Object[]{portalUri};
                String[] signature = new String[]{"java.lang.String"};
                mbs.invoke(mBeanName, "deploy", params, signature);
            }
            catch (Exception e) {
                String message = "Error deploying portal war on instance: " + instanceID;
                logger.log(Level.SEVERE, message, e);
            }
        }
    }

    public void undeployPortalWebApp() throws PSMBeanException {
        Iterator instances = this.getInstances().iterator();
        while (instances.hasNext()) {
            String instanceID = (String)instances.next();
            try {
                MBeanServer mbs = PASModule.getMBeanServer();
                ObjectName mBeanName = AdminUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal.ServerInstance", (List)AdminUtil.getChildPath((List)this.path, (String)instanceID));
                String portalUri = this.pdc.getAttributeValue("PortalDomain.Portal", this.path, "PortalWebAppUri");
                Object[] params = new Object[]{portalUri};
                String[] signature = new String[]{"java.lang.String"};
                mbs.invoke(mBeanName, "undeploy", params, signature);
            }
            catch (Exception e) {
                String message = "Error undeploying portal war on instance: " + instanceID;
                logger.log(Level.SEVERE, message, e);
            }
        }
    }

    public List getAttribute(Map optionsMap) throws PSMBeanException {
        List values = null;
        String compName = (String)optionsMap.get("component");
        logger.log(Level.FINEST, "Getting attr for " + compName);
        AttributeHandler handler = AttributeHandlerFactory.getComponentAttrHandler(compName, this.getPSConfigContext(), this.getDomainID(), this.getID());
        handler.validate(null, optionsMap);
        values = handler.getAttribute(optionsMap);
        return values;
    }

    public Map getAttributes(Map optionsMap) throws PSMBeanException {
        Map values = null;
        String compName = (String)optionsMap.get("component");
        logger.log(Level.FINEST, "Getting multiple attrs for " + compName);
        AttributeHandler handler = AttributeHandlerFactory.getComponentAttrHandler(compName, this.getPSConfigContext(), this.getDomainID(), this.getID());
        handler.validate(null, optionsMap);
        values = handler.getAttributes(optionsMap);
        return values;
    }

    public void setAttribute(List values, Map optionsMap) throws PSMBeanException {
        String compName = (String)optionsMap.get("component");
        logger.log(Level.FINEST, "Setting attr for " + compName);
        AttributeHandler handler = AttributeHandlerFactory.getComponentAttrHandler(compName, this.getPSConfigContext(), this.getDomainID(), this.getID());
        handler.validate(values, optionsMap);
        handler.setAttribute(values, optionsMap);
    }

    public void setAttributes(Map nameValues, Map optionsMap) throws PSMBeanException {
        String compName = (String)optionsMap.get("component");
        logger.log(Level.FINEST, "Setting multiple attrs for " + compName);
        AttributeHandler handler = AttributeHandlerFactory.getComponentAttrHandler(compName, this.getPSConfigContext(), this.getDomainID(), this.getID());
        handler.validate(null, optionsMap);
        handler.setAttributes(nameValues, optionsMap);
    }

    public Map listAttributes(Map optionsMap) throws PSMBeanException {
        Map values = null;
        String compName = (String)optionsMap.get("component");
        logger.log(Level.FINEST, "Getting attr list for " + compName);
        AttributeHandler handler = AttributeHandlerFactory.getComponentAttrHandler(compName, this.getPSConfigContext(), this.getDomainID(), this.getID());
        handler.validate(null, optionsMap);
        values = handler.listAttributes(optionsMap);
        return values;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

