/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.common;

import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.server.AdminServerUtil;
import com.sun.portal.fabric.common.AttributeHandler;
import com.sun.portal.fabric.common.AttributeOperations;
import com.sun.portal.fabric.common.DSAMEAttributeOperations;
import com.sun.portal.log.common.PortalLogger;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GenericDSAMEAttributeHandler
implements AttributeHandler {
    public static final String COS_PRIORITY_STRING = "priority";
    protected String compName = null;
    protected String domainId = null;
    protected String portalId = null;
    protected AttributeOperations attrOps = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$common$GenericDSAMEAttributeHandler == null ? (class$com$sun$portal$fabric$common$GenericDSAMEAttributeHandler = GenericDSAMEAttributeHandler.class$("com.sun.portal.fabric.common.GenericDSAMEAttributeHandler")) : class$com$sun$portal$fabric$common$GenericDSAMEAttributeHandler));
    static /* synthetic */ Class class$com$sun$portal$fabric$common$GenericDSAMEAttributeHandler;

    public void init(String component, String domainId, String portalId) throws PSMBeanException {
        this.compName = component;
        this.domainId = domainId;
        this.portalId = portalId;
        try {
            this.attrOps = new DSAMEAttributeOperations(AdminServerUtil.getSSOToken());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error during initialization", e);
            throw new PSMBeanException("error.psadmin.handler.init.failed", e.getMessage(), (Throwable)e);
        }
    }

    public void validate(List values, Map optionsMap) throws PSMBeanException {
    }

    public String getAttributeName(String userFriendlyName) {
        return userFriendlyName;
    }

    public String getComponentName(String userFriendlyName) {
        return userFriendlyName;
    }

    public Map listAttributes(Map optionsMap) throws PSMBeanException {
        return Collections.EMPTY_MAP;
    }

    public List getAttribute(Map optionsMap) throws PSMBeanException {
        String comp = (String)optionsMap.get("component");
        String attr = (String)optionsMap.get("attribute-name");
        List values = null;
        try {
            values = this.attrOps.getAttribute(this.getComponentName(comp), this.getAttributeName(attr), this.buildExtraInfo(optionsMap));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to get attribute " + attr + " for " + comp);
            throw new PSMBeanException("error.psadmin.get.failed", e.getMessage(), (Throwable)e);
        }
        return values == null ? Collections.EMPTY_LIST : values;
    }

    public Map getAttributes(Map optionsMap) throws PSMBeanException {
        String comp = (String)optionsMap.get("component");
        Set attrNames = (Set)optionsMap.get("attribute-names");
        int nNames = attrNames.size();
        HashMap<String, String> nameMap = new HashMap<String, String>(nNames);
        HashSet<String> realNames = new HashSet<String>(nNames);
        Iterator iter = attrNames.iterator();
        while (iter.hasNext()) {
            String fName = (String)iter.next();
            String realName = this.getAttributeName(fName);
            nameMap.put(realName, fName);
            realNames.add(realName);
        }
        Map rNameValues = null;
        try {
            rNameValues = this.attrOps.getAttributes(this.getComponentName(comp), realNames, this.buildExtraInfo(optionsMap));
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Unable to get attributes " + attrNames + " for " + comp);
            throw new PSMBeanException("error.psadmin.get.failed", e.getMessage(), (Throwable)e);
        }
        HashMap nameValues = new HashMap(nNames);
        if (rNameValues != null) {
            Iterator riter = rNameValues.keySet().iterator();
            while (riter.hasNext()) {
                String rName = (String)riter.next();
                nameValues.put(nameMap.get(rName), rNameValues.get(rName));
            }
        }
        return nameValues == null ? Collections.EMPTY_MAP : nameValues;
    }

    public void setAttribute(List values, Map optionsMap) throws PSMBeanException {
        String comp = (String)optionsMap.get("component");
        String attr = (String)optionsMap.get("attribute-name");
        try {
            this.attrOps.setAttribute(this.getComponentName(comp), this.getAttributeName(attr), values, this.buildExtraInfo(optionsMap));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to set attributes " + attr + " for " + comp, e);
            throw new PSMBeanException("error.psadmin.set.failed", e.getMessage(), (Throwable)e);
        }
    }

    public void setAttributes(Map nameValues, Map optionsMap) throws PSMBeanException {
        String comp = (String)optionsMap.get("component");
        Set fNameSet = nameValues.keySet();
        int nNames = fNameSet.size();
        HashMap rNameValues = new HashMap(nNames);
        Iterator iter = fNameSet.iterator();
        while (iter.hasNext()) {
            String fName = (String)iter.next();
            String realName = this.getAttributeName(fName);
            rNameValues.put(realName, nameValues.get(fName));
        }
        try {
            this.attrOps.setAttributes(this.getComponentName(comp), rNameValues, this.buildExtraInfo(optionsMap));
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Unable to set attributes " + fNameSet + " for " + comp, e);
            throw new PSMBeanException("error.psadmin.set.failed", e.getMessage(), (Throwable)e);
        }
    }

    protected Map buildExtraInfo(Map optionsMap) {
        HashMap<String, Object> extraInfo = new HashMap<String, Object>();
        boolean global = Boolean.valueOf((String)optionsMap.get("global"));
        boolean org = Boolean.valueOf((String)optionsMap.get("org"));
        String dn = (String)optionsMap.get("dn");
        if (global) {
            extraInfo.put("type", new Integer(0));
        } else if (org) {
            extraInfo.put("type", new Integer(1));
        }
        if (dn != null) {
            extraInfo.put("dn", dn);
        }
        List addValues = (List)optionsMap.get("add");
        List removeValues = (List)optionsMap.get("remove");
        String inheritStr = (String)optionsMap.get("inherit");
        extraInfo.put("inherit", new Boolean(inheritStr));
        if (addValues != null) {
            extraInfo.put("add", new HashSet(addValues));
        }
        if (removeValues != null) {
            extraInfo.put("remove", new HashSet(removeValues));
        }
        logger.log(Level.FINEST, "ExtraInfo is " + extraInfo);
        return extraInfo;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

