/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.fabric.common;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMFilteredRole;
import com.iplanet.am.sdk.AMOrganization;
import com.iplanet.am.sdk.AMRole;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMTemplate;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.AttributeSchema;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import com.sun.portal.fabric.common.AttributeOperations;
import com.sun.portal.log.common.PortalLogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DSAMEAttributeOperations
implements AttributeOperations {
    public static final String COS_PRIORITY_STRING = "priority";
    public static final String SCHEMA_TYPE = "type";
    public static final String DN = "dn";
    public static final String INHERIT = "inherit";
    public static final String ADD = "add";
    public static final String REMOVE = "remove";
    public static final int UNKNOWN = -1;
    public static final int GLOBAL = 0;
    public static final int ORG = 1;
    protected SSOToken token = null;
    protected AMStoreConnection amsc = null;
    private static Logger logger = PortalLogger.getLogger((Class)(class$com$sun$portal$fabric$common$DSAMEAttributeOperations == null ? (class$com$sun$portal$fabric$common$DSAMEAttributeOperations = DSAMEAttributeOperations.class$("com.sun.portal.fabric.common.DSAMEAttributeOperations")) : class$com$sun$portal$fabric$common$DSAMEAttributeOperations));
    static /* synthetic */ Class class$com$sun$portal$fabric$common$DSAMEAttributeOperations;

    public DSAMEAttributeOperations(SSOToken token) throws Exception {
        this.token = token;
        try {
            this.amsc = new AMStoreConnection(token);
        }
        catch (SSOException ssoe) {
            logger.log(Level.SEVERE, "Could not get AMStoreConnection", ssoe);
            throw new Exception(ssoe.getMessage(), ssoe);
        }
    }

    public List getAttribute(String serviceName, String attrName, Map extraInfo) throws Exception {
        if (serviceName == null || serviceName.length() == 0 || attrName == null || attrName.length() == 0 || extraInfo == null) {
            logger.log(Level.SEVERE, "Incorrect args passed, can not get attributes");
            throw new Exception("Arguments passed are either null or empty");
        }
        Set values = null;
        int type = -1;
        Integer t = (Integer)extraInfo.get(SCHEMA_TYPE);
        if (t != null) {
            type = t;
        }
        String dn = (String)extraInfo.get(DN);
        try {
            switch (type) {
                case 0: {
                    values = this.getGlobalAttribute(serviceName, attrName);
                    break;
                }
                case 1: {
                    if (dn == null) {
                        values = this.getDefaultOrgAttribute(serviceName, attrName);
                        break;
                    }
                    values = this.getOrgAttribute(serviceName, attrName, dn);
                    break;
                }
                default: {
                    if (dn == null) {
                        values = this.getDefaultDynamicAttribute(serviceName, attrName);
                        break;
                    }
                    int objType = this.amsc.getAMObjectType(dn);
                    if (objType == 1) {
                        values = this.getUserAttribute(attrName, dn);
                        break;
                    }
                    values = this.getDynamicAttribute(serviceName, attrName, dn, objType);
                    break;
                }
            }
        }
        catch (AMException ame) {
            logger.log(Level.INFO, "Could not get attr", ame);
            throw new Exception(ame.getMessage(), ame);
        }
        catch (SSOException ssoe) {
            logger.log(Level.SEVERE, "Could not get attr", ssoe);
            throw new Exception(ssoe.getMessage(), ssoe);
        }
        catch (SMSException smse) {
            logger.log(Level.SEVERE, "Could not get attr", smse);
            throw new Exception(smse.getMessage(), smse);
        }
        logger.log(Level.FINEST, "Values for " + attrName + " are " + values);
        return values == null ? Collections.EMPTY_LIST : new ArrayList(values);
    }

    public Map getAttributes(String serviceName, Set names, Map extraInfo) throws Exception {
        if (serviceName == null || serviceName.length() == 0 || names == null || names.size() == 0 || extraInfo == null) {
            logger.log(Level.SEVERE, "Incorrect args passed, can not get attributes");
            throw new Exception("Arguments passed are either null or empty");
        }
        Map nameValues = null;
        int type = -1;
        Integer t = (Integer)extraInfo.get(SCHEMA_TYPE);
        if (t != null) {
            type = t;
        }
        String dn = (String)extraInfo.get(DN);
        try {
            switch (type) {
                case 0: {
                    nameValues = this.getGlobalAttributes(serviceName, names);
                    break;
                }
                case 1: {
                    if (dn == null) {
                        nameValues = this.getDefaultOrgAttributes(serviceName, names);
                        break;
                    }
                    nameValues = this.getOrgAttributes(serviceName, names, dn);
                    break;
                }
                default: {
                    if (dn == null) {
                        nameValues = this.getDefaultDynamicAttributes(serviceName, names);
                        break;
                    }
                    int objType = this.amsc.getAMObjectType(dn);
                    if (objType == 1) {
                        nameValues = this.getUserAttributes(names, dn);
                        break;
                    }
                    nameValues = this.getDynamicAttributes(serviceName, names, dn, objType);
                    break;
                }
            }
        }
        catch (AMException ame) {
            logger.log(Level.INFO, "Could not get multiple attrs", ame);
            throw new Exception(ame.getMessage(), ame);
        }
        catch (SSOException ssoe) {
            logger.log(Level.SEVERE, "Could not get multiple attrs", ssoe);
            throw new Exception(ssoe.getMessage(), ssoe);
        }
        catch (SMSException smse) {
            logger.log(Level.SEVERE, "Could not get multiple attrs", smse);
            throw new Exception(smse.getMessage(), smse);
        }
        HashMap returnMap = new HashMap(names.size());
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            Set values = (Set)nameValues.get(name);
            if (values != null) {
                ArrayList listValue = new ArrayList(values);
                returnMap.put(name, listValue);
                continue;
            }
            logger.log(Level.FINEST, "Skipping null value for attribute " + name);
        }
        logger.log(Level.FINEST, "Attr name-value map is: " + returnMap);
        return returnMap;
    }

    public void setAttribute(String serviceName, String attrName, List valuesList, Map extraInfo) throws Exception {
        if (serviceName == null || serviceName.length() == 0 || attrName == null || attrName.length() == 0 || valuesList == null || extraInfo == null) {
            logger.log(Level.SEVERE, "Incorrect args passed, can not set attribute");
            throw new Exception("Arguments passed are either null or empty");
        }
        HashSet values = new HashSet(valuesList);
        int type = -1;
        Integer t = (Integer)extraInfo.get(SCHEMA_TYPE);
        if (t != null) {
            type = t;
        }
        String dn = (String)extraInfo.get(DN);
        Set addValues = (Set)extraInfo.get(ADD);
        Set removeValues = (Set)extraInfo.get(REMOVE);
        boolean inherit = (Boolean)extraInfo.get(INHERIT);
        try {
            switch (type) {
                case 0: {
                    if (addValues != null && removeValues != null) {
                        this.addGlobalAttributeValue(serviceName, attrName, addValues);
                        this.removeGlobalAttributeValue(serviceName, attrName, removeValues);
                        break;
                    }
                    if (removeValues != null) {
                        this.removeGlobalAttributeValue(serviceName, attrName, removeValues);
                        break;
                    }
                    if (addValues != null) {
                        this.addGlobalAttributeValue(serviceName, attrName, addValues);
                        break;
                    }
                    this.setGlobalAttribute(serviceName, attrName, values);
                    break;
                }
                case 1: {
                    if (dn == null) {
                        if (addValues != null && removeValues != null) {
                            this.addDefaultOrgAttributeValue(serviceName, attrName, addValues);
                            this.removeDefaultOrgAttributeValue(serviceName, attrName, removeValues);
                            break;
                        }
                        if (removeValues != null) {
                            this.removeDefaultOrgAttributeValue(serviceName, attrName, removeValues);
                            break;
                        }
                        if (addValues != null) {
                            this.addDefaultOrgAttributeValue(serviceName, attrName, addValues);
                            break;
                        }
                        this.setDefaultOrgAttribute(serviceName, attrName, values);
                        break;
                    }
                    if (addValues != null && removeValues != null) {
                        this.addOrgAttributeValue(serviceName, attrName, addValues, dn);
                        this.removeOrgAttributeValue(serviceName, attrName, removeValues, dn);
                        break;
                    }
                    if (removeValues != null) {
                        this.removeOrgAttributeValue(serviceName, attrName, removeValues, dn);
                        break;
                    }
                    if (addValues != null) {
                        this.addOrgAttributeValue(serviceName, attrName, addValues, dn);
                        break;
                    }
                    if (inherit) {
                        throw new Exception("Unsupported operation: supported only on user dn");
                    }
                    this.setOrgAttribute(serviceName, attrName, values, dn);
                    break;
                }
                default: {
                    if (dn == null) {
                        if (addValues != null && removeValues != null) {
                            this.addDefaultDynamicAttributeValue(serviceName, attrName, addValues);
                            this.removeDefaultDynamicAttributeValue(serviceName, attrName, removeValues);
                            break;
                        }
                        if (removeValues != null) {
                            this.removeDefaultDynamicAttributeValue(serviceName, attrName, removeValues);
                            break;
                        }
                        if (addValues != null) {
                            this.addDefaultDynamicAttributeValue(serviceName, attrName, addValues);
                            break;
                        }
                        this.setDefaultDynamicAttribute(serviceName, attrName, values);
                        break;
                    }
                    int objType = this.amsc.getAMObjectType(dn);
                    if (objType == 1) {
                        if (addValues != null && removeValues != null) {
                            this.addUserAttributeValue(attrName, addValues, dn);
                            this.removeUserAttributeValue(attrName, removeValues, dn);
                            break;
                        }
                        if (removeValues != null) {
                            this.removeUserAttributeValue(attrName, removeValues, dn);
                            break;
                        }
                        if (addValues != null) {
                            this.addUserAttributeValue(attrName, addValues, dn);
                            break;
                        }
                        if (inherit) {
                            this.inherit(attrName, dn);
                            break;
                        }
                        this.setUserAttribute(attrName, values, dn);
                        break;
                    }
                    if (addValues != null && removeValues != null) {
                        this.addDynamicAttributeValue(serviceName, attrName, addValues, dn, objType);
                        this.removeDynamicAttributeValue(serviceName, attrName, removeValues, dn, objType);
                        break;
                    }
                    if (removeValues != null) {
                        this.removeDynamicAttributeValue(serviceName, attrName, removeValues, dn, objType);
                        break;
                    }
                    if (addValues != null) {
                        this.addDynamicAttributeValue(serviceName, attrName, addValues, dn, objType);
                        break;
                    }
                    if (inherit) {
                        throw new Exception("Unsupported operation: supported only on user dn");
                    }
                    this.setDynamicAttribute(serviceName, attrName, values, dn, objType);
                    break;
                }
            }
        }
        catch (AMException ame) {
            logger.log(Level.SEVERE, "Could not set attr", ame);
            throw new Exception(ame.getMessage(), ame);
        }
        catch (SSOException ssoe) {
            logger.log(Level.SEVERE, "Could not set attr", ssoe);
            throw new Exception(ssoe.getMessage(), ssoe);
        }
        catch (SMSException smse) {
            logger.log(Level.SEVERE, "Could not set attr", smse);
            throw new Exception(smse.getMessage(), smse);
        }
    }

    public void setAttributes(String serviceName, Map values, Map extraInfo) throws Exception {
        if (serviceName == null || serviceName.length() == 0 || values == null || values.size() == 0 || extraInfo == null) {
            logger.log(Level.SEVERE, "Incorrect args passed, can not set attributes");
            throw new Exception("Arguments passed are either null or empty");
        }
        HashMap nameValues = new HashMap(values.size());
        Iterator iter = values.keySet().iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            nameValues.put(name, new HashSet((List)values.get(name)));
        }
        int type = -1;
        Integer t = (Integer)extraInfo.get(SCHEMA_TYPE);
        if (t != null) {
            type = t;
        }
        String dn = (String)extraInfo.get(DN);
        try {
            switch (type) {
                case 0: {
                    this.setGlobalAttributes(serviceName, nameValues);
                    break;
                }
                case 1: {
                    if (dn == null) {
                        this.setDefaultOrgAttributes(serviceName, nameValues);
                        break;
                    }
                    this.setOrgAttributes(serviceName, nameValues, dn);
                    break;
                }
                default: {
                    if (dn == null) {
                        this.setDefaultDynamicAttributes(serviceName, nameValues);
                        break;
                    }
                    int objType = this.amsc.getAMObjectType(dn);
                    if (objType == 1) {
                        this.setUserAttributes(nameValues, dn);
                        break;
                    }
                    this.setDynamicAttributes(serviceName, nameValues, dn, objType);
                    break;
                }
            }
        }
        catch (AMException ame) {
            logger.log(Level.SEVERE, "Could not set multiple attrs", ame);
            throw new Exception(ame.getMessage(), ame);
        }
        catch (SSOException ssoe) {
            logger.log(Level.SEVERE, "Could not set multiple attrs", ssoe);
            throw new Exception(ssoe.getMessage(), ssoe);
        }
        catch (SMSException smse) {
            logger.log(Level.SEVERE, "Could not set multiple attrs", smse);
            throw new Exception(smse.getMessage(), smse);
        }
    }

    public Map listAttributes(String serviceName, Map extraInfo) {
        logger.log(Level.INFO, "No implementation of listAttributes, subclasses need to override");
        return Collections.EMPTY_MAP;
    }

    protected Set getGlobalAttribute(String serviceName, String attributeName) throws SSOException, SMSException {
        Set values = null;
        ServiceSchemaManager svcMgr = new ServiceSchemaManager(serviceName, this.token);
        ServiceSchema svcSchema = svcMgr.getGlobalSchema();
        Map attrs = svcSchema.getAttributeDefaults();
        values = (Set)attrs.get(attributeName);
        return values == null ? Collections.EMPTY_SET : values;
    }

    protected Map getGlobalAttributes(String serviceName, Set names) throws SSOException, SMSException {
        ServiceSchemaManager svcMgr = new ServiceSchemaManager(serviceName, this.token);
        ServiceSchema svcSchema = svcMgr.getGlobalSchema();
        Map attrs = svcSchema.getAttributeDefaults();
        if (attrs != null && !attrs.isEmpty()) {
            Set keys = attrs.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (names.contains(obj)) continue;
                iter.remove();
            }
        }
        return attrs == null ? Collections.EMPTY_MAP : attrs;
    }

    protected Set getDefaultOrgAttribute(String serviceName, String attributeName) throws SSOException, SMSException {
        Set values = null;
        ServiceSchemaManager svcMgr = new ServiceSchemaManager(serviceName, this.token);
        ServiceSchema svcSchema = svcMgr.getOrganizationSchema();
        Map attrs = svcSchema.getAttributeDefaults();
        values = (Set)attrs.get(attributeName);
        return values == null ? Collections.EMPTY_SET : values;
    }

    protected Map getDefaultOrgAttributes(String serviceName, Set names) throws SSOException, SMSException {
        ServiceSchemaManager svcMgr = new ServiceSchemaManager(serviceName, this.token);
        ServiceSchema svcSchema = svcMgr.getOrganizationSchema();
        Map attrs = svcSchema.getAttributeDefaults();
        if (attrs != null && !attrs.isEmpty()) {
            Set keys = attrs.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (names.contains(obj)) continue;
                iter.remove();
            }
        }
        return attrs == null ? Collections.EMPTY_MAP : attrs;
    }

    protected Set getOrgAttribute(String serviceName, String attributeName, String orgDN) throws AMException, SSOException {
        Set values = null;
        AMOrganization org = this.amsc.getOrganization(orgDN);
        AMTemplate template = org.getTemplate(serviceName, 302);
        values = template.getAttribute(attributeName);
        return values == null ? Collections.EMPTY_SET : values;
    }

    protected Map getOrgAttributes(String serviceName, Set names, String orgDN) throws AMException, SSOException {
        AMOrganization org = this.amsc.getOrganization(orgDN);
        AMTemplate template = org.getTemplate(serviceName, 302);
        Map nameValues = template.getAttributes(names);
        return nameValues == null ? Collections.EMPTY_MAP : nameValues;
    }

    protected Set getDefaultDynamicAttribute(String serviceName, String attributeName) throws SSOException, SMSException {
        Set values = null;
        ServiceSchemaManager svcMgr = new ServiceSchemaManager(serviceName, this.token);
        ServiceSchema svcSchema = svcMgr.getDynamicSchema();
        Map attrs = svcSchema.getAttributeDefaults();
        values = (Set)attrs.get(attributeName);
        return values == null ? Collections.EMPTY_SET : values;
    }

    protected Map getDefaultDynamicAttributes(String serviceName, Set names) throws SSOException, SMSException {
        ServiceSchemaManager svcMgr = new ServiceSchemaManager(serviceName, this.token);
        ServiceSchema svcSchema = svcMgr.getDynamicSchema();
        Map attrs = svcSchema.getAttributeDefaults();
        if (attrs != null && !attrs.isEmpty()) {
            Set keys = attrs.keySet();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                if (names.contains(obj)) continue;
                iter.remove();
            }
        }
        return attrs == null ? Collections.EMPTY_MAP : attrs;
    }

    protected Set getDynamicAttribute(String serviceName, String attributeName, String templateDN, int objType) throws AMException, SSOException, Exception {
        Set<Integer> values = null;
        AMTemplate template = this.getTemplate(serviceName, templateDN, objType);
        if (template != null && template.isExists()) {
            if (COS_PRIORITY_STRING.equals(attributeName)) {
                values = new HashSet();
                values.add(new Integer(template.getPriority()));
            } else {
                values = template.getAttribute(attributeName);
            }
        }
        return values == null ? Collections.EMPTY_SET : values;
    }

    protected Map getDynamicAttributes(String serviceName, Set names, String templateDN, int objType) throws AMException, SSOException, Exception {
        HashMap nameValues = null;
        AMTemplate template = this.getTemplate(serviceName, templateDN, objType);
        if (template != null && template.isExists()) {
            boolean getPriority = false;
            if (names.contains(COS_PRIORITY_STRING)) {
                getPriority = true;
                names.remove(COS_PRIORITY_STRING);
            }
            nameValues = template.getAttributes(names);
            if (getPriority) {
                if (nameValues.isEmpty()) {
                    nameValues = new HashMap(1);
                }
                HashSet<Integer> values = new HashSet<Integer>();
                values.add(new Integer(template.getPriority()));
                nameValues.put(COS_PRIORITY_STRING, values);
                names.add(COS_PRIORITY_STRING);
            }
        }
        return nameValues == null ? Collections.EMPTY_MAP : nameValues;
    }

    protected Set getUserAttribute(String attributeName, String userDN) throws AMException, SSOException {
        Set values = null;
        AMUser user = this.amsc.getUser(userDN);
        values = user.getAttribute(attributeName);
        return values == null ? Collections.EMPTY_SET : values;
    }

    protected Map getUserAttributes(Set names, String userDN) throws AMException, SSOException {
        Map nameValues = null;
        AMUser user = this.amsc.getUser(userDN);
        nameValues = user.getAttributes(names);
        return nameValues == null ? Collections.EMPTY_MAP : nameValues;
    }

    protected void setGlobalAttribute(String serviceName, String attributeName, Set values) throws SSOException, SMSException {
        ServiceSchemaManager svcMgr = new ServiceSchemaManager(serviceName, this.token);
        ServiceSchema svcSchema = svcMgr.getGlobalSchema();
        AttributeSchema attrSchema = svcSchema.getAttributeSchema(attributeName);
        attrSchema.setDefaultValues(values);
    }

    protected void setGlobalAttributes(String serviceName, Map nameValues) throws SSOException, SMSException {
        ServiceSchemaManager svcMgr = new ServiceSchemaManager(serviceName, this.token);
        ServiceSchema svcSchema = svcMgr.getGlobalSchema();
        svcSchema.setAttributeDefaults(nameValues);
    }

    protected void addGlobalAttributeValue(String serviceName, String attributeName, Set values) throws SSOException, SMSException {
        ServiceSchemaManager svcMgr = new ServiceSchemaManager(serviceName, this.token);
        ServiceSchema svcSchema = svcMgr.getGlobalSchema();
        AttributeSchema attrSchema = svcSchema.getAttributeSchema(attributeName);
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            attrSchema.addDefaultValue((String)iter.next());
        }
    }

    protected void removeGlobalAttributeValue(String serviceName, String attributeName, Set values) throws SSOException, SMSException {
        ServiceSchemaManager svcMgr = new ServiceSchemaManager(serviceName, this.token);
        ServiceSchema svcSchema = svcMgr.getGlobalSchema();
        AttributeSchema attrSchema = svcSchema.getAttributeSchema(attributeName);
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            attrSchema.removeDefaultValue((String)iter.next());
        }
    }

    protected void setDefaultOrgAttribute(String serviceName, String attributeName, Set values) throws SSOException, SMSException {
        ServiceSchemaManager svcMgr = new ServiceSchemaManager(serviceName, this.token);
        ServiceSchema svcSchema = svcMgr.getOrganizationSchema();
        AttributeSchema attrSchema = svcSchema.getAttributeSchema(attributeName);
        attrSchema.setDefaultValues(values);
    }

    protected void setDefaultOrgAttributes(String serviceName, Map nameValues) throws SSOException, SMSException {
        ServiceSchemaManager svcMgr = new ServiceSchemaManager(serviceName, this.token);
        ServiceSchema svcSchema = svcMgr.getOrganizationSchema();
        svcSchema.setAttributeDefaults(nameValues);
    }

    protected void addDefaultOrgAttributeValue(String serviceName, String attributeName, Set values) throws SSOException, SMSException {
        ServiceSchemaManager svcMgr = new ServiceSchemaManager(serviceName, this.token);
        ServiceSchema svcSchema = svcMgr.getOrganizationSchema();
        AttributeSchema attrSchema = svcSchema.getAttributeSchema(attributeName);
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            attrSchema.addDefaultValue((String)iter.next());
        }
    }

    protected void removeDefaultOrgAttributeValue(String serviceName, String attributeName, Set values) throws SSOException, SMSException {
        ServiceSchemaManager svcMgr = new ServiceSchemaManager(serviceName, this.token);
        ServiceSchema svcSchema = svcMgr.getOrganizationSchema();
        AttributeSchema attrSchema = svcSchema.getAttributeSchema(attributeName);
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            attrSchema.removeDefaultValue((String)iter.next());
        }
    }

    protected void setOrgAttribute(String serviceName, String attributeName, Set values, String orgDN) throws SSOException, AMException {
        AMOrganization org = this.amsc.getOrganization(orgDN);
        AMTemplate template = org.getTemplate(serviceName, 302);
        HashMap<String, Set> map = new HashMap<String, Set>();
        map.put(attributeName, values);
        template.setAttributes(map);
        template.store();
    }

    protected void setOrgAttributes(String serviceName, Map nameValues, String orgDN) throws SSOException, AMException {
        AMOrganization org = this.amsc.getOrganization(orgDN);
        AMTemplate template = org.getTemplate(serviceName, 302);
        template.setAttributes(nameValues);
        template.store();
    }

    protected void addOrgAttributeValue(String serviceName, String attributeName, Set values, String orgDN) throws SSOException, AMException {
        Set oldValues = this.getOrgAttribute(serviceName, attributeName, orgDN);
        values.addAll(oldValues);
        this.setOrgAttribute(serviceName, attributeName, values, orgDN);
    }

    protected void removeOrgAttributeValue(String serviceName, String attributeName, Set values, String orgDN) throws SSOException, AMException {
        Set oldValues = this.getOrgAttribute(serviceName, attributeName, orgDN);
        oldValues.removeAll(values);
        this.setOrgAttribute(serviceName, attributeName, oldValues, orgDN);
    }

    protected void setDefaultDynamicAttribute(String serviceName, String attributeName, Set values) throws SMSException, SSOException {
        ServiceSchemaManager svcMgr = new ServiceSchemaManager(serviceName, this.token);
        ServiceSchema svcSchema = svcMgr.getDynamicSchema();
        AttributeSchema attrSchema = svcSchema.getAttributeSchema(attributeName);
        attrSchema.setDefaultValues(values);
    }

    protected void setDefaultDynamicAttributes(String serviceName, Map nameValues) throws SMSException, SSOException {
        ServiceSchemaManager svcMgr = new ServiceSchemaManager(serviceName, this.token);
        ServiceSchema svcSchema = svcMgr.getDynamicSchema();
        svcSchema.setAttributeDefaults(nameValues);
    }

    protected void addDefaultDynamicAttributeValue(String serviceName, String attributeName, Set values) throws SMSException, SSOException {
        ServiceSchemaManager svcMgr = new ServiceSchemaManager(serviceName, this.token);
        ServiceSchema svcSchema = svcMgr.getDynamicSchema();
        AttributeSchema attrSchema = svcSchema.getAttributeSchema(attributeName);
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            attrSchema.addDefaultValue((String)iter.next());
        }
    }

    protected void removeDefaultDynamicAttributeValue(String serviceName, String attributeName, Set values) throws SMSException, SSOException {
        ServiceSchemaManager svcMgr = new ServiceSchemaManager(serviceName, this.token);
        ServiceSchema svcSchema = svcMgr.getDynamicSchema();
        AttributeSchema attrSchema = svcSchema.getAttributeSchema(attributeName);
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            attrSchema.removeDefaultValue((String)iter.next());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setDynamicAttribute(String serviceName, String attributeName, Set values, String templateDN, int objType) throws SSOException, AMException, Exception {
        HashMap<String, Set> map = new HashMap<String, Set>();
        boolean setPriority = false;
        if (COS_PRIORITY_STRING.equals(attributeName)) {
            setPriority = true;
        } else {
            map.put(attributeName, values);
        }
        AMTemplate template = this.getTemplate(serviceName, templateDN, objType);
        if (template != null && template.isExists()) {
            block8: {
                if (setPriority && !values.isEmpty()) {
                    String pStr = (String)values.iterator().next();
                    int pri = -1;
                    try {
                        pri = Integer.parseInt(pStr);
                    }
                    catch (NumberFormatException nfe) {
                        throw new Exception(nfe);
                    }
                    if (pri >= 0 && pri <= 6) {
                        template.setPriority(pri);
                        break block8;
                    } else {
                        logger.log(Level.SEVERE, "Priority of template is not correct and hence can not set");
                        throw new Exception("Incorrect priority value. Not between 0 and 6.");
                    }
                }
                template.setAttributes(map);
            }
            template.store();
        }
    }

    private AMTemplate getTemplate(String serviceName, String templateDN, int objType) throws Exception {
        AMTemplate template = null;
        switch (objType) {
            case 2: {
                AMOrganization org = this.amsc.getOrganization(templateDN);
                template = org.getTemplate(serviceName, 301);
                if (template.isExists()) break;
                org.createTemplate(301, serviceName, null);
                break;
            }
            case 6: {
                AMRole amrole = this.amsc.getRole(templateDN);
                template = amrole.getTemplate(serviceName, 301);
                if (template.isExists()) break;
                amrole.createTemplate(301, serviceName, null);
                break;
            }
            case 8: {
                AMFilteredRole amFRole = this.amsc.getFilteredRole(templateDN);
                template = amFRole.getTemplate(serviceName, 301);
                if (template.isExists()) break;
                amFRole.createTemplate(301, serviceName, null);
                break;
            }
            default: {
                logger.log(Level.SEVERE, "Not recognizable AMObject type. Could not determine the type of the node.");
                throw new Exception("Unknown node.");
            }
        }
        return template;
    }

    protected void setDynamicAttributes(String serviceName, Map nameValues, String templateDN, int objType) throws SSOException, AMException, Exception {
        AMTemplate template;
        boolean setPriority = false;
        Set values = Collections.EMPTY_SET;
        if (nameValues.containsKey(COS_PRIORITY_STRING)) {
            setPriority = true;
            values = (Set)nameValues.remove(COS_PRIORITY_STRING);
        }
        if ((template = this.getTemplate(serviceName, templateDN, objType)) != null && template.isExists()) {
            if (setPriority && !values.isEmpty()) {
                String pStr = (String)values.iterator().next();
                int pri = -1;
                try {
                    pri = Integer.parseInt(pStr);
                }
                catch (NumberFormatException nfe) {
                    throw new Exception(nfe);
                }
                if (pri >= 0 && pri <= 6) {
                    template.setPriority(pri);
                } else {
                    logger.log(Level.FINE, "Priority of template is not correct and hence can not set. Ignored");
                }
            }
            if (!nameValues.isEmpty()) {
                template.setAttributes(nameValues);
            }
            template.store();
        }
    }

    protected void addDynamicAttributeValue(String serviceName, String attributeName, Set values, String templateDN, int objType) throws SSOException, AMException, Exception {
        Set oldValues = this.getDynamicAttribute(serviceName, attributeName, templateDN, objType);
        values.addAll(oldValues);
        this.setDynamicAttribute(serviceName, attributeName, values, templateDN, objType);
    }

    protected void removeDynamicAttributeValue(String serviceName, String attributeName, Set values, String templateDN, int objType) throws SSOException, AMException, Exception {
        Set oldValues = this.getDynamicAttribute(serviceName, attributeName, templateDN, objType);
        oldValues.removeAll(values);
        this.setDynamicAttribute(serviceName, attributeName, oldValues, templateDN, objType);
    }

    protected void setUserAttribute(String attributeName, Set values, String userDN) throws AMException, SSOException {
        AMUser user = this.amsc.getUser(userDN);
        HashMap<String, Set> map = new HashMap<String, Set>();
        map.put(attributeName, values);
        user.setAttributes(map);
        user.store();
    }

    protected void setUserAttributes(Map nameValues, String userDN) throws AMException, SSOException {
        AMUser user = this.amsc.getUser(userDN);
        user.setAttributes(nameValues);
        user.store();
    }

    protected void addUserAttributeValue(String attributeName, Set values, String userDN) throws AMException, SSOException {
        Set oldValues = this.getUserAttribute(attributeName, userDN);
        values.addAll(oldValues);
        this.setUserAttribute(attributeName, values, userDN);
    }

    protected void removeUserAttributeValue(String attributeName, Set values, String userDN) throws AMException, SSOException {
        Set oldValues = this.getUserAttribute(attributeName, userDN);
        oldValues.removeAll(values);
        this.setUserAttribute(attributeName, oldValues, userDN);
    }

    protected void inherit(String attributeName, String userDN) throws AMException, SSOException {
        AMUser user = this.amsc.getUser(userDN);
        HashSet<String> set = new HashSet<String>();
        set.add(attributeName);
        user.removeAttributes(set);
        user.store();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

