/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.comm.url;

import com.sun.comclient.calendar.CalendarComponentException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.OperationNotSupportedException;
import com.sun.comclient.calendar.VEvent;
import com.sun.comclient.calendar.VTodo;
import com.sun.portal.comm.url.ABURL;
import com.sun.portal.comm.url.CalURL;
import com.sun.portal.comm.url.MailURL;
import com.sun.portal.comm.url.URLBuilder;
import com.sun.ssoadapter.SSOAdapter;
import javax.mail.Address;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.UIDFolder;

public class UWCURLBuilder
extends URLBuilder
implements MailURL,
CalURL,
ABURL {
    private String contexturi = null;
    private String calid = null;

    public void init(SSOAdapter ssoAdapter) {
        super.init(ssoAdapter);
        this.contexturi = this.adapterProperties.getProperty("uwcContext");
        if (this.contexturi == null) {
            this.setPath("?argv=laurel=on&argv=cal=1");
        } else {
            this.setPath(this.contexturi);
        }
    }

    public boolean allowsMessageURL() {
        return true;
    }

    public String getMessageURL(Message message) {
        if (message == null) {
            return this.getStartURL();
        }
        StringBuffer returnURL = new StringBuffer(this.getBaseURL());
        String lang = this.getLocale().getLanguage();
        Folder folder = message.getFolder();
        returnURL.append("/");
        returnURL.append("?argv=laurel=on&argv=mbox=");
        returnURL.append(this.encode(message.getFolder().getFullName()));
        returnURL.append("&argv=msg=");
        try {
            returnURL.append(((UIDFolder)folder).getUID(message));
        }
        catch (MessagingException me) {
            return this.getStartURL();
        }
        returnURL.append("&argv=cal=1");
        return returnURL.toString();
    }

    public boolean allowsComposeURL() {
        return true;
    }

    public String getComposeURL(String subject, Address[] to, Address[] cc, Address[] bcc) {
        StringBuffer returnURL = new StringBuffer(this.getBaseURL());
        returnURL.append(this.contexturi);
        returnURL.append("/?argv=view=compose&argv=laurel=on");
        return returnURL.toString();
    }

    public boolean allowsViewURL() {
        return true;
    }

    public String getViewURL(String view, String date) {
        StringBuffer returnURL = new StringBuffer(this.getBaseURL());
        returnURL.append("/").append(this.contexturi);
        return returnURL.toString();
    }

    public boolean allowsTaskURL() {
        return true;
    }

    public String getTaskURL(Object task) {
        VTodo vtask = (VTodo)task;
        StringBuffer taskURL = new StringBuffer(this.getBaseURL());
        String calid = this.getCalendarToView();
        String taskid = null;
        DateTime recurrenceDateTime = null;
        try {
            if (vtask != null) {
                taskid = vtask.getID();
                recurrenceDateTime = vtask.getRecurrenceID();
                taskURL.append("/").append(this.contexturi).append("/calclient/ViewTaskData").append("?todoUid=" + taskid).append("&calid=" + calid);
                if (vtask.isRecurring() && recurrenceDateTime != null) {
                    taskURL.append("&rid=" + recurrenceDateTime.toISO8601());
                }
            }
        }
        catch (OperationNotSupportedException onse) {
        }
        catch (CalendarComponentException cce) {
            // empty catch block
        }
        return taskURL.toString();
    }

    public boolean allowsEventURL() {
        return true;
    }

    public String getEventURL(Object event) {
        VEvent vevent = (VEvent)event;
        StringBuffer eventURL = new StringBuffer(this.getBaseURL());
        String calid = this.getCalendarToView();
        String eventid = null;
        DateTime recurrenceDateTime = null;
        try {
            if (vevent != null) {
                eventid = vevent.getID();
                recurrenceDateTime = vevent.getRecurrenceID();
                eventURL.append("/").append(this.contexturi).append("/calclient/ViewEventData").append("?eventid=" + eventid).append("&calid=" + calid);
                if (vevent.isRecurring() && recurrenceDateTime != null) {
                    eventURL.append("&rid=" + recurrenceDateTime.toISO8601());
                }
            }
        }
        catch (OperationNotSupportedException onse) {
        }
        catch (CalendarComponentException cce) {
            // empty catch block
        }
        return eventURL.toString();
    }

    public void setCalid(String calid) {
        this.calid = calid;
    }

    public String getCalid() {
        return this.calid;
    }

    private String getCalendarToView() {
        StringBuffer cid = new StringBuffer();
        if (this.calid != null && this.calid.length() > 0) {
            return this.encode(this.calid);
        }
        if (this.user != null && this.user.length() > 0) {
            cid.append(this.encode(this.user));
            if (this.domain != null && this.domain.length() > 0) {
                cid.append("%40");
                cid.append(this.encode(this.domain));
            }
        }
        return cid.toString();
    }

    public boolean allowsContactURL() {
        return false;
    }

    public String getContactURL(Object contact) {
        return this.getStartURL();
    }

    public boolean allowsComposeEventURL() {
        return true;
    }

    public boolean allowsComposeTaskURL() {
        return true;
    }

    public String getComposeEventURL(DateTime time) {
        if (time == null) {
            time = new DateTime();
        }
        StringBuffer stBuff = new StringBuffer(this.getStartURL());
        stBuff.append("/calclient/EditEvent?category=All&viewctx=day&date=" + time.toISO8601());
        if (this.calid != null && this.calid.length() > 0) {
            stBuff.append("&caltype=calid&calid=" + this.calid);
        }
        return stBuff.toString();
    }

    public String getComposeTaskURL(DateTime time) {
        if (time == null) {
            time = new DateTime();
        }
        StringBuffer stBuff = new StringBuffer(this.getStartURL());
        stBuff.append("/calclient/NewTask?category=All&viewctx=day&date=" + time.toISO8601());
        if (this.calid != null && this.calid.length() > 0) {
            stBuff.append("&caltype=calid&calid=" + this.calid);
        }
        return stBuff.toString();
    }
}

