/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.comm.url;

import com.iplanet.am.sdk.AMException;
import com.iplanet.am.sdk.AMStoreConnection;
import com.iplanet.am.sdk.AMUser;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.ssoadapter.SSOAdapter;
import com.sun.ssoadapter.SSOAdapterException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;

public abstract class URLBuilder {
    protected Properties adapterProperties = null;
    protected String user = null;
    protected String password = null;
    protected String domain = null;
    protected boolean serverSSOEnabled = false;
    protected boolean useProxyAuth = false;
    protected String proxyAuthUid = null;
    protected String baseURL = null;
    protected String path = null;
    protected String encoding = null;
    protected SSOAdapter ssoAdapter = null;
    protected String debugid = null;

    public boolean allowsStartURL() {
        return true;
    }

    public String getStartURL() {
        String messageURL = this.baseURL;
        if (this.path != null && this.path.length() > 0) {
            messageURL = messageURL + this.path;
        }
        return messageURL;
    }

    public void init(SSOAdapter ssoAdapter) {
        this.ssoAdapter = ssoAdapter;
        this.adapterProperties = ssoAdapter.getProperties();
        this.initBaseURL();
        this.serverSSOEnabled = this.adapterProperties.getProperty("serverSSOEnabled", "").equalsIgnoreCase("true");
        if (!this.serverSSOEnabled) {
            this.initLogonProperties(ssoAdapter);
        }
        String adapterName = ssoAdapter.getName();
        try {
            SSOToken token = ssoAdapter.getSSOToken();
            this.debugid = token.getPrincipal().getName() + " ssoadapter=" + adapterName + " ";
        }
        catch (Exception e) {
            this.debugid = " ssoadapter=" + adapterName + " ";
        }
    }

    protected void initLogonProperties(SSOAdapter ssoAdapter) {
        String enableProxyAuth;
        if (this.adapterProperties == null) {
            this.adapterProperties = ssoAdapter.getProperties();
        }
        if ((enableProxyAuth = this.adapterProperties.getProperty("enableProxyAuth")) != null && enableProxyAuth.equals("true")) {
            this.useProxyAuth = true;
            this.user = this.adapterProperties.getProperty("proxyAdminUid");
            this.password = this.adapterProperties.getProperty("proxyAdminPassword");
            AMStoreConnection amsc = null;
            AMUser auser = null;
            String usrAttr = this.adapterProperties.getProperty("userAttribute", "uid");
            try {
                SSOToken ssotoken = ssoAdapter.getSSOToken();
                amsc = new AMStoreConnection(ssotoken);
                auser = amsc.getUser(ssotoken.getPrincipal().getName());
                this.proxyAuthUid = auser.getStringAttribute(usrAttr);
            }
            catch (SSOException ssoe) {
            }
            catch (AMException ame) {
            }
            catch (SSOAdapterException ssoae) {}
        } else {
            this.user = this.adapterProperties.getProperty("uid");
            this.password = this.adapterProperties.getProperty("password");
        }
        this.domain = this.adapterProperties.getProperty("domain");
    }

    protected void initBaseURL() {
        StringBuffer sb = new StringBuffer();
        String clientProtocol = this.adapterProperties.getProperty("clientProtocol", this.adapterProperties.getProperty("protocol", "http"));
        if (clientProtocol.equals("undef")) {
            clientProtocol = "http";
        }
        sb.append(clientProtocol);
        sb.append("://");
        String clientHost = this.adapterProperties.getProperty("clientHost", this.adapterProperties.getProperty("host", "nohostsetinpreferences"));
        sb.append(clientHost);
        sb.append(':');
        String clientPort = this.adapterProperties.getProperty("clientPort", this.adapterProperties.getProperty("port", "80"));
        sb.append(clientPort);
        this.baseURL = sb.toString();
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public void setPath(String path) {
        this.path = path != null && !path.equals("") && path.charAt(0) != '/' ? "/" + path : path;
    }

    public String getPath() {
        return this.path;
    }

    public boolean getServerSSOEnabled() {
        return this.serverSSOEnabled;
    }

    public void setServerSSOEnabled(boolean serverSSOEnabled) {
        this.serverSSOEnabled = serverSSOEnabled;
    }

    public Properties getAdapterProperties() {
        return this.adapterProperties;
    }

    public void setAdapterProperties(Properties adapterProperties) {
        this.adapterProperties = adapterProperties;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String encode(String text) {
        try {
            if (text != null) {
                return URLEncoder.encode(text, this.getEncoding());
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return text;
    }

    public Locale getLocale() {
        String userLocaleString = "en_US";
        SSOToken session = null;
        try {
            session = this.ssoAdapter.getSSOToken();
            if (session != null) {
                userLocaleString = session.getProperty("Locale");
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        StringTokenizer localeTokens = new StringTokenizer(userLocaleString, "_");
        String userLangString = localeTokens.hasMoreTokens() ? localeTokens.nextToken() : "";
        String userCountryString = localeTokens.hasMoreTokens() ? localeTokens.nextToken() : "";
        String userVariantString = localeTokens.hasMoreTokens() ? localeTokens.nextToken() : "";
        Locale userLocale = new Locale(userLangString, userCountryString, userVariantString);
        return userLocale;
    }
}

