/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.comm.url;

import com.sun.portal.comm.url.MailURL;
import com.sun.portal.comm.url.URLBuilder;
import com.sun.ssoadapter.SSOAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import javax.mail.Address;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.UIDFolder;

public class SunMailURLBuilder
extends URLBuilder
implements MailURL {
    protected String sid = null;

    public void init(SSOAdapter ssoAdapter) {
        super.init(ssoAdapter);
        if (!this.serverSSOEnabled) {
            this.getSession();
        }
    }

    public boolean isValidSession() {
        if (this.sid == null) {
            return false;
        }
        StringBuffer pageContent = new StringBuffer();
        StringBuffer urlstr = new StringBuffer(this.baseURL);
        urlstr.append("/mbox.msc?security=false&mbox=INBOX&start=0&count=0&date=false");
        urlstr.append("&sid=");
        urlstr.append(this.encode(this.sid));
        HttpURLConnection urlconn = null;
        try {
            URL url = new URL(urlstr.toString());
            urlconn = (HttpURLConnection)url.openConnection();
            urlconn.setInstanceFollowRedirects(false);
        }
        catch (IOException ioe) {
            return false;
        }
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(urlconn.getInputStream()));
            String inputLine = null;
            while ((inputLine = in.readLine()) != null) {
                pageContent.append(inputLine);
            }
            in.close();
        }
        catch (IOException ioe) {
            return false;
        }
        if (pageContent.indexOf("parent.timeoutCB()") > 0) {
            this.sid = null;
            return false;
        }
        return true;
    }

    public void getSession() {
        StringBuffer urlstr = new StringBuffer(this.baseURL);
        urlstr.append("/login.msc?");
        urlstr.append("password=");
        urlstr.append(this.encode(this.password));
        urlstr.append("&user=");
        urlstr.append(this.encode(this.user));
        if (this.useProxyAuth && this.proxyAuthUid != null && this.proxyAuthUid.length() > 0) {
            urlstr.append("&proxyauth=");
            urlstr.append(this.encode(this.proxyAuthUid));
        }
        if (this.domain != null && this.domain.length() > 0) {
            urlstr.append("%40");
            urlstr.append(this.encode(this.domain));
        }
        HttpURLConnection urlconn = null;
        try {
            URL url = new URL(urlstr.toString());
            urlconn = (HttpURLConnection)url.openConnection();
            urlconn.setInstanceFollowRedirects(false);
        }
        catch (MalformedURLException mfe) {
            return;
        }
        catch (IOException ioe) {
            return;
        }
        String location = urlconn.getHeaderField("Location");
        if (location != null) {
            int sessionIdBegin = 0;
            sessionIdBegin = location.indexOf("sid");
            if (sessionIdBegin < 0) {
                return;
            }
            this.setPath(location + "&view=portal");
            String inter = location.substring(sessionIdBegin + 4);
            int sessionIdEnd = inter.indexOf("&");
            this.sid = inter.substring(0, sessionIdEnd);
        }
    }

    public boolean allowsMessageURL() {
        return true;
    }

    public String getMessageURL(Message message) {
        if (message == null) {
            return this.getStartURL();
        }
        StringBuffer msgURL = new StringBuffer(this.getBaseURL());
        Folder folder = message.getFolder();
        if (this.getServerSSOEnabled()) {
            msgURL.append("/?argv=mbox=");
            msgURL.append(this.encode(message.getFolder().getFullName()));
            msgURL.append("&argv=msg=");
            try {
                msgURL.append(((UIDFolder)folder).getUID(message));
            }
            catch (MessagingException me) {
                return this.getStartURL();
            }
        }
        msgURL.append(this.getPath());
        msgURL.append("&mbox=");
        msgURL.append(this.encode(message.getFolder().getFullName()));
        msgURL.append("&msg=");
        try {
            msgURL.append(((UIDFolder)folder).getUID(message));
        }
        catch (MessagingException me) {
            return this.getStartURL();
        }
        return msgURL.toString();
    }

    public boolean allowsComposeURL() {
        return false;
    }

    public String getComposeURL(String subject, Address[] to, Address[] cc, Address[] bcc) {
        return this.getStartURL();
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }
}

