/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.comm.url;

import com.sun.comclient.calendar.CalendarStoreException;
import com.sun.comclient.calendar.DateTime;
import com.sun.comclient.calendar.socs.SOCSCalendarStore;
import com.sun.comclient.calendar.socs.SOCSEvent;
import com.sun.comclient.calendar.socs.SOCSTodo;
import com.sun.portal.comm.url.CalURL;
import com.sun.portal.comm.url.URLBuilder;
import com.sun.ssoadapter.SSOAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class SunCalURLBuilder
extends URLBuilder
implements CalURL {
    protected String calid = null;
    protected String sid = null;

    public void init(SSOAdapter ssoAdapter) {
        super.init(ssoAdapter);
        if (!this.serverSSOEnabled) {
            this.getSession();
        }
    }

    public boolean isValidSession() {
        if (this.sid == null) {
            return false;
        }
        String vid = null;
        StringBuffer urlstr = new StringBuffer(this.baseURL);
        urlstr.append("/check_id.wcap?fmt-out=text%2Fxml&id=");
        urlstr.append(this.encode(this.sid));
        vid = this.pullDataFromURL(urlstr.toString(), "<X-NSCP-WCAP-CHECK-ID>", "</X-NSCP-WCAP-CHECK-ID>");
        return vid != null && vid.equals("1");
    }

    public void getSession() {
        String eprc = this.adapterProperties.getProperty("enablePerRequestConnection", "false");
        if (eprc.equals("true")) {
            if (this.useProxyAuth) {
                this.user = this.adapterProperties.getProperty("proxyAdminUid");
                this.password = this.adapterProperties.getProperty("proxyAdminPassword");
            }
            StringBuffer urlstr = new StringBuffer(this.baseURL);
            urlstr.append("/login.wcap?fmt-out=text%2Fxml&");
            urlstr.append("password=");
            urlstr.append(this.encode(this.password));
            urlstr.append("&user=");
            urlstr.append(this.encode(this.user));
            if (this.useProxyAuth && this.proxyAuthUid != null && this.proxyAuthUid.length() > 0) {
                urlstr.append("&proxyauth=");
                urlstr.append(this.encode(this.proxyAuthUid));
            }
            this.sid = this.pullDataFromURL(urlstr.toString(), "<X-NSCP-WCAP-SESSION-ID>", "</X-NSCP-WCAP-SESSION-ID>");
        } else {
            SOCSCalendarStore socsStore = (SOCSCalendarStore)this.ssoAdapter.getConnection();
            try {
                this.sid = socsStore.getSOCSSession().getID();
            }
            catch (CalendarStoreException cse) {
                return;
            }
        }
        StringBuffer pathBuf = new StringBuffer("/command.shtml?id=");
        if (this.sid != null) {
            pathBuf.append(this.encode(this.sid));
        }
        this.setPath(pathBuf.toString());
    }

    private String pullDataFromURL(String urlString, String startDelim, String endDelim) {
        String data = null;
        String line = null;
        BufferedReader in = null;
        URLConnection urlconn = null;
        URL url = null;
        try {
            url = new URL(urlString);
            urlconn = url.openConnection();
            urlconn.setDoInput(true);
            urlconn.setDoOutput(true);
            urlconn.setUseCaches(false);
            in = new BufferedReader(new InputStreamReader(urlconn.getInputStream()));
            while ((line = in.readLine()) != null) {
                if (line.indexOf(startDelim) == -1) continue;
                int start = line.indexOf(startDelim) + startDelim.length();
                int end = line.indexOf(endDelim);
                data = line.substring(start, end);
                break;
            }
            in.close();
        }
        catch (MalformedURLException mue) {
            return null;
        }
        catch (IOException ie) {
            return null;
        }
        return data;
    }

    public String getStartURL() {
        return this.getStartURLForComp() + "&view=overview";
    }

    private String getStartURLForComp() {
        StringBuffer messageURL = new StringBuffer(this.baseURL);
        if (this.path != null && this.path.length() > 0) {
            messageURL.append(this.path);
            if (this.calid != null && this.calid.length() > 0) {
                messageURL.append("&calid=");
                messageURL.append(this.encode(this.calid));
                if (this.domain != null && this.domain.length() > 0) {
                    messageURL.append("%40");
                    messageURL.append(this.encode(this.domain));
                }
            }
        }
        return messageURL.toString();
    }

    public void setCalid(String calid) {
        this.calid = calid;
    }

    public String getCalid() {
        return this.calid;
    }

    public boolean allowsViewURL() {
        return false;
    }

    public String getViewURL(String view, String date) {
        return this.getStartURL();
    }

    public boolean allowsTaskURL() {
        return true;
    }

    public String getTaskURL(Object task) {
        if (task != null && task instanceof SOCSTodo) {
            SOCSTodo todo = (SOCSTodo)task;
            StringBuffer sb = new StringBuffer(this.getStartURLForComp());
            sb.append("&view=new_task&uid=" + todo.getID());
            if (todo.isRecurring()) {
                sb.append("&rid=" + todo.getRecurrenceID().getTimeInMillis() / 1000L);
            } else {
                sb.append("&rid=0");
            }
            return sb.toString();
        }
        return this.getStartURL();
    }

    public boolean allowsEventURL() {
        return true;
    }

    public String getEventURL(Object event) {
        if (event != null) {
            if (event instanceof SOCSEvent) {
                SOCSEvent eventV = (SOCSEvent)event;
                StringBuffer sb = new StringBuffer(this.getStartURLForComp());
                sb.append("&view=new_event&uid=" + eventV.getID());
                if (eventV.isRecurring()) {
                    sb.append("&rid=" + eventV.getRecurrenceID().getTimeInMillis() / 1000L);
                } else {
                    sb.append("&rid=0");
                }
                return sb.toString();
            }
            return this.getStartURL();
        }
        return this.getStartURL();
    }

    public boolean allowsComposeEventURL() {
        return false;
    }

    public boolean allowsComposeTaskURL() {
        return false;
    }

    public String getComposeEventURL(DateTime datetime) {
        return this.getStartURL();
    }

    public String getComposeTaskURL(DateTime datetime) {
        return this.getStartURL();
    }
}

