/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.comm.url;

import com.sun.portal.comm.url.ABURL;
import com.sun.portal.comm.url.URLBuilder;
import com.sun.ssoadapter.SSOAdapter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class SunABURLBuilder
extends URLBuilder
implements ABURL {
    protected String sid = null;

    public void init(SSOAdapter ssoAdapter) {
        super.init(ssoAdapter);
        if (!this.serverSSOEnabled) {
            this.getSession();
        }
    }

    public boolean isValidSession() {
        if (this.sid == null) {
            return false;
        }
        StringBuffer pageContent = new StringBuffer();
        StringBuffer urlstr = new StringBuffer(this.baseURL);
        urlstr.append("/mbox.msc?security=false&mbox=INBOX&start=0&count=0&date=false");
        urlstr.append("&sid=");
        urlstr.append(this.encode(this.sid));
        HttpURLConnection urlconn = null;
        try {
            URL url = new URL(urlstr.toString());
            urlconn = (HttpURLConnection)url.openConnection();
            urlconn.setInstanceFollowRedirects(false);
            BufferedReader in = new BufferedReader(new InputStreamReader(urlconn.getInputStream()));
            String inputLine = null;
            while ((inputLine = in.readLine()) != null) {
                pageContent.append(inputLine);
            }
            in.close();
        }
        catch (IOException ioe) {
            return false;
        }
        if (pageContent.indexOf("parent.timeoutCB()") > 0) {
            this.sid = null;
            return false;
        }
        return true;
    }

    public void getSession() {
        StringBuffer urlstr = new StringBuffer(this.baseURL);
        urlstr.append("/login.msc?");
        urlstr.append("password=");
        urlstr.append(this.encode(this.password));
        urlstr.append("&user=");
        urlstr.append(this.encode(this.user));
        if (this.useProxyAuth && this.proxyAuthUid != null && this.proxyAuthUid.length() > 0) {
            urlstr.append("&proxyauth=");
            urlstr.append(this.encode(this.proxyAuthUid));
        }
        if (this.domain != null && this.domain.length() > 0) {
            urlstr.append("%40");
            urlstr.append(this.encode(this.domain));
        }
        HttpURLConnection urlconn = null;
        try {
            URL url = new URL(urlstr.toString());
            urlconn = (HttpURLConnection)url.openConnection();
            urlconn.setInstanceFollowRedirects(false);
        }
        catch (MalformedURLException mfe) {
            return;
        }
        catch (IOException ioe) {
            return;
        }
        String location = urlconn.getHeaderField("Location");
        if (location != null) {
            int sessionIdBegin = 0;
            sessionIdBegin = location.indexOf("sid");
            if (sessionIdBegin < 0) {
                return;
            }
            this.setPath(location + "&view=portal");
            String inter = location.substring(sessionIdBegin + 4);
            int sessionIdEnd = inter.indexOf("&");
            this.sid = inter.substring(0, sessionIdEnd);
        }
    }

    public boolean allowsContactURL() {
        return false;
    }

    public String getContactURL(Object contact) {
        return this.getStartURL();
    }

    public String getSid() {
        return this.sid;
    }

    public void setSid(String sid) {
        this.sid = sid;
    }
}

