/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.comm.url;

import com.sun.portal.comm.url.MailURL;
import com.sun.portal.comm.url.URLBuilder;
import com.sun.ssoadapter.SSOAdapter;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;

public class ExchangeMailURLBuilder
extends URLBuilder
implements MailURL {
    public void init(SSOAdapter ssoAdapter) {
        super.init(ssoAdapter);
        this.setPath(this.adapterProperties.getProperty("exchangeContextPath", "/exchange"));
    }

    public String getStartURL() {
        StringBuffer startURL = new StringBuffer(this.getBaseURL());
        startURL.append(this.getPath());
        String exchangeOperation = this.adapterProperties.getProperty("exchangeOperation");
        if (exchangeOperation != null) {
            startURL.append('/');
            startURL.append(this.encode(this.user));
            startURL.append('/');
            startURL.append(this.encode(exchangeOperation));
        }
        return startURL.toString();
    }

    public boolean allowsMessageURL() {
        return true;
    }

    public String getMessageURL(Message message) {
        StringBuffer result = new StringBuffer(this.getStartURL());
        result.append("/");
        result.append(this.encode(this.user));
        result.append("/");
        result.append(message.getFolder());
        result.append("/");
        try {
            result.append(ExchangeMailURLBuilder.encodec(this.changeSubjectToURL(message.getSubject())));
        }
        catch (MessagingException ex) {
            ex.printStackTrace();
        }
        result.append(".EML?Cmd=open");
        return result.toString();
    }

    public boolean allowsComposeURL() {
        return false;
    }

    public String getComposeURL(String subject, Address[] to, Address[] cc, Address[] bcc) {
        return this.getStartURL();
    }

    private String changeSubjectToURL(String subject) {
        if (subject == null) {
            return "No Subject";
        }
        if (subject.startsWith("Canceled:")) {
            return subject.substring(9).trim();
        }
        return subject.trim();
    }

    private static String encodec(String text) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == ' ') {
                result.append("%20");
                continue;
            }
            result.append(ch);
        }
        return result.toString();
    }
}

