/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.AdminBaseCommand;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.util.AdminClientUtil;
import java.io.File;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class VersionCommand
extends AdminBaseCommand {
    static final String fs = File.separator;
    private String jarFullPath;
    private static final String OPT_PATCHES = "patches";
    private static final String OPT_VERBOSE = "verbose";
    private static final String OPT_DISPLAY = "display";
    private static final String OPT_JARFILE = "jar";

    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void validateJar() throws CommandException {
        String jarFilePath = this.getOption(OPT_JARFILE);
        if (jarFilePath != null) {
            File f = new File(jarFilePath);
            this.jarFullPath = f.getAbsolutePath();
            if (!f.exists()) {
                Object[] token = new String[]{this.jarFullPath};
                throw new CommandException(this.getLocalizedString("error.psadmin.file.not.found", token));
            }
        }
    }

    public void runCommand() throws CommandException, CommandValidationException {
        block13: {
            this.validateOptions();
            this.validateJar();
            String operation = "";
            try {
                MBeanServerConnection msc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
                Boolean patch = new Boolean(this.getBooleanOption(OPT_PATCHES));
                Boolean patchVerbose = new Boolean(this.getBooleanOption(OPT_VERBOSE));
                Boolean display = new Boolean(this.getBooleanOption(OPT_DISPLAY));
                Object[] params = new Object[]{display, this.jarFullPath, patch, patchVerbose};
                String[] signature = new String[]{"java.lang.Boolean", "java.lang.String", "java.lang.Boolean", "java.lang.Boolean"};
                operation = "getPortalVersion";
                ObjectName objName = AdminClientUtil.getPortalDomainMBeanObjectName((String)this.getDomainId());
                String out = (String)msc.invoke(objName, operation, params, signature);
                CLILogger.getInstance().printMessage(out);
            }
            catch (InstanceNotFoundException ie) {
                logger.log(Level.SEVERE, "PSALI_CSPACC0005", ie);
                throw new CommandException(this.getLocalizedString("error.psadmin.mbean.instance.not.found", new Object[]{operation}), (Throwable)ie);
            }
            catch (MBeanException me) {
                logger.log(Level.SEVERE, "PSALI_CSPACC0006", me);
                boolean isPE = me.getCause() instanceof PSMBeanException;
                if (isPE) {
                    PSMBeanException pe = (PSMBeanException)me.getCause();
                    String key = null;
                    Object[] tokens = pe.getTokens();
                    if (pe.getErrorKey() != null) {
                        key = pe.getErrorKey();
                        CLILogger.getInstance().printMessage(this.getLocalizedString(key, tokens));
                        break block13;
                    }
                    throw new CommandException(this.getLocalizedString("error.psadmin.jmx.invoke", new Object[]{operation}), (Throwable)pe);
                }
                throw new CommandException(this.getLocalizedString("error.psadmin.jmx.invoke", new Object[]{operation}), (Throwable)me);
            }
            catch (ReflectionException re) {
                logger.log(Level.SEVERE, "PSALI_CSPACC0007", re);
                throw new CommandException(this.getLocalizedString("error.psadmin.mbean.reflection.error", new Object[]{operation}), (Throwable)re);
            }
            catch (MalformedObjectNameException mle) {
                logger.log(Level.SEVERE, "PSALI_CSPACC0004", mle);
                throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), (Throwable)mle);
            }
            catch (CommandException ce) {
                logger.log(Level.SEVERE, "PSALI_CSPACC0008", ce);
                throw ce;
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "PSALI_CSPACC0010", ex);
                throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), (Throwable)ex);
            }
            finally {
                this.closeMBeanServerConnection();
            }
        }
    }
}

