/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.AdminBaseCommand;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.util.AdminUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.logging.Level;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class SetDomainRepositoryPasswordCommand
extends AdminBaseCommand {
    private String password = null;

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        this.validateOperands();
        CLILogger cliLogger = CLILogger.getInstance();
        MBeanServerConnection serverConnection = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
        try {
            ObjectName objectName = AdminUtil.getPortalDomainMBeanObjectName((String)"defaultDomain");
            Attribute attribute = new Attribute("DomainRepositoryPassword", this.password);
            serverConnection.setAttribute(objectName, attribute);
        }
        catch (MalformedObjectNameException e) {
            this.log(Level.SEVERE, "PSALI_CSPACC0004", e);
            throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), (Throwable)e);
        }
        catch (InstanceNotFoundException e) {
            this.log(Level.SEVERE, "PSALI_CSPACC0005", e);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.instance.not.found", new Object[]{"setAttribute:DomainRepositoryPassword"}), (Throwable)e);
        }
        catch (AttributeNotFoundException e) {
            this.log(Level.SEVERE, "PSALI_CSPACC0014", e);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.attribute.not.found", new Object[]{"DomainRepositoryPassword"}), (Throwable)e);
        }
        catch (InvalidAttributeValueException e) {
            this.log(Level.SEVERE, "PSALI_CSPACC0015", e);
            throw new CommandException(this.getLocalizedString("error.psadmin.invalid.attribute.value"), (Throwable)e);
        }
        catch (MBeanException e) {
            this.log(Level.SEVERE, "PSALI_CSPACC0006", e);
            String key = "error.psadmin.jmx.invoke";
            Exception targetException = e.getTargetException();
            if (targetException instanceof PSMBeanException) {
                String message;
                if (this.getBooleanOption("debug") && (message = targetException.getMessage()) != null) {
                    cliLogger.printMessage(message);
                }
                key = ((PSMBeanException)targetException).getErrorKey();
            }
            throw new CommandException(this.getLocalizedString(key), (Throwable)e);
        }
        catch (ReflectionException e) {
            this.log(Level.SEVERE, "PSALI_CSPACC0007", e);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.reflection.error", new Object[]{"setAttribute:DomainRepositoryPassword"}), (Throwable)e);
        }
        catch (IOException e) {
            this.log(Level.SEVERE, "PSALI_CSPACC0003", e);
            throw new CommandException(this.getLocalizedString("error.psadmin.io.error"), (Throwable)e);
        }
        catch (Exception e) {
            this.log(Level.SEVERE, "PSALI_CSPACC0010", e);
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), (Throwable)e);
        }
        finally {
            this.closeMBeanServerConnection();
        }
    }

    private void validateOperands() throws CommandException {
        String fileName = (String)this.getOperands().firstElement();
        File file = new File(fileName);
        if (!file.exists() || !file.canRead()) {
            throw new CommandException(this.getLocalizedString("error.psadmin.password.file.not.exist.or.not.readable"));
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0) {
                    this.password = line;
                    break;
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            this.log(Level.SEVERE, e.getMessage(), e);
            throw new CommandException(this.getLocalizedString("error.psadmin.password.read.error"));
        }
    }

    private final void log(Level level, String message, Throwable t) {
        if (logger.isLoggable(level)) {
            logger.log(level, message, t);
        }
    }
}

