/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.GenericCommand;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.util.AdminUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class SetAttributeCommand
extends GenericCommand {
    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException(this.getLocalizedString("error.psadmin.option.validation.failed"));
        }
        String portalId = this.getOption("portal");
        if (portalId != null) {
            this.validatePortalId();
        }
        String operation = "";
        try {
            List optValues;
            String component = this.getOption("component");
            List values = null;
            Vector v = this.getOperands();
            values = v == null || v.isEmpty() ? Collections.EMPTY_LIST : this.getMultiValueFromString((String)v.firstElement());
            this.validateSetOptions(values, this.getOptions(), component);
            MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            ObjectName objectName = portalId == null ? AdminUtil.getPortalDomainMBeanObjectName((String)this.getDomainId()) : AdminUtil.getPortalMBeanObjectName((String)this.getDomainId(), (String)portalId);
            HashMap optMap = this.getOptions();
            if (optMap.containsKey("add")) {
                optValues = this.getMultiValueOption("add");
                optMap.remove("add");
                optMap.put("add", optValues);
            }
            if (optMap.containsKey("remove")) {
                optValues = this.getMultiValueOption("remove");
                optMap.remove("remove");
                optMap.put("remove", optValues);
            }
            optMap.put("operation", "set");
            Object[] params = new Object[]{values, optMap};
            String[] signature = new String[]{"java.util.List", "java.util.Map"};
            operation = "setAttribute";
            mbsc.invoke(objectName, operation, params, signature);
        }
        catch (InstanceNotFoundException ie) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0005", ie);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.instance.not.found", new Object[]{operation}), (Throwable)ie);
        }
        catch (MBeanException me) {
            String dbgMsg;
            logger.log(Level.SEVERE, "PSALI_CSPACC0006", me);
            boolean psmbe = me.getCause() instanceof PSMBeanException;
            if (this.getBooleanOption("debug") && psmbe && (dbgMsg = me.getCause().getMessage()) != null) {
                CLILogger.getInstance().printMessage(dbgMsg);
            }
            if (psmbe) {
                throw new CommandException(this.getLocalizedString(((PSMBeanException)me.getCause()).getErrorKey()), (Throwable)me);
            }
            throw new CommandException(this.getLocalizedString("error.psadmin.jmx.invoke"), (Throwable)me);
        }
        catch (ReflectionException re) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0007", re);
            throw new CommandException(this.getLocalizedString("error.psadmin.jmx.invoke"), (Throwable)re);
        }
        catch (CommandException ce) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0008", ce);
            throw ce;
        }
        catch (CommandValidationException cve) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0013", cve);
            throw cve;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0010", ex);
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), (Throwable)ex);
        }
        finally {
            this.closeMBeanServerConnection();
        }
    }

    private void validateSetOptions(List values, Map optionsMap, String component) throws CommandValidationException {
        this.validateBasicOptions(optionsMap);
        this.validateBasicSetOptions(values, optionsMap);
        if ("desktop".equals(component)) {
            this.validateDesktopOptions(optionsMap);
        } else if ("subscriptions".equals(component)) {
            this.validateSubscriptionsOptions(optionsMap);
        }
    }

    private void validateBasicOptions(Map optionsMap) throws CommandValidationException {
        boolean global = Boolean.valueOf((String)optionsMap.get("global"));
        boolean org = Boolean.valueOf((String)optionsMap.get("org"));
        boolean dn = optionsMap.containsKey("dn");
        if (global && (org || dn)) {
            throw new CommandValidationException(this.getLocalizedString("error.psadmin.validation.combination.1"));
        }
    }

    private void validateBasicSetOptions(List values, Map optionsMap) throws CommandValidationException {
        boolean inherit = Boolean.valueOf((String)optionsMap.get("inherit"));
        boolean add = optionsMap.containsKey("add");
        boolean remove = optionsMap.containsKey("remove");
        boolean dn = optionsMap.containsKey("dn");
        if (inherit) {
            if (add || remove || values.size() != 0) {
                throw new CommandValidationException(this.getLocalizedString("error.psadmin.validation.combination.2"));
            }
            if (!dn) {
                throw new CommandValidationException(this.getLocalizedString("error.psadmin.validation.combination.6"));
            }
        } else if (add || remove) {
            if (inherit || !values.isEmpty()) {
                throw new CommandValidationException(this.getLocalizedString("error.psadmin.validation.combination.3"));
            }
        } else if (values.size() == 1) {
            if (inherit || add || remove) {
                throw new CommandValidationException(this.getLocalizedString("error.psadmin.validation.combination.4"));
            }
        } else if (values.isEmpty() && !inherit && !add && !remove) {
            throw new CommandValidationException(this.getLocalizedString("error.psadmin.validation.combination.5"));
        }
    }

    private void validateDesktopOptions(Map map) throws CommandValidationException {
        String portalId = this.getOption("portal");
        if (portalId == null) {
            throw new CommandValidationException(this.getLocalizedString("error.psadmin.portalid.not.specified"));
        }
        boolean org = Boolean.valueOf((String)map.get("org"));
        if (org) {
            throw new CommandValidationException(this.getLocalizedString("error.psadmin.org.option.not.valid.for.desktop"));
        }
    }

    private void validateSubscriptionsOptions(Map map) throws CommandValidationException {
        String portalId = this.getOption("portal");
        if (portalId == null) {
            throw new CommandValidationException(this.getLocalizedString("error.psadmin.portalid.not.specified"));
        }
    }
}

