/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.AdminBaseCommand;
import com.sun.portal.admin.common.util.AdminClientUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ScheduleTasksCommand
extends AdminBaseCommand {
    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        String operation = "";
        try {
            LinkedList<String> path = new LinkedList<String>();
            path.addFirst("defaultDomain");
            path.addFirst("scheduler");
            ObjectName on = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain.Scheduler", path);
            Object[] params = new Object[]{this.getActions()};
            String[] signatures = new String[]{"java.util.List"};
            operation = "schedule";
            MBeanServerConnection msc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            msc.invoke(on, operation, params, signatures);
        }
        catch (InstanceNotFoundException ie) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0005", ie);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.instance.not.found", new Object[]{operation}), (Throwable)ie);
        }
        catch (MBeanException me) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0006", me);
            throw new CommandException(this.getLocalizedString("error.psadmin.jmx.invoke", new Object[]{operation}), (Throwable)me);
        }
        catch (ReflectionException re) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0007", re);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.reflection.error", new Object[]{operation}), (Throwable)re);
        }
        catch (MalformedObjectNameException mle) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0004", mle);
            throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), (Throwable)mle);
        }
        catch (CommandException ce) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0008", ce);
            throw ce;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0010", e);
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), (Throwable)e);
        }
        finally {
            this.closeMBeanServerConnection();
        }
    }

    private List getActions() {
        ArrayList<String> actions = new ArrayList<String>();
        try {
            String commandFile = this.getOption("commandfile");
            if (commandFile != null) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(commandFile));
                while ((line = br.readLine()) != null) {
                    actions.add(line);
                }
                br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return actions;
    }
}

