/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.AdminBaseCommand;
import com.sun.portal.admin.common.util.AdminClientUtil;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class RedeployCommand
extends AdminBaseCommand {
    public static final String OPT_ALLWEBAPPS = "allwebapps";
    public static final String ATTR_PORTALURI = "PortalWebAppUri";

    public void runCommand() throws CommandException, CommandValidationException {
        String instanceId = this.getInstanceId();
        this.validateOptions();
        this.validatePortalId();
        if (instanceId != null) {
            this.validateInstance();
        }
        String operation = "";
        try {
            MBeanServerConnection msc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            ObjectName pObjName = AdminClientUtil.getPortalMBeanObjectName((String)"defaultDomain", (String)this.getPortalId());
            Object[] params = new Object[]{};
            String[] signature = new String[]{};
            if (this.getBooleanOption(OPT_ALLWEBAPPS)) {
                Object[] iparams = new Object[]{};
                String[] isignature = new String[]{};
                operation = "undeployAllWebApps";
                msc.invoke(pObjName, operation, iparams, isignature);
                operation = "deployAllWebApps";
                msc.invoke(pObjName, operation, iparams, isignature);
            } else if (instanceId != null) {
                operation = "createPortalWebApp";
                String uri = (String)msc.invoke(pObjName, operation, params, signature);
                ObjectName objName = AdminClientUtil.getInstanceMBeanObjectName((String)"defaultDomain", (String)this.getPortalId(), (String)this.getInstanceId());
                Object[] iparams = new Object[]{uri};
                String[] isignature = new String[]{"java.lang.String"};
                operation = "undeploy";
                msc.invoke(objName, operation, iparams, isignature);
                operation = "deploy";
                msc.invoke(objName, operation, iparams, isignature);
            } else {
                Object[] iparams = new Object[]{};
                String[] isignature = new String[]{};
                operation = "undeployPortalWebApp";
                msc.invoke(pObjName, operation, iparams, isignature);
                operation = "deployPortalWebApp";
                msc.invoke(pObjName, operation, iparams, isignature);
            }
        }
        catch (InstanceNotFoundException ie) {
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.instance.not.found", new Object[]{operation}), (Throwable)ie);
        }
        catch (MBeanException me) {
            throw new CommandException(this.getLocalizedString("error.psadmin.jmx.invoke", new Object[]{operation}), (Throwable)me);
        }
        catch (ReflectionException re) {
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.reflection.error", new Object[]{operation}), (Throwable)re);
        }
        catch (MalformedObjectNameException mle) {
            throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), (Throwable)mle);
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception ex) {
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), (Throwable)ex);
        }
        finally {
            this.closeMBeanServerConnection();
        }
    }
}

