/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CLIDescriptorsReader;
import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CLITokenizer;
import com.sun.enterprise.cli.framework.Command;
import com.sun.enterprise.cli.framework.CommandEnvironment;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandFactory;
import com.sun.enterprise.cli.framework.CommandLineParser;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.CommandValidator;
import com.sun.enterprise.cli.framework.HelpException;
import com.sun.enterprise.cli.framework.InputsAndOutputs;
import com.sun.enterprise.cli.framework.ValidCommand;
import com.sun.portal.admin.cli.commands.AdminBaseCommand;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;

public class MultiProcessCommand
extends AdminBaseCommand {
    private static final String OPT_PRINTPROMPT = "printprompt";
    private static final String OPT_INPUT = "input";
    private static final String OPT_ECHO = "echo";
    private static final String OPT_ENCODING = "encoding";
    private static final String EXIT = "exit";
    private static final String ERROR_ON_LINE = "error.psadmin.multimode.errorOnLine";
    private boolean mDone = false;
    private boolean printPrompt = true;
    private final String kPromptString = this.getLocalizedString("psadmin.prompt");

    public boolean validateOptions() throws CommandValidationException {
        if (super.validateOptions()) {
            this.printPrompt = this.getBooleanOption(OPT_PRINTPROMPT);
            if (this.getBooleanOption(OPT_ECHO)) {
                CLILogger.getInstance().printMessage(this.toString());
            }
            return true;
        }
        return false;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        try {
            MBeanServerConnection mbs = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            System.setProperty("psadmin.multimode.running", "true");
        }
        catch (Exception e) {
            // empty catch block
        }
        String line = null;
        int lineNo = 0;
        try {
            if (this.isFileOptionSpecified()) {
                CLILogger.getInstance().printDebugMessage("file option specified");
                this.checkForFileExistence(null, this.getOption(OPT_INPUT));
                this.setInputStreamToFile();
            } else {
                this.printExitMessage();
            }
            line = this.printPromptAndReadLine();
            while (!this.isExitLine(line)) {
                ++lineNo;
                if (this.isExecutableLine(line)) {
                    this.processLine(line, lineNo);
                }
                line = this.printPromptAndReadLine();
            }
        }
        catch (CommandException ce) {
            System.setProperty("psadmin.multimode.running", "false");
            this.closeMBeanServerConnection();
            logger.log(Level.SEVERE, "PSALI_CSPACC0008", ce);
            throw ce;
        }
        catch (Exception e) {
            System.setProperty("psadmin.multimode.running", "false");
            this.closeMBeanServerConnection();
            logger.log(Level.SEVERE, "PSALI_CSPACC0010", e);
            throw new CommandException((Throwable)e);
        }
        System.setProperty("psadmin.multimode.running", "false");
        this.closeMBeanServerConnection();
    }

    private void printExitMessage() {
        CLILogger.getInstance().printMessage(this.getLocalizedString("ExitMessage"));
    }

    private String printPromptAndReadLine() throws CommandException {
        try {
            String line;
            if (this.printPrompt) {
                InputsAndOutputs.getInstance().getUserOutput().print(this.kPromptString);
            }
            if ((line = InputsAndOutputs.getInstance().getUserInput().getLine()) == null && this.isFileOptionSpecified()) {
                return EXIT;
            }
            return line;
        }
        catch (IOException ioe) {
            throw new CommandException(this.getLocalizedString("CouldNotPrintOrRead"), (Throwable)ioe);
        }
    }

    private boolean isExecutableLine(String line) {
        boolean isExecutable = true;
        if (line == null) {
            isExecutable = false;
        } else if (line.trim().equals("") || line.startsWith("#") || line.length() < 1) {
            isExecutable = false;
        }
        return isExecutable;
    }

    private void setInputStreamToFile() throws CommandException {
        try {
            String sEncoding = this.getOption(OPT_ENCODING);
            if (sEncoding == null) {
                CLILogger.getInstance().printDebugMessage("Set input stream");
                InputsAndOutputs.getInstance().setUserInputFile(this.getOption(OPT_INPUT));
            } else {
                InputsAndOutputs.getInstance().setUserInputFile(this.getOption(OPT_INPUT), sEncoding);
            }
        }
        catch (IOException ioe) {
            throw new CommandException(this.getLocalizedString("CouldNotSetInputStream"), (Throwable)ioe);
        }
    }

    private String[] splitStringToArray(String line) throws CommandException {
        CLITokenizer cliTokenizer = new CLITokenizer(line, " ");
        String[] strArray = new String[cliTokenizer.countTokens()];
        int ii = 0;
        while (cliTokenizer.hasMoreTokens()) {
            strArray[ii++] = cliTokenizer.nextTokenWithoutEscapeAndQuoteChars();
            CLILogger.getInstance().printDebugMessage("CLIToken = [" + strArray[ii - 1] + "]");
        }
        return strArray;
    }

    private boolean isExitLine(String line) {
        return line == null || line != null && (line.equalsIgnoreCase(EXIT) || line.equalsIgnoreCase("quit"));
    }

    private boolean isFileOptionSpecified() {
        return this.getOption(OPT_INPUT) != null;
    }

    private void checkValidCommand(ValidCommand validCommand, String commandName) throws CommandException {
        if (validCommand == null) {
            throw new CommandException(this.getLocalizedString("InvalidCommand", new Object[]{commandName}));
        }
    }

    private void processLine(String line, int lineNo) {
        ValidCommand validCommand = null;
        try {
            String[] commandLine = this.splitStringToArray(line);
            CLIDescriptorsReader cliDescriptorsReader = CLIDescriptorsReader.getInstance();
            validCommand = cliDescriptorsReader.getCommand(commandLine[0]);
            if (commandLine[0].equals("help")) {
                throw new HelpException(commandLine.length < 2 ? null : commandLine[1]);
            }
            this.checkValidCommand(validCommand, commandLine[0]);
            CommandLineParser clp = new CommandLineParser(commandLine, validCommand);
            CommandValidator commandValidator = new CommandValidator();
            commandValidator.validateCommandAndOptions(validCommand, clp.getOptionsList(), clp.getOperands());
            Command command = CommandFactory.createCommand((ValidCommand)validCommand, (HashMap)clp.getOptionsList(), (Vector)clp.getOperands());
            command.runCommand();
        }
        catch (HelpException he) {
            this.invokeHelpClass(he.getHelpClassName(), he.getCommandName(), he.getUsageText());
        }
        catch (CommandValidationException cve) {
            this.printUsageText(validCommand);
            CLILogger.getInstance().printExceptionStackTrace((Throwable)cve);
            CLILogger.getInstance().printError(this.getLocalizedString(ERROR_ON_LINE) + " " + Integer.toString(lineNo));
            CLILogger.getInstance().printError(cve.getLocalizedMessage());
        }
        catch (CommandException ce) {
            CLILogger.getInstance().printExceptionStackTrace((Throwable)ce);
            CLILogger.getInstance().printError(this.getLocalizedString(ERROR_ON_LINE) + " " + Integer.toString(lineNo));
            CLILogger.getInstance().printError(ce.getLocalizedMessage());
        }
    }

    private void invokeHelpClass(String helpClassName, String helpCommandName, String commandUsageText) {
        try {
            Command helpCommand = null;
            Class<?> helpClass = Class.forName(helpClassName);
            helpCommand = (Command)helpClass.newInstance();
            helpCommand.setName(helpCommandName);
            if (helpCommandName != null) {
                helpCommand.setOperands(new Vector<String>(Arrays.asList(helpCommandName)));
            }
            helpCommand.setOption("isMultiMode", "true");
            String interactiveVal = (String)CommandEnvironment.getInstance().getEnvironments().get("interactive");
            helpCommand.setOption("interactive", interactiveVal == null ? "true" : interactiveVal);
            helpCommand.runCommand();
        }
        catch (Exception e) {
            if (commandUsageText == null) {
                CLILogger.getInstance().printMessage(this.getLocalizedString("NoUsageText", new Object[]{helpCommandName}));
            }
            CLILogger.getInstance().printMessage(this.getLocalizedString("Usage", new Object[]{commandUsageText}));
        }
    }

    private void printUsageText(ValidCommand validCommand) {
        if (validCommand != null && validCommand.getUsageText() != null) {
            CLILogger.getInstance().printError(this.getLocalizedString("Usage", new Object[]{validCommand.getUsageText()}));
        }
    }
}

