/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.AdminBaseCommand;
import com.sun.portal.admin.common.util.AdminClientUtil;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ListSearchServersCommand
extends AdminBaseCommand {
    public static final String DOMAIN_LABEL = "psadmin.subcommand.resource.list-search-servers.domain.label";
    public static final String SEARCHSERVER_LABEL = "psadmin.subcommand.resource.list-search-servers.searchserver.label";
    public static final String URL_LABEL = "psadmin.subcommand.resource.list-search-servers.url.label";
    public static final String ROOT_LABEL = "psadmin.subcommand.resource.list-search-servers.root.label";

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        StringBuffer sb = new StringBuffer();
        try {
            MBeanServerConnection msc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            ObjectName on = AdminClientUtil.getSearchServerPattern((String)"defaultDomain");
            Set<ObjectName> objects = msc.queryNames(on, new ObjectName(""));
            sb.append(this.getLocalizedString(DOMAIN_LABEL, new Object[]{"defaultDomain"}));
            Iterator<ObjectName> i = objects.iterator();
            while (i.hasNext()) {
                on = i.next();
                String searchServerID = (String)msc.getAttribute(on, "ID");
                LinkedList<String> path = new LinkedList<String>();
                path.addFirst("defaultDomain");
                path.addFirst(searchServerID);
                on = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain.SearchServer", path);
                Properties p = (Properties)msc.getAttribute(on, "Vitals");
                String url = p.getProperty("url");
                String root = p.getProperty("root");
                sb.append("==========================================\n");
                sb.append(this.getLocalizedString(SEARCHSERVER_LABEL, new Object[]{searchServerID}));
                sb.append("------------------------------------------\n");
                sb.append(this.getLocalizedString(URL_LABEL, new Object[]{url}));
                sb.append(this.getLocalizedString(ROOT_LABEL, new Object[]{root}));
            }
            sb.append("==========================================\n");
            this.closeMBeanServerConnection();
        }
        catch (IOException ie) {
            throw new CommandException(this.getLocalizedString("error.psadmin.jmx.invoke"), (Throwable)ie);
        }
        catch (MalformedObjectNameException mle) {
            throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), (Throwable)mle);
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception ex) {
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), (Throwable)ex);
        }
        CLILogger.getInstance().printMessage(sb.toString());
    }
}

