/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.AdminBaseCommand;
import com.sun.portal.admin.common.util.AdminUtil;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class ListPortalsCommand
extends AdminBaseCommand {
    public static final String DOMAIN_LABEL = "psadmin.subcommand.resource.list-portal.domain.label";
    public static final String PORTAL_LABEL = "psadmin.subcommand.resource.list-portal.portal.label";
    public static final String INSTANCE_LABEL = "psadmin.subcommand.resource.list-portal.instance.label";
    public static final String HOST_LABEL = "psadmin.subcommand.resource.list-portal.host.label";
    public static final String INSTANCE_PORT_LABEL = "psadmin.subcommand.resource.list-portal.port.label";
    public static final String WC_INSTANCE_NAME_LABEL = "psadmin.subcommand.resource.list-portal.wcinstance.label";
    public static final String PORTAL_NOT_FOUND = "psadmin.subcommand.resource.list-portal.portal.not.found";
    public static final String PORTAL_SEPARATOR = "============================================\n";
    public static final String INSTANCE_SEPARATOR = "--------------------------------------------\n";

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        StringBuffer outStr = new StringBuffer();
        String portalId = this.getOption("portal");
        HashSet<String> attrs = new HashSet<String>();
        attrs.add("Host");
        attrs.add("Port");
        attrs.add("WebContainerInstanceName");
        String[] iSignature = new String[]{"java.lang.String", "java.util.Set"};
        Object[] iParams = new Object[]{"PortalDomain.Portal.ServerInstance", attrs};
        try {
            String pId;
            ObjectName o;
            if (portalId != null) {
                this.validatePortalId();
            }
            MBeanServerConnection msc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            ObjectName portalPat = AdminUtil.getPortalsPattern((String)"defaultDomain");
            ObjectName instancePat = null;
            Set<ObjectName> portalObjs = msc.queryNames(portalPat, new ObjectName(""));
            Set<ObjectName> instanceObjs = null;
            outStr.append(this.getLocalizedString(DOMAIN_LABEL, new Object[]{"defaultDomain"}));
            outStr.append(PORTAL_SEPARATOR);
            boolean found = false;
            Iterator<ObjectName> i = portalObjs.iterator();
            while (i.hasNext()) {
                o = i.next();
                pId = (String)msc.getAttribute(o, "ID");
                if (portalId == null || !pId.equals(portalId)) continue;
                found = true;
                break;
            }
            if (found) {
                outStr.append(this.getLocalizedString(PORTAL_LABEL, new Object[]{portalId}));
                instancePat = AdminUtil.getPortalServerInstancesPattern((String)"defaultDomain", (String)portalId);
                instanceObjs = msc.queryNames(instancePat, new ObjectName(""));
                Iterator<ObjectName> j = instanceObjs.iterator();
                while (j.hasNext()) {
                    outStr.append(INSTANCE_SEPARATOR);
                    ObjectName iObj = j.next();
                    String iId = (String)msc.getAttribute(iObj, "ID");
                    Map attrValMap = (Map)msc.invoke(iObj, "getMultipleAttributeValues", iParams, iSignature);
                    String host = this.getValueFromMap(attrValMap, "Host");
                    String port = this.getValueFromMap(attrValMap, "Port");
                    String wcInstance = this.getValueFromMap(attrValMap, "WebContainerInstanceName");
                    outStr.append(this.getLocalizedString(INSTANCE_LABEL, new Object[]{iId}));
                    outStr.append(this.getLocalizedString(HOST_LABEL, new Object[]{host}));
                    outStr.append(this.getLocalizedString(INSTANCE_PORT_LABEL, new Object[]{port}));
                    outStr.append(this.getLocalizedString(WC_INSTANCE_NAME_LABEL, new Object[]{wcInstance}));
                }
                outStr.append(PORTAL_SEPARATOR);
            } else if (portalId != null && !found) {
                outStr.append(this.getLocalizedString(PORTAL_NOT_FOUND, new Object[]{portalId}));
                outStr.append(PORTAL_SEPARATOR);
            } else {
                i = portalObjs.iterator();
                while (i.hasNext()) {
                    o = i.next();
                    pId = (String)msc.getAttribute(o, "ID");
                    outStr.append(this.getLocalizedString(PORTAL_LABEL, new Object[]{pId}));
                    instancePat = AdminUtil.getPortalServerInstancesPattern((String)"defaultDomain", (String)pId);
                    instanceObjs = msc.queryNames(instancePat, new ObjectName(""));
                    Iterator<ObjectName> j = instanceObjs.iterator();
                    while (j.hasNext()) {
                        outStr.append(INSTANCE_SEPARATOR);
                        ObjectName iObj = j.next();
                        String iId = (String)msc.getAttribute(iObj, "ID");
                        Map attrValMap = (Map)msc.invoke(iObj, "getMultipleAttributeValues", iParams, iSignature);
                        String host = this.getValueFromMap(attrValMap, "Host");
                        String port = this.getValueFromMap(attrValMap, "Port");
                        String wcInstance = this.getValueFromMap(attrValMap, "WebContainerInstanceName");
                        outStr.append(this.getLocalizedString(INSTANCE_LABEL, new Object[]{iId}));
                        outStr.append(this.getLocalizedString(HOST_LABEL, new Object[]{host}));
                        outStr.append(this.getLocalizedString(INSTANCE_PORT_LABEL, new Object[]{port}));
                        outStr.append(this.getLocalizedString(WC_INSTANCE_NAME_LABEL, new Object[]{wcInstance}));
                    }
                    outStr.append(PORTAL_SEPARATOR);
                }
            }
            this.closeMBeanServerConnection();
        }
        catch (IOException ie) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0003", ie);
            throw new CommandException(this.getLocalizedString("error.psadmin.io.error"), (Throwable)ie);
        }
        catch (MalformedObjectNameException mle) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0004", mle);
            throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), (Throwable)mle);
        }
        catch (CommandException ce) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0008", ce);
            throw ce;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0010", ex);
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), (Throwable)ex);
        }
        CLILogger.getInstance().printMessage(outStr.toString());
    }

    private String getValueFromMap(Map valuesMap, String key) {
        String value = "";
        Set valueSet = (Set)valuesMap.get(key);
        if (valueSet != null && (value = valueSet.toString()).length() > 2) {
            value = value.substring(1, value.length() - 1);
        }
        return value;
    }
}

