/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.AdminBaseCommand;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.util.AdminClientUtil;
import java.io.File;
import java.util.LinkedList;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ListParCommand
extends AdminBaseCommand {
    public static final String OPT_VERBOSE = "verbose";
    public static final String OPT_DP = "dp-only";
    public static final String OPT_PBFILES = "pbfiles-only";
    public static final String OPT_WAR = "war-only";
    public static final String OPT_STATIC = "static-only";
    public static final String ERROR_IMPORT_PAR_EXT_NOT_RIGHT = "error.psadmin.import.par.ext.not.right";
    private boolean verbose;
    private boolean pbfilesOnly;
    private boolean dpOnly;
    private boolean warOnly;
    private boolean staticOnly;
    private String parFileName = null;

    protected void validateOperands() throws CommandException {
        String name = (String)this.getOperands().get(0);
        if (!name.endsWith(".par")) {
            throw new CommandException(this.getLocalizedString(ERROR_IMPORT_PAR_EXT_NOT_RIGHT), null);
        }
        File f = new File(name);
        String fullPath = f.getAbsolutePath();
        if (!f.exists()) {
            Object[] token = new String[]{fullPath};
            logger.log(Level.SEVERE, "PSALI_CSPACC0012", token);
            throw new CommandException(this.getLocalizedString("error.psadmin.file.not.found", token));
        }
        this.parFileName = fullPath;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        this.validatePortalId();
        this.validateOperands();
        String operation = "";
        try {
            this.verbose = this.getBooleanOption(OPT_VERBOSE);
            this.dpOnly = this.getBooleanOption(OPT_DP);
            this.pbfilesOnly = this.getBooleanOption(OPT_PBFILES);
            this.warOnly = this.getBooleanOption(OPT_WAR);
            this.staticOnly = this.getBooleanOption(OPT_STATIC);
            Object[] params = new Object[]{this.parFileName, new Boolean(this.verbose), new Boolean(this.dpOnly), new Boolean(this.pbfilesOnly), new Boolean(this.warOnly), new Boolean(this.staticOnly)};
            String[] signature = new String[]{"java.lang.String", "java.lang.Boolean", "java.lang.Boolean", "java.lang.Boolean", "java.lang.Boolean", "java.lang.Boolean"};
            operation = "listPar";
            MBeanServerConnection msc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            LinkedList<String> path = new LinkedList<String>();
            path.addFirst(this.getDomainId());
            path.addFirst(this.getPortalId());
            path.addFirst("DesktopDynamic");
            ObjectName objName = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal.DesktopDynamic", path);
            String par = (String)msc.invoke(objName, operation, params, signature);
            CLILogger.getInstance().printMessage(par);
        }
        catch (InstanceNotFoundException ie) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0005", ie);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.instance.not.found", new Object[]{operation}), null);
        }
        catch (MBeanException me) {
            PSMBeanException pme = (PSMBeanException)me.getTargetException();
            logger.log(Level.SEVERE, "PSALI_CSPACC0006", (Throwable)pme);
            throw new CommandException(this.getLocalizedString(pme.getErrorKey(), pme.getTokens()));
        }
        catch (MalformedObjectNameException mle) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0004", mle);
            throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), null);
        }
        catch (CommandException ce) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0008", ce);
            throw ce;
        }
        catch (ReflectionException re) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0007", re);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.reflection.error", new Object[]{operation}), (Throwable)re);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0010", ex);
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), null);
        }
        finally {
            this.closeMBeanServerConnection();
        }
    }
}

