/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.GenericCommand;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.util.AdminUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ListAttributesCommand
extends GenericCommand {
    String[] portalCentricComponents = new String[]{"desktop", "producer", "consumer", "subscriptions"};

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException(this.getLocalizedString("error.psadmin.option.validation.failed"));
        }
        String portalId = this.getOption("portal");
        this.validatePortalId(portalId);
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
        String operation = "";
        try {
            ObjectName objectName = portalId == null ? AdminUtil.getPortalDomainMBeanObjectName((String)this.getDomainId()) : AdminUtil.getPortalMBeanObjectName((String)this.getDomainId(), (String)portalId);
            HashMap optMap = this.getOptions();
            optMap.put("operation", "list");
            Object[] params = new Object[]{optMap};
            String[] signature = new String[]{"java.util.Map"};
            operation = "listAttributes";
            Object returnValue = mbsc.invoke(objectName, operation, params, signature);
            this.formatAndDisplay((Map)returnValue, this.getBooleanOption("verbose"));
        }
        catch (InstanceNotFoundException ie) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0005", ie);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.instance.not.found", new Object[]{operation}), (Throwable)ie);
        }
        catch (MBeanException me) {
            String dbgMsg;
            logger.log(Level.SEVERE, "PSALI_CSPACC0006", me);
            boolean psmbe = me.getCause() instanceof PSMBeanException;
            if (this.getBooleanOption("debug") && psmbe && (dbgMsg = me.getCause().getMessage()) != null) {
                CLILogger.getInstance().printMessage(dbgMsg);
            }
            if (psmbe) {
                throw new CommandException(this.getLocalizedString(((PSMBeanException)me.getCause()).getErrorKey()), (Throwable)me);
            }
            throw new CommandException(this.getLocalizedString("error.psadmin.jmx.invoke", new Object[]{operation}), (Throwable)me);
        }
        catch (ReflectionException re) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0007", re);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.reflection.error", new Object[]{operation}), (Throwable)re);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0010", ex);
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), (Throwable)ex);
        }
        finally {
            this.closeMBeanServerConnection();
        }
    }

    private void validatePortalId(String portalId) throws CommandException {
        if (portalId != null) {
            this.validatePortalId();
        } else {
            String comp = this.getOption("component");
            List<String> comps = Arrays.asList(this.portalCentricComponents);
            if (comps.contains(comp)) {
                throw new CommandException(this.getLocalizedString("error.psadmin.invalid.portalid"));
            }
        }
    }

    private void formatAndDisplay(Map map, boolean verbose) {
        TreeMap sorted = new TreeMap(map);
        Iterator iter = sorted.keySet().iterator();
        if (!verbose) {
            while (iter.hasNext()) {
                String attrName = (String)iter.next();
                List info = (List)sorted.get(attrName);
                String typeStr = "";
                if (!info.isEmpty()) {
                    int type = (Integer)info.get(0);
                    typeStr = this.getLocalizedTypeString(type);
                }
                CLILogger.getInstance().printMessage(attrName + " {" + typeStr + "}\n");
            }
        } else {
            while (iter.hasNext()) {
                String attrName = (String)iter.next();
                List info = (List)sorted.get(attrName);
                String typeStr = "";
                String desc = null;
                String privileges = null;
                String example = null;
                if (!info.isEmpty()) {
                    String e;
                    String d;
                    int size = info.size();
                    int type = (Integer)info.get(0);
                    typeStr = this.getLocalizedTypeString(type);
                    if (size > 1 && (d = (String)info.get(1)) != null) {
                        desc = this.getLocalizedString(d);
                    }
                    if (size > 2) {
                        Integer i = (Integer)info.get(2);
                        privileges = i != null ? this.getLocalizedPrivilegeString(i) : this.getLocalizedPrivilegeString(0);
                    }
                    if (size > 3 && (e = (String)info.get(3)) != null) {
                        example = this.getLocalizedString(e);
                    }
                }
                CLILogger.getInstance().printMessage("----------");
                CLILogger.getInstance().printMessage(this.getLocalizedString("psadmin.list.attr.name.label") + ": " + attrName);
                CLILogger.getInstance().printMessage(this.getLocalizedString("psadmin.list.attr.type.label") + ": " + typeStr);
                if (desc != null) {
                    CLILogger.getInstance().printMessage(this.getLocalizedString("psadmin.list.attr.desc.label") + ": " + desc);
                }
                CLILogger.getInstance().printMessage(this.getLocalizedString("psadmin.list.attr.privilege.label") + ": " + privileges);
                if (example == null) continue;
                CLILogger.getInstance().printMessage(this.getLocalizedString("psadmin.list.attr.example.label") + ": " + example);
            }
        }
    }

    private String getLocalizedPrivilegeString(int priv) {
        String privStr = null;
        switch (priv) {
            case 0: {
                privStr = this.getLocalizedString("psadmin.list.privilege.read.write");
                break;
            }
            case 1: {
                privStr = this.getLocalizedString("psadmin.list.privilege.read.only");
                break;
            }
            case 3: {
                privStr = this.getLocalizedString("psadmin.list.privilege.write.only");
                break;
            }
            default: {
                privStr = "";
            }
        }
        return privStr;
    }

    private String getLocalizedTypeString(int type) {
        String typeStr = null;
        switch (type) {
            case 0: {
                typeStr = this.getLocalizedString("psadmin.list.type.single.boolean");
                break;
            }
            case 1: {
                typeStr = this.getLocalizedString("psadmin.list.type.single.string");
                break;
            }
            case 2: {
                typeStr = this.getLocalizedString("psadmin.list.type.single.numeric");
                break;
            }
            case 4: {
                typeStr = this.getLocalizedString("psadmin.list.type.list.string");
                break;
            }
            case 5: {
                typeStr = this.getLocalizedString("psadmin.list.type.list.numeric");
                break;
            }
            case 7: {
                typeStr = this.getLocalizedString("psadmin.list.type.single.choice.string");
                break;
            }
            case 8: {
                typeStr = this.getLocalizedString("psadmin.list.type.single.choice.numeric");
                break;
            }
            case 10: {
                typeStr = this.getLocalizedString("psadmin.list.type.multiple.choice.string");
                break;
            }
            case 11: {
                typeStr = this.getLocalizedString("psadmin.list.type.multiple.choice.numeric");
                break;
            }
            default: {
                typeStr = "";
            }
        }
        return typeStr;
    }
}

