/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.AdminBaseCommand;
import com.sun.portal.admin.common.BackupVersion;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.util.AdminClientUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;

public class ImportCommand
extends AdminBaseCommand {
    public static final String OPT_DEPLOY = "redeploy";
    public static final String OPT_OPERATIONS = "operations";
    public static final String PROVIDER = "provider";
    public static final String DESKTOP = "desktop";
    public static final String OPT_FILES_ONLY = "files-only";
    public static final String OPT_DP_ONLY = "dp-only";
    public static final String OPT_CONTINUE = "continue";
    public static final String OPT_DP_NODE = "dpnode";
    public static final String ARG_EQ = "=";
    public static final String ARG_PIPE = "|";
    public static final String ARG_COMMA = ",";
    public static final String ERROR_MBEAN_IMPORT_NOT_FOUND = "error.psadmin.mbean.import.not.found";
    public static final String ERROR_IMPORT_PAR_EXT_NOT_RIGHT = "error.psadmin.par.ext.not.right";
    public static final String ERROR_IE_PROPERTY_NOT_FOUND = "error.psadmin.ie.property.not.found";
    public static final String ERROR_IE_PROPERTY = "error.psadmin.ie.property";
    public static final String DEPLOY_FAILED = "error.psadmin.import.deploy.failed";
    public static final String ERROR_UPLOAD_FILE = "error.psadmin.upload.file";
    public static final String ERROR_INCORRECT_OPTIONS = "error.psadmin.export.incorrect.option";
    public static final String ERROR_DPNODE_REQUIRED = "error.psadmin.import.dpnode.required";
    public static final String PARAM_PAR_FILE_NAME = "parFileName";
    public static final String PSADMIN_IE_PROP_FILE = "psadminImportExport.properties";
    private String m_ParFileName = null;
    private List m_operations = null;

    protected void validateOperands() throws CommandException {
        String name = (String)this.getOperands().get(0);
        if (!name.endsWith(".par")) {
            throw new CommandException(this.getLocalizedString(ERROR_IMPORT_PAR_EXT_NOT_RIGHT), null);
        }
        File f = new File(name);
        String fullPath = f.getAbsolutePath();
        if (!f.exists()) {
            Object[] token = new String[]{fullPath};
            logger.log(Level.SEVERE, "PSALI_CSPACC0012", token);
            throw new CommandException(this.getLocalizedString("error.psadmin.file.not.found", token));
        }
        this.m_ParFileName = fullPath;
    }

    private void validateOptions(String type) throws CommandException {
        String operations = this.getOption(OPT_OPERATIONS);
        boolean filesOnly = this.getBooleanOption(OPT_FILES_ONLY);
        boolean dpOnly = this.getBooleanOption(OPT_DP_ONLY);
        boolean toContinue = this.getBooleanOption(OPT_CONTINUE);
        if (type.toLowerCase().equals(PROVIDER)) {
            if (filesOnly || dpOnly || toContinue) {
                Object[] tokens = new String[]{"files-only,dp-only,continue,", type};
                throw new CommandException(this.getLocalizedString(ERROR_INCORRECT_OPTIONS, tokens));
            }
        } else if (type.toLowerCase().equals(DESKTOP) && operations != null) {
            Object[] tokens = new String[]{OPT_OPERATIONS, type};
            throw new CommandException(this.getLocalizedString(ERROR_INCORRECT_OPTIONS, tokens));
        }
    }

    public void runCommand() throws CommandException, CommandValidationException {
        String propFilePath = null;
        Object id = null;
        MBeanServerConnection msc = null;
        this.validateOptions();
        this.validateOperands();
        this.validatePortalId();
        String operation = "";
        try {
            msc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            Object[] dParams = new Object[]{this.m_ParFileName};
            String[] dSignature = new String[]{"java.lang.String"};
            LinkedList<String> path = new LinkedList<String>();
            path.addFirst(this.getDomainId());
            path.addFirst(this.getPortalId());
            path.addFirst("DesktopDynamic");
            ObjectName dtObjName = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain.Portal.DesktopDynamic", path);
            String backupVersion = (String)msc.invoke(dtObjName, "getArchiveFileVersion", dParams, dSignature);
            String type = PROVIDER;
            if (backupVersion != null) {
                type = BackupVersion.getType((String)backupVersion);
            }
            if (logger.isLoggable(Level.INFO)) {
                Object[] tokens = new Object[]{type};
                logger.log(Level.INFO, "PSALI_CSPACC0001", tokens);
            }
            this.validateOptions(type);
            String domainId = this.getDomainId();
            String portalId = this.getPortalId();
            ObjectName cObjName = ImportCommand.getComponentMBeanObjectName(type, domainId, portalId);
            MBeanInfo mInfo = msc.getMBeanInfo(cObjName);
            MBeanOperationInfo[] opInfo = mInfo.getOperations();
            MBeanParameterInfo[] paramInfo = null;
            boolean found = false;
            String returnType = null;
            for (int i = 0; i < opInfo.length; ++i) {
                if (!opInfo[i].getName().startsWith("import") || !opInfo[i].getName().toLowerCase().endsWith(type)) continue;
                operation = opInfo[i].getName();
                paramInfo = opInfo[i].getSignature();
                returnType = opInfo[i].getReturnType();
                found = true;
                break;
            }
            if (!found) {
                throw new CommandException(this.getLocalizedString(ERROR_MBEAN_IMPORT_NOT_FOUND));
            }
            HashMap options = this.getOptions();
            Object[] params = new Object[paramInfo.length];
            String[] signature = new String[paramInfo.length];
            int i = 0;
            for (i = 0; i < paramInfo.length; ++i) {
                String o;
                signature[i] = paramInfo[i].getType();
                String pName = paramInfo[i].getDescription();
                if (pName.equals("portal")) {
                    signature[i] = "java.lang.String";
                    params[i] = portalId;
                    continue;
                }
                if (pName.equals(PARAM_PAR_FILE_NAME)) {
                    signature[i] = "java.lang.String";
                    params[i] = this.m_ParFileName;
                    continue;
                }
                if (pName.equals(OPT_OPERATIONS)) {
                    signature[i] = "java.util.List";
                    this.m_operations = this.getOperations(pName);
                    this.validateDpNode();
                    this.setOperationsEncoding();
                    params[i] = this.m_operations;
                    continue;
                }
                if (signature[i].equals("java.lang.Boolean")) {
                    params[i] = new Boolean(this.getOption(pName));
                    continue;
                }
                if (signature[i].equals("java.util.Properties")) {
                    o = this.getOption(pName);
                    if (o == null) continue;
                    Properties p = new Properties();
                    propFilePath = o;
                    p.load(new FileInputStream(propFilePath));
                    params[i] = p;
                    continue;
                }
                params[i] = signature[i].equals("java.lang.String") ? ((o = this.getOption(pName)) == null ? null : o) : null;
            }
            msc.invoke(cObjName, operation, params, signature);
            boolean deploy = this.getBooleanOption(OPT_DEPLOY);
            if (deploy) {
                ObjectName pObjName = AdminClientUtil.getPortalMBeanObjectName((String)"defaultDomain", (String)portalId);
                Object[] cparams = new Object[]{};
                String[] csignature = new String[]{};
                msc.invoke(pObjName, "undeployAllWebApps", cparams, csignature);
                msc.invoke(pObjName, "deployAllWebApps", cparams, csignature);
            }
        }
        catch (FileNotFoundException fe) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0002", fe);
            Object[] tok = new Object[]{propFilePath};
            throw new CommandException(this.getLocalizedString(ERROR_IE_PROPERTY_NOT_FOUND, tok), (Throwable)fe);
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0003", ioe);
            Object[] tok = new Object[]{propFilePath};
            throw new CommandException(this.getLocalizedString(ERROR_IE_PROPERTY, tok), (Throwable)ioe);
        }
        catch (MalformedObjectNameException me) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0004", me);
            throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), (Throwable)me);
        }
        catch (InstanceNotFoundException ie) {
            Object[] tok = new Object[]{operation};
            logger.log(Level.SEVERE, "PSALI_CSPACC0005", ie);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.instance.not.found", tok), (Throwable)ie);
        }
        catch (MBeanException me) {
            String dbgMsg;
            Object[] tok = new Object[]{operation};
            logger.log(Level.SEVERE, "PSALI_CSPACC0006", me);
            boolean pe = me.getCause() instanceof PSMBeanException;
            if (this.getBooleanOption("debug") && pe && (dbgMsg = me.getCause().getMessage()) != null) {
                CLILogger.getInstance().printMessage(dbgMsg);
            }
            if (pe) {
                Object[] tokens = ((PSMBeanException)me.getCause()).getTokens();
                if (tokens != null) {
                    throw new CommandException(this.getLocalizedString(((PSMBeanException)me.getCause()).getErrorKey(), tokens), (Throwable)me);
                }
                throw new CommandException(this.getLocalizedString(((PSMBeanException)me.getCause()).getErrorKey()), (Throwable)me);
            }
            throw new CommandException(this.getLocalizedString("error.psadmin.jmx.invoke", tok), (Throwable)me);
        }
        catch (ReflectionException re) {
            String dbgMsg;
            Object[] tok = new Object[]{operation};
            logger.log(Level.SEVERE, "PSALI_CSPACC0007", re);
            if (this.getBooleanOption("debug") && (dbgMsg = re.getCause().getMessage()) != null) {
                CLILogger.getInstance().printMessage(dbgMsg);
            }
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.reflection.error", tok), (Throwable)re);
        }
        catch (CommandException ce) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0008", ce);
            throw ce;
        }
        catch (RuntimeErrorException rte) {
            Object[] tok = new Object[]{operation};
            logger.log(Level.SEVERE, "PSALI_CSPACC0009", rte);
            throw new CommandException(this.getLocalizedString("error.psadmin.jmx.runtime.error", tok), (Throwable)rte);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0010", ex);
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), (Throwable)ex);
        }
        finally {
            this.closeMBeanServerConnection();
        }
    }

    public static ObjectName getComponentMBeanObjectName(String type, String domainId, String portalId) throws MalformedObjectNameException {
        ObjectName objName = null;
        LinkedList<String> path = new LinkedList<String>();
        path.addFirst(domainId);
        path.addFirst(portalId);
        String resourceId = "DesktopDynamic";
        path.addFirst(resourceId);
        objName = AdminClientUtil.getResourceMBeanObjectName((String)("PortalDomain.Portal." + resourceId), path);
        return objName;
    }

    private List getOperations(String operations) throws CommandException {
        List ops = this.getMultiValueOption(operations);
        return ops;
    }

    private void validateDpNode() throws CommandException {
        if (this.m_operations != null) {
            boolean isDpNode = false;
            for (int i = 0; i < this.m_operations.size(); ++i) {
                String operation = (String)this.m_operations.get(i);
                isDpNode = false;
                String val = "";
                StringTokenizer tok = new StringTokenizer(operation, ARG_PIPE);
                String key = tok.nextToken();
                int vidx = key.indexOf(ARG_EQ);
                if (vidx != -1) {
                    val = key.substring(vidx + 1);
                    key = key.substring(0, vidx);
                }
                if (!(key.equalsIgnoreCase(OPT_DP_NODE) ? val.equals("") : this.getOption(OPT_DP_NODE) == null)) continue;
                throw new CommandException(this.getLocalizedString(ERROR_DPNODE_REQUIRED));
            }
        }
    }

    private String getEncodedOperation(String operation) throws Exception {
        StringTokenizer tok = new StringTokenizer(operation, ARG_PIPE);
        String newOperation = "";
        String newToken = "";
        while (tok.hasMoreTokens()) {
            String keyVal = tok.nextToken();
            int vidx = keyVal.indexOf(ARG_EQ);
            if (vidx != -1) {
                String val = keyVal.substring(vidx + 1);
                String key = keyVal.substring(0, vidx);
                val = URLEncoder.encode(val, "UTF-8");
                newToken = key + ARG_EQ + val;
            } else {
                newToken = keyVal;
            }
            newOperation = newOperation + newToken + ARG_COMMA;
        }
        if (newOperation != null) {
            newOperation = newOperation.substring(0, newOperation.length() - 1);
        }
        return newOperation;
    }

    private void setOperationsEncoding() throws Exception {
        if (this.m_operations != null) {
            for (int i = 0; i < this.m_operations.size(); ++i) {
                String operation = (String)this.m_operations.get(i);
                operation = this.getEncodedOperation(operation);
                this.m_operations.set(i, operation);
            }
        }
    }
}

