/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.LocalStringsManager;
import com.sun.enterprise.cli.framework.LocalStringsManagerFactory;
import com.sun.enterprise.cli.framework.More;
import com.sun.portal.admin.cli.commands.AdminBaseCommand;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;

public class HelpCommand
extends AdminBaseCommand {
    private static final int DEFAULT_PAGE_LENGTH = 50;
    private static final int NO_PAGE_LENGTH = -1;
    private static final String DEFAULT_HELP = "help";
    private static final String PSADMIN_MAIN_HELP = "psadmin.help.portal";
    private static final String PSADMIN_HELP = "psadmin.help";
    private static final String IO_ERROR = "error.psadmin.io.error";
    private static final String OPT_COMPONENT = "component";
    private static final String[] VALID_COMPONENTS = new String[]{"portal", "desktop", "logging", "monitoring", "portlet", "rewriter", "search", "sra", "ssoadapter", "subscriptions", "ubt", "wsrp"};
    private static Set validComponents = new HashSet();

    public boolean validateOptions() throws CommandValidationException {
        return true;
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        try {
            More m = new More(this.getPageLength(), this.getSource(), this.getDestination(), this.getUserInput(), this.getUserOutput(), this.getQuitChar(), this.getPrompt());
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0003", ioe);
            throw new CommandException(this.getLocalizedString(IO_ERROR), (Throwable)ioe);
        }
    }

    private String getCommandName() {
        String command = DEFAULT_HELP;
        if (this.operands.size() > 0) {
            String operand = (String)this.getOperands().get(0);
            if (operand.indexOf("component=") != -1) {
                command = operand.substring(operand.indexOf("=") + 1);
                if (!validComponents.contains(command)) {
                    command = DEFAULT_HELP;
                }
            } else {
                command = operand;
            }
        }
        return command;
    }

    private Writer getDestination() throws IOException {
        return new OutputStreamWriter(System.out);
    }

    private int getPageLength() {
        if (this.getOption("isMultiMode") != null && this.getBooleanOption("isMultiMode") && this.getOption("interactive") != null && this.getBooleanOption("interactive")) {
            return 50;
        }
        return -1;
    }

    private String getPrompt() {
        return this.getLocalizedString("ManpagePrompt");
    }

    private String getQuitChar() {
        return this.getLocalizedString("ManpageQuit");
    }

    private Reader getSource() throws CommandValidationException {
        LocalStringsManager lsm = null;
        String helpKey = null;
        StringBuffer helpStr = new StringBuffer(1096);
        String command = this.getCommandName();
        helpKey = command.equals(DEFAULT_HELP) ? PSADMIN_HELP : "psadmin.help." + command;
        try {
            lsm = LocalStringsManagerFactory.getCommandLocalStringsManager();
            if (this.getCommandName().equals(DEFAULT_HELP)) {
                String value = null;
                for (int i = 0; i < VALID_COMPONENTS.length; ++i) {
                    value = lsm.getString("psadmin.help." + VALID_COMPONENTS[i]);
                    if (value == null || value.startsWith("Key not found")) continue;
                    helpStr.append(value);
                }
            } else {
                helpStr.append(lsm.getString(helpKey));
            }
        }
        catch (Exception e) {
            throw new CommandValidationException("exception", (Throwable)e);
        }
        String str = helpStr.toString();
        if (str.startsWith("Key not found")) {
            Object[] tokens = new Object[]{command};
            helpStr.delete(0, helpStr.length());
            helpStr.append(this.getLocalizedString("InvalidCommand", tokens));
        }
        return new StringReader(helpStr.toString());
    }

    private Reader getUserInput() {
        return new InputStreamReader(System.in);
    }

    private Writer getUserOutput() {
        return new OutputStreamWriter(System.err);
    }

    static {
        for (int i = 0; i < VALID_COMPONENTS.length; ++i) {
            validComponents.add(VALID_COMPONENTS[i]);
        }
    }
}

