/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.GenericCommand;
import com.sun.portal.admin.cli.display.AttributeDisplayHandler;
import com.sun.portal.admin.cli.display.AttributeDisplayHandlerFactory;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.util.AdminUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class GetAttributeCommand
extends GenericCommand {
    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException(this.getLocalizedString("error.psadmin.option.validation.failed"));
        }
        String portalId = this.getOption("portal");
        if (portalId != null) {
            this.validatePortalId();
        }
        String component = this.getOption("component");
        this.validateGetOptions(this.getOptions(), component);
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
        String operation = "";
        try {
            ObjectName objectName = portalId == null ? AdminUtil.getPortalDomainMBeanObjectName((String)this.getDomainId()) : AdminUtil.getPortalMBeanObjectName((String)this.getDomainId(), (String)portalId);
            HashMap optMap = this.getOptions();
            optMap.put("operation", "get");
            Object[] params = new Object[]{optMap};
            String[] signature = new String[]{"java.util.Map"};
            operation = "getAttribute";
            Object returnValue = mbsc.invoke(objectName, operation, params, signature);
            AttributeDisplayHandler attrHandler = AttributeDisplayHandlerFactory.getAttrDisplayHandler(component);
            if (attrHandler != null) {
                attrHandler.handleReturnValue((List)returnValue);
            } else {
                this.handleReturnValue(returnValue);
            }
        }
        catch (InstanceNotFoundException ie) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0005", ie);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.instance.not.found", new Object[]{operation}), (Throwable)ie);
        }
        catch (MBeanException me) {
            String dbgMsg;
            logger.log(Level.SEVERE, "PSALI_CSPACC0006", me);
            boolean psmbe = me.getCause() instanceof PSMBeanException;
            if (this.getBooleanOption("debug") && psmbe && (dbgMsg = me.getCause().getMessage()) != null) {
                CLILogger.getInstance().printMessage(dbgMsg);
            }
            if (psmbe) {
                throw new CommandException(this.getLocalizedString(((PSMBeanException)me.getCause()).getErrorKey()), (Throwable)me);
            }
            throw new CommandException(this.getLocalizedString("error.psadmin.jmx.invoke", new Object[]{operation}), (Throwable)me);
        }
        catch (ReflectionException re) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0007", re);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.reflection.error", new Object[]{operation}), (Throwable)re);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0010", ex);
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), (Throwable)ex);
        }
        finally {
            this.closeMBeanServerConnection();
        }
    }

    private void validateGetOptions(Map optionsMap, String component) throws CommandValidationException {
        this.validateBasicOptions(optionsMap);
        if ("desktop".equals(component)) {
            this.validateDesktopOptions(optionsMap);
        } else if ("subscriptions".equals(component)) {
            this.validateSubscriptionsOptions(optionsMap);
        }
    }

    private void validateBasicOptions(Map optionsMap) throws CommandValidationException {
        boolean global = Boolean.valueOf((String)optionsMap.get("global"));
        boolean org = Boolean.valueOf((String)optionsMap.get("org"));
        boolean dn = optionsMap.containsKey("dn");
        if (global && (org || dn)) {
            throw new CommandValidationException(this.getLocalizedString("error.psadmin.validation.combination.1"));
        }
    }

    private void validateDesktopOptions(Map map) throws CommandValidationException {
        String portalId = this.getOption("portal");
        if (portalId == null) {
            throw new CommandValidationException(this.getLocalizedString("error.psadmin.portalid.not.specified"));
        }
        boolean org = Boolean.valueOf((String)map.get("org"));
        if (org) {
            throw new CommandValidationException(this.getLocalizedString("error.psadmin.org.option.not.valid.for.desktop"));
        }
    }

    private void validateSubscriptionsOptions(Map map) throws CommandValidationException {
        String portalId = this.getOption("portal");
        if (portalId == null) {
            throw new CommandValidationException(this.getLocalizedString("error.psadmin.portalid.not.specified"));
        }
    }
}

