/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.AdminBaseCommand;
import com.sun.portal.admin.common.PSMBeanException;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;

public class GenericCommand
extends AdminBaseCommand {
    public boolean validateOptions() throws CommandValidationException {
        return super.validateOptions();
    }

    public void runCommand() throws CommandException, CommandValidationException {
        if (!this.validateOptions()) {
            throw new CommandValidationException(this.getLocalizedString("error.psadmin.option.validation.failed"));
        }
        if (this.getOption("portal") != null) {
            this.validatePortalId();
        }
        if (this.getOption("searchserver") != null) {
            this.validateSearchServerID();
        }
        if (this.getInstanceId() != null && !this.getName().equals("create-portal") && !this.getName().equals("create-instance")) {
            this.validateInstance();
        }
        MBeanServerConnection mbsc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
        String operationName = null;
        try {
            ObjectName objectName = this.getObjectName();
            Object[] params = this.getParamsInfo();
            String[] types = this.getTypesInfo();
            operationName = this.getOperationName();
            Object returnValue = mbsc.invoke(objectName, operationName, params, types);
            this.handleReturnValue(returnValue);
        }
        catch (InstanceNotFoundException ie) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0005", ie);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.instance.not.found", new Object[]{operationName}), (Throwable)ie);
        }
        catch (MBeanException me) {
            String dbgMsg;
            logger.log(Level.SEVERE, "PSALI_CSPACC0006", me);
            boolean pe = me.getCause() instanceof PSMBeanException;
            if (this.getBooleanOption("debug") && pe && (dbgMsg = me.getCause().getMessage()) != null) {
                CLILogger.getInstance().printMessage(dbgMsg);
            }
            if (pe) {
                PSMBeanException pme = (PSMBeanException)me.getCause();
                if (((PSMBeanException)me.getCause()).getTokens() != null) {
                    throw new CommandException(this.getLocalizedString(pme.getErrorKey(), pme.getTokens()), (Throwable)pme);
                }
                throw new CommandException(this.getLocalizedString(pme.getErrorKey()), (Throwable)me);
            }
            throw new CommandException(this.getLocalizedString("error.psadmin.jmx.invoke", new Object[]{operationName}), (Throwable)me);
        }
        catch (ReflectionException re) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0007", re);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.reflection.error", new Object[]{operationName}), (Throwable)re);
        }
        catch (RuntimeErrorException rte) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0009", rte);
            throw new CommandException(this.getLocalizedString("error.psadmin.jmx.runtime.error", new Object[]{operationName}), (Throwable)rte);
        }
        catch (CommandException ce) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0008", ce);
            throw ce;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0010", ex);
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), (Throwable)ex);
        }
        finally {
            this.closeMBeanServerConnection();
        }
    }
}

