/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.AdminBaseCommand;
import com.sun.portal.admin.cli.commands.ImportCommand;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.util.AdminClientUtil;
import com.sun.portal.admin.common.util.UploadDownloadException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.RuntimeErrorException;

public class ExportCommand
extends AdminBaseCommand {
    public static final String OPT_EXPORT_FILE = "exportfile";
    public static final String OPT_DN = "dn";
    public static final String OPT_GLOBAL = "global";
    public static final String ERROR_MBEAN_EXPORT_NOT_FOUND = "error.psadmin.mbean.export.not.found";
    public static final String ERROR_EXPORT_OPERAND_NOT_RIGHT = "error.psadmin.export.operand.not.right";
    public static final String ERROR_EXPORT_PAR_EXT_NOT_RIGHT = "error.psadmin.par.ext.not.right";
    public static final String ERROR_EXPORT_FILE_EXT_NOT_RIGHT = "error.psadmin.export.file.ext.not.right";
    public static final String ERROR_EXPORT_FILE_ALREADY_EXISTS = "error.psadmin.export.file.already.exists";
    public static final String ERROR_EXPORT_FILE_PATH_DOESNOT_EXIST = "error.psadmin.export.file.path.doesnot.exist";
    public static final String ERROR_TRANSFERRED_EXPORT_FILE = "error.psadmin.error.transferred.export.file";
    public static final String ERROR_DOWNLOAD_FILE = "error.psadmin.download.file";
    public static final String ERROR_EXPORT_FILES_NOT_FOUND = "error.psadmin.export.files.not.found";
    public static final String ERROR_EITHER_DN_OR_GLOBAL = "error.psadmin.export.either.dn.or.global";
    public static final String ERROR_NEITHER_DN_NOR_GLOBAL = "error.psadmin.export.neither.dn.nor.global";
    public static final String ERROR_INCORRECT_OPTIONS = "error.psadmin.export.incorrect.option";
    private String m_ParFileName = null;
    private String m_Datatype_Str = "desktop";
    private byte[][] m_exportFiles = null;
    private String dn = null;
    private boolean global;

    protected void validateOperands() throws CommandException {
        String name = (String)this.getOperands().get(0);
        if (!name.endsWith(".par")) {
            throw new CommandException(this.getLocalizedString(ERROR_EXPORT_PAR_EXT_NOT_RIGHT), null);
        }
        File f = new File(name);
        File parent = f.getParentFile();
        if (name.indexOf(File.separator) != -1 && !parent.exists()) {
            Object[] token = new String[]{parent.getAbsolutePath()};
            throw new CommandException(this.getLocalizedString(ERROR_EXPORT_FILE_PATH_DOESNOT_EXIST, token));
        }
        String fullPath = f.getAbsolutePath();
        if (f.exists()) {
            Object[] token = new String[]{fullPath};
            throw new CommandException(this.getLocalizedString(ERROR_EXPORT_FILE_ALREADY_EXISTS, token));
        }
        this.m_ParFileName = fullPath;
    }

    protected void checkDependency(String dn, boolean global) throws CommandException {
        if (dn != null && global) {
            throw new CommandException(this.getLocalizedString(ERROR_EITHER_DN_OR_GLOBAL), null);
        }
        if (dn == null && !global) {
            throw new CommandException(this.getLocalizedString(ERROR_NEITHER_DN_NOR_GLOBAL), null);
        }
    }

    private void validateOptions(String type) throws CommandException {
        String dn = this.getOption(OPT_DN);
        boolean global = this.getBooleanOption(OPT_GLOBAL);
        String exportFiles = this.getOption(OPT_EXPORT_FILE);
        boolean filesOnly = this.getBooleanOption("files-only");
        boolean dpOnly = this.getBooleanOption("dp-only");
        if (type.toLowerCase().equals("provider")) {
            this.checkDependency(dn, global);
            if (exportFiles == null) {
                throw new CommandException(this.getLocalizedString(ERROR_EXPORT_FILES_NOT_FOUND, null));
            }
            if (filesOnly || dpOnly) {
                Object[] tokens = new String[]{"files-only,dp-only", type};
                throw new CommandException(this.getLocalizedString(ERROR_INCORRECT_OPTIONS, tokens));
            }
        } else if (type.toLowerCase().equals("desktop") && (exportFiles != null || dn != null || global)) {
            Object[] tokens = new String[]{"exportfile,dn,global", type};
            throw new CommandException(this.getLocalizedString(ERROR_INCORRECT_OPTIONS, tokens));
        }
    }

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        this.validateOperands();
        this.validatePortalId();
        String type = this.getOption("type");
        this.validateOptions(type);
        String portalId = this.getPortalId();
        String propFilePath = null;
        MBeanServerConnection msc = null;
        String operation = "";
        try {
            msc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            ObjectName cObjName = ImportCommand.getComponentMBeanObjectName(this.m_Datatype_Str, this.getDomainId(), portalId);
            MBeanInfo mInfo = msc.getMBeanInfo(cObjName);
            MBeanOperationInfo[] opInfo = mInfo.getOperations();
            MBeanParameterInfo[] paramInfo = null;
            boolean found = false;
            String returnType = null;
            for (int i = 0; i < opInfo.length; ++i) {
                if (!opInfo[i].getName().startsWith("export") || !opInfo[i].getName().toLowerCase().endsWith(type)) continue;
                operation = opInfo[i].getName();
                paramInfo = opInfo[i].getSignature();
                returnType = opInfo[i].getReturnType();
                found = true;
                break;
            }
            if (!found) {
                throw new CommandException(this.getLocalizedString(ERROR_MBEAN_EXPORT_NOT_FOUND));
            }
            HashMap options = this.getOptions();
            Object[] params = new Object[paramInfo.length];
            String[] signature = new String[paramInfo.length];
            int i = 0;
            for (i = 0; i < paramInfo.length; ++i) {
                String o;
                signature[i] = paramInfo[i].getType();
                String pName = paramInfo[i].getDescription();
                if (pName.equals("parFileName")) {
                    signature[i] = "java.lang.String";
                    params[i] = this.m_ParFileName;
                    continue;
                }
                if (pName.equals(OPT_EXPORT_FILE)) {
                    signature[i] = "[[B";
                    this.m_exportFiles = this.getExportFilesInput(this.getOption(pName));
                    params[i] = this.m_exportFiles;
                    continue;
                }
                if (signature[i].equals("java.lang.Boolean")) {
                    params[i] = new Boolean(this.getOption(pName));
                    continue;
                }
                if (signature[i].equals("java.util.Properties")) {
                    o = this.getOption(pName);
                    if (o == null) continue;
                    Properties p = new Properties();
                    propFilePath = o;
                    p.load(new FileInputStream(propFilePath));
                    params[i] = p;
                    continue;
                }
                if (signature[i].equals("java.lang.String")) {
                    o = this.getOption(pName);
                    params[i] = o;
                    continue;
                }
                params[i] = null;
            }
            msc.invoke(cObjName, operation, params, signature);
        }
        catch (FileNotFoundException fe) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0002", fe);
            Object[] tok = new Object[]{propFilePath};
            throw new CommandException(this.getLocalizedString("error.psadmin.ie.property.not.found", tok), (Throwable)fe);
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0003", ioe);
            Object[] tok = new Object[]{propFilePath};
            throw new CommandException(this.getLocalizedString("error.psadmin.ie.property", tok), (Throwable)ioe);
        }
        catch (MalformedObjectNameException me) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0004", me);
            throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), (Throwable)me);
        }
        catch (InstanceNotFoundException ie) {
            Object[] tok = new Object[]{operation};
            logger.log(Level.SEVERE, "PSALI_CSPACC0005", ie);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.instance.not.found", tok), (Throwable)ie);
        }
        catch (MBeanException me) {
            String dbgMsg;
            Object[] tok = new Object[]{operation};
            logger.log(Level.SEVERE, "PSALI_CSPACC0006", me);
            boolean pe = me.getCause() instanceof PSMBeanException;
            if (this.getBooleanOption("debug") && pe && (dbgMsg = me.getCause().getMessage()) != null) {
                CLILogger.getInstance().printMessage(dbgMsg);
            }
            if (pe) {
                Object[] tokens = ((PSMBeanException)me.getCause()).getTokens();
                if (tokens != null) {
                    throw new CommandException(this.getLocalizedString(((PSMBeanException)me.getCause()).getErrorKey(), tokens), (Throwable)me);
                }
                throw new CommandException(this.getLocalizedString(((PSMBeanException)me.getCause()).getErrorKey()), (Throwable)me);
            }
            throw new CommandException(this.getLocalizedString("error.psadmin.jmx.invoke", tok), (Throwable)me);
        }
        catch (ReflectionException re) {
            String dbgMsg;
            Object[] tok = new Object[]{operation};
            logger.log(Level.SEVERE, "PSALI_CSPACC0007", re);
            if (this.getBooleanOption("debug") && (dbgMsg = re.getCause().getMessage()) != null) {
                CLILogger.getInstance().printMessage(dbgMsg);
            }
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.reflection.error", tok), (Throwable)re);
        }
        catch (CommandException ce) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0008", ce);
            throw ce;
        }
        catch (RuntimeErrorException rte) {
            Object[] tok = new Object[]{operation};
            logger.log(Level.SEVERE, "PSALI_CSPACC0009", rte);
            throw new CommandException(this.getLocalizedString("error.psadmin.jmx.runtime.error", tok), (Throwable)rte);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0010", ex);
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), (Throwable)ex);
        }
        finally {
            this.closeMBeanServerConnection();
        }
    }

    private void downloadFile(MBeanServerConnection mbsc, String file) throws CommandException {
        try {
            AdminClientUtil.downloadFile((MBeanServerConnection)mbsc, (String)this.getDomainId(), (String)file, (int)4096, (String)file);
        }
        catch (UploadDownloadException upde) {
            Object[] tokens = new Object[]{file};
            throw new CommandException(this.getLocalizedString(ERROR_DOWNLOAD_FILE, tokens));
        }
    }

    private byte[][] getExportFilesInput(String exportfiles) throws IOException, CommandException {
        StringTokenizer st = new StringTokenizer(exportfiles, ",");
        String[] files = new String[st.countTokens()];
        int k = 0;
        while (st.hasMoreTokens()) {
            files[k] = this.validateExportFile(st.nextToken());
            ++k;
        }
        byte[] byteArray = null;
        Object arrayByteArray = null;
        if (files != null && files.length > 0) {
            int nbyteArray = files.length;
            arrayByteArray = new byte[nbyteArray][];
            for (int i = 0; i < nbyteArray; ++i) {
                FileInputStream fis = null;
                try {
                    File file = new File(files[i]);
                    fis = new FileInputStream(file);
                    byteArray = new byte[(int)file.length()];
                    fis.read(byteArray);
                    fis.close();
                    arrayByteArray[i] = byteArray;
                    continue;
                }
                catch (IOException ioe) {
                    throw new IOException(ioe.getMessage());
                }
            }
        }
        return arrayByteArray;
    }

    private String validateExportFile(String exportFile) throws CommandException {
        File f = new File(exportFile);
        String fullPath = f.getAbsolutePath();
        if (!exportFile.endsWith(".txt")) {
            Object[] token = new String[]{fullPath};
            throw new CommandException(this.getLocalizedString(ERROR_EXPORT_FILE_EXT_NOT_RIGHT, token));
        }
        if (!f.exists()) {
            Object[] token = new String[]{fullPath};
            throw new CommandException(this.getLocalizedString("error.psadmin.file.not.found", token));
        }
        if (f.length() == 0L) {
            Object[] token = new String[]{fullPath};
            throw new CommandException(this.getLocalizedString("error.psadmin.error.reading.file", token));
        }
        return fullPath;
    }
}

