/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.AdminBaseCommand;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.util.AdminClientUtil;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class DeletePortalCommand
extends AdminBaseCommand {
    public void runCommand() throws CommandException, CommandValidationException {
        ObjectName instancePat = null;
        Set<ObjectName> instanceObjs = null;
        this.validateOptions();
        this.validatePortalId();
        String operation = "";
        try {
            MBeanServerConnection msc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            instancePat = AdminClientUtil.getPortalServerInstancesPattern((String)"defaultDomain", (String)this.getPortalId());
            instanceObjs = msc.queryNames(instancePat, new ObjectName(""));
            Iterator<ObjectName> j = instanceObjs.iterator();
            while (j.hasNext()) {
                ObjectName iObj = j.next();
                String iId = (String)msc.getAttribute(iObj, "ID");
                Object[] iParams = new Object[]{iId};
                String[] iSignature = new String[]{"java.lang.String"};
                operation = "deleteInstance";
                ObjectName iObjName = AdminClientUtil.getPortalMBeanObjectName((String)"defaultDomain", (String)this.getPortalId());
                msc.invoke(iObjName, operation, iParams, iSignature);
            }
            Object[] params = new Object[]{this.getPortalId()};
            String[] signature = new String[]{"java.lang.String"};
            operation = "deletePortal";
            ObjectName objName = AdminClientUtil.getPortalDomainMBeanObjectName((String)"defaultDomain");
            Boolean ret = (Boolean)msc.invoke(objName, operation, params, signature);
            this.closeMBeanServerConnection();
        }
        catch (InstanceNotFoundException ie) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0005", ie);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.instance.not.found", new Object[]{operation}), (Throwable)ie);
        }
        catch (MBeanException me) {
            String dbgMsg;
            logger.log(Level.SEVERE, "PSALI_CSPACC0006", me);
            boolean psmbe = me.getCause() instanceof PSMBeanException;
            if (this.getBooleanOption("debug") && psmbe && (dbgMsg = me.getCause().getMessage()) != null) {
                CLILogger.getInstance().printMessage(dbgMsg);
            }
            if (psmbe) {
                Object[] toInsert = ((PSMBeanException)me.getCause()).getTokens();
                if (toInsert != null) {
                    throw new CommandException(this.getLocalizedString(((PSMBeanException)me.getCause()).getErrorKey(), toInsert), me.getCause());
                }
                throw new CommandException(this.getLocalizedString(((PSMBeanException)me.getCause()).getErrorKey()), me.getCause());
            }
            throw new CommandException(this.getLocalizedString("error.psadmin.jmx.invoke", new Object[]{operation}), (Throwable)me);
        }
        catch (ReflectionException re) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0007", re);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.reflection.error", new Object[]{operation}), (Throwable)re);
        }
        catch (MalformedObjectNameException mle) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0004", mle);
            throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), (Throwable)mle);
        }
        catch (CommandException ce) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0008", ce);
            throw ce;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0010", ex);
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), (Throwable)ex);
        }
    }
}

