/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.GenericCommand;
import com.sun.portal.admin.common.util.AdminClientUtil;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class CreateSearchServerCommand
extends GenericCommand {
    public static final String BAD_SEARCH_SERVER = "error.psadmin.createsearchserver.bad";

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        Properties p = this.getWebConfigProp();
        String host = (String)p.get("Host");
        String port = (String)p.get("Port");
        String instance = (String)p.get("WebContainerInstanceName");
        boolean failed = false;
        try {
            MBeanServerConnection msc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            ObjectName on = AdminClientUtil.getSearchServerPattern((String)"defaultDomain");
            Set<ObjectName> objects = msc.queryNames(on, new ObjectName(""));
            Iterator<ObjectName> i = objects.iterator();
            while (i.hasNext()) {
                on = i.next();
                String testHost = (String)msc.getAttribute(on, "Host");
                String testPort = (String)msc.getAttribute(on, "Port");
                String testInstance = (String)msc.getAttribute(on, "Instance");
                if (!testHost.equals(host) || !testPort.equals(port) || !testInstance.equals(instance)) continue;
                failed = true;
            }
        }
        catch (Exception e) {
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), (Throwable)e);
        }
        if (failed) {
            throw new CommandException(this.getLocalizedString(BAD_SEARCH_SERVER), null);
        }
        String operation = "";
        try {
            LinkedList<String> path = new LinkedList<String>();
            path.addFirst("defaultDomain");
            ObjectName on = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain", path);
            Object[] params = new Object[]{this.getOption("searchserver"), p};
            String[] signatures = new String[]{"java.lang.String", "java.util.Properties"};
            operation = "createSearchServer";
            MBeanServerConnection msc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            msc.invoke(on, operation, params, signatures);
        }
        catch (InstanceNotFoundException ie) {
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.instance.not.found", new Object[]{operation}), (Throwable)ie);
        }
        catch (MBeanException me) {
            throw new CommandException(this.getLocalizedString("error.psadmin.jmx.invoke", new Object[]{operation}), (Throwable)me);
        }
        catch (ReflectionException re) {
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.reflection.error", new Object[]{operation}), (Throwable)re);
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), (Throwable)e);
        }
        finally {
            this.closeMBeanServerConnection();
        }
    }
}

