/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.AdminBaseCommand;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.util.AdminClientUtil;
import java.util.Properties;
import java.util.logging.Level;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class CreatePortalInstanceCommand
extends AdminBaseCommand {
    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        this.validatePortalId();
        if (this.getInstanceId() != null && this.isExistingInstance()) {
            throw new CommandException(this.getLocalizedString("error.psadmin.instance.already.exists"));
        }
        Properties webconfig = this.getWebConfigProp();
        String operation = "";
        try {
            MBeanServerConnection msc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            Object[] params = new Object[]{webconfig};
            String[] signature = new String[]{"java.util.Map"};
            operation = "validateWebContainer";
            ObjectName objName = AdminClientUtil.getPortalDomainMBeanObjectName((String)"defaultDomain");
            msc.invoke(objName, operation, params, signature);
            Object[] iParams = new Object[]{this.getInstanceId(), webconfig};
            String[] iSignature = new String[]{"java.lang.String", "java.util.Properties"};
            operation = "createAndFinalizeInstance";
            ObjectName iObjName = AdminClientUtil.getPortalMBeanObjectName((String)"defaultDomain", (String)this.getPortalId());
            msc.invoke(iObjName, operation, iParams, iSignature);
        }
        catch (InstanceNotFoundException ie) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0005", ie);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.instance.not.found", new Object[]{operation}), (Throwable)ie);
        }
        catch (MBeanException me) {
            String dbgMsg;
            logger.log(Level.SEVERE, "PSALI_CSPACC0006", me);
            boolean psmbe = me.getCause() instanceof PSMBeanException;
            if (this.getBooleanOption("debug") && psmbe && (dbgMsg = me.getCause().getMessage()) != null) {
                CLILogger.getInstance().printMessage(dbgMsg);
            }
            if (psmbe) {
                Object[] toInsert = ((PSMBeanException)me.getCause()).getTokens();
                if (toInsert != null) {
                    throw new CommandException(this.getLocalizedString(((PSMBeanException)me.getCause()).getErrorKey(), toInsert), me.getCause());
                }
                throw new CommandException(this.getLocalizedString(((PSMBeanException)me.getCause()).getErrorKey()), me.getCause());
            }
            throw new CommandException(this.getLocalizedString("error.psadmin.jmx.invoke", new Object[]{operation}), (Throwable)me);
        }
        catch (ReflectionException re) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0007", re);
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.reflection.error", new Object[]{operation}), (Throwable)re);
        }
        catch (MalformedObjectNameException mle) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0004", mle);
            throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), (Throwable)mle);
        }
        catch (CommandException ce) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0008", ce);
            throw ce;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0010", ex);
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), (Throwable)ex);
        }
        finally {
            this.closeMBeanServerConnection();
        }
    }
}

