/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.portal.admin.cli.commands.AdminBaseCommand;
import com.sun.portal.admin.common.util.AdminClientUtil;
import com.sun.portal.util.FileWildFilter;
import java.io.File;
import java.io.FilenameFilter;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ConfigureInstancesCommand
extends AdminBaseCommand {
    public static final String OPT_CONF_DIR = "confdir";
    private File m_confDir;

    public void runCommand() throws CommandException, CommandValidationException {
        this.validateOptions();
        this.validatePortalId();
        this.validateConfiguration();
        String operation = "";
        try {
            MBeanServerConnection msc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            ObjectName pObjName = AdminClientUtil.getPortalMBeanObjectName((String)"defaultDomain", (String)this.getPortalId());
            Object[] params = new Object[]{this.m_confDir.getAbsolutePath()};
            String[] signature = new String[]{"java.lang.String"};
            operation = "configureInstances";
            Boolean ret = (Boolean)msc.invoke(pObjName, operation, params, signature);
            boolean success = ret;
            if (!success) {
                throw new CommandException(this.getLocalizedString("error.psadmin.instance.conf.failed"));
            }
        }
        catch (InstanceNotFoundException ie) {
            Object[] tok = new Object[]{operation};
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.instance.not.found", tok), (Throwable)ie);
        }
        catch (MBeanException me) {
            Object[] tok = new Object[]{operation};
            throw new CommandException(this.getLocalizedString("error.psadmin.jmx.invoke", tok), (Throwable)me);
        }
        catch (ReflectionException re) {
            Object[] tok = new Object[]{operation};
            throw new CommandException(this.getLocalizedString("error.psadmin.mbean.reflection.error", tok), (Throwable)re);
        }
        catch (MalformedObjectNameException mle) {
            throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), (Throwable)mle);
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception ex) {
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), (Throwable)ex);
        }
        finally {
            this.closeMBeanServerConnection();
        }
    }

    protected void validateConfiguration() throws CommandException {
        String confDir = this.getOption(OPT_CONF_DIR);
        this.m_confDir = new File(confDir);
        if (!this.m_confDir.exists() || !this.m_confDir.isDirectory()) {
            Object[] tokens = new Object[]{confDir};
            throw new CommandException(this.getLocalizedString("error.psadmin.invalid.instance.confdir", tokens));
        }
        boolean doConfig = false;
        if (!doConfig) {
            doConfig = this.doConfigFilesExist("server.classpath");
        }
        if (!doConfig) {
            doConfig = this.doConfigFilesExist("jvmoptions.properties");
        }
        if (!doConfig) {
            doConfig = this.doConfigFilesExist("server.policy");
        }
        if (!doConfig) {
            doConfig = this.doConfigFilesExist("[\\S|\\s]*\\.datasource");
        }
        if (!doConfig) {
            doConfig = this.doConfigFilesExist("[\\S|\\s]*\\.jndi");
        }
        if (!doConfig) {
            Object[] tokens = new Object[]{confDir};
            throw new CommandException(this.getLocalizedString("error.psadmin.instance.conf.not.reqd", tokens));
        }
    }

    private boolean doConfigFilesExist(String filesRegEx) {
        FileWildFilter filter = new FileWildFilter(filesRegEx, null, 2);
        File[] files = this.m_confDir.listFiles((FilenameFilter)filter);
        return files != null && files.length != 0;
    }
}

