/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.admin.cli.commands;

import com.sun.enterprise.cli.framework.CLILogger;
import com.sun.enterprise.cli.framework.CLITokenizer;
import com.sun.enterprise.cli.framework.Command;
import com.sun.enterprise.cli.framework.CommandException;
import com.sun.enterprise.cli.framework.CommandValidationException;
import com.sun.enterprise.cli.framework.InputsAndOutputs;
import com.sun.enterprise.cli.framework.LocalStringsManager;
import com.sun.enterprise.cli.framework.LocalStringsManagerFactory;
import com.sun.portal.admin.cli.commands.AdminCLIConstants;
import com.sun.portal.admin.common.PSMBeanException;
import com.sun.portal.admin.common.context.PSConfigContext;
import com.sun.portal.admin.common.context.PSConfigContextImpl;
import com.sun.portal.admin.common.util.AdminClientUtil;
import com.sun.portal.log.common.PortalLogManager;
import com.sun.portal.log.common.PortalLogger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnector;

public abstract class AdminBaseCommand
extends Command
implements AdminCLIConstants {
    public static String cliLogFileName;
    public static String mbeanLogFileName;
    public static Logger logger;
    public static final String INTERACTIVE = "interactive";
    public static final String OBJECT_NAME = "objectname";
    public static final String RESOURCE_ID = "resourceid";
    public static final String RESOURCE_TYPE = "resourcetype";
    public static final String DOMAIN_MBEAN_OBJECT_NAME = "DomainMBeanObjectName";
    public static final String PORTAL_MBEAN_OBJECT_NAME = "PortalMBeanObjectName";
    public static final String INSTANCE_MBEAN_OBJECT_NAME = "InstanceMBeanObjectName";
    public static final String DOMAIN_RESOURCE_MBEAN_OBJECT_NAME = "DomainResourceMBeanObjectName";
    public static final String PORTAL_RESOURCE_MBEAN_OBJECT_NAME = "PortalResourceMBeanObjectName";
    public static final String INSTANCE_RESOURCE_MBEAN_OBJECT_NAME = "InstanceResourceMBeanObjectName";
    public static final String OPERATION = "operation";
    public static final String PARAMS = "params";
    public static final String PARAM_TYPES = "paramtypes";
    public static final String RETURN_TYPE = "returntype";
    public static final String DISPLAY_TYPE = "displaytype";
    public static final String ATTRIBUTE_LIST_CLASS;
    public static final String PROPERTIES_CLASS;
    public static final String BOOLEAN_CLASS;
    public static final String PRIMITIVE_BOOLEAN_CLASS;
    public static final String STRING_ARRAY;
    public static final String INTEGER_CLASS;
    public static final String LIST_CLASS;
    public static final String PARAM_DELIMITER = ",";
    public static final String PARAM_VALUE_DELIMITER = "=";
    public static final String PROPERTY_DELIMITER = ":";
    public static final String PROPERTY_FILE = "LocalStrings";
    public static final int DEFAULT_UPLOAD_SIZE = 4096;
    public static final int DEFAULT_DOWNLOAD_SIZE = 4096;
    public static final String ERROR_GET_INSTANCE_HOST = "error.psadmin.unknown.host";
    public static final String ERROR_UNKNOWN_HOST = "error.psadmin.unknown.host";
    private static final String ERROR_FILE_UPLOAD = "fileUploadDownload.errorInUpload";
    private static final String ERROR_FILE_DOWNLOAD = "fileUploadDownload.errorInDownload";
    protected LocalStringsManager commandLocalStringsManager = null;
    private String m_password;
    private String m_instanceId;
    private Properties m_webConfigProp;
    private String m_portalId;
    private String m_domainId;
    private String m_portalUri;
    private static JMXConnector m_connector;
    private static MBeanServerConnection m_mbsc;
    static /* synthetic */ Class class$com$sun$portal$admin$cli$commands$AdminBaseCommand;
    static /* synthetic */ Class class$javax$management$AttributeList;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$util$List;

    public static Logger getLogger() {
        return logger;
    }

    public boolean validateOptions() throws CommandValidationException {
        try {
            this.validatePassword();
            this.setOutput();
        }
        catch (Exception e) {
            throw new CommandValidationException(e.getMessage());
        }
        return true;
    }

    protected void validatePassword() throws CommandException {
        String passwordFileName = this.getOption("passwordfile");
        if (passwordFileName == null) {
            return;
        }
        File file = new File(passwordFileName);
        if (!file.exists() || !file.canRead()) {
            throw new CommandException(this.getLocalizedString("error.psadmin.password.file.not.exist.or.not.readable", new Object[]{passwordFileName}));
        }
        if (file.exists() && file.length() <= 0L) {
            throw new CommandException(this.getLocalizedString("error.psadmin.password.file.size.zero", new Object[]{passwordFileName}));
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0) {
                    this.m_password = line;
                    break;
                }
                line = reader.readLine();
            }
            reader.close();
        }
        catch (IOException e) {
            throw new CommandException(this.getLocalizedString("error.psadmin.password.read.error"));
        }
    }

    protected void validatePortalId() throws CommandException {
        this.m_portalId = this.getOption("portal");
        if (!this.getName().equals("create-portal")) {
            List portalList = this.getPortalNames();
            boolean found = false;
            Iterator iter = portalList.iterator();
            while (iter.hasNext()) {
                String id = (String)iter.next();
                if (!id.equalsIgnoreCase(this.m_portalId)) continue;
                found = true;
            }
            if (!found) {
                throw new CommandException(this.getLocalizedString("error.psadmin.invalid.portalid"));
            }
        }
        if (this.m_portalId != null && this.m_portalId.matches(".*[^a-zA-Z0-9-].*")) {
            throw new CommandException(this.getLocalizedString("error.psadmin.portalid.invalid.format"));
        }
    }

    protected void validatePortalUri() throws CommandException {
        this.m_portalUri = this.getOption("uri");
        if (this.m_portalUri != null && !this.m_portalUri.startsWith("/")) {
            throw new CommandException(this.getLocalizedString("error.psadmin.portaluri.invalid.format"));
        }
    }

    protected void validateInstance() throws CommandException {
        String instance = this.getOption("instance");
        List instanceList = this.getInstanceNames(this.m_portalId);
        if (!instanceList.contains(instance)) {
            throw new CommandException(this.getLocalizedString("error.psadmin.invalid.instanceid"));
        }
    }

    protected boolean isExistingInstance() throws CommandException {
        String instance = this.getOption("instance");
        List instanceList = this.getInstanceNames(this.m_portalId);
        return instanceList.contains(instance);
    }

    protected void validateSearchServerID() throws CommandException {
        String option = this.getOption("searchserver");
        List l = this.getSearchServers();
        boolean found = false;
        Iterator i = l.iterator();
        while (i.hasNext()) {
            String id = (String)i.next();
            if (!id.equalsIgnoreCase(option)) continue;
            found = true;
        }
        if (!found) {
            throw new CommandException(this.getLocalizedString("error.psadmin.invalid.searchserverid"));
        }
    }

    protected String getUserId() {
        return this.getOption("adminuser");
    }

    protected String getPassword() {
        return this.m_password;
    }

    protected String getHost() {
        return this.getOption("hostname") != null ? this.getOption("hostname") : "localhost";
    }

    protected String getPortalId() {
        return this.getOption("portal");
    }

    protected String getPortalUri() {
        return this.getOption("uri") != null ? this.getOption("uri") : "/portal";
    }

    protected String getDomainId() {
        String domainId = this.getOption("domain") != null ? this.getOption("domain") : "defaultDomain";
        return domainId;
    }

    protected String getSearchServerId() {
        return this.getOption("searchserver") != null ? this.getOption("searchserver") : "";
    }

    protected String getInstanceId() {
        return this.getOption("instance");
    }

    protected Properties getWebConfigProp() throws CommandException {
        String webConfig = this.getOption("webconfig");
        if (webConfig == null) {
            throw new CommandException(this.getLocalizedString("error.psadmin.file.not.found", new Object[]{webConfig}));
        }
        return this.createPropertiesParam(webConfig);
    }

    protected List getMultiValueOption(String optionName) throws CommandException {
        return this.getMultiValueFromString(this.getOption(optionName));
    }

    protected List getMultiValueFromString(String value) throws CommandException {
        ArrayList<String> valueList = new ArrayList<String>();
        if (value != null) {
            CLITokenizer ct = new CLITokenizer(value, " ");
            while (ct.hasMoreTokens()) {
                valueList.add(ct.nextTokenWithoutEscapeAndQuoteChars());
            }
        }
        return valueList;
    }

    public Object getAttribute(MBeanServerConnection mbs, ObjectName obj, String attribute) {
        try {
            return mbs.getAttribute(obj, attribute);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to get mbean server attribute.", e);
            return null;
        }
    }

    protected List getPortalNames() throws CommandException {
        ArrayList<Object> pNames = new ArrayList<Object>();
        try {
            m_mbsc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            ObjectName portalPat = AdminClientUtil.getPortalsPattern((String)"defaultDomain");
            Set<ObjectName> objNames = m_mbsc.queryNames(portalPat, null);
            Iterator<ObjectName> iter = objNames.iterator();
            while (iter.hasNext()) {
                pNames.add(this.getAttribute(m_mbsc, iter.next(), "ID"));
            }
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0010", ex);
            throw new CommandException(this.getLocalizedString("error.psadmin.get.portals"));
        }
        return pNames;
    }

    protected List getInstanceNames(String portalId) throws CommandException {
        ArrayList<String> iNames = new ArrayList<String>();
        try {
            m_mbsc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            ObjectName instancePat = AdminClientUtil.getPortalServerInstancesPattern((String)"defaultDomain", (String)portalId);
            Set<ObjectName> objNames = m_mbsc.queryNames(instancePat, new ObjectName(""));
            Iterator<ObjectName> iter = objNames.iterator();
            while (iter.hasNext()) {
                String instance = (String)m_mbsc.getAttribute(iter.next(), "ID");
                iNames.add(instance);
            }
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0010", ex);
            Object[] tokens = new Object[]{portalId};
            throw new CommandException(this.getLocalizedString("error.psadmin.get.instances", tokens));
        }
        return iNames;
    }

    public Set getInstanceHosts(MBeanServerConnection msc, String portalId) throws CommandException {
        List instances = this.getInstanceNames(portalId);
        TreeSet<String> hosts = new TreeSet<String>();
        Iterator it = instances.iterator();
        try {
            while (it.hasNext()) {
                String instance = (String)it.next();
                ObjectName iObjectName = AdminClientUtil.getInstanceMBeanObjectName((String)this.getDomainId(), (String)portalId, (String)instance);
                String host = (String)msc.getAttribute(iObjectName, "Host");
                if (hosts.contains(host)) continue;
                hosts.add(host);
            }
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0010", ex);
            Object[] tokens = new Object[]{portalId};
            throw new CommandException(this.getLocalizedString("error.psadmin.unknown.host", tokens));
        }
        return hosts;
    }

    protected List getSearchServers() throws CommandException {
        ArrayList<String> l = new ArrayList<String>();
        try {
            MBeanServerConnection msc = this.getMBeanServerConnection(this.getUserId(), this.getPassword(), this.getHost());
            ObjectName on = AdminClientUtil.getSearchServerPattern((String)"defaultDomain");
            Set<ObjectName> objects = msc.queryNames(on, new ObjectName(""));
            Iterator<ObjectName> i = objects.iterator();
            while (i.hasNext()) {
                on = i.next();
                String searchServerID = (String)msc.getAttribute(on, "ID");
                l.add(searchServerID);
            }
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception ex) {
            throw new CommandException(this.getLocalizedString("error.psadmin.get.searchservers"));
        }
        return l;
    }

    protected String getLocalizedString(String key) {
        String retStr = LocalStringsManager.DEFAULT_STRING_VALUE;
        try {
            if (this.commandLocalStringsManager != null) {
                retStr = this.commandLocalStringsManager.getString(key);
            }
            if (retStr.equals(LocalStringsManager.DEFAULT_STRING_VALUE)) {
                LocalStringsManager lsm = LocalStringsManagerFactory.getCommandLocalStringsManager();
                retStr = lsm.getString(key);
            }
        }
        catch (CommandValidationException commandValidationException) {
            // empty catch block
        }
        return retStr;
    }

    protected String getLocalizedString(String key, Object[] toInsert) {
        String retStr = LocalStringsManager.DEFAULT_STRING_VALUE;
        try {
            if (this.commandLocalStringsManager != null) {
                retStr = this.commandLocalStringsManager.getString(key, toInsert);
            }
            if (retStr.equals(LocalStringsManager.DEFAULT_STRING_VALUE)) {
                LocalStringsManager lsm = LocalStringsManagerFactory.getCommandLocalStringsManager();
                retStr = lsm.getString(key, toInsert);
            }
        }
        catch (CommandValidationException ce) {
            // empty catch block
        }
        return retStr;
    }

    protected void setOutput() {
        InputsAndOutputs inAndOut = InputsAndOutputs.getInstance();
        String output = this.getOption("output");
        try {
            if (output != null) {
                inAndOut.setUserOutputFile(output);
            }
        }
        catch (IOException ie) {
            CLILogger.getInstance().printDebugMessage(this.getLocalizedString("error.psadmin.output.error"));
        }
    }

    protected PSConfigContext getPSConfigContext() {
        PSConfigContextImpl configCtx = null;
        try {
            configCtx = new PSConfigContextImpl("defaultDomain");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return configCtx;
    }

    protected MBeanServerConnection getMBeanServerConnection(String id, String pwd, String host) throws CommandException {
        if (m_mbsc != null) {
            return m_mbsc;
        }
        try {
            if (m_connector == null) {
                m_connector = AdminClientUtil.getJMXConnector((String)host, (String)"defaultDomain", (String)id, (String)pwd);
            }
            m_mbsc = m_connector.getMBeanServerConnection();
            return m_mbsc;
        }
        catch (SecurityException se) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0011", se);
            throw new CommandException(this.getLocalizedString("error.psadmin.auth.security.violation"), (Throwable)se);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0010", e);
            throw new CommandException(this.getLocalizedString("error.psadmin.auth.connection.error"));
        }
    }

    protected void closeMBeanServerConnection() throws CommandException {
        String multimodeRunning = System.getProperty("psadmin.multimode.running");
        boolean isMultimodeRunning = multimodeRunning == null ? false : multimodeRunning.equals("true");
        try {
            if (!isMultimodeRunning && m_connector != null) {
                m_connector.close();
                m_connector = null;
                m_mbsc = null;
            }
        }
        catch (IOException ie) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0003", ie);
            throw new CommandException(this.getLocalizedString("error.psadmin.auth.closing.connection.error"));
        }
    }

    protected File checkForFileExistence(String parent, String fileName) throws CommandException {
        if (fileName == null) {
            return null;
        }
        File file = null;
        file = parent == null ? new File(fileName) : new File(parent, fileName);
        if (!file.canRead()) {
            throw new CommandException(this.getLocalizedString("FileDoesNotExist", new Object[]{fileName}));
        }
        return file;
    }

    protected ObjectName getObjectName() throws CommandException {
        String objectName = (String)((Vector)this.getProperty(OBJECT_NAME)).get(0);
        String objectNameStr = this.replacePattern(objectName);
        ObjectName on = null;
        try {
            if (objectNameStr.equals(DOMAIN_MBEAN_OBJECT_NAME)) {
                on = AdminClientUtil.getPortalDomainMBeanObjectName((String)this.getDomainId());
            } else if (objectNameStr.equals(PORTAL_MBEAN_OBJECT_NAME)) {
                on = AdminClientUtil.getPortalMBeanObjectName((String)this.getDomainId(), (String)this.getPortalId());
            } else if (objectNameStr.equals(INSTANCE_MBEAN_OBJECT_NAME)) {
                on = AdminClientUtil.getInstanceMBeanObjectName((String)this.getDomainId(), (String)this.getPortalId(), (String)this.getInstanceId());
            } else {
                LinkedList<String> path = new LinkedList<String>();
                String resourceType = (String)((Vector)this.getProperty(RESOURCE_TYPE)).get(0);
                if (objectNameStr.equals(DOMAIN_RESOURCE_MBEAN_OBJECT_NAME)) {
                    path.addFirst(this.getDomainId());
                    Vector v = (Vector)this.getProperty(RESOURCE_ID);
                    for (int i = 0; i < v.size(); ++i) {
                        String resourceId = (String)v.get(i);
                        resourceId = this.replacePattern(resourceId);
                        path.addFirst(resourceId);
                    }
                } else if (objectNameStr.equals(PORTAL_RESOURCE_MBEAN_OBJECT_NAME)) {
                    String resourceId = (String)((Vector)this.getProperty(RESOURCE_ID)).get(0);
                    resourceId = this.replacePattern(resourceId);
                    path.addFirst(this.getDomainId());
                    path.addFirst(this.getPortalId());
                    path.addFirst(resourceId);
                } else if (objectNameStr.equals(INSTANCE_RESOURCE_MBEAN_OBJECT_NAME)) {
                    String resourceId = (String)((Vector)this.getProperty(RESOURCE_ID)).get(0);
                    resourceId = this.replacePattern(resourceId);
                    path.addFirst(this.getDomainId());
                    path.addFirst(this.getPortalId());
                    path.addFirst(this.getInstanceId());
                    path.addFirst(resourceId);
                }
                on = AdminClientUtil.getResourceMBeanObjectName((String)resourceType, path);
            }
            if (on == null) {
                on = new ObjectName(objectNameStr);
            }
        }
        catch (MalformedObjectNameException me) {
            throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), (Throwable)me);
        }
        CLILogger.getInstance().printDebugMessage("Object Name = [" + on.toString() + "]");
        return on;
    }

    protected Object[] getParamsInfo() throws CommandException, CommandValidationException {
        Vector params = (Vector)this.getProperty(PARAMS);
        String[] typesInfo = this.getTypesInfo();
        Object[] paramsInfo = params == null ? null : new Object[params.size()];
        for (int i = 0; params != null && i < params.size(); ++i) {
            String paramStr = (String)params.get(i);
            CLILogger.getInstance().printDebugMessage("Types Info [" + i + "] = " + typesInfo[i]);
            CLILogger.getInstance().printDebugMessage("ATTRIBUTE_LIST_CLASS = " + ATTRIBUTE_LIST_CLASS);
            if (typesInfo[i].equals(ATTRIBUTE_LIST_CLASS)) {
                paramsInfo[i] = this.getAttributeList(paramStr);
                continue;
            }
            if (typesInfo[i].equals(PROPERTIES_CLASS)) {
                paramsInfo[i] = this.createPropertiesParam((String)params.get(i));
                continue;
            }
            if (typesInfo[i].equals(INTEGER_CLASS)) {
                paramsInfo[i] = this.createIntegerParam((String)params.get(i));
                continue;
            }
            if (typesInfo[i].equals(BOOLEAN_CLASS)) {
                if (this.createBooleanVal((String)params.get(i)) == null) continue;
                paramsInfo[i] = this.createBooleanVal((String)params.get(i));
                continue;
            }
            if (typesInfo[i].equals(LIST_CLASS)) {
                paramsInfo[i] = this.getMultiValueFromString(this.replacePattern((String)params.get(i)));
                continue;
            }
            if (typesInfo[i].equals(STRING_ARRAY)) {
                paramsInfo[i] = this.createStringArrayParam((String)params.get(i));
                continue;
            }
            CLILogger.getInstance().printDebugMessage((String)params.get(i));
            paramsInfo[i] = this.replacePattern((String)params.get(i));
            CLILogger.getInstance().printDebugMessage("ParamsInfo = " + paramsInfo[i]);
        }
        return paramsInfo;
    }

    protected String[] getTypesInfo() {
        Vector typesList = (Vector)this.getProperty(PARAM_TYPES);
        String[] types = typesList == null ? null : new String[typesList.size()];
        CLILogger.getInstance().printDebugMessage("Types = ");
        for (int i = 0; typesList != null && i < typesList.size(); ++i) {
            types[i] = (String)typesList.get(i);
            CLILogger.getInstance().printDebugMessage(types[i] + PARAM_DELIMITER);
        }
        CLILogger.getInstance().printDebugMessage("");
        return types;
    }

    protected String getOperationName() throws CommandException {
        String operationName = (String)((Vector)this.getProperty(OPERATION)).get(0);
        String operationNameStr = this.replacePattern(operationName);
        CLILogger.getInstance().printDebugMessage("OperationName = " + operationNameStr);
        return operationNameStr;
    }

    protected String getReturnType() {
        String returnType = (String)((Vector)this.getProperty(RETURN_TYPE)).get(0);
        CLILogger.getInstance().printDebugMessage("ReturnType = " + returnType);
        return returnType;
    }

    private AttributeList getAttributeList(String paramStr) throws CommandException {
        AttributeList attrList = new AttributeList();
        StringTokenizer paramsTokenizer = new StringTokenizer(paramStr, PARAM_DELIMITER);
        int size = paramsTokenizer.countTokens();
        for (int i = 0; i < size; ++i) {
            String nameValue = paramsTokenizer.nextToken();
            String nameValueStr = this.replacePattern(nameValue);
            if (nameValueStr == null) continue;
            int index = this.getDelimeterIndex(nameValueStr, PARAM_VALUE_DELIMITER, 0);
            String attrName = nameValueStr.substring(0, index);
            String attrValue = nameValueStr.substring(index + 1);
            if (attrValue.length() <= 0) continue;
            CLILogger.getInstance().printDebugMessage("**Attr Name = " + attrName + ", Value = " + attrValue);
            attrList.add(new Attribute(attrName, attrValue));
        }
        return attrList;
    }

    protected Properties createPropertiesParam(String propertyVal) throws CommandException {
        String propertyStr = this.replacePattern(propertyVal);
        if (propertyStr == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream(propertyStr));
        }
        catch (FileNotFoundException fnfe) {
            throw new CommandException(this.getLocalizedString("error.psadmin.file.not.found", new Object[]{propertyStr}));
        }
        catch (IOException ioe) {
            Object[] tokens = new Object[]{ioe.toString()};
            throw new CommandException(this.getLocalizedString("error.psadmin.error.reading.file", new Object[]{propertyStr}));
        }
        return properties;
    }

    private Boolean createBooleanVal(String booleanVal) throws CommandException {
        String booleanStr = this.replacePattern(booleanVal);
        return Boolean.valueOf(booleanStr);
    }

    private Integer createIntegerParam(String paramStr) throws CommandException {
        Integer in = new Integer(0);
        String str = this.replacePattern(paramStr);
        try {
            if (str != null) {
                in = new Integer(str);
            }
        }
        catch (NumberFormatException nf) {
            throw new CommandException(this.getLocalizedString("error.psadmin.option.integer.is.required"));
        }
        return in;
    }

    private List createListParam(String str) throws CommandException {
        String strArrayVal = this.replacePattern(str);
        ArrayList<String> list = new ArrayList<String>();
        if (strArrayVal != null && !strArrayVal.equals("null")) {
            StringTokenizer tokenizer = new StringTokenizer(strArrayVal, PARAM_DELIMITER);
            while (tokenizer.hasMoreTokens()) {
                list.add(tokenizer.nextToken());
            }
        }
        return list;
    }

    private String[] createStringArrayParam(String str) throws CommandException {
        String strArrayVal = this.replacePattern(str);
        CLILogger.getInstance().printDebugMessage("strArrayVal value = \"" + strArrayVal + "\"");
        if (strArrayVal == null || strArrayVal.equals("") || strArrayVal.equals("null")) {
            return null;
        }
        CLITokenizer cliTokenizer = new CLITokenizer(strArrayVal, PROPERTY_DELIMITER);
        String[] strArray = new String[cliTokenizer.countTokens()];
        int ii = 0;
        while (cliTokenizer.hasMoreTokens()) {
            strArray[ii++] = cliTokenizer.nextTokenWithoutEscapeAndQuoteChars();
        }
        return strArray;
    }

    protected void handleReturnValue(Object returnval) {
        if (returnval == null) {
            return;
        }
        Class<?> cl = returnval.getClass();
        if (cl.isArray()) {
            if (cl == new ObjectName[0].getClass()) {
                ObjectName[] objs = (ObjectName[])returnval;
                if (objs.length == 0) {
                    CLILogger.getInstance().printDetailMessage(this.getLocalizedString("NoElementsToList"));
                    return;
                }
                String displayType = (String)((Vector)this.getProperty(DISPLAY_TYPE)).get(0);
                for (int ii = 0; ii < objs.length; ++ii) {
                    ObjectName objectName = objs[ii];
                    CLILogger.getInstance().printDebugMessage("ObjectName = " + objectName);
                    CLILogger.getInstance().printMessage(objectName.getKeyProperty(displayType));
                }
            } else {
                Object[] objs = (Object[])returnval;
                if (objs.length == 0) {
                    CLILogger.getInstance().printDetailMessage(this.getLocalizedString("NoElementsToList"));
                    return;
                }
                for (int ii = 0; ii < objs.length; ++ii) {
                    CLILogger.getInstance().printMessage(objs[ii].toString());
                }
            }
        } else {
            Object obj = returnval;
            CLILogger.getInstance().printMessage(obj.toString());
        }
    }

    /*
     * Loose catch block
     */
    public String[] uploadFile(MBeanServerConnection msc, File file, int uploadSize) throws CommandException {
        String[] nameIdArray;
        block13: {
            String remoteFileName = null;
            ObjectName objectName = null;
            String uploadId = null;
            nameIdArray = null;
            long fileSize = file.length();
            FileInputStream fi = null;
            if (uploadSize == 0) {
                uploadSize = 4096;
            }
            LinkedList<String> path = new LinkedList<String>();
            path.addFirst(this.getDomainId());
            path.addFirst("UploadDownloadFileManager");
            objectName = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain.UploadDownloadFileManager", path);
            if (!msc.isRegistered(objectName)) {
                logger.log(Level.SEVERE, "PSALI_CSPACC0016");
                throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), null);
            }
            Object[] params = new Object[]{file.getName(), new Long(fileSize)};
            String[] signature = new String[]{"java.lang.String", "java.lang.Long"};
            nameIdArray = (String[])msc.invoke(objectName, "initiateFileUpload", params, signature);
            uploadId = nameIdArray[0];
            remoteFileName = nameIdArray[1];
            fi = new FileInputStream(file);
            byte[] bytesToUpload = null;
            long offset = 0L;
            int readSize = 0;
            String nameByteArray = new byte[0].getClass().getName();
            signature[0] = "java.lang.String";
            signature[1] = nameByteArray;
            params[0] = uploadId;
            readSize = fileSize < (long)uploadSize ? new Long(fileSize).intValue() : uploadSize;
            bytesToUpload = new byte[readSize];
            while (fi.read(bytesToUpload) != -1) {
                params[1] = bytesToUpload;
                msc.invoke(objectName, "uploadBytes", params, signature);
                int n = readSize = new Long(fileSize - (offset += (long)readSize)).intValue() > uploadSize ? uploadSize : new Long(fileSize - offset).intValue();
                if (readSize == 0) break;
                bytesToUpload = new byte[readSize];
            }
            Object var20_22 = null;
            try {
                fi.close();
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "PSALI_CSPACC0003", ioe);
            }
            break block13;
            {
                catch (MalformedObjectNameException moe) {
                    logger.log(Level.SEVERE, "PSALI_CSPACC0004", moe);
                    throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), null);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "PSALI_CSPACC0003", e);
                    throw new CommandException(this.getLocalizedString(ERROR_FILE_UPLOAD), null);
                }
                catch (MBeanException me) {
                    PSMBeanException pme = (PSMBeanException)me.getTargetException();
                    logger.log(Level.SEVERE, "PSALI_CSPACC0006", (Throwable)pme);
                    throw new CommandException(this.getLocalizedString(pme.getErrorKey(), pme.getTokens()));
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "PSALI_CSPACC0010", e);
                    throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), null);
                }
            }
            catch (Throwable throwable) {
                Object var20_23 = null;
                try {
                    fi.close();
                }
                catch (IOException ioe) {
                    logger.log(Level.SEVERE, "PSALI_CSPACC0003", ioe);
                }
                throw throwable;
            }
        }
        return nameIdArray;
    }

    public void uploadDownloadCleanUp(MBeanServerConnection msc, String id) throws CommandException {
        try {
            LinkedList<String> path = new LinkedList<String>();
            path.addFirst(this.getDomainId());
            path.addFirst("UploadDownloadFileManager");
            ObjectName objectName = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain.UploadDownloadFileManager", path);
            if (!msc.isRegistered(objectName)) {
                logger.log(Level.SEVERE, "PSALI_CSPACC0016");
                throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), null);
            }
            Object[] params = new String[]{id};
            String[] signature = new String[]{"java.lang.String"};
            msc.invoke(objectName, "cleanUp", params, signature);
        }
        catch (MalformedObjectNameException moe) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0004", moe);
            throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), null);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "PSALI_CSPACC0003", e);
        }
        catch (Exception e) {
            throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), null);
        }
    }

    /*
     * Loose catch block
     */
    public long downloadFile(MBeanServerConnection msc, String fileName, int downloadSize) throws CommandException {
        long fileSize;
        block13: {
            int readSize;
            ObjectName objectName = null;
            String downloadId = null;
            Object[] idSizeArray = null;
            fileSize = 0L;
            FileOutputStream fo = null;
            if (downloadSize == 0) {
                downloadSize = 4096;
            }
            LinkedList<String> path = new LinkedList<String>();
            path.addFirst(this.getDomainId());
            path.addFirst("UploadDownloadFileManager");
            objectName = AdminClientUtil.getResourceMBeanObjectName((String)"PortalDomain.UploadDownloadFileManager", path);
            if (!msc.isRegistered(objectName)) {
                logger.log(Level.SEVERE, "PSALI_CSPACC0016");
                throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), null);
            }
            Object[] params = new Object[]{fileName};
            String[] signature = new String[]{"java.lang.String"};
            idSizeArray = (Object[])msc.invoke(objectName, "initiateFileDownload", params, signature);
            downloadId = (String)idSizeArray[0];
            fileSize = (Long)idSizeArray[1];
            byte[] bytesDownloaded = null;
            long bytesRead = 0L;
            String[] signature2 = new String[]{"java.lang.String", "java.lang.Integer"};
            Object[] params2 = new Object[2];
            params2[0] = downloadId;
            fo = new FileOutputStream(new File(fileName).getName(), true);
            int n = readSize = fileSize > (long)downloadSize ? downloadSize : new Long(fileSize).intValue();
            while (bytesRead <= fileSize) {
                params2[1] = new Integer(readSize);
                bytesDownloaded = (byte[])msc.invoke(objectName, "downloadBytes", params2, signature2);
                fo.write(bytesDownloaded);
                if ((readSize = fileSize - (bytesRead += (long)bytesDownloaded.length) > (long)downloadSize ? downloadSize : new Long(fileSize - bytesRead).intValue()) != 0) continue;
            }
            Object[] params3 = new String[]{downloadId};
            String[] signature3 = new String[]{"java.lang.String"};
            msc.invoke(objectName, "cleanUp", params3, signature3);
            Object var22_24 = null;
            try {
                fo.close();
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "PSALI_CSPACC0003", ioe);
            }
            break block13;
            {
                catch (MalformedObjectNameException moe) {
                    logger.log(Level.SEVERE, "PSALI_CSPACC0004", moe);
                    throw new CommandException(this.getLocalizedString("error.psadmin.object.name"), null);
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "PSALI_CSPACC0003", e);
                    throw new CommandException(this.getLocalizedString(ERROR_FILE_DOWNLOAD), null);
                }
                catch (MBeanException me) {
                    PSMBeanException pme = (PSMBeanException)me.getTargetException();
                    logger.log(Level.SEVERE, "PSALI_CSPACC0006", (Throwable)pme);
                    throw new CommandException(this.getLocalizedString(pme.getErrorKey(), pme.getTokens()));
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, "PSALI_CSPACC0010", e);
                    throw new CommandException(this.getLocalizedString("error.psadmin.command.failed"), null);
                }
            }
            catch (Throwable throwable) {
                Object var22_25 = null;
                try {
                    fo.close();
                }
                catch (IOException ioe) {
                    logger.log(Level.SEVERE, "PSALI_CSPACC0003", ioe);
                }
                throw throwable;
            }
        }
        return fileSize;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        PortalLogManager manager = new PortalLogManager();
        manager.init("debug.com.sun.portal.admin.cli");
        try {
            cliLogFileName = manager.getLogFileName("debug.com.sun.portal.admin.cli");
            mbeanLogFileName = manager.getLogFileName("debug.com.sun.portal");
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger = PortalLogger.getLogger((Class)(class$com$sun$portal$admin$cli$commands$AdminBaseCommand == null ? (class$com$sun$portal$admin$cli$commands$AdminBaseCommand = AdminBaseCommand.class$("com.sun.portal.admin.cli.commands.AdminBaseCommand")) : class$com$sun$portal$admin$cli$commands$AdminBaseCommand));
        ATTRIBUTE_LIST_CLASS = (class$javax$management$AttributeList == null ? (class$javax$management$AttributeList = AdminBaseCommand.class$("javax.management.AttributeList")) : class$javax$management$AttributeList).getName();
        PROPERTIES_CLASS = (class$java$util$Properties == null ? (class$java$util$Properties = AdminBaseCommand.class$("java.util.Properties")) : class$java$util$Properties).getName();
        BOOLEAN_CLASS = (class$java$lang$Boolean == null ? (class$java$lang$Boolean = AdminBaseCommand.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName();
        PRIMITIVE_BOOLEAN_CLASS = Boolean.TYPE.getName();
        STRING_ARRAY = new String[0].getClass().getName();
        INTEGER_CLASS = (class$java$lang$Integer == null ? (class$java$lang$Integer = AdminBaseCommand.class$("java.lang.Integer")) : class$java$lang$Integer).getName();
        LIST_CLASS = (class$java$util$List == null ? (class$java$util$List = AdminBaseCommand.class$("java.util.List")) : class$java$util$List).getName();
    }
}

