/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.taskadmin;

import com.iplanet.sso.SSOToken;
import com.sun.portal.desktop.dp.DPChannel;
import com.sun.portal.desktop.dp.DPCollection;
import com.sun.portal.desktop.dp.DPNode;
import com.sun.portal.desktop.dp.DPProperties;
import com.sun.portal.desktop.dp.DPProperty;
import com.sun.portal.desktop.dp.DPProvider;
import com.sun.portal.desktop.dp.DPRoot;
import com.sun.portal.log.common.PortalLogger;
import com.sun.portal.portletcontainercommon.PortletPreferencesUtility;
import com.sun.portal.taskadmin.ChannelTaskAdmin;
import com.sun.portal.taskadmin.TaskAdminException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class PortletTaskAdmin
extends ChannelTaskAdmin {
    private static String PORTLET_CLASS = "PortletWindowProvider";
    private static final String PORTLET_PREFIX = "__Portlet__";
    private static String PORTLET_PREFERENCE_PROPS = "__Portlet__PreferenceProperties";
    private static String PORTLET_PREFERENCE_READONLY = "isReadOnly";
    private static Logger debugLogger = PortalLogger.getLogger((Class)(class$com$sun$portal$taskadmin$PortletTaskAdmin == null ? (class$com$sun$portal$taskadmin$PortletTaskAdmin = PortletTaskAdmin.class$("com.sun.portal.taskadmin.PortletTaskAdmin")) : class$com$sun$portal$taskadmin$PortletTaskAdmin));
    static /* synthetic */ Class class$com$sun$portal$taskadmin$PortletTaskAdmin;

    public PortletTaskAdmin(HttpServletRequest req, String baseDN) throws TaskAdminException {
        super(req, baseDN);
    }

    public PortletTaskAdmin(HttpServletRequest req, DPRoot dpRoot) throws TaskAdminException {
        super(req, dpRoot);
    }

    public PortletTaskAdmin(SSOToken ssoToken, String baseDN, String portalId) throws TaskAdminException {
        super(ssoToken, baseDN, portalId);
    }

    public void createPortletChannel(String channelName, String portletName) throws TaskAdminException {
        String providerName = this.getProviderName(portletName);
        this.createChannel(channelName, providerName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getExistingPortlets() throws TaskAdminException {
        DPRoot currentNode = this.dpRoot;
        Set providers = this.getProviderNames((DPNode)currentNode);
        TreeSet<String> portlets = new TreeSet<String>();
        Iterator iter = providers.iterator();
        while (iter.hasNext()) {
            String providername = (String)iter.next();
            DPProvider provider = null;
            String className = null;
            Object object = dpLock;
            synchronized (object) {
                provider = this.dpRoot.getProvider(providername);
                if (provider != null) {
                    className = provider.getClassName();
                }
            }
            if (className == null || !className.endsWith(PORTLET_CLASS)) continue;
            portlets.add(this.getPortletDisplayName(providername));
        }
        return portlets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getPortletPreferenceNames(String portletName) throws TaskAdminException {
        TreeSet portletPrefs = null;
        DPChannel channel = this.getDPChannel(portletName);
        DPProvider provider = null;
        Object object = dpLock;
        synchronized (object) {
            provider = channel.getProvider();
            if (provider == null) {
                debugLogger.log(Level.INFO, "PSPL_ADCSPT0001", portletName);
                Object[] tokens = new Object[]{portletName};
                throw new TaskAdminException(2, tokens);
            }
            DPProperties channelProperties = channel.getProperties();
            DPProperties providerProperties = provider.getProperties();
            DPCollection channelPrefs = channelProperties.getCollection(PORTLET_PREFERENCE_PROPS);
            DPCollection providerPrefs = providerProperties.getCollection(PORTLET_PREFERENCE_PROPS);
            DPCollection readOnlyPrefs = (DPCollection)channelPrefs.get(PORTLET_PREFERENCE_READONLY);
            if (readOnlyPrefs == null && providerPrefs != null) {
                readOnlyPrefs = (DPCollection)providerPrefs.get(PORTLET_PREFERENCE_READONLY);
            }
            portletPrefs = readOnlyPrefs != null ? readOnlyPrefs.getNames() : new TreeSet();
        }
        return portletPrefs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPortletPreferenceStringValue(String portletName, String prefName) throws TaskAdminException {
        String value = null;
        String pref = PORTLET_PREFIX + prefName;
        DPChannel channel = this.getDPChannel(portletName);
        Object object = dpLock;
        synchronized (object) {
            DPProperties channelProperties = channel.getProperties();
            DPProperty property = channelProperties.get(pref, false);
            if (property == null) {
                DPProperties providerProperties = channel.getProvider().getProperties();
                property = providerProperties.get(pref);
            }
            if (property == null) {
                Object[] tokens = new Object[]{portletName, prefName};
                throw new TaskAdminException(21, tokens);
            }
            value = property.getValue().toString();
        }
        return value;
    }

    public List getPortletPreferenceValues(String portletName, String prefName) throws TaskAdminException {
        String prefValue = this.getPortletPreferenceStringValue(portletName, prefName);
        return PortletPreferencesUtility.getPreferenceValues((String)prefValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPortletPreferenceStringValue(String portletName, String prefName, String value) throws TaskAdminException {
        String pref = PORTLET_PREFIX + prefName;
        DPChannel channel = this.getDPChannel(portletName);
        Object object = dpLock;
        synchronized (object) {
            DPProperties channelProperties = channel.getProperties();
            DPProperty property = channelProperties.get(pref, false);
            if (property == null) {
                DPProperties providerProperties = channel.getProvider().getProperties();
                property = providerProperties.get(pref);
                if (property == null) {
                    Object[] tokens = new Object[]{portletName, prefName};
                    throw new TaskAdminException(21, tokens);
                }
                property = channelProperties.add(property);
            }
            property.setValue((Object)value);
        }
    }

    public void setPortletPreferenceValues(String portletName, String prefName, String[] values) throws TaskAdminException {
        String value = PortletPreferencesUtility.getPreferenceString((String[])values);
        this.setPortletPreferenceStringValue(portletName, prefName, value);
    }

    public boolean isPortletChannel(String channelName) throws TaskAdminException {
        boolean isPortlet = false;
        String classname = this.getClassName(channelName);
        if (classname != null && classname.endsWith(PORTLET_CLASS)) {
            isPortlet = true;
        }
        return isPortlet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getPortletPreferenceMap(String portletName) throws TaskAdminException {
        HashMap prefMap = new HashMap();
        TreeSet prefNames = null;
        DPChannel channel = this.getDPChannel(portletName);
        DPProvider provider = null;
        DPCollection readOnlyPrefs = null;
        Object object = dpLock;
        synchronized (object) {
            provider = channel.getProvider();
            if (provider == null) {
                debugLogger.log(Level.INFO, "PSPL_ADCSPT0001", portletName);
                Object[] tokens = new Object[]{portletName};
                throw new TaskAdminException(2, tokens);
            }
            DPProperties channelProperties = channel.getProperties();
            DPProperties providerProperties = provider.getProperties();
            DPCollection channelPrefs = channelProperties.getCollection(PORTLET_PREFERENCE_PROPS);
            DPCollection providerPrefs = providerProperties.getCollection(PORTLET_PREFERENCE_PROPS);
            readOnlyPrefs = (DPCollection)channelPrefs.get(PORTLET_PREFERENCE_READONLY);
            if (readOnlyPrefs == null && providerPrefs != null) {
                readOnlyPrefs = (DPCollection)providerPrefs.get(PORTLET_PREFERENCE_READONLY);
            }
            prefNames = readOnlyPrefs != null ? readOnlyPrefs.getNames() : new TreeSet();
        }
        Iterator i = prefNames.iterator();
        while (i.hasNext()) {
            String prefName = (String)i.next();
            List values = this.getPortletPreferenceValues(portletName, prefName);
            DPProperty readOnlyProp = readOnlyPrefs.get(prefName);
            Boolean readOnly = (Boolean)readOnlyProp.getValue();
            HashMap<String, Object> valueMap = new HashMap<String, Object>();
            valueMap.put("values", values);
            valueMap.put("isReadOnly", readOnly);
            prefMap.put(prefName, valueMap);
        }
        return prefMap;
    }

    private String getPortletDisplayName(String portletName) {
        if (portletName.startsWith(PORTLET_PREFIX)) {
            return portletName.substring(PORTLET_PREFIX.length());
        }
        return portletName;
    }

    private String getProviderName(String portletName) {
        return PORTLET_PREFIX + portletName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

