/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.admin.mbeans.tasks;

import com.sun.portal.portlet.admin.mbeans.tasks.NoOpEntityResolver;
import com.sun.portal.portlet.admin.mbeans.tasks.PortletDeployerException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.IllegalAddException;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.xml.sax.EntityResolver;

public class PDWebAppUpdater {
    private static final List listenerClasses = new ArrayList();
    private static final String servletClass = "com.sun.portal.portletappengine.PortletAppEngineServlet";
    private static final String servletName = "PortletAppEngineServlet";
    private static final String loaderServletClass = "com.sun.portal.portletappengine.LoadServletContextLsnrServlet";
    private static final String loaderServletName = "LoadServletContextLsnrServlet";
    private static final String servletMapping = "/servlet/PortletAppEngineServlet";
    private static final List contextParams = new ArrayList();
    private static final String CONTEXT_PARAM = "context-param";
    private static final String PARAM_NAME = "param-name";
    private static final String PARAM_VALUE = "param-value";
    private static final String LISTENER = "listener";
    private static final String LISTENER_CLASS = "listener-class";
    private static final String SERVLET = "servlet";
    private static final String SERVLET_NAME = "servlet-name";
    private static final String SERVLET_CLASS = "servlet-class";
    private static final String LOAD_ON_STARTUP = "load-on-startup";
    private static final String SERVLET_MAPPING = "servlet-mapping";
    private static final String URL_PATTERN = "url-pattern";
    private static final String SECURITY_ROLE = "security-role";
    private static final String ROLE_NAME = "role-name";
    private static final String TAGLIB = "taglib";
    private static final String JSP_CONFIG = "jsp-config";
    private static final String TAGLIB_URI = "taglib-uri";
    private static final String TAGLIB_LOCATION = "taglib-location";
    private static final String taglibURI = "http://java.sun.com/portlet";
    private static final String taglibLocation = "/WEB-INF/portlet.tld";
    private static final String contextParamComment = "Init Parameters";
    private static final String listenerClassComment = "Listener Classes";
    private static final String servletComment = "PAE Servlet";
    private static final String loaderServletComment = "ServletContext Loader Servlet";
    private static final String servletMappingComment = "PAE Servlet Mapping";
    private static final String taglibComment = "taglib for portlets";
    private static final String indent = "   ";
    private static final boolean newLines = true;
    private static List elementBeforeCtxParam;
    private static List elementBeforeListener;
    private static List elementBeforeTaglib;
    private static List elementBeforeServletMapping;
    private static final String WEB_INF_PREFIX;
    private static final String WEB_XML = "web.xml";
    private static final String WEB_XML_NAME;
    private static final String PAE_PREFIX;
    private static final String WEB_APP_VERSION = "version";
    private static final String WEB_APP_2_4 = "2.4";

    public static List getRoles(InputStream in) throws IOException, PortletDeployerException {
        Document doc = PDWebAppUpdater.getDocument(in);
        Element root = doc.getRootElement();
        ArrayList<String> roles = new ArrayList<String>();
        List sRoleElements = root.getChildren(SECURITY_ROLE);
        for (int i = 0; i < sRoleElements.size(); ++i) {
            String role;
            Element sRoleElement = (Element)sRoleElements.get(i);
            Element roleName = sRoleElement.getChild(ROLE_NAME);
            if (roleName == null || (role = roleName.getTextTrim()) == null || role.length() == 0) continue;
            roles.add(role);
        }
        return roles;
    }

    public static List getRolesWithNamespace(InputStream in) throws IOException, PortletDeployerException {
        Document doc = PDWebAppUpdater.getDocument(in);
        Element root = doc.getRootElement();
        ArrayList<String> roles = new ArrayList<String>();
        List sRoleElements = root.getChildren(SECURITY_ROLE, root.getNamespace());
        for (int i = 0; i < sRoleElements.size(); ++i) {
            String role;
            Element sRoleElement = (Element)sRoleElements.get(i);
            Element roleName = sRoleElement.getChild(ROLE_NAME, root.getNamespace());
            if (roleName == null || (role = roleName.getTextTrim()) == null || role.length() == 0) continue;
            roles.add(role);
        }
        return roles;
    }

    public static File addWebAppParam(InputStream in, Properties configProps, String portletAppName) throws IOException, PortletDeployerException {
        Document doc = PDWebAppUpdater.getDocument(in);
        Element root = doc.getRootElement();
        boolean updated = PDWebAppUpdater.isWebAppUpdated(root, configProps);
        if (updated) {
            try {
                PDWebAppUpdater.removeElements(root, configProps);
            }
            catch (PortletDeployerException pe) {
                throw new PortletDeployerException("errorIllegalAdd", pe);
            }
        }
        try {
            String version = PDWebAppUpdater.getWebAppVersion(root);
            if (version != null && version.equals(WEB_APP_2_4)) {
                PDWebAppUpdater.addElementsAsPer2_4Schema(root, portletAppName, configProps);
            } else {
                PDWebAppUpdater.addElements(root, portletAppName, configProps);
            }
        }
        catch (IllegalAddException iae) {
            throw new PortletDeployerException("errorIllegalAdd", iae);
        }
        return PDWebAppUpdater.createUpdatedFile(doc);
    }

    public static File removeWebAppParam(InputStream in, Properties configProps) throws IOException, PortletDeployerException {
        Document doc = PDWebAppUpdater.getDocument(in);
        Element root = doc.getRootElement();
        try {
            PDWebAppUpdater.removeElements(root, configProps);
        }
        catch (IllegalAddException iae) {
            Object[] tokens = new Object[]{iae.toString()};
            throw new PortletDeployerException("errorIllegalAdd", tokens);
        }
        return PDWebAppUpdater.createUpdatedFile(doc);
    }

    public static boolean isWebAppUpdated(InputStream in, Properties configProps) throws PortletDeployerException {
        Document doc = PDWebAppUpdater.getDocument(in);
        Element root = doc.getRootElement();
        return PDWebAppUpdater.isWebAppUpdated(root, configProps);
    }

    private static boolean isWebAppUpdated(Element root, Properties configProps) throws PortletDeployerException {
        boolean updated = false;
        List children = root.getChildren();
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            String param;
            Element child = (Element)itr.next();
            if (child.getName().equals(CONTEXT_PARAM)) {
                param = child.getChildTextTrim(PARAM_NAME);
                if (!contextParams.contains(param)) continue;
                updated = true;
                return updated;
            }
            if (child.getName().equals(LISTENER)) {
                param = child.getChildTextTrim(LISTENER_CLASS);
                if (!listenerClasses.contains(param)) continue;
                updated = true;
                return updated;
            }
            if (!child.getName().equals(SERVLET) || !(param = child.getChildTextTrim(SERVLET_NAME)).equals(servletName) && !param.equals(loaderServletName)) continue;
            updated = true;
            return updated;
        }
        return updated;
    }

    private static Document getDocument(InputStream in) throws PortletDeployerException {
        if (in == null) {
            throw new PortletDeployerException("emptyWebXML");
        }
        Document doc = null;
        try {
            SAXBuilder builder = new SAXBuilder();
            builder.setEntityResolver((EntityResolver)new NoOpEntityResolver());
            doc = builder.build(in);
        }
        catch (IOException e) {
            throw new PortletDeployerException("error reading stream " + e.getMessage());
        }
        catch (JDOMException je) {
            Object[] tokens = new Object[]{je.toString()};
            throw new PortletDeployerException("errorDocumentBuild", tokens);
        }
        return doc;
    }

    private static File createUpdatedFile(Document doc) throws IOException {
        File newWebXMLFile = File.createTempFile("web", ".xml");
        newWebXMLFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(newWebXMLFile);
        Format format = Format.getPrettyFormat();
        format.setIndent(indent);
        format.setLineSeparator(System.getProperty("line.separator"));
        format.setEncoding("ISO-8859-1");
        XMLOutputter fmt = new XMLOutputter(format);
        fmt.output(doc, (OutputStream)fos);
        fos.close();
        return newWebXMLFile;
    }

    private static void addElements(Element root, String portletAppName, Properties configProps) throws IllegalAddException {
        Element child;
        List children = root.getChildren();
        int size = children.size();
        int newSize = size + contextParams.size() + listenerClasses.size() + 1;
        ArrayList<Object> newChildren = new ArrayList<Object>(newSize);
        int i = 0;
        boolean addPortletParam = false;
        for (i = 0; i < size; ++i) {
            child = (Element)children.get(i);
            if (!elementBeforeCtxParam.contains(child.getName())) {
                newChildren.addAll(PDWebAppUpdater.genContextParamElements(portletAppName, configProps));
                addPortletParam = true;
                break;
            }
            newChildren.add(child);
        }
        if (!addPortletParam) {
            newChildren.addAll(PDWebAppUpdater.genContextParamElements(portletAppName, configProps));
            addPortletParam = false;
        }
        while (i < size) {
            child = (Element)children.get(i);
            if (!elementBeforeListener.contains(child.getName())) {
                newChildren.addAll(PDWebAppUpdater.genLoaderServletElements());
                newChildren.addAll(PDWebAppUpdater.genServletElements());
                addPortletParam = true;
                break;
            }
            newChildren.add(child);
            ++i;
        }
        if (!addPortletParam) {
            newChildren.addAll(PDWebAppUpdater.genLoaderServletElements());
            newChildren.addAll(PDWebAppUpdater.genServletElements());
        }
        boolean addServletMappingParam = false;
        while (i < size) {
            Element child2 = (Element)children.get(i);
            if (!elementBeforeServletMapping.contains(child2.getName())) {
                newChildren.addAll(PDWebAppUpdater.genServletMappingElements());
                addServletMappingParam = true;
                break;
            }
            newChildren.add(child2);
            ++i;
        }
        if (!addServletMappingParam) {
            newChildren.addAll(PDWebAppUpdater.genServletMappingElements());
        }
        boolean addTaglibParam = false;
        while (i < size) {
            Element child3 = (Element)children.get(i);
            if (!elementBeforeTaglib.contains(child3.getName())) {
                newChildren.addAll(PDWebAppUpdater.genTaglibElements());
                addTaglibParam = true;
                break;
            }
            newChildren.add(child3);
            ++i;
        }
        if (!addTaglibParam) {
            newChildren.addAll(PDWebAppUpdater.genTaglibElements());
        }
        while (i < size) {
            newChildren.add(children.get(i));
            ++i;
        }
        Iterator it = root.getChildren().iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            list.add(((Element)it.next()).getName());
        }
        for (int count = 0; count < list.size(); ++count) {
            root.removeChild((String)list.get(count));
        }
        root.setContent(newChildren);
    }

    private static void addElementsAsPer2_4Schema(Element root, String portletAppName, Properties configProps) throws IllegalAddException {
        Element child;
        List children = root.getChildren();
        int size = children.size();
        int newSize = size + contextParams.size() + listenerClasses.size() + 1;
        ArrayList<Element> newChildren = new ArrayList<Element>(newSize);
        int i = 0;
        boolean addTaglibParam = false;
        for (i = 0; i < size; ++i) {
            child = (Element)children.get(i);
            if (child.getName().equals(JSP_CONFIG)) {
                Element newChild = (Element)child.clone();
                newChild.addContent((Collection)PDWebAppUpdater.genTaglibElements());
                newChildren.add(newChild);
                addTaglibParam = true;
                continue;
            }
            newChildren.add(child);
        }
        newChildren.addAll(PDWebAppUpdater.genContextParamElements(portletAppName, configProps));
        newChildren.addAll(PDWebAppUpdater.genLoaderServletElements());
        newChildren.addAll(PDWebAppUpdater.genServletElements());
        newChildren.addAll(PDWebAppUpdater.genServletMappingElements());
        if (!addTaglibParam) {
            child = new Element(JSP_CONFIG);
            child.setContent((Collection)PDWebAppUpdater.genTaglibElements());
            newChildren.add(child);
        }
        Iterator it = root.getChildren().iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            list.add(((Element)it.next()).getName());
        }
        for (int count = 0; count < list.size(); ++count) {
            root.removeChild((String)list.get(count));
        }
        root.setContent(newChildren);
    }

    private static List genContextParamElements(String portletAppName, Properties configProps) {
        ArrayList<Object> contextParamElements = new ArrayList<Object>(contextParams.size());
        Comment comment = new Comment(contextParamComment);
        contextParamElements.add(comment);
        for (int i = 0; i < contextParams.size(); ++i) {
            Element contextParam = new Element(CONTEXT_PARAM);
            Element paramName = new Element(PARAM_NAME);
            paramName.addContent((String)contextParams.get(i));
            Element paramValue = new Element(PARAM_VALUE);
            paramValue.addContent(configProps.getProperty((String)contextParams.get(i)));
            contextParam.addContent((Content)paramName);
            contextParam.addContent((Content)paramValue);
            contextParamElements.add(contextParam);
        }
        return contextParamElements;
    }

    private static List genListenerElements() {
        ArrayList<Object> listenerElements = new ArrayList<Object>(listenerClasses.size());
        Comment comment = new Comment(listenerClassComment);
        listenerElements.add(comment);
        for (int i = 0; i < listenerClasses.size(); ++i) {
            Element listenerElement = new Element(LISTENER);
            Element listenerClassElement = new Element(LISTENER_CLASS);
            listenerClassElement.addContent((String)listenerClasses.get(i));
            listenerElement.addContent((Content)listenerClassElement);
            listenerElements.add(listenerElement);
        }
        return listenerElements;
    }

    private static List genServletElements() {
        ArrayList<Object> servletElements = new ArrayList<Object>(1);
        Comment comment = new Comment(servletComment);
        servletElements.add(comment);
        Element servletElement = new Element(SERVLET);
        Element servletNameElement = new Element(SERVLET_NAME);
        servletNameElement.addContent(servletName);
        Element servletClassElement = new Element(SERVLET_CLASS);
        servletClassElement.addContent(servletClass);
        Element loadOnStartupElement = new Element(LOAD_ON_STARTUP);
        loadOnStartupElement.addContent("2");
        servletElement.addContent((Content)servletNameElement);
        servletElement.addContent((Content)servletClassElement);
        servletElement.addContent((Content)loadOnStartupElement);
        servletElements.add(servletElement);
        return servletElements;
    }

    private static List genLoaderServletElements() {
        ArrayList<Object> servletElements = new ArrayList<Object>(1);
        Comment comment = new Comment(loaderServletComment);
        servletElements.add(comment);
        Element servletElement = new Element(SERVLET);
        Element servletNameElement = new Element(SERVLET_NAME);
        servletNameElement.addContent(loaderServletName);
        Element servletClassElement = new Element(SERVLET_CLASS);
        servletClassElement.addContent(loaderServletClass);
        Element loadOnStartupElement = new Element(LOAD_ON_STARTUP);
        loadOnStartupElement.addContent("1");
        servletElement.addContent((Content)servletNameElement);
        servletElement.addContent((Content)servletClassElement);
        servletElement.addContent((Content)loadOnStartupElement);
        servletElements.add(servletElement);
        return servletElements;
    }

    private static List genServletMappingElements() {
        ArrayList<Object> servletMappingElements = new ArrayList<Object>(1);
        Comment comment = new Comment(servletMappingComment);
        servletMappingElements.add(comment);
        Element servletMappingElement = new Element(SERVLET_MAPPING);
        Element servletNameElement = new Element(SERVLET_NAME);
        servletNameElement.addContent(servletName);
        Element urlPatternElement = new Element(URL_PATTERN);
        urlPatternElement.addContent(servletMapping);
        servletMappingElement.addContent((Content)servletNameElement);
        servletMappingElement.addContent((Content)urlPatternElement);
        servletMappingElements.add(servletMappingElement);
        return servletMappingElements;
    }

    private static List genTaglibElements() {
        ArrayList<Object> taglibElements = new ArrayList<Object>(1);
        Comment comment = new Comment(taglibComment);
        taglibElements.add(comment);
        Element taglibElement = new Element(TAGLIB);
        Element taglibURIElement = new Element(TAGLIB_URI);
        taglibURIElement.addContent(taglibURI);
        Element taglibLocationElement = new Element(TAGLIB_LOCATION);
        taglibLocationElement.addContent(taglibLocation);
        taglibElement.addContent((Content)taglibURIElement);
        taglibElement.addContent((Content)taglibLocationElement);
        taglibElements.add(taglibElement);
        return taglibElements;
    }

    private static void removeElements(Element root, Properties configProps) throws PortletDeployerException {
        List children = root.getChildren();
        ArrayList<Element> newchildren = new ArrayList<Element>();
        Iterator itr = children.iterator();
        while (itr.hasNext()) {
            String param;
            Element child = (Element)itr.next();
            if (child.getName().equals(CONTEXT_PARAM)) {
                param = child.getChildTextTrim(PARAM_NAME);
                if (contextParams.contains(param)) continue;
                newchildren.add(child);
                continue;
            }
            if (child.getName().equals(LISTENER)) {
                param = child.getChildTextTrim(LISTENER_CLASS);
                if (listenerClasses.contains(param)) continue;
                newchildren.add(child);
                continue;
            }
            if (child.getName().equals(SERVLET)) {
                param = child.getChildTextTrim(SERVLET_NAME);
                if (param.equals(servletName)) continue;
                newchildren.add(child);
                continue;
            }
            newchildren.add(child);
        }
        Iterator it = root.getChildren().iterator();
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            list.add(((Element)it.next()).getName());
        }
        for (int count = 0; count < list.size(); ++count) {
            root.removeChild((String)list.get(count));
        }
        root.setContent(newchildren);
    }

    private static String getWebAppVersion(Element root) throws PortletDeployerException {
        String versionValue = null;
        Attribute versionAttribute = root.getAttribute(WEB_APP_VERSION);
        if (versionAttribute != null && ((versionValue = root.getAttributeValue(WEB_APP_VERSION)) == null || Float.parseFloat(versionValue) < Float.parseFloat(WEB_APP_2_4))) {
            throw new PortletDeployerException("errorGettingVersionValue");
        }
        return versionValue;
    }

    static {
        listenerClasses.add("com.sun.portal.portletappengine.impl.LifecycleManagerContextListenerImpl");
        listenerClasses.add("com.sun.portal.portletappengine.impl.RequestResponseFactoryContextListenerImpl");
        contextParams.add("request_response_factory.minSizeParam");
        contextParams.add("request_response_factory.maxSizeParam");
        contextParams.add("request_response_factory.partitionParam");
        contextParams.add("DDSchemaLocation");
        elementBeforeCtxParam = new ArrayList();
        elementBeforeListener = new ArrayList();
        elementBeforeTaglib = new ArrayList();
        elementBeforeServletMapping = new ArrayList();
        elementBeforeCtxParam.add("icon");
        elementBeforeCtxParam.add("display-name");
        elementBeforeCtxParam.add("description");
        elementBeforeCtxParam.add("distributable");
        elementBeforeCtxParam.add(CONTEXT_PARAM);
        elementBeforeListener.add("filter");
        elementBeforeListener.add("filter-mapping");
        elementBeforeListener.add(LISTENER);
        elementBeforeServletMapping.add(SERVLET);
        elementBeforeTaglib.add(SERVLET_MAPPING);
        elementBeforeTaglib.add("session-config");
        elementBeforeTaglib.add("mime-mapping");
        elementBeforeTaglib.add("welcome-file-list");
        elementBeforeTaglib.add("error-page");
        WEB_INF_PREFIX = "WEB-INF" + File.separator;
        WEB_XML_NAME = WEB_INF_PREFIX + WEB_XML;
        PAE_PREFIX = WEB_INF_PREFIX + "lib" + File.separator;
    }
}

