/*
 * Decompiled with CFR 0.152.
 */
package com.sun.portal.portlet.admin.mbeans.tasks;

import com.sun.portal.log.common.PortalLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.logging.Level;

public class PDWarUpdater {
    private File warFile = null;
    private JarFile jar = null;
    private Properties configProps = null;
    private static final String TLD_LOCATION = "tldLocation";
    private static final String WEB_INF_PREFIX = "WEB-INF/";
    private static final String WEB_XML = "web.xml";
    private static final String WEB_XML_NAME = "WEB-INF/web.xml";
    private static final String DD_LOCATION = "DDFileLocation";
    private static final String WAR_SUFFIX = ".war";
    static /* synthetic */ Class class$com$sun$portal$portlet$admin$mbeans$tasks$PDProviderEntryGenerator;

    public PDWarUpdater(File warFile, Properties props) throws IOException {
        this.warFile = warFile;
        this.jar = new JarFile(warFile);
        this.configProps = props;
    }

    public JarFile getJarFile() {
        return this.jar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getUpdatedWarFile(File webXMLFile) throws Exception {
        String tldFileName = this.configProps.getProperty(TLD_LOCATION);
        File tldFile = new File(tldFileName);
        String ddLocation = this.configProps.getProperty(DD_LOCATION);
        String tempWarFileName = this.warFile.getName().substring(0, this.warFile.getName().indexOf(46)) + WAR_SUFFIX + ".tmp";
        File tempJarFile = new File(ddLocation, tempWarFileName);
        tempJarFile.deleteOnExit();
        boolean jarUpdated = false;
        try {
            Manifest jarManifest = this.jar.getManifest();
            JarOutputStream tempJar = new JarOutputStream(new FileOutputStream(tempJarFile));
            byte[] buffer = new byte[1024];
            try {
                int bytesRead;
                FileInputStream webXMLin = new FileInputStream(webXMLFile);
                try {
                    JarEntry entry = new JarEntry(WEB_XML_NAME);
                    tempJar.putNextEntry(entry);
                    while ((bytesRead = webXMLin.read(buffer)) != -1) {
                        tempJar.write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    webXMLin.close();
                }
                FileInputStream tldin = new FileInputStream(tldFile);
                try {
                    JarEntry entry = new JarEntry(WEB_INF_PREFIX + tldFile.getName());
                    tempJar.putNextEntry(entry);
                    while ((bytesRead = tldin.read(buffer)) != -1) {
                        tempJar.write(buffer, 0, bytesRead);
                    }
                }
                finally {
                    tldin.close();
                }
                Enumeration<JarEntry> entries = this.jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (entry.getName().equals(WEB_XML_NAME) || entry.getName().equals(WEB_INF_PREFIX + tldFile.getName())) continue;
                    InputStream entryStream = this.jar.getInputStream(entry);
                    tempJar.putNextEntry(entry);
                    while ((bytesRead = entryStream.read(buffer)) != -1) {
                        tempJar.write(buffer, 0, bytesRead);
                    }
                }
                jarUpdated = true;
            }
            catch (Exception ex) {
                PortalLogger.getLogger((Class)(class$com$sun$portal$portlet$admin$mbeans$tasks$PDProviderEntryGenerator == null ? (class$com$sun$portal$portlet$admin$mbeans$tasks$PDProviderEntryGenerator = PDWarUpdater.class$("com.sun.portal.portlet.admin.mbeans.tasks.PDProviderEntryGenerator")) : class$com$sun$portal$portlet$admin$mbeans$tasks$PDProviderEntryGenerator)).log(Level.SEVERE, "PSPL_CSPPAMT0001", ex);
                throw ex;
            }
            finally {
                tempJar.close();
            }
            Object var19_21 = null;
        }
        catch (Throwable throwable) {
            Object var19_22 = null;
            this.jar.close();
            if (!jarUpdated) {
                tempJarFile.delete();
            }
            throw throwable;
        }
        this.jar.close();
        if (!jarUpdated) {
            tempJarFile.delete();
        }
        if (jarUpdated) {
            return tempJarFile;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

